#!/usr/bin/env ruby
# vim:ts=2 sw=2 et
# noseeadd2.rb : 無啥味自動加詞

# Copyright (C) 2008  Edward G.J. Lee <edt1023@info.sayya.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program in doc/COPYING; if not, write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301 USA

# 2008.02.10 noseeing 自動加詞，和原 gcin 加字詞的檔案分開，穩定後
#            再行合併。
# 2008.03.25 改用 ftools。
# 2008.04.17 直接用 gcin 加字詞的 xxx.gtab.append 檔。

$KCODE='u'
require 'ftools'

locale = `echo $LC_ALL`.chomp
if locale == ""
  locale = `echo $LC_CTYPE`.chomp
  if locale == ""
    locale = `echo $LANG`.chomp
  end
end

# 固定目錄
ghome = ENV['HOME'] + '/.gcin'
if test ?f, "/usr/share/gcin/table/noseeing.gtab"
  gdir = "/usr/share/gcin/table/noseeing.gtab"
elsif test ?f, "/usr/local/share/gcin/table/noseeing.gtab"
  gdir = "/usr/local/share/gcin/table/noseeing.gtab"
elsif test ?f, ghome + "/noseeing.gtab"
  gdir = ghome + "/noseeing.gtab"
else
  puts "You didn't install noseeing."
  exit
end

# 基本字 hash (norepeat.table.hash)
H = {"主" => "a",
     "之" => "a",
     "也" => "a",
     "今" => "a",
     "令" => "a",
     "佘" => "a",
     "余" => "a",
     "侖" => "a",
     "俞" => "a",
     "倉" => "a",
     "僉" => "a",
     "兮" => "a",
     "冰" => "a",
     "刌" => "a",
     "划" => "a",
     "剆" => "a",
     "創" => "a",
     "劃" => "a",
     "劊" => "a",
     "劍" => "a",
     "合" => "a",
     "含" => "a",
     "命" => "a",
     "咸" => "a",
     "塱" => "a",
     "壟" => "a",
     "壹" => "a",
     "奧" => "a",
     "威" => "a",
     "寸" => "a",
     "尃" => "a",
     "尤" => "a",
     "尨" => "a",
     "弇" => "a",
     "弋" => "a",
     "式" => "a",
     "彧" => "a",
     "忒" => "a",
     "念" => "a",
     "怷" => "a",
     "惑" => "a",
     "愈" => "a",
     "感" => "a",
     "慦" => "a",
     "慼" => "a",
     "憌" => "a",
     "懖" => "a",
     "懟" => "a",
     "戈" => "a",
     "戉" => "a",
     "戊" => "a",
     "戌" => "a",
     "戍" => "a",
     "戎" => "a",
     "成" => "a",
     "戒" => "a",
     "戔" => "a",
     "或" => "a",
     "戚" => "a",
     "戧" => "a",
     "拿" => "a",
     "敆" => "a",
     "救" => "a",
     "敘" => "a",
     "敜" => "a",
     "敷" => "a",
     "斂" => "a",
     "斜" => "a",
     "族" => "a",
     "書" => "a",
     "會" => "a",
     "朗" => "a",
     "朮" => "a",
     "樖" => "a",
     "欱" => "a",
     "欴" => "a",
     "欸" => "a",
     "欽" => "a",
     "歈" => "a",
     "歙" => "a",
     "歛" => "a",
     "殶" => "a",
     "毹" => "a",
     "求" => "a",
     "澳" => "a",
     "犬" => "a",
     "犮" => "a",
     "猋" => "a",
     "瓴" => "a",
     "甫" => "a",
     "畣" => "a",
     "發" => "a",
     "盒" => "a",
     "盚" => "a",
     "盛" => "a",
     "盞" => "a",
     "盦" => "a",
     "矣" => "a",
     "礱" => "a",
     "缽" => "a",
     "義" => "a",
     "翎" => "a",
     "翕" => "a",
     "聾" => "a",
     "臧" => "a",
     "良" => "a",
     "華" => "a",
     "蠪" => "a",
     "術" => "a",
     "衾" => "a",
     "裘" => "a",
     "襲" => "a",
     "覦" => "a",
     "觱" => "a",
     "讋" => "a",
     "貣" => "a",
     "貪" => "a",
     "貳" => "a",
     "貸" => "a",
     "蹙" => "a",
     "迆" => "a",
     "迖" => "a",
     "述" => "a",
     "逋" => "a",
     "逑" => "a",
     "途" => "a",
     "逾" => "a",
     "過" => "a",
     "郃" => "a",
     "郎" => "a",
     "郕" => "a",
     "郙" => "a",
     "鄃" => "a",
     "鄰" => "a",
     "鄶" => "a",
     "酓" => "a",
     "金" => "a",
     "釓" => "a",
     "釔" => "a",
     "釕" => "a",
     "釗" => "a",
     "釘" => "a",
     "釙" => "a",
     "釚" => "a",
     "針" => "a",
     "釢" => "a",
     "釣" => "a",
     "釤" => "a",
     "釦" => "a",
     "釧" => "a",
     "釨" => "a",
     "釩" => "a",
     "釪" => "a",
     "釫" => "a",
     "釬" => "a",
     "釭" => "a",
     "釮" => "a",
     "釱" => "a",
     "釳" => "a",
     "釴" => "a",
     "釵" => "a",
     "釷" => "a",
     "釸" => "a",
     "釹" => "a",
     "釽" => "a",
     "釿" => "a",
     "鈀" => "a",
     "鈁" => "a",
     "鈂" => "a",
     "鈃" => "a",
     "鈄" => "a",
     "鈅" => "a",
     "鈆" => "a",
     "鈇" => "a",
     "鈉" => "a",
     "鈊" => "a",
     "鈌" => "a",
     "鈍" => "a",
     "鈏" => "a",
     "鈐" => "a",
     "鈑" => "a",
     "鈒" => "a",
     "鈔" => "a",
     "鈕" => "a",
     "鈖" => "a",
     "鈗" => "a",
     "鈙" => "a",
     "鈚" => "a",
     "鈜" => "a",
     "鈞" => "a",
     "鈣" => "a",
     "鈤" => "a",
     "鈥" => "a",
     "鈦" => "a",
     "鈧" => "a",
     "鈮" => "a",
     "鈰" => "a",
     "鈱" => "a",
     "鈲" => "a",
     "鈳" => "a",
     "鈴" => "a",
     "鈶" => "a",
     "鈷" => "a",
     "鈸" => "a",
     "鈹" => "a",
     "鈺" => "a",
     "鈽" => "a",
     "鈾" => "a",
     "鈿" => "a",
     "鉀" => "a",
     "鉅" => "a",
     "鉆" => "a",
     "鉈" => "a",
     "鉉" => "a",
     "鉊" => "a",
     "鉋" => "a",
     "鉌" => "a",
     "鉍" => "a",
     "鉎" => "a",
     "鉏" => "a",
     "鉐" => "a",
     "鉑" => "a",
     "鉒" => "a",
     "鉓" => "a",
     "鉔" => "a",
     "鉖" => "a",
     "鉗" => "a",
     "鉚" => "a",
     "鉛" => "a",
     "鉞" => "a",
     "鉠" => "a",
     "鉡" => "a",
     "鉣" => "a",
     "鉤" => "a",
     "鉥" => "a",
     "鉦" => "a",
     "鉧" => "a",
     "鉬" => "a",
     "鉭" => "a",
     "鉯" => "a",
     "鉰" => "a",
     "鉲" => "a",
     "鉶" => "a",
     "鉸" => "a",
     "鉹" => "a",
     "鉺" => "a",
     "鉻" => "a",
     "鉼" => "a",
     "鉽" => "a",
     "鉾" => "a",
     "鉿" => "a",
     "銀" => "a",
     "銂" => "a",
     "銃" => "a",
     "銅" => "a",
     "銆" => "a",
     "銇" => "a",
     "銈" => "a",
     "銊" => "a",
     "銋" => "a",
     "銌" => "a",
     "銍" => "a",
     "銑" => "a",
     "銓" => "a",
     "銔" => "a",
     "銕" => "a",
     "銖" => "a",
     "銗" => "a",
     "銘" => "a",
     "銙" => "a",
     "銚" => "a",
     "銛" => "a",
     "銜" => "a",
     "銝" => "a",
     "銠" => "a",
     "銡" => "a",
     "銢" => "a",
     "銣" => "a",
     "銤" => "a",
     "銥" => "a",
     "銦" => "a",
     "銧" => "a",
     "銨" => "a",
     "銩" => "a",
     "銪" => "a",
     "銫" => "a",
     "銬" => "a",
     "銲" => "a",
     "銳" => "a",
     "銵" => "a",
     "銶" => "a",
     "銷" => "a",
     "銹" => "a",
     "銻" => "a",
     "銼" => "a",
     "鋀" => "a",
     "鋁" => "a",
     "鋂" => "a",
     "鋃" => "a",
     "鋄" => "a",
     "鋅" => "a",
     "鋇" => "a",
     "鋉" => "a",
     "鋊" => "a",
     "鋋" => "a",
     "鋌" => "a",
     "鋍" => "a",
     "鋎" => "a",
     "鋏" => "a",
     "鋐" => "a",
     "鋑" => "a",
     "鋒" => "a",
     "鋓" => "a",
     "鋕" => "a",
     "鋗" => "a",
     "鋘" => "a",
     "鋙" => "a",
     "鋝" => "a",
     "鋞" => "a",
     "鋟" => "a",
     "鋠" => "a",
     "鋡" => "a",
     "鋤" => "a",
     "鋦" => "a",
     "鋧" => "a",
     "鋨" => "a",
     "鋩" => "a",
     "鋪" => "a",
     "鋮" => "a",
     "鋯" => "a",
     "鋰" => "a",
     "鋱" => "a",
     "鋷" => "a",
     "鋸" => "a",
     "鋹" => "a",
     "鋺" => "a",
     "鋼" => "a",
     "鋾" => "a",
     "鋿" => "a",
     "錀" => "a",
     "錁" => "a",
     "錂" => "a",
     "錄" => "a",
     "錆" => "a",
     "錈" => "a",
     "錉" => "a",
     "錋" => "a",
     "錌" => "a",
     "錍" => "a",
     "錎" => "a",
     "錏" => "a",
     "錐" => "a",
     "錒" => "a",
     "錓" => "a",
     "錔" => "a",
     "錕" => "a",
     "錘" => "a",
     "錙" => "a",
     "錚" => "a",
     "錛" => "a",
     "錝" => "a",
     "錞" => "a",
     "錟" => "a",
     "錠" => "a",
     "錡" => "a",
     "錢" => "a",
     "錣" => "a",
     "錤" => "a",
     "錥" => "a",
     "錦" => "a",
     "錧" => "a",
     "錨" => "a",
     "錩" => "a",
     "錪" => "a",
     "錫" => "a",
     "錭" => "a",
     "錮" => "a",
     "錯" => "a",
     "錳" => "a",
     "錴" => "a",
     "錵" => "a",
     "錶" => "a",
     "錸" => "a",
     "錹" => "a",
     "錼" => "a",
     "鍆" => "a",
     "鍇" => "a",
     "鍉" => "a",
     "鍊" => "a",
     "鍋" => "a",
     "鍍" => "a",
     "鍎" => "a",
     "鍏" => "a",
     "鍐" => "a",
     "鍑" => "a",
     "鍒" => "a",
     "鍔" => "a",
     "鍕" => "a",
     "鍖" => "a",
     "鍗" => "a",
     "鍘" => "a",
     "鍚" => "a",
     "鍛" => "a",
     "鍜" => "a",
     "鍞" => "a",
     "鍠" => "a",
     "鍡" => "a",
     "鍣" => "a",
     "鍤" => "a",
     "鍥" => "a",
     "鍧" => "a",
     "鍬" => "a",
     "鍭" => "a",
     "鍰" => "a",
     "鍱" => "a",
     "鍵" => "a",
     "鍶" => "a",
     "鍷" => "a",
     "鍹" => "a",
     "鍺" => "a",
     "鍻" => "a",
     "鍼" => "a",
     "鍾" => "a",
     "鎀" => "a",
     "鎂" => "a",
     "鎃" => "a",
     "鎈" => "a",
     "鎉" => "a",
     "鎊" => "a",
     "鎌" => "a",
     "鎍" => "a",
     "鎎" => "a",
     "鎑" => "a",
     "鎒" => "a",
     "鎔" => "a",
     "鎕" => "a",
     "鎖" => "a",
     "鎗" => "a",
     "鎘" => "a",
     "鎙" => "a",
     "鎚" => "a",
     "鎛" => "a",
     "鎝" => "a",
     "鎞" => "a",
     "鎟" => "a",
     "鎡" => "a",
     "鎢" => "a",
     "鎤" => "a",
     "鎦" => "a",
     "鎧" => "a",
     "鎨" => "a",
     "鎩" => "a",
     "鎪" => "a",
     "鎬" => "a",
     "鎮" => "a",
     "鎯" => "a",
     "鎰" => "a",
     "鎱" => "a",
     "鎲" => "a",
     "鎳" => "a",
     "鎴" => "a",
     "鎵" => "a",
     "鎷" => "a",
     "鏀" => "a",
     "鏂" => "a",
     "鏃" => "a",
     "鏄" => "a",
     "鏇" => "a",
     "鏈" => "a",
     "鏌" => "a",
     "鏍" => "a",
     "鏎" => "a",
     "鏏" => "a",
     "鏐" => "a",
     "鏑" => "a",
     "鏒" => "a",
     "鏔" => "a",
     "鏕" => "a",
     "鏗" => "a",
     "鏘" => "a",
     "鏙" => "a",
     "鏚" => "a",
     "鏜" => "a",
     "鏝" => "a",
     "鏞" => "a",
     "鏟" => "a",
     "鏡" => "a",
     "鏢" => "a",
     "鏣" => "a",
     "鏤" => "a",
     "鏦" => "a",
     "鏬" => "a",
     "鏮" => "a",
     "鏵" => "a",
     "鏶" => "a",
     "鏷" => "a",
     "鏸" => "a",
     "鏹" => "a",
     "鏺" => "a",
     "鏻" => "a",
     "鏼" => "a",
     "鏽" => "a",
     "鏾" => "a",
     "鏿" => "a",
     "鐀" => "a",
     "鐃" => "a",
     "鐇" => "a",
     "鐉" => "a",
     "鐊" => "a",
     "鐋" => "a",
     "鐌" => "a",
     "鐍" => "a",
     "鐎" => "a",
     "鐏" => "a",
     "鐐" => "a",
     "鐑" => "a",
     "鐒" => "a",
     "鐓" => "a",
     "鐔" => "a",
     "鐕" => "a",
     "鐖" => "a",
     "鐘" => "a",
     "鐙" => "a",
     "鐠" => "a",
     "鐨" => "a",
     "鐩" => "a",
     "鐪" => "a",
     "鐫" => "a",
     "鐬" => "a",
     "鐮" => "a",
     "鐰" => "a",
     "鐱" => "a",
     "鐲" => "a",
     "鐳" => "a",
     "鐵" => "a",
     "鐶" => "a",
     "鐷" => "a",
     "鐸" => "a",
     "鐹" => "a",
     "鐺" => "a",
     "鐻" => "a",
     "鐼" => "a",
     "鐽" => "a",
     "鐿" => "a",
     "鑀" => "a",
     "鑄" => "a",
     "鑅" => "a",
     "鑆" => "a",
     "鑇" => "a",
     "鑈" => "a",
     "鑉" => "a",
     "鑊" => "a",
     "鑌" => "a",
     "鑏" => "a",
     "鑐" => "a",
     "鑑" => "a",
     "鑕" => "a",
     "鑗" => "a",
     "鑝" => "a",
     "鑞" => "a",
     "鑠" => "a",
     "鑢" => "a",
     "鑣" => "a",
     "鑤" => "a",
     "鑨" => "a",
     "鑩" => "a",
     "鑪" => "a",
     "鑫" => "a",
     "鑭" => "a",
     "鑮" => "a",
     "鑯" => "a",
     "鑰" => "a",
     "鑱" => "a",
     "鑲" => "a",
     "鑳" => "a",
     "鑴" => "a",
     "鑵" => "a",
     "鑶" => "a",
     "鑷" => "a",
     "鑸" => "a",
     "鑼" => "a",
     "鑽" => "a",
     "钀" => "a",
     "钁" => "a",
     "钂" => "a",
     "钃" => "a",
     "隿" => "a",
     "雂" => "a",
     "韽" => "a",
     "領" => "a",
     "頜" => "a",
     "頷" => "a",
     "顉" => "a",
     "顑" => "a",
     "顣" => "a",
     "顩" => "a",
     "飆" => "a",
     "餘" => "a",
     "駐" => "a",
     "髮" => "a",
     "鳶" => "a",
     "鳹" => "a",
     "鴒" => "a",
     "鴿" => "a",
     "鵏" => "a",
     "鶐" => "a",
     "鶬" => "a",
     "鷨" => "a",
     "鸗" => "a",
     "鸙" => "a",
     "點" => "a",
     "龍" => "a",
     "龑" => "a",
     "龒" => "a",
     "龔" => "a",
     "龕" => "a",
     "龘" => "a",
     "龠" => "a",
     "龢" => "a",
     "龤" => "a",
     "不" => "b",
     "丕" => "b",
     "並" => "b",
     "丫" => "b",
     "乏" => "b",
     "亡" => "b",
     "人" => "b",
     "介" => "b",
     "仚" => "b",
     "仝" => "b",
     "企" => "b",
     "俎" => "b",
     "個" => "b",
     "傘" => "b",
     "兌" => "b",
     "入" => "b",
     "全" => "b",
     "八" => "b",
     "公" => "b",
     "兼" => "b",
     "冱" => "b",
     "冶" => "b",
     "冷" => "b",
     "冹" => "b",
     "冼" => "b",
     "冽" => "b",
     "冾" => "b",
     "凄" => "b",
     "凅" => "b",
     "准" => "b",
     "凈" => "b",
     "凊" => "b",
     "凋" => "b",
     "凌" => "b",
     "凍" => "b",
     "凎" => "b",
     "凐" => "b",
     "凔" => "b",
     "凗" => "b",
     "凘" => "b",
     "凜" => "b",
     "凝" => "b",
     "凞" => "b",
     "分" => "b",
     "判" => "b",
     "券" => "b",
     "剃" => "b",
     "剉" => "b",
     "前" => "b",
     "剪" => "b",
     "勓" => "b",
     "半" => "b",
     "卷" => "b",
     "卻" => "b",
     "叛" => "b",
     "叢" => "b",
     "否" => "b",
     "咨" => "b",
     "善" => "b",
     "單" => "b",
     "坌" => "b",
     "坐" => "b",
     "坒" => "b",
     "塑" => "b",
     "墜" => "b",
     "墬" => "b",
     "墮" => "b",
     "夎" => "b",
     "夔" => "b",
     "奀" => "b",
     "奠" => "b",
     "姜" => "b",
     "姿" => "b",
     "嫳" => "b",
     "孬" => "b",
     "孳" => "b",
     "尊" => "b",
     "導" => "b",
     "尒" => "b",
     "屳" => "b",
     "岔" => "b",
     "峹" => "b",
     "嵞" => "b",
     "嶞" => "b",
     "差" => "b",
     "帣" => "b",
     "幣" => "b",
     "并" => "b",
     "弅" => "b",
     "弊" => "b",
     "弚" => "b",
     "弟" => "b",
     "弮" => "b",
     "彆" => "b",
     "從" => "b",
     "忿" => "b",
     "恙" => "b",
     "恣" => "b",
     "悆" => "b",
     "愬" => "b",
     "慈" => "b",
     "慫" => "b",
     "慾" => "b",
     "憋" => "b",
     "憑" => "b",
     "戰" => "b",
     "拳" => "b",
     "攽" => "b",
     "敓" => "b",
     "敝" => "b",
     "敶" => "b",
     "斃" => "b",
     "斧" => "b",
     "普" => "b",
     "曾" => "b",
     "朔" => "b",
     "柒" => "b",
     "栥" => "b",
     "楶" => "b",
     "槊" => "b",
     "檃" => "b",
     "次" => "b",
     "欲" => "b",
     "歉" => "b",
     "歪" => "b",
     "比" => "b",
     "毖" => "b",
     "毞" => "b",
     "毤" => "b",
     "汆" => "b",
     "決" => "b",
     "沖" => "b",
     "涂" => "b",
     "涼" => "b",
     "淨" => "b",
     "減" => "b",
     "湊" => "b",
     "準" => "b",
     "炃" => "b",
     "為" => "b",
     "煎" => "b",
     "父" => "b",
     "爸" => "b",
     "爹" => "b",
     "爺" => "b",
     "牶" => "b",
     "狹" => "b",
     "猷" => "b",
     "獘" => "b",
     "獸" => "b",
     "瓮" => "b",
     "瓶" => "b",
     "瓷" => "b",
     "甑" => "b",
     "甭" => "b",
     "畢" => "b",
     "畬" => "b",
     "皆" => "b",
     "盃" => "b",
     "盆" => "b",
     "益" => "b",
     "盜" => "b",
     "眷" => "b",
     "眾" => "b",
     "瞥" => "b",
     "禽" => "b",
     "秶" => "b",
     "粊" => "b",
     "粢" => "b",
     "糴" => "b",
     "絭" => "b",
     "總" => "b",
     "羊" => "b",
     "羋" => "b",
     "羌" => "b",
     "美" => "b",
     "羑" => "b",
     "羒" => "b",
     "羔" => "b",
     "羕" => "b",
     "羖" => "b",
     "羚" => "b",
     "羛" => "b",
     "羜" => "b",
     "羝" => "b",
     "羞" => "b",
     "羠" => "b",
     "羡" => "b",
     "羢" => "b",
     "羥" => "b",
     "羦" => "b",
     "羧" => "b",
     "羨" => "b",
     "羬" => "b",
     "羭" => "b",
     "羯" => "b",
     "羰" => "b",
     "羱" => "b",
     "羲" => "b",
     "羳" => "b",
     "羵" => "b",
     "羶" => "b",
     "羷" => "b",
     "羹" => "b",
     "羺" => "b",
     "羻" => "b",
     "翁" => "b",
     "翔" => "b",
     "翦" => "b",
     "聳" => "b",
     "肏" => "b",
     "脊" => "b",
     "舍" => "b",
     "舒" => "b",
     "舖" => "b",
     "艵" => "b",
     "茲" => "b",
     "著" => "b",
     "蓋" => "b",
     "蘭" => "b",
     "螴" => "b",
     "螸" => "b",
     "蟞" => "b",
     "蠤" => "b",
     "蠲" => "b",
     "觠" => "b",
     "謄" => "b",
     "谷" => "b",
     "谹" => "b",
     "谻" => "b",
     "谼" => "b",
     "谽" => "b",
     "谾" => "b",
     "豂" => "b",
     "豃" => "b",
     "豅" => "b",
     "豢" => "b",
     "貧" => "b",
     "資" => "b",
     "蹩" => "b",
     "迸" => "b",
     "送" => "b",
     "逆" => "b",
     "遂" => "b",
     "遒" => "b",
     "道" => "b",
     "遞" => "b",
     "遵" => "b",
     "還" => "b",
     "邠" => "b",
     "邳" => "b",
     "郤" => "b",
     "郱" => "b",
     "鄨" => "b",
     "鄫" => "b",
     "鄬" => "b",
     "鄭" => "b",
     "鄯" => "b",
     "酋" => "b",
     "釜" => "b",
     "鐆" => "b",
     "關" => "b",
     "阞" => "b",
     "阠" => "b",
     "阡" => "b",
     "阢" => "b",
     "阣" => "b",
     "阤" => "b",
     "阨" => "b",
     "阪" => "b",
     "阬" => "b",
     "阭" => "b",
     "阮" => "b",
     "阯" => "b",
     "阰" => "b",
     "阱" => "b",
     "防" => "b",
     "阹" => "b",
     "阺" => "b",
     "阻" => "b",
     "阼" => "b",
     "阽" => "b",
     "阿" => "b",
     "陀" => "b",
     "陂" => "b",
     "陃" => "b",
     "附" => "b",
     "陊" => "b",
     "陋" => "b",
     "陌" => "b",
     "降" => "b",
     "陎" => "b",
     "陏" => "b",
     "限" => "b",
     "陑" => "b",
     "陓" => "b",
     "陔" => "b",
     "陘" => "b",
     "陛" => "b",
     "陜" => "b",
     "陝" => "b",
     "陞" => "b",
     "陟" => "b",
     "陡" => "b",
     "院" => "b",
     "陣" => "b",
     "除" => "b",
     "陪" => "b",
     "陫" => "b",
     "陬" => "b",
     "陭" => "b",
     "陯" => "b",
     "陰" => "b",
     "陱" => "b",
     "陲" => "b",
     "陳" => "b",
     "陴" => "b",
     "陵" => "b",
     "陶" => "b",
     "陷" => "b",
     "陸" => "b",
     "陼" => "b",
     "陽" => "b",
     "陾" => "b",
     "隀" => "b",
     "隃" => "b",
     "隄" => "b",
     "隅" => "b",
     "隆" => "b",
     "隇" => "b",
     "隈" => "b",
     "隉" => "b",
     "隊" => "b",
     "隋" => "b",
     "隍" => "b",
     "階" => "b",
     "隑" => "b",
     "隒" => "b",
     "隓" => "b",
     "隔" => "b",
     "隕" => "b",
     "隗" => "b",
     "隘" => "b",
     "隙" => "b",
     "際" => "b",
     "障" => "b",
     "隞" => "b",
     "隡" => "b",
     "隢" => "b",
     "隤" => "b",
     "隧" => "b",
     "隨" => "b",
     "隩" => "b",
     "險" => "b",
     "隬" => "b",
     "隮" => "b",
     "隰" => "b",
     "隱" => "b",
     "隳" => "b",
     "隴" => "b",
     "雓" => "b",
     "韏" => "b",
     "韱" => "b",
     "頌" => "b",
     "頒" => "b",
     "頖" => "b",
     "頩" => "b",
     "頭" => "b",
     "餈" => "b",
     "養" => "b",
     "館" => "b",
     "首" => "b",
     "馘" => "b",
     "馮" => "b",
     "騭" => "b",
     "鯗" => "b",
     "鱉" => "b",
     "鳻" => "b",
     "鴀" => "b",
     "鴔" => "b",
     "鵒" => "b",
     "鵜" => "b",
     "鵧" => "b",
     "鵨" => "b",
     "鶛" => "b",
     "鶲" => "b",
     "鶺" => "b",
     "鶿" => "b",
     "鷁" => "b",
     "鷩" => "b",
     "鷷" => "b",
     "麶" => "b",
     "齤" => "b",
     "齹" => "b",
     "七" => "c",
     "中" => "c",
     "串" => "c",
     "乜" => "c",
     "切" => "c",
     "刷" => "c",
     "剝" => "c",
     "剭" => "c",
     "剸" => "c",
     "剽" => "c",
     "劇" => "c",
     "劈" => "c",
     "劙" => "c",
     "史" => "c",
     "名" => "c",
     "咫" => "c",
     "垔" => "c",
     "塹" => "c",
     "墼" => "c",
     "壁" => "c",
     "壂" => "c",
     "夕" => "c",
     "外" => "c",
     "夗" => "c",
     "多" => "c",
     "夠" => "c",
     "夤" => "c",
     "央" => "c",
     "妴" => "c",
     "嬖" => "c",
     "孱" => "c",
     "宣" => "c",
     "專" => "c",
     "尉" => "c",
     "尸" => "c",
     "尺" => "c",
     "尻" => "c",
     "尼" => "c",
     "尾" => "c",
     "尿" => "c",
     "局" => "c",
     "屁" => "c",
     "屄" => "c",
     "居" => "c",
     "屆" => "c",
     "屇" => "c",
     "屈" => "c",
     "屋" => "c",
     "屌" => "c",
     "屍" => "c",
     "屎" => "c",
     "屏" => "c",
     "屐" => "c",
     "屑" => "c",
     "展" => "c",
     "屖" => "c",
     "屘" => "c",
     "屙" => "c",
     "屜" => "c",
     "屝" => "c",
     "屠" => "c",
     "屢" => "c",
     "屣" => "c",
     "層" => "c",
     "履" => "c",
     "屧" => "c",
     "屨" => "c",
     "屩" => "c",
     "屪" => "c",
     "屬" => "c",
     "屭" => "c",
     "岊" => "c",
     "巴" => "c",
     "幦" => "c",
     "彔" => "c",
     "彖" => "c",
     "彘" => "c",
     "彙" => "c",
     "彝" => "c",
     "彯" => "c",
     "忠" => "c",
     "怨" => "c",
     "患" => "c",
     "惠" => "c",
     "慰" => "c",
     "憵" => "c",
     "捷" => "c",
     "擊" => "c",
     "擘" => "c",
     "斬" => "c",
     "斸" => "c",
     "晝" => "c",
     "暫" => "c",
     "東" => "c",
     "柬" => "c",
     "栗" => "c",
     "桀" => "c",
     "槧" => "c",
     "檕" => "c",
     "檗" => "c",
     "歅" => "c",
     "殿" => "c",
     "毄" => "c",
     "溪" => "c",
     "熨" => "c",
     "犀" => "c",
     "犚" => "c",
     "璧" => "c",
     "瓢" => "c",
     "甄" => "c",
     "甓" => "c",
     "盅" => "c",
     "盍" => "c",
     "盎" => "c",
     "盝" => "c",
     "盡" => "c",
     "眉" => "c",
     "眢" => "c",
     "磛" => "c",
     "票" => "c",
     "禍" => "c",
     "粟" => "c",
     "糪" => "c",
     "繫" => "c",
     "繴" => "c",
     "罊" => "c",
     "羼" => "c",
     "翗" => "c",
     "翲" => "c",
     "臀" => "c",
     "臂" => "c",
     "舛" => "c",
     "虫" => "c",
     "虭" => "c",
     "虮" => "c",
     "虯" => "c",
     "虰" => "c",
     "虳" => "c",
     "虴" => "c",
     "虷" => "c",
     "虹" => "c",
     "虻" => "c",
     "虼" => "c",
     "蚅" => "c",
     "蚆" => "c",
     "蚇" => "c",
     "蚊" => "c",
     "蚋" => "c",
     "蚌" => "c",
     "蚍" => "c",
     "蚎" => "c",
     "蚐" => "c",
     "蚑" => "c",
     "蚓" => "c",
     "蚔" => "c",
     "蚖" => "c",
     "蚗" => "c",
     "蚘" => "c",
     "蚙" => "c",
     "蚚" => "c",
     "蚜" => "c",
     "蚝" => "c",
     "蚞" => "c",
     "蚡" => "c",
     "蚢" => "c",
     "蚣" => "c",
     "蚥" => "c",
     "蚧" => "c",
     "蚨" => "c",
     "蚪" => "c",
     "蚯" => "c",
     "蚰" => "c",
     "蚱" => "c",
     "蚳" => "c",
     "蚴" => "c",
     "蚵" => "c",
     "蚶" => "c",
     "蚷" => "c",
     "蚸" => "c",
     "蚹" => "c",
     "蚺" => "c",
     "蚼" => "c",
     "蚽" => "c",
     "蚾" => "c",
     "蚿" => "c",
     "蛀" => "c",
     "蛁" => "c",
     "蛂" => "c",
     "蛃" => "c",
     "蛄" => "c",
     "蛅" => "c",
     "蛆" => "c",
     "蛇" => "c",
     "蛈" => "c",
     "蛉" => "c",
     "蛌" => "c",
     "蛐" => "c",
     "蛑" => "c",
     "蛔" => "c",
     "蛖" => "c",
     "蛘" => "c",
     "蛙" => "c",
     "蛚" => "c",
     "蛛" => "c",
     "蛜" => "c",
     "蛝" => "c",
     "蛞" => "c",
     "蛟" => "c",
     "蛢" => "c",
     "蛣" => "c",
     "蛤" => "c",
     "蛦" => "c",
     "蛨" => "c",
     "蛫" => "c",
     "蛭" => "c",
     "蛵" => "c",
     "蛶" => "c",
     "蛷" => "c",
     "蛸" => "c",
     "蛹" => "c",
     "蛺" => "c",
     "蛻" => "c",
     "蛾" => "c",
     "蜁" => "c",
     "蜂" => "c",
     "蜄" => "c",
     "蜅" => "c",
     "蜆" => "c",
     "蜈" => "c",
     "蜉" => "c",
     "蜊" => "c",
     "蜋" => "c",
     "蜌" => "c",
     "蜍" => "c",
     "蜎" => "c",
     "蜒" => "c",
     "蜓" => "c",
     "蜘" => "c",
     "蜙" => "c",
     "蜛" => "c",
     "蜞" => "c",
     "蜠" => "c",
     "蜡" => "c",
     "蜢" => "c",
     "蜣" => "c",
     "蜥" => "c",
     "蜦" => "c",
     "蜧" => "c",
     "蜨" => "c",
     "蜩" => "c",
     "蜪" => "c",
     "蜬" => "c",
     "蜭" => "c",
     "蜮" => "c",
     "蜱" => "c",
     "蜲" => "c",
     "蜳" => "c",
     "蜴" => "c",
     "蜵" => "c",
     "蜷" => "c",
     "蜺" => "c",
     "蜻" => "c",
     "蜼" => "c",
     "蜾" => "c",
     "蜿" => "c",
     "蝀" => "c",
     "蝂" => "c",
     "蝃" => "c",
     "蝆" => "c",
     "蝌" => "c",
     "蝍" => "c",
     "蝎" => "c",
     "蝏" => "c",
     "蝐" => "c",
     "蝑" => "c",
     "蝒" => "c",
     "蝓" => "c",
     "蝔" => "c",
     "蝖" => "c",
     "蝗" => "c",
     "蝘" => "c",
     "蝙" => "c",
     "蝚" => "c",
     "蝛" => "c",
     "蝜" => "c",
     "蝝" => "c",
     "蝞" => "c",
     "蝟" => "c",
     "蝠" => "c",
     "蝡" => "c",
     "蝢" => "c",
     "蝣" => "c",
     "蝤" => "c",
     "蝦" => "c",
     "蝧" => "c",
     "蝩" => "c",
     "蝪" => "c",
     "蝫" => "c",
     "蝬" => "c",
     "蝭" => "c",
     "蝮" => "c",
     "蝯" => "c",
     "蝳" => "c",
     "蝴" => "c",
     "蝶" => "c",
     "蝷" => "c",
     "蝸" => "c",
     "蝹" => "c",
     "蝺" => "c",
     "蝻" => "c",
     "螁" => "c",
     "螂" => "c",
     "螃" => "c",
     "螄" => "c",
     "螅" => "c",
     "螇" => "c",
     "螈" => "c",
     "螉" => "c",
     "螏" => "c",
     "螐" => "c",
     "螑" => "c",
     "螓" => "c",
     "螔" => "c",
     "螖" => "c",
     "螗" => "c",
     "螘" => "c",
     "螛" => "c",
     "螝" => "c",
     "螞" => "c",
     "螟" => "c",
     "螪" => "c",
     "螬" => "c",
     "螭" => "c",
     "螮" => "c",
     "螰" => "c",
     "螲" => "c",
     "螳" => "c",
     "螵" => "c",
     "螹" => "c",
     "螺" => "c",
     "螻" => "c",
     "螼" => "c",
     "螾" => "c",
     "蟀" => "c",
     "蟂" => "c",
     "蟃" => "c",
     "蟅" => "c",
     "蟆" => "c",
     "蟈" => "c",
     "蟉" => "c",
     "蟋" => "c",
     "蟌" => "c",
     "蟑" => "c",
     "蟒" => "c",
     "蟓" => "c",
     "蟔" => "c",
     "蟘" => "c",
     "蟙" => "c",
     "蟛" => "c",
     "蟜" => "c",
     "蟝" => "c",
     "蟟" => "c",
     "蟠" => "c",
     "蟡" => "c",
     "蟢" => "c",
     "蟣" => "c",
     "蟤" => "c",
     "蟥" => "c",
     "蟦" => "c",
     "蟧" => "c",
     "蟪" => "c",
     "蟫" => "c",
     "蟬" => "c",
     "蟭" => "c",
     "蟯" => "c",
     "蟲" => "c",
     "蟳" => "c",
     "蟶" => "c",
     "蟷" => "c",
     "蟺" => "c",
     "蟻" => "c",
     "蟾" => "c",
     "蟿" => "c",
     "蠀" => "c",
     "蠂" => "c",
     "蠅" => "c",
     "蠉" => "c",
     "蠊" => "c",
     "蠋" => "c",
     "蠌" => "c",
     "蠍" => "c",
     "蠐" => "c",
     "蠑" => "c",
     "蠓" => "c",
     "蠔" => "c",
     "蠕" => "c",
     "蠖" => "c",
     "蠗" => "c",
     "蠙" => "c",
     "蠛" => "c",
     "蠝" => "c",
     "蠟" => "c",
     "蠡" => "c",
     "蠣" => "c",
     "蠦" => "c",
     "蠨" => "c",
     "蠩" => "c",
     "蠬" => "c",
     "蠮" => "c",
     "蠰" => "c",
     "蠱" => "c",
     "蠳" => "c",
     "蠵" => "c",
     "蠷" => "c",
     "蠸" => "c",
     "蠼" => "c",
     "蠾" => "c",
     "袃" => "c",
     "褽" => "c",
     "襞" => "c",
     "襾" => "c",
     "西" => "c",
     "要" => "c",
     "覂" => "c",
     "覃" => "c",
     "覅" => "c",
     "覆" => "c",
     "覈" => "c",
     "譬" => "c",
     "貴" => "c",
     "賈" => "c",
     "蹔" => "c",
     "躄" => "c",
     "車" => "c",
     "軋" => "c",
     "軌" => "c",
     "軏" => "c",
     "軑" => "c",
     "軒" => "c",
     "軓" => "c",
     "軔" => "c",
     "軗" => "c",
     "軘" => "c",
     "軛" => "c",
     "軜" => "c",
     "軝" => "c",
     "軞" => "c",
     "軟" => "c",
     "軠" => "c",
     "軡" => "c",
     "軥" => "c",
     "軦" => "c",
     "軧" => "c",
     "軨" => "c",
     "軩" => "c",
     "軫" => "c",
     "軮" => "c",
     "軯" => "c",
     "軱" => "c",
     "軴" => "c",
     "軵" => "c",
     "軶" => "c",
     "軷" => "c",
     "軸" => "c",
     "軹" => "c",
     "軺" => "c",
     "軻" => "c",
     "軼" => "c",
     "軾" => "c",
     "軿" => "c",
     "輀" => "c",
     "輁" => "c",
     "較" => "c",
     "輅" => "c",
     "輆" => "c",
     "輇" => "c",
     "輈" => "c",
     "輊" => "c",
     "輍" => "c",
     "輎" => "c",
     "輐" => "c",
     "輑" => "c",
     "輒" => "c",
     "輓" => "c",
     "輔" => "c",
     "輕" => "c",
     "輖" => "c",
     "輗" => "c",
     "輘" => "c",
     "輚" => "c",
     "輛" => "c",
     "輜" => "c",
     "輞" => "c",
     "輟" => "c",
     "輠" => "c",
     "輣" => "c",
     "輤" => "c",
     "輥" => "c",
     "輪" => "c",
     "輬" => "c",
     "輮" => "c",
     "輯" => "c",
     "輲" => "c",
     "輳" => "c",
     "輴" => "c",
     "輵" => "c",
     "輶" => "c",
     "輷" => "c",
     "輸" => "c",
     "輹" => "c",
     "輻" => "c",
     "輾" => "c",
     "輿" => "c",
     "轀" => "c",
     "轃" => "c",
     "轄" => "c",
     "轅" => "c",
     "轆" => "c",
     "轇" => "c",
     "轈" => "c",
     "轉" => "c",
     "轋" => "c",
     "轍" => "c",
     "轎" => "c",
     "轏" => "c",
     "轐" => "c",
     "轑" => "c",
     "轒" => "c",
     "轓" => "c",
     "轔" => "c",
     "轕" => "c",
     "轖" => "c",
     "轗" => "c",
     "轘" => "c",
     "轙" => "c",
     "轚" => "c",
     "轛" => "c",
     "轞" => "c",
     "轟" => "c",
     "轠" => "c",
     "轡" => "c",
     "轢" => "c",
     "轣" => "c",
     "轤" => "c",
     "辟" => "c",
     "迉" => "c",
     "迡" => "c",
     "迺" => "c",
     "迻" => "c",
     "連" => "c",
     "逯" => "c",
     "遣" => "c",
     "遲" => "c",
     "遷" => "c",
     "遺" => "c",
     "避" => "c",
     "郺" => "c",
     "郿" => "c",
     "鄄" => "c",
     "鄟" => "c",
     "鏨" => "c",
     "鑋" => "c",
     "雒" => "c",
     "霸" => "c",
     "顠" => "c",
     "飄" => "c",
     "飧" => "c",
     "餮" => "c",
     "駂" => "c",
     "駌" => "c",
     "鳲" => "c",
     "鴇" => "c",
     "鴛" => "c",
     "鴦" => "c",
     "鶇" => "c",
     "鶋" => "c",
     "鶌" => "c",
     "鶨" => "c",
     "鷅" => "c",
     "鷒" => "c",
     "鷣" => "c",
     "鷵" => "c",
     "鷿" => "c",
     "鼊" => "c",
     "" => "c",
     "" => "c",
     "" => "c",
     "" => "c",
     "互" => "d",
     "亙" => "d",
     "債" => "d",
     "免" => "d",
     "兔" => "d",
     "冒" => "d",
     "冔" => "d",
     "冕" => "d",
     "刀" => "d",
     "刃" => "d",
     "列" => "d",
     "刳" => "d",
     "剔" => "d",
     "剞" => "d",
     "剬" => "d",
     "劉" => "d",
     "力" => "d",
     "加" => "d",
     "劦" => "d",
     "劭" => "d",
     "勉" => "d",
     "勖" => "d",
     "勗" => "d",
     "勰" => "d",
     "匏" => "d",
     "匙" => "d",
     "卯" => "d",
     "卲" => "d",
     "即" => "d",
     "卵" => "d",
     "卿" => "d",
     "召" => "d",
     "哿" => "d",
     "嗧" => "d",
     "堲" => "d",
     "塈" => "d",
     "墾" => "d",
     "大" => "d",
     "太" => "d",
     "夯" => "d",
     "夸" => "d",
     "夼" => "d",
     "奄" => "d",
     "奅" => "d",
     "奇" => "d",
     "奈" => "d",
     "奎" => "d",
     "奓" => "d",
     "奔" => "d",
     "套" => "d",
     "奢" => "d",
     "奩" => "d",
     "奪" => "d",
     "奫" => "d",
     "奭" => "d",
     "奮" => "d",
     "奲" => "d",
     "姭" => "d",
     "姴" => "d",
     "孵" => "d",
     "尟" => "d",
     "影" => "d",
     "待" => "d",
     "得" => "d",
     "忍" => "d",
     "態" => "d",
     "懇" => "d",
     "戥" => "d",
     "攲" => "d",
     "敧" => "d",
     "斗" => "d",
     "既" => "d",
     "日" => "d",
     "旦" => "d",
     "早" => "d",
     "旯" => "d",
     "旰" => "d",
     "旱" => "d",
     "旲" => "d",
     "旳" => "d",
     "旴" => "d",
     "旵" => "d",
     "旺" => "d",
     "旻" => "d",
     "旼" => "d",
     "旽" => "d",
     "昀" => "d",
     "昂" => "d",
     "昃" => "d",
     "昄" => "d",
     "昅" => "d",
     "昆" => "d",
     "昇" => "d",
     "昈" => "d",
     "昉" => "d",
     "昊" => "d",
     "昌" => "d",
     "昍" => "d",
     "明" => "d",
     "昐" => "d",
     "昑" => "d",
     "昒" => "d",
     "易" => "d",
     "昕" => "d",
     "昜" => "d",
     "星" => "d",
     "映" => "d",
     "昡" => "d",
     "昢" => "d",
     "昤" => "d",
     "昦" => "d",
     "昧" => "d",
     "昨" => "d",
     "昫" => "d",
     "昭" => "d",
     "昮" => "d",
     "是" => "d",
     "昱" => "d",
     "昲" => "d",
     "昳" => "d",
     "昴" => "d",
     "昵" => "d",
     "昹" => "d",
     "昺" => "d",
     "晁" => "d",
     "時" => "d",
     "晃" => "d",
     "晅" => "d",
     "晇" => "d",
     "晊" => "d",
     "晌" => "d",
     "晏" => "d",
     "晑" => "d",
     "晒" => "d",
     "晙" => "d",
     "晚" => "d",
     "晛" => "d",
     "晜" => "d",
     "晞" => "d",
     "晟" => "d",
     "晡" => "d",
     "晤" => "d",
     "晥" => "d",
     "晦" => "d",
     "晨" => "d",
     "晪" => "d",
     "晬" => "d",
     "景" => "d",
     "晰" => "d",
     "晱" => "d",
     "晲" => "d",
     "晴" => "d",
     "晶" => "d",
     "晷" => "d",
     "晸" => "d",
     "晹" => "d",
     "晻" => "d",
     "晼" => "d",
     "晾" => "d",
     "暀" => "d",
     "暄" => "d",
     "暆" => "d",
     "暇" => "d",
     "暈" => "d",
     "暉" => "d",
     "暊" => "d",
     "暌" => "d",
     "暍" => "d",
     "暐" => "d",
     "暑" => "d",
     "暔" => "d",
     "暕" => "d",
     "暖" => "d",
     "暗" => "d",
     "暘" => "d",
     "暙" => "d",
     "暝" => "d",
     "暟" => "d",
     "暠" => "d",
     "暡" => "d",
     "暨" => "d",
     "暩" => "d",
     "暪" => "d",
     "暯" => "d",
     "暰" => "d",
     "暱" => "d",
     "暲" => "d",
     "暴" => "d",
     "暵" => "d",
     "暷" => "d",
     "暸" => "d",
     "暹" => "d",
     "暺" => "d",
     "暻" => "d",
     "暽" => "d",
     "暾" => "d",
     "曀" => "d",
     "曄" => "d",
     "曇" => "d",
     "曈" => "d",
     "曉" => "d",
     "曊" => "d",
     "曋" => "d",
     "曌" => "d",
     "曏" => "d",
     "曒" => "d",
     "曖" => "d",
     "曘" => "d",
     "曙" => "d",
     "曚" => "d",
     "曛" => "d",
     "曜" => "d",
     "曝" => "d",
     "曞" => "d",
     "曠" => "d",
     "曣" => "d",
     "曤" => "d",
     "曦" => "d",
     "曨" => "d",
     "曩" => "d",
     "曬" => "d",
     "曭" => "d",
     "曮" => "d",
     "曰" => "d",
     "曷" => "d",
     "曼" => "d",
     "最" => "d",
     "杲" => "d",
     "架" => "d",
     "欥" => "d",
     "欹" => "d",
     "欿" => "d",
     "歂" => "d",
     "歇" => "d",
     "歞" => "d",
     "歹" => "d",
     "死" => "d",
     "歾" => "d",
     "歿" => "d",
     "殀" => "d",
     "殂" => "d",
     "殃" => "d",
     "殄" => "d",
     "殆" => "d",
     "殈" => "d",
     "殉" => "d",
     "殊" => "d",
     "殌" => "d",
     "殍" => "d",
     "殎" => "d",
     "殏" => "d",
     "殑" => "d",
     "殔" => "d",
     "殕" => "d",
     "殖" => "d",
     "殗" => "d",
     "殘" => "d",
     "殙" => "d",
     "殛" => "d",
     "殞" => "d",
     "殟" => "d",
     "殠" => "d",
     "殢" => "d",
     "殣" => "d",
     "殤" => "d",
     "殥" => "d",
     "殦" => "d",
     "殧" => "d",
     "殪" => "d",
     "殫" => "d",
     "殭" => "d",
     "殮" => "d",
     "殯" => "d",
     "殰" => "d",
     "殲" => "d",
     "毈" => "d",
     "毠" => "d",
     "毷" => "d",
     "毼" => "d",
     "毾" => "d",
     "渡" => "d",
     "炅" => "d",
     "炚" => "d",
     "烈" => "d",
     "煚" => "d",
     "煦" => "d",
     "照" => "d",
     "燄" => "d",
     "爽" => "d",
     "牽" => "d",
     "猒" => "d",
     "瓠" => "d",
     "留" => "d",
     "的" => "d",
     "盟" => "d",
     "綔" => "d",
     "羍" => "d",
     "耑" => "d",
     "耷" => "d",
     "肂" => "d",
     "脅" => "d",
     "艮" => "d",
     "色" => "d",
     "袈" => "d",
     "裂" => "d",
     "謈" => "d",
     "豆" => "d",
     "豇" => "d",
     "豉" => "d",
     "豌" => "d",
     "豍" => "d",
     "豏" => "d",
     "負" => "d",
     "貿" => "d",
     "賀" => "d",
     "贕" => "d",
     "辦" => "d",
     "迢" => "d",
     "迦" => "d",
     "迾" => "d",
     "退" => "d",
     "逗" => "d",
     "逸" => "d",
     "逿" => "d",
     "遄" => "d",
     "遏" => "d",
     "達" => "d",
     "遛" => "d",
     "遢" => "d",
     "遼" => "d",
     "邊" => "d",
     "邵" => "d",
     "郖" => "d",
     "鄤" => "d",
     "鄮" => "d",
     "量" => "d",
     "韙" => "d",
     "題" => "d",
     "顓" => "d",
     "顥" => "d",
     "顯" => "d",
     "駕" => "d",
     "鬥" => "d",
     "鬧" => "d",
     "鬨" => "d",
     "鬩" => "d",
     "鬫" => "d",
     "鬮" => "d",
     "鮤" => "d",
     "鱀" => "d",
     "鳭" => "d",
     "鴐" => "d",
     "鴠" => "d",
     "鴮" => "d",
     "鴷" => "d",
     "鵪" => "d",
     "鵵" => "d",
     "鵸" => "d",
     "鶗" => "d",
     "鶡" => "d",
     "鶹" => "d",
     "鷃" => "d",
     "鷐" => "d",
     "鷞" => "d",
     "鷯" => "d",
     "一" => "e",
     "万" => "e",
     "丌" => "e",
     "丑" => "e",
     "丙" => "e",
     "乳" => "e",
     "乿" => "e",
     "亂" => "e",
     "亞" => "e",
     "兀" => "e",
     "兩" => "e",
     "再" => "e",
     "凱" => "e",
     "出" => "e",
     "剄" => "e",
     "剢" => "e",
     "副" => "e",
     "剴" => "e",
     "剻" => "e",
     "劌" => "e",
     "勁" => "e",
     "印" => "e",
     "卼" => "e",
     "受" => "e",
     "司" => "e",
     "君" => "e",
     "吞" => "e",
     "喬" => "e",
     "嚴" => "e",
     "天" => "e",
     "夷" => "e",
     "奚" => "e",
     "妥" => "e",
     "孚" => "e",
     "尋" => "e",
     "尬" => "e",
     "尷" => "e",
     "尹" => "e",
     "屮" => "e",
     "屯" => "e",
     "山" => "e",
     "屴" => "e",
     "屹" => "e",
     "屺" => "e",
     "屻" => "e",
     "屼" => "e",
     "屾" => "e",
     "岆" => "e",
     "岈" => "e",
     "岉" => "e",
     "岋" => "e",
     "岌" => "e",
     "岍" => "e",
     "岏" => "e",
     "岐" => "e",
     "岑" => "e",
     "岒" => "e",
     "岓" => "e",
     "岕" => "e",
     "岝" => "e",
     "岟" => "e",
     "岠" => "e",
     "岢" => "e",
     "岣" => "e",
     "岤" => "e",
     "岥" => "e",
     "岦" => "e",
     "岧" => "e",
     "岨" => "e",
     "岩" => "e",
     "岪" => "e",
     "岫" => "e",
     "岬" => "e",
     "岭" => "e",
     "岮" => "e",
     "岯" => "e",
     "岰" => "e",
     "岵" => "e",
     "岶" => "e",
     "岷" => "e",
     "岸" => "e",
     "峆" => "e",
     "峇" => "e",
     "峈" => "e",
     "峉" => "e",
     "峋" => "e",
     "峌" => "e",
     "峎" => "e",
     "峏" => "e",
     "峐" => "e",
     "峒" => "e",
     "峓" => "e",
     "峔" => "e",
     "峖" => "e",
     "峗" => "e",
     "峘" => "e",
     "峙" => "e",
     "峚" => "e",
     "峛" => "e",
     "峞" => "e",
     "峟" => "e",
     "峨" => "e",
     "峪" => "e",
     "峬" => "e",
     "峭" => "e",
     "峮" => "e",
     "峰" => "e",
     "峴" => "e",
     "峷" => "e",
     "峸" => "e",
     "峻" => "e",
     "峽" => "e",
     "峿" => "e",
     "崀" => "e",
     "崁" => "e",
     "崆" => "e",
     "崇" => "e",
     "崋" => "e",
     "崌" => "e",
     "崍" => "e",
     "崎" => "e",
     "崏" => "e",
     "崑" => "e",
     "崒" => "e",
     "崔" => "e",
     "崖" => "e",
     "崗" => "e",
     "崙" => "e",
     "崚" => "e",
     "崛" => "e",
     "崝" => "e",
     "崞" => "e",
     "崟" => "e",
     "崠" => "e",
     "崢" => "e",
     "崣" => "e",
     "崤" => "e",
     "崥" => "e",
     "崦" => "e",
     "崧" => "e",
     "崨" => "e",
     "崩" => "e",
     "崮" => "e",
     "崰" => "e",
     "崱" => "e",
     "崲" => "e",
     "崳" => "e",
     "崴" => "e",
     "崵" => "e",
     "崶" => "e",
     "崷" => "e",
     "崸" => "e",
     "崹" => "e",
     "崺" => "e",
     "崼" => "e",
     "崽" => "e",
     "崿" => "e",
     "嵀" => "e",
     "嵁" => "e",
     "嵂" => "e",
     "嵃" => "e",
     "嵅" => "e",
     "嵉" => "e",
     "嵊" => "e",
     "嵋" => "e",
     "嵌" => "e",
     "嵎" => "e",
     "嵐" => "e",
     "嵑" => "e",
     "嵕" => "e",
     "嵙" => "e",
     "嵢" => "e",
     "嵣" => "e",
     "嵥" => "e",
     "嵧" => "e",
     "嵨" => "e",
     "嵩" => "e",
     "嵫" => "e",
     "嵬" => "e",
     "嵯" => "e",
     "嵱" => "e",
     "嵲" => "e",
     "嵷" => "e",
     "嵹" => "e",
     "嵺" => "e",
     "嵼" => "e",
     "嵽" => "e",
     "嵾" => "e",
     "嵿" => "e",
     "嶀" => "e",
     "嶁" => "e",
     "嶂" => "e",
     "嶄" => "e",
     "嶆" => "e",
     "嶇" => "e",
     "嶈" => "e",
     "嶉" => "e",
     "嶊" => "e",
     "嶍" => "e",
     "嶒" => "e",
     "嶓" => "e",
     "嶔" => "e",
     "嶕" => "e",
     "嶗" => "e",
     "嶙" => "e",
     "嶚" => "e",
     "嶜" => "e",
     "嶝" => "e",
     "嶟" => "e",
     "嶠" => "e",
     "嶡" => "e",
     "嶢" => "e",
     "嶧" => "e",
     "嶩" => "e",
     "嶪" => "e",
     "嶬" => "e",
     "嶭" => "e",
     "嶮" => "e",
     "嶯" => "e",
     "嶰" => "e",
     "嶱" => "e",
     "嶲" => "e",
     "嶵" => "e",
     "嶷" => "e",
     "嶸" => "e",
     "嶺" => "e",
     "嶼" => "e",
     "嶽" => "e",
     "巀" => "e",
     "巂" => "e",
     "巃" => "e",
     "巆" => "e",
     "巇" => "e",
     "巉" => "e",
     "巋" => "e",
     "巍" => "e",
     "巏" => "e",
     "巑" => "e",
     "巔" => "e",
     "巕" => "e",
     "巖" => "e",
     "巘" => "e",
     "巠" => "e",
     "巰" => "e",
     "帚" => "e",
     "建" => "e",
     "彩" => "e",
     "忝" => "e",
     "悉" => "e",
     "惡" => "e",
     "愛" => "e",
     "戩" => "e",
     "戮" => "e",
     "戳" => "e",
     "採" => "e",
     "政" => "e",
     "敳" => "e",
     "敿" => "e",
     "昋" => "e",
     "晉" => "e",
     "村" => "e",
     "櫫" => "e",
     "櫱" => "e",
     "歟" => "e",
     "正" => "e",
     "武" => "e",
     "歲" => "e",
     "段" => "e",
     "毣" => "e",
     "滅" => "e",
     "炭" => "e",
     "焄" => "e",
     "焉" => "e",
     "無" => "e",
     "然" => "e",
     "燹" => "e",
     "爪" => "e",
     "爬" => "e",
     "爭" => "e",
     "爰" => "e",
     "爵" => "e",
     "獃" => "e",
     "甒" => "e",
     "畫" => "e",
     "盥" => "e",
     "礜" => "e",
     "祟" => "e",
     "管" => "e",
     "糱" => "e",
     "糶" => "e",
     "系" => "e",
     "繇" => "e",
     "群" => "e",
     "羽" => "e",
     "羾" => "e",
     "羿" => "e",
     "翀" => "e",
     "翂" => "e",
     "翇" => "e",
     "翋" => "e",
     "翌" => "e",
     "翍" => "e",
     "翏" => "e",
     "翐" => "e",
     "翑" => "e",
     "習" => "e",
     "翜" => "e",
     "翞" => "e",
     "翟" => "e",
     "翠" => "e",
     "翣" => "e",
     "翨" => "e",
     "翪" => "e",
     "翫" => "e",
     "翬" => "e",
     "翭" => "e",
     "翮" => "e",
     "翯" => "e",
     "翴" => "e",
     "翵" => "e",
     "翼" => "e",
     "聿" => "e",
     "肅" => "e",
     "肆" => "e",
     "舀" => "e",
     "與" => "e",
     "舉" => "e",
     "舜" => "e",
     "艸" => "e",
     "芔" => "e",
     "茻" => "e",
     "虢" => "e",
     "虣" => "e",
     "虺" => "e",
     "蚕" => "e",
     "蚩" => "e",
     "融" => "e",
     "蠆" => "e",
     "蠥" => "e",
     "蠫" => "e",
     "蠶" => "e",
     "衋" => "e",
     "覓" => "e",
     "覗" => "e",
     "覬" => "e",
     "覶" => "e",
     "譽" => "e",
     "谿" => "e",
     "豈" => "e",
     "豕" => "e",
     "豖" => "e",
     "豗" => "e",
     "豜" => "e",
     "豝" => "e",
     "豟" => "e",
     "豤" => "e",
     "豥" => "e",
     "豨" => "e",
     "豩" => "e",
     "豬" => "e",
     "豭" => "e",
     "豯" => "e",
     "豱" => "e",
     "豲" => "e",
     "豳" => "e",
     "豵" => "e",
     "豶" => "e",
     "豷" => "e",
     "豸" => "e",
     "豹" => "e",
     "豺" => "e",
     "豻" => "e",
     "豽" => "e",
     "貀" => "e",
     "貁" => "e",
     "貂" => "e",
     "貄" => "e",
     "貅" => "e",
     "貆" => "e",
     "貉" => "e",
     "貊" => "e",
     "貌" => "e",
     "貍" => "e",
     "貏" => "e",
     "貐" => "e",
     "貑" => "e",
     "貒" => "e",
     "貓" => "e",
     "貔" => "e",
     "貕" => "e",
     "貗" => "e",
     "貘" => "e",
     "貙" => "e",
     "貚" => "e",
     "貜" => "e",
     "賮" => "e",
     "輋" => "e",
     "轝" => "e",
     "辭" => "e",
     "辿" => "e",
     "迍" => "e",
     "迎" => "e",
     "迗" => "e",
     "逐" => "e",
     "逕" => "e",
     "逮" => "e",
     "逼" => "e",
     "遙" => "e",
     "邁" => "e",
     "邈" => "e",
     "那" => "e",
     "邴" => "e",
     "郛" => "e",
     "郡" => "e",
     "鄑" => "e",
     "鄝" => "e",
     "鄢" => "e",
     "鄦" => "e",
     "鄩" => "e",
     "酅" => "e",
     "酉" => "e",
     "酊" => "e",
     "酌" => "e",
     "配" => "e",
     "酎" => "e",
     "酏" => "e",
     "酐" => "e",
     "酕" => "e",
     "酖" => "e",
     "酗" => "e",
     "酘" => "e",
     "酚" => "e",
     "酟" => "e",
     "酠" => "e",
     "酡" => "e",
     "酢" => "e",
     "酣" => "e",
     "酤" => "e",
     "酥" => "e",
     "酩" => "e",
     "酪" => "e",
     "酬" => "e",
     "酮" => "e",
     "酯" => "e",
     "酲" => "e",
     "酳" => "e",
     "酴" => "e",
     "酵" => "e",
     "酷" => "e",
     "酸" => "e",
     "酹" => "e",
     "酺" => "e",
     "醀" => "e",
     "醁" => "e",
     "醂" => "e",
     "醃" => "e",
     "醄" => "e",
     "醅" => "e",
     "醆" => "e",
     "醇" => "e",
     "醉" => "e",
     "醊" => "e",
     "醋" => "e",
     "醍" => "e",
     "醏" => "e",
     "醐" => "e",
     "醑" => "e",
     "醒" => "e",
     "醓" => "e",
     "醙" => "e",
     "醚" => "e",
     "醛" => "e",
     "醜" => "e",
     "醝" => "e",
     "醞" => "e",
     "醠" => "e",
     "醡" => "e",
     "醢" => "e",
     "醣" => "e",
     "醥" => "e",
     "醧" => "e",
     "醨" => "e",
     "醪" => "e",
     "醭" => "e",
     "醮" => "e",
     "醯" => "e",
     "醰" => "e",
     "醱" => "e",
     "醲" => "e",
     "醳" => "e",
     "醴" => "e",
     "醵" => "e",
     "醷" => "e",
     "醹" => "e",
     "醺" => "e",
     "醼" => "e",
     "醽" => "e",
     "醾" => "e",
     "釀" => "e",
     "釂" => "e",
     "釃" => "e",
     "釅" => "e",
     "采" => "e",
     "釉" => "e",
     "釋" => "e",
     "長" => "e",
     "镺" => "e",
     "镻" => "e",
     "镼" => "e",
     "镽" => "e",
     "隸" => "e",
     "雞" => "e",
     "雟" => "e",
     "雡" => "e",
     "靈" => "e",
     "鞷" => "e",
     "頓" => "e",
     "頨" => "e",
     "頯" => "e",
     "頵" => "e",
     "頸" => "e",
     "顗" => "e",
     "顟" => "e",
     "颻" => "e",
     "颽" => "e",
     "飁" => "e",
     "鬲" => "e",
     "鬷" => "e",
     "鬺" => "e",
     "鵘" => "e",
     "鵛" => "e",
     "鵡" => "e",
     "鶝" => "e",
     "鶢" => "e",
     "鷂" => "e",
     "鷊" => "e",
     "鷚" => "e",
     "鷡" => "e",
     "鷫" => "e",
     "鷮" => "e",
     "鸐" => "e",
     "鸒" => "e",
     "兀" => "e",
     "上" => "f",
     "下" => "f",
     "丐" => "f",
     "丰" => "f",
     "丱" => "f",
     "丳" => "f",
     "侯" => "f",
     "兜" => "f",
     "典" => "f",
     "冀" => "f",
     "剡" => "f",
     "劻" => "f",
     "勞" => "f",
     "勵" => "f",
     "匕" => "f",
     "北" => "f",
     "匚" => "f",
     "匜" => "f",
     "匝" => "f",
     "匟" => "f",
     "匠" => "f",
     "匡" => "f",
     "匢" => "f",
     "匣" => "f",
     "匪" => "f",
     "匭" => "f",
     "匯" => "f",
     "匰" => "f",
     "匱" => "f",
     "匴" => "f",
     "匷" => "f",
     "匹" => "f",
     "匼" => "f",
     "匽" => "f",
     "匾" => "f",
     "匿" => "f",
     "區" => "f",
     "卌" => "f",
     "卡" => "f",
     "卬" => "f",
     "卮" => "f",
     "叔" => "f",
     "叵" => "f",
     "后" => "f",
     "唇" => "f",
     "啟" => "f",
     "四" => "f",
     "垕" => "f",
     "塋" => "f",
     "壽" => "f",
     "奉" => "f",
     "奏" => "f",
     "契" => "f",
     "奰" => "f",
     "妀" => "f",
     "妄" => "f",
     "嫈" => "f",
     "嫛" => "f",
     "嬴" => "f",
     "富" => "f",
     "對" => "f",
     "巟" => "f",
     "巨" => "f",
     "己" => "f",
     "已" => "f",
     "巽" => "f",
     "帶" => "f",
     "幫" => "f",
     "异" => "f",
     "彗" => "f",
     "後" => "f",
     "忌" => "f",
     "忐" => "f",
     "忑" => "f",
     "忘" => "f",
     "恝" => "f",
     "惄" => "f",
     "惷" => "f",
     "慇" => "f",
     "慝" => "f",
     "慧" => "f",
     "憃" => "f",
     "戶" => "f",
     "戺" => "f",
     "戽" => "f",
     "戾" => "f",
     "房" => "f",
     "所" => "f",
     "扁" => "f",
     "扂" => "f",
     "扃" => "f",
     "扆" => "f",
     "扇" => "f",
     "扈" => "f",
     "扉" => "f",
     "扊" => "f",
     "挈" => "f",
     "改" => "f",
     "放" => "f",
     "敊" => "f",
     "敥" => "f",
     "敺" => "f",
     "斀" => "f",
     "斁" => "f",
     "斷" => "f",
     "方" => "f",
     "斻" => "f",
     "於" => "f",
     "施" => "f",
     "斿" => "f",
     "旂" => "f",
     "旃" => "f",
     "旄" => "f",
     "旅" => "f",
     "旆" => "f",
     "旋" => "f",
     "旌" => "f",
     "旍" => "f",
     "旎" => "f",
     "旐" => "f",
     "旒" => "f",
     "旓" => "f",
     "旖" => "f",
     "旗" => "f",
     "旚" => "f",
     "旛" => "f",
     "旝" => "f",
     "旞" => "f",
     "旟" => "f",
     "旨" => "f",
     "春" => "f",
     "曲" => "f",
     "望" => "f",
     "杗" => "f",
     "栔" => "f",
     "棨" => "f",
     "業" => "f",
     "榮" => "f",
     "樂" => "f",
     "欻" => "f",
     "款" => "f",
     "歐" => "f",
     "歜" => "f",
     "殷" => "f",
     "毆" => "f",
     "毉" => "f",
     "氓" => "f",
     "泰" => "f",
     "洯" => "f",
     "滎" => "f",
     "潁" => "f",
     "火" => "f",
     "灱" => "f",
     "灴" => "f",
     "灶" => "f",
     "灺" => "f",
     "灼" => "f",
     "炂" => "f",
     "炄" => "f",
     "炆" => "f",
     "炊" => "f",
     "炎" => "f",
     "炑" => "f",
     "炒" => "f",
     "炓" => "f",
     "炔" => "f",
     "炕" => "f",
     "炖" => "f",
     "炘" => "f",
     "炟" => "f",
     "炡" => "f",
     "炤" => "f",
     "炩" => "f",
     "炫" => "f",
     "炬" => "f",
     "炮" => "f",
     "炯" => "f",
     "炳" => "f",
     "炴" => "f",
     "炵" => "f",
     "炷" => "f",
     "炸" => "f",
     "炾" => "f",
     "烅" => "f",
     "烆" => "f",
     "烇" => "f",
     "烊" => "f",
     "烍" => "f",
     "烑" => "f",
     "烒" => "f",
     "烓" => "f",
     "烔" => "f",
     "烗" => "f",
     "烘" => "f",
     "烙" => "f",
     "烚" => "f",
     "烜" => "f",
     "烞" => "f",
     "烠" => "f",
     "烡" => "f",
     "烢" => "f",
     "烤" => "f",
     "烯" => "f",
     "烰" => "f",
     "烳" => "f",
     "烴" => "f",
     "烶" => "f",
     "烷" => "f",
     "烸" => "f",
     "烺" => "f",
     "烻" => "f",
     "烼" => "f",
     "烽" => "f",
     "烿" => "f",
     "焀" => "f",
     "焆" => "f",
     "焊" => "f",
     "焌" => "f",
     "焍" => "f",
     "焐" => "f",
     "焓" => "f",
     "焗" => "f",
     "焙" => "f",
     "焜" => "f",
     "焞" => "f",
     "焟" => "f",
     "焠" => "f",
     "焢" => "f",
     "焥" => "f",
     "焨" => "f",
     "焮" => "f",
     "焯" => "f",
     "焰" => "f",
     "焱" => "f",
     "焲" => "f",
     "焺" => "f",
     "煁" => "f",
     "煂" => "f",
     "煃" => "f",
     "煄" => "f",
     "煆" => "f",
     "煇" => "f",
     "煉" => "f",
     "煋" => "f",
     "煌" => "f",
     "煍" => "f",
     "煐" => "f",
     "煒" => "f",
     "煓" => "f",
     "煔" => "f",
     "煖" => "f",
     "煘" => "f",
     "煙" => "f",
     "煜" => "f",
     "煝" => "f",
     "煟" => "f",
     "煠" => "f",
     "煡" => "f",
     "煢" => "f",
     "煣" => "f",
     "煤" => "f",
     "煥" => "f",
     "煨" => "f",
     "煩" => "f",
     "煪" => "f",
     "煬" => "f",
     "煰" => "f",
     "煸" => "f",
     "煻" => "f",
     "煽" => "f",
     "熀" => "f",
     "熁" => "f",
     "熂" => "f",
     "熄" => "f",
     "熅" => "f",
     "熆" => "f",
     "熇" => "f",
     "熉" => "f",
     "熐" => "f",
     "熒" => "f",
     "熔" => "f",
     "熗" => "f",
     "熚" => "f",
     "熛" => "f",
     "熜" => "f",
     "熝" => "f",
     "熞" => "f",
     "熠" => "f",
     "熡" => "f",
     "熤" => "f",
     "熥" => "f",
     "熩" => "f",
     "熪" => "f",
     "熯" => "f",
     "熰" => "f",
     "熲" => "f",
     "熳" => "f",
     "熵" => "f",
     "熸" => "f",
     "熼" => "f",
     "熽" => "f",
     "熾" => "f",
     "熿" => "f",
     "燀" => "f",
     "燁" => "f",
     "燂" => "f",
     "燃" => "f",
     "燆" => "f",
     "燇" => "f",
     "燈" => "f",
     "燉" => "f",
     "燊" => "f",
     "燋" => "f",
     "燎" => "f",
     "燏" => "f",
     "燐" => "f",
     "燒" => "f",
     "燔" => "f",
     "燖" => "f",
     "燘" => "f",
     "燚" => "f",
     "燛" => "f",
     "燜" => "f",
     "營" => "f",
     "燠" => "f",
     "燡" => "f",
     "燤" => "f",
     "燥" => "f",
     "燦" => "f",
     "燧" => "f",
     "燨" => "f",
     "燬" => "f",
     "燭" => "f",
     "燮" => "f",
     "燰" => "f",
     "燱" => "f",
     "燲" => "f",
     "燴" => "f",
     "燸" => "f",
     "燻" => "f",
     "燼" => "f",
     "燽" => "f",
     "燾" => "f",
     "燿" => "f",
     "爁" => "f",
     "爃" => "f",
     "爅" => "f",
     "爆" => "f",
     "爊" => "f",
     "爌" => "f",
     "爍" => "f",
     "爐" => "f",
     "爓" => "f",
     "爔" => "f",
     "爙" => "f",
     "爚" => "f",
     "爛" => "f",
     "爝" => "f",
     "爞" => "f",
     "爟" => "f",
     "爣" => "f",
     "爦" => "f",
     "爧" => "f",
     "爩" => "f",
     "犖" => "f",
     "瑩" => "f",
     "瑿" => "f",
     "瓬" => "f",
     "甂" => "f",
     "甇" => "f",
     "甌" => "f",
     "疑" => "f",
     "皿" => "f",
     "盲" => "f",
     "真" => "f",
     "督" => "f",
     "睪" => "f",
     "瞏" => "f",
     "砉" => "f",
     "禜" => "f",
     "秦" => "f",
     "穎" => "f",
     "絜" => "f",
     "綮" => "f",
     "縈" => "f",
     "繄" => "f",
     "罃" => "f",
     "罘" => "f",
     "罛" => "f",
     "罜" => "f",
     "罝" => "f",
     "罞" => "f",
     "罟" => "f",
     "罠" => "f",
     "罡" => "f",
     "罣" => "f",
     "罥" => "f",
     "罦" => "f",
     "罧" => "f",
     "罨" => "f",
     "罩" => "f",
     "罪" => "f",
     "罫" => "f",
     "罬" => "f",
     "罭" => "f",
     "置" => "f",
     "罰" => "f",
     "署" => "f",
     "罳" => "f",
     "罵" => "f",
     "罶" => "f",
     "罷" => "f",
     "罹" => "f",
     "罺" => "f",
     "罻" => "f",
     "罼" => "f",
     "罽" => "f",
     "罾" => "f",
     "罿" => "f",
     "羃" => "f",
     "羅" => "f",
     "羆" => "f",
     "羇" => "f",
     "羈" => "f",
     "羉" => "f",
     "羸" => "f",
     "翩" => "f",
     "翳" => "f",
     "翾" => "f",
     "肄" => "f",
     "肇" => "f",
     "肓" => "f",
     "肩" => "f",
     "背" => "f",
     "胡" => "f",
     "胥" => "f",
     "脣" => "f",
     "膂" => "f",
     "膋" => "f",
     "臝" => "f",
     "臦" => "f",
     "臩" => "f",
     "舂" => "f",
     "艷" => "f",
     "蛋" => "f",
     "蛪" => "f",
     "蜀" => "f",
     "蜃" => "f",
     "螢" => "f",
     "螶" => "f",
     "蠃" => "f",
     "蠢" => "f",
     "衁" => "f",
     "裻" => "f",
     "褮" => "f",
     "覢" => "f",
     "覮" => "f",
     "觢" => "f",
     "觺" => "f",
     "詈" => "f",
     "謍" => "f",
     "豊" => "f",
     "豐" => "f",
     "豔" => "f",
     "買" => "f",
     "贀" => "f",
     "贏" => "f",
     "辰" => "f",
     "辱" => "f",
     "農" => "f",
     "逅" => "f",
     "遊" => "f",
     "遍" => "f",
     "遝" => "f",
     "遰" => "f",
     "選" => "f",
     "邏" => "f",
     "邔" => "f",
     "邙" => "f",
     "邡" => "f",
     "邦" => "f",
     "邶" => "f",
     "郈" => "f",
     "郯" => "f",
     "郾" => "f",
     "鄁" => "f",
     "鄏" => "f",
     "鄴" => "f",
     "酆" => "f",
     "醟" => "f",
     "醫" => "f",
     "錖" => "f",
     "鎣" => "f",
     "鑿" => "f",
     "雇" => "f",
     "頃" => "f",
     "顃" => "f",
     "顅" => "f",
     "顈" => "f",
     "顧" => "f",
     "顲" => "f",
     "飛" => "f",
     "鴄" => "f",
     "鵋" => "f",
     "鵳" => "f",
     "鶠" => "f",
     "鶣" => "f",
     "鶯" => "f",
     "鷖" => "f",
     "鷗" => "f",
     "鷟" => "f",
     "鷶" => "f",
     "鸀" => "f",
     "鸁" => "f",
     "鸅" => "f",
     "黳" => "f",
     "黹" => "f",
     "黺" => "f",
     "黻" => "f",
     "黼" => "f",
     "齧" => "f",
     "乇" => "g",
     "乖" => "g",
     "乘" => "g",
     "兒" => "g",
     "刊" => "g",
     "刮" => "g",
     "剩" => "g",
     "努" => "g",
     "動" => "g",
     "勳" => "g",
     "千" => "g",
     "叟" => "g",
     "垂" => "g",
     "墏" => "g",
     "壯" => "g",
     "夭" => "g",
     "夾" => "g",
     "奘" => "g",
     "女" => "g",
     "奴" => "g",
     "奶" => "g",
     "奷" => "g",
     "奸" => "g",
     "她" => "g",
     "奻" => "g",
     "奼" => "g",
     "好" => "g",
     "奾" => "g",
     "妁" => "g",
     "如" => "g",
     "妃" => "g",
     "妅" => "g",
     "妊" => "g",
     "妍" => "g",
     "妎" => "g",
     "妏" => "g",
     "妐" => "g",
     "妒" => "g",
     "妓" => "g",
     "妖" => "g",
     "妗" => "g",
     "妘" => "g",
     "妙" => "g",
     "妝" => "g",
     "妞" => "g",
     "妠" => "g",
     "妡" => "g",
     "妢" => "g",
     "妣" => "g",
     "妤" => "g",
     "妦" => "g",
     "妧" => "g",
     "妨" => "g",
     "妮" => "g",
     "妯" => "g",
     "妱" => "g",
     "妲" => "g",
     "妳" => "g",
     "妵" => "g",
     "妶" => "g",
     "妹" => "g",
     "妺" => "g",
     "妼" => "g",
     "妽" => "g",
     "姀" => "g",
     "姁" => "g",
     "姃" => "g",
     "姅" => "g",
     "姆" => "g",
     "姈" => "g",
     "姊" => "g",
     "始" => "g",
     "姌" => "g",
     "姍" => "g",
     "姎" => "g",
     "姏" => "g",
     "姐" => "g",
     "姑" => "g",
     "姒" => "g",
     "姓" => "g",
     "姖" => "g",
     "姘" => "g",
     "姚" => "g",
     "姛" => "g",
     "姝" => "g",
     "姞" => "g",
     "姠" => "g",
     "姡" => "g",
     "姣" => "g",
     "姤" => "g",
     "姥" => "g",
     "姦" => "g",
     "姨" => "g",
     "姩" => "g",
     "姪" => "g",
     "姬" => "g",
     "姮" => "g",
     "姱" => "g",
     "姲" => "g",
     "姳" => "g",
     "姵" => "g",
     "姶" => "g",
     "姷" => "g",
     "姺" => "g",
     "姻" => "g",
     "姼" => "g",
     "姽" => "g",
     "姾" => "g",
     "娀" => "g",
     "娃" => "g",
     "娉" => "g",
     "娊" => "g",
     "娌" => "g",
     "娏" => "g",
     "娓" => "g",
     "娕" => "g",
     "娖" => "g",
     "娗" => "g",
     "娘" => "g",
     "娙" => "g",
     "娛" => "g",
     "娜" => "g",
     "娞" => "g",
     "娟" => "g",
     "娠" => "g",
     "娣" => "g",
     "娥" => "g",
     "娩" => "g",
     "娭" => "g",
     "娮" => "g",
     "娳" => "g",
     "娵" => "g",
     "娷" => "g",
     "娸" => "g",
     "娹" => "g",
     "娼" => "g",
     "娾" => "g",
     "婀" => "g",
     "婂" => "g",
     "婃" => "g",
     "婄" => "g",
     "婇" => "g",
     "婈" => "g",
     "婉" => "g",
     "婊" => "g",
     "婌" => "g",
     "婍" => "g",
     "婐" => "g",
     "婑" => "g",
     "婒" => "g",
     "婕" => "g",
     "婖" => "g",
     "婗" => "g",
     "婘" => "g",
     "婚" => "g",
     "婛" => "g",
     "婝" => "g",
     "婞" => "g",
     "婟" => "g",
     "婠" => "g",
     "婢" => "g",
     "婤" => "g",
     "婥" => "g",
     "婦" => "g",
     "婧" => "g",
     "婩" => "g",
     "婬" => "g",
     "婭" => "g",
     "婰" => "g",
     "婷" => "g",
     "婸" => "g",
     "婻" => "g",
     "婼" => "g",
     "婽" => "g",
     "婿" => "g",
     "媃" => "g",
     "媄" => "g",
     "媊" => "g",
     "媋" => "g",
     "媌" => "g",
     "媎" => "g",
     "媏" => "g",
     "媒" => "g",
     "媓" => "g",
     "媔" => "g",
     "媕" => "g",
     "媗" => "g",
     "媚" => "g",
     "媛" => "g",
     "媜" => "g",
     "媞" => "g",
     "媟" => "g",
     "媢" => "g",
     "媥" => "g",
     "媦" => "g",
     "媧" => "g",
     "媩" => "g",
     "媬" => "g",
     "媮" => "g",
     "媯" => "g",
     "媰" => "g",
     "媱" => "g",
     "媲" => "g",
     "媳" => "g",
     "媴" => "g",
     "媶" => "g",
     "媷" => "g",
     "媸" => "g",
     "媹" => "g",
     "媺" => "g",
     "媼" => "g",
     "媽" => "g",
     "媾" => "g",
     "媿" => "g",
     "嫀" => "g",
     "嫁" => "g",
     "嫂" => "g",
     "嫄" => "g",
     "嫆" => "g",
     "嫇" => "g",
     "嫉" => "g",
     "嫊" => "g",
     "嫋" => "g",
     "嫌" => "g",
     "嫍" => "g",
     "嫕" => "g",
     "嫖" => "g",
     "嫗" => "g",
     "嫘" => "g",
     "嫙" => "g",
     "嫚" => "g",
     "嫜" => "g",
     "嫝" => "g",
     "嫞" => "g",
     "嫟" => "g",
     "嫡" => "g",
     "嫣" => "g",
     "嫥" => "g",
     "嫦" => "g",
     "嫨" => "g",
     "嫩" => "g",
     "嫪" => "g",
     "嫫" => "g",
     "嫬" => "g",
     "嫭" => "g",
     "嫮" => "g",
     "嫴" => "g",
     "嫵" => "g",
     "嫶" => "g",
     "嫷" => "g",
     "嫸" => "g",
     "嫹" => "g",
     "嫺" => "g",
     "嫻" => "g",
     "嫽" => "g",
     "嫿" => "g",
     "嬁" => "g",
     "嬂" => "g",
     "嬅" => "g",
     "嬇" => "g",
     "嬈" => "g",
     "嬉" => "g",
     "嬋" => "g",
     "嬌" => "g",
     "嬏" => "g",
     "嬐" => "g",
     "嬓" => "g",
     "嬔" => "g",
     "嬗" => "g",
     "嬙" => "g",
     "嬚" => "g",
     "嬛" => "g",
     "嬝" => "g",
     "嬞" => "g",
     "嬠" => "g",
     "嬡" => "g",
     "嬣" => "g",
     "嬤" => "g",
     "嬥" => "g",
     "嬦" => "g",
     "嬧" => "g",
     "嬨" => "g",
     "嬪" => "g",
     "嬬" => "g",
     "嬭" => "g",
     "嬯" => "g",
     "嬸" => "g",
     "嬼" => "g",
     "嬽" => "g",
     "嬾" => "g",
     "嬿" => "g",
     "孀" => "g",
     "孃" => "g",
     "孅" => "g",
     "孇" => "g",
     "孈" => "g",
     "孋" => "g",
     "孍" => "g",
     "孎" => "g",
     "孥" => "g",
     "將" => "g",
     "就" => "g",
     "帑" => "g",
     "帠" => "g",
     "帤" => "g",
     "干" => "g",
     "幵" => "g",
     "幹" => "g",
     "幾" => "g",
     "床" => "g",
     "弩" => "g",
     "怒" => "g",
     "恕" => "g",
     "憩" => "g",
     "戕" => "g",
     "拏" => "g",
     "挐" => "g",
     "收" => "g",
     "教" => "g",
     "敵" => "g",
     "斞" => "g",
     "斨" => "g",
     "旁" => "g",
     "某" => "g",
     "桼" => "g",
     "槳" => "g",
     "機" => "g",
     "歃" => "g",
     "毀" => "g",
     "毇" => "g",
     "漿" => "g",
     "濌" => "g",
     "烎" => "g",
     "焋" => "g",
     "熏" => "g",
     "爿" => "g",
     "牁" => "g",
     "牂" => "g",
     "牄" => "g",
     "牆" => "g",
     "狀" => "g",
     "獎" => "g",
     "瓜" => "g",
     "瓝" => "g",
     "瓞" => "g",
     "瓟" => "g",
     "瓥" => "g",
     "甀" => "g",
     "甘" => "g",
     "甜" => "g",
     "砮" => "g",
     "秉" => "g",
     "絮" => "g",
     "臼" => "g",
     "臾" => "g",
     "臿" => "g",
     "舁" => "g",
     "舄" => "g",
     "舅" => "g",
     "舌" => "g",
     "舐" => "g",
     "舑" => "g",
     "舔" => "g",
     "舕" => "g",
     "艦" => "g",
     "螿" => "g",
     "裝" => "g",
     "覝" => "g",
     "賚" => "g",
     "适" => "g",
     "適" => "g",
     "邗" => "g",
     "邯" => "g",
     "郟" => "g",
     "郳" => "g",
     "郵" => "g",
     "鄋" => "g",
     "醬" => "g",
     "重" => "g",
     "頇" => "g",
     "頰" => "g",
     "駑" => "g",
     "鳱" => "g",
     "鴰" => "g",
     "鴽" => "g",
     "鵊" => "g",
     "鶂" => "g",
     "鷲" => "g",
     "麉" => "g",
     "麥" => "g",
     "麧" => "g",
     "麩" => "g",
     "麭" => "g",
     "麮" => "g",
     "麰" => "g",
     "麴" => "g",
     "麵" => "g",
     "麷" => "g",
     "鼠" => "g",
     "鼢" => "g",
     "鼣" => "g",
     "鼤" => "g",
     "鼥" => "g",
     "鼨" => "g",
     "鼩" => "g",
     "鼪" => "g",
     "鼫" => "g",
     "鼬" => "g",
     "鼭" => "g",
     "鼮" => "g",
     "鼯" => "g",
     "鼰" => "g",
     "鼱" => "g",
     "鼲" => "g",
     "鼳" => "g",
     "鼴" => "g",
     "鼵" => "g",
     "鼶" => "g",
     "鼷" => "g",
     "鼸" => "g",
     "乎" => "h",
     "利" => "h",
     "勣" => "h",
     "和" => "h",
     "墯" => "h",
     "委" => "h",
     "媝" => "h",
     "季" => "h",
     "嵇" => "h",
     "巷" => "h",
     "很" => "h",
     "心" => "h",
     "必" => "h",
     "忉" => "h",
     "忏" => "h",
     "忔" => "h",
     "忕" => "h",
     "忖" => "h",
     "忙" => "h",
     "忡" => "h",
     "忣" => "h",
     "忤" => "h",
     "忨" => "h",
     "忪" => "h",
     "快" => "h",
     "忭" => "h",
     "忮" => "h",
     "忯" => "h",
     "忱" => "h",
     "忳" => "h",
     "忴" => "h",
     "忷" => "h",
     "忸" => "h",
     "忺" => "h",
     "忻" => "h",
     "怀" => "h",
     "怉" => "h",
     "怊" => "h",
     "怋" => "h",
     "怌" => "h",
     "怍" => "h",
     "怏" => "h",
     "怐" => "h",
     "怑" => "h",
     "怓" => "h",
     "怔" => "h",
     "怕" => "h",
     "怖" => "h",
     "怗" => "h",
     "怙" => "h",
     "怚" => "h",
     "怛" => "h",
     "怜" => "h",
     "怞" => "h",
     "怡" => "h",
     "怢" => "h",
     "怦" => "h",
     "性" => "h",
     "怩" => "h",
     "怪" => "h",
     "怫" => "h",
     "怬" => "h",
     "怭" => "h",
     "怮" => "h",
     "怯" => "h",
     "怲" => "h",
     "怳" => "h",
     "怴" => "h",
     "怵" => "h",
     "恀" => "h",
     "恂" => "h",
     "恃" => "h",
     "恄" => "h",
     "恅" => "h",
     "恆" => "h",
     "恇" => "h",
     "恉" => "h",
     "恌" => "h",
     "恍" => "h",
     "恒" => "h",
     "恓" => "h",
     "恔" => "h",
     "恘" => "h",
     "恛" => "h",
     "恞" => "h",
     "恟" => "h",
     "恢" => "h",
     "恤" => "h",
     "恦" => "h",
     "恨" => "h",
     "恪" => "h",
     "恫" => "h",
     "恬" => "h",
     "恮" => "h",
     "恰" => "h",
     "恲" => "h",
     "悀" => "h",
     "悁" => "h",
     "悃" => "h",
     "悄" => "h",
     "悅" => "h",
     "悇" => "h",
     "悈" => "h",
     "悌" => "h",
     "悍" => "h",
     "悎" => "h",
     "悒" => "h",
     "悔" => "h",
     "悕" => "h",
     "悖" => "h",
     "悗" => "h",
     "悚" => "h",
     "悛" => "h",
     "悜" => "h",
     "悝" => "h",
     "悟" => "h",
     "悢" => "h",
     "悰" => "h",
     "悱" => "h",
     "悴" => "h",
     "悵" => "h",
     "悷" => "h",
     "悸" => "h",
     "悺" => "h",
     "悻" => "h",
     "悼" => "h",
     "悽" => "h",
     "悾" => "h",
     "悿" => "h",
     "惀" => "h",
     "惃" => "h",
     "情" => "h",
     "惆" => "h",
     "惇" => "h",
     "惈" => "h",
     "惊" => "h",
     "惋" => "h",
     "惍" => "h",
     "惏" => "h",
     "惓" => "h",
     "惔" => "h",
     "惕" => "h",
     "惘" => "h",
     "惙" => "h",
     "惚" => "h",
     "惛" => "h",
     "惜" => "h",
     "惝" => "h",
     "惟" => "h",
     "惢" => "h",
     "惤" => "h",
     "惦" => "h",
     "惰" => "h",
     "惱" => "h",
     "惲" => "h",
     "惴" => "h",
     "惵" => "h",
     "惶" => "h",
     "惸" => "h",
     "惺" => "h",
     "惻" => "h",
     "惼" => "h",
     "惾" => "h",
     "惿" => "h",
     "愀" => "h",
     "愁" => "h",
     "愃" => "h",
     "愄" => "h",
     "愅" => "h",
     "愉" => "h",
     "愊" => "h",
     "愋" => "h",
     "愎" => "h",
     "愐" => "h",
     "愒" => "h",
     "愓" => "h",
     "愔" => "h",
     "愕" => "h",
     "愖" => "h",
     "愘" => "h",
     "愜" => "h",
     "愝" => "h",
     "愣" => "h",
     "愧" => "h",
     "愩" => "h",
     "愫" => "h",
     "愮" => "h",
     "愯" => "h",
     "愲" => "h",
     "愴" => "h",
     "愶" => "h",
     "愷" => "h",
     "愾" => "h",
     "慀" => "h",
     "慄" => "h",
     "慅" => "h",
     "慆" => "h",
     "慉" => "h",
     "慊" => "h",
     "慌" => "h",
     "慍" => "h",
     "慎" => "h",
     "慏" => "h",
     "慒" => "h",
     "慓" => "h",
     "慔" => "h",
     "慖" => "h",
     "慘" => "h",
     "慚" => "h",
     "慛" => "h",
     "慞" => "h",
     "慟" => "h",
     "慡" => "h",
     "慢" => "h",
     "慣" => "h",
     "慥" => "h",
     "慨" => "h",
     "慪" => "h",
     "慬" => "h",
     "慱" => "h",
     "慲" => "h",
     "慳" => "h",
     "慴" => "h",
     "慵" => "h",
     "慷" => "h",
     "慺" => "h",
     "憀" => "h",
     "憂" => "h",
     "憉" => "h",
     "憍" => "h",
     "憎" => "h",
     "憐" => "h",
     "憒" => "h",
     "憓" => "h",
     "憔" => "h",
     "憚" => "h",
     "憛" => "h",
     "憟" => "h",
     "憡" => "h",
     "憢" => "h",
     "憤" => "h",
     "憧" => "h",
     "憪" => "h",
     "憫" => "h",
     "憬" => "h",
     "憭" => "h",
     "憮" => "h",
     "憯" => "h",
     "憰" => "h",
     "憱" => "h",
     "憳" => "h",
     "憴" => "h",
     "憶" => "h",
     "憸" => "h",
     "憺" => "h",
     "憾" => "h",
     "憿" => "h",
     "懁" => "h",
     "懂" => "h",
     "懅" => "h",
     "懆" => "h",
     "懈" => "h",
     "懊" => "h",
     "懌" => "h",
     "懍" => "h",
     "懞" => "h",
     "懠" => "h",
     "懤" => "h",
     "懥" => "h",
     "懦" => "h",
     "懧" => "h",
     "懨" => "h",
     "懩" => "h",
     "懪" => "h",
     "懫" => "h",
     "懭" => "h",
     "懮" => "h",
     "懰" => "h",
     "懱" => "h",
     "懵" => "h",
     "懶" => "h",
     "懷" => "h",
     "懹" => "h",
     "懺" => "h",
     "懻" => "h",
     "懼" => "h",
     "懽" => "h",
     "懾" => "h",
     "戃" => "h",
     "戄" => "h",
     "手" => "h",
     "拜" => "h",
     "掰" => "h",
     "掱" => "h",
     "揫" => "h",
     "搿" => "h",
     "摮" => "h",
     "敖" => "h",
     "梨" => "h",
     "橤" => "h",
     "毒" => "h",
     "煮" => "h",
     "熬" => "h",
     "犁" => "h",
     "犩" => "h",
     "獒" => "h",
     "瓾" => "h",
     "甃" => "h",
     "皴" => "h",
     "盉" => "h",
     "看" => "h",
     "睹" => "h",
     "禾" => "h",
     "禿" => "h",
     "秀" => "h",
     "私" => "h",
     "秅" => "h",
     "秈" => "h",
     "秋" => "h",
     "种" => "h",
     "秎" => "h",
     "秏" => "h",
     "科" => "h",
     "秒" => "h",
     "秕" => "h",
     "秖" => "h",
     "秘" => "h",
     "秜" => "h",
     "秝" => "h",
     "秞" => "h",
     "租" => "h",
     "秠" => "h",
     "秣" => "h",
     "秤" => "h",
     "秧" => "h",
     "秩" => "h",
     "秪" => "h",
     "秫" => "h",
     "秬" => "h",
     "秭" => "h",
     "秮" => "h",
     "秷" => "h",
     "秸" => "h",
     "秺" => "h",
     "移" => "h",
     "稀" => "h",
     "稂" => "h",
     "稃" => "h",
     "稄" => "h",
     "稅" => "h",
     "稈" => "h",
     "稊" => "h",
     "程" => "h",
     "稌" => "h",
     "稍" => "h",
     "稐" => "h",
     "稑" => "h",
     "稒" => "h",
     "稓" => "h",
     "稔" => "h",
     "稕" => "h",
     "稗" => "h",
     "稘" => "h",
     "稙" => "h",
     "稚" => "h",
     "稛" => "h",
     "稜" => "h",
     "稞" => "h",
     "稠" => "h",
     "稢" => "h",
     "稦" => "h",
     "稨" => "h",
     "稫" => "h",
     "種" => "h",
     "稯" => "h",
     "稰" => "h",
     "稱" => "h",
     "稷" => "h",
     "稹" => "h",
     "稻" => "h",
     "稼" => "h",
     "稽" => "h",
     "稿" => "h",
     "穄" => "h",
     "穆" => "h",
     "穇" => "h",
     "穊" => "h",
     "穋" => "h",
     "積" => "h",
     "穔" => "h",
     "穖" => "h",
     "穗" => "h",
     "穘" => "h",
     "穚" => "h",
     "穛" => "h",
     "穜" => "h",
     "穟" => "h",
     "穠" => "h",
     "穡" => "h",
     "穢" => "h",
     "穧" => "h",
     "穨" => "h",
     "穩" => "h",
     "穫" => "h",
     "穬" => "h",
     "穭" => "h",
     "穮" => "h",
     "穰" => "h",
     "穱" => "h",
     "素" => "h",
     "繠" => "h",
     "纛" => "h",
     "翥" => "h",
     "者" => "h",
     "聱" => "h",
     "蝵" => "h",
     "螯" => "h",
     "表" => "h",
     "覕" => "h",
     "覣" => "h",
     "謷" => "h",
     "責" => "h",
     "贅" => "h",
     "透" => "h",
     "逡" => "h",
     "逶" => "h",
     "遨" => "h",
     "邲" => "h",
     "郬" => "h",
     "都" => "h",
     "鏊" => "h",
     "青" => "h",
     "靘" => "h",
     "靚" => "h",
     "靛" => "h",
     "靜" => "h",
     "頹" => "h",
     "香" => "h",
     "馜" => "h",
     "馝" => "h",
     "馞" => "h",
     "馡" => "h",
     "馣" => "h",
     "馥" => "h",
     "馦" => "h",
     "馧" => "h",
     "馫" => "h",
     "驁" => "h",
     "驚" => "h",
     "魏" => "h",
     "鯬" => "h",
     "鰲" => "h",
     "鵚" => "h",
     "鵹" => "h",
     "鶄" => "h",
     "鶖" => "h",
     "黍" => "h",
     "黎" => "h",
     "黏" => "h",
     "黐" => "h",
     "黧" => "h",
     "鼇" => "h",
     "冑" => "i",
     "功" => "i",
     "奱" => "i",
     "孌" => "i",
     "孿" => "i",
     "巒" => "i",
     "工" => "i",
     "巧" => "i",
     "彎" => "i",
     "恐" => "i",
     "憨" => "i",
     "應" => "i",
     "戀" => "i",
     "我" => "i",
     "掀" => "i",
     "攣" => "i",
     "攻" => "i",
     "敢" => "i",
     "暢" => "i",
     "曫" => "i",
     "曳" => "i",
     "朄" => "i",
     "欒" => "i",
     "欠" => "i",
     "汞" => "i",
     "瓨" => "i",
     "由" => "i",
     "申" => "i",
     "甹" => "i",
     "矕" => "i",
     "胄" => "i",
     "臠" => "i",
     "舊" => "i",
     "蛩" => "i",
     "蠻" => "i",
     "言" => "i",
     "訂" => "i",
     "訃" => "i",
     "計" => "i",
     "訊" => "i",
     "訌" => "i",
     "討" => "i",
     "訏" => "i",
     "訐" => "i",
     "訑" => "i",
     "訒" => "i",
     "訓" => "i",
     "訕" => "i",
     "訖" => "i",
     "託" => "i",
     "記" => "i",
     "訛" => "i",
     "訝" => "i",
     "訞" => "i",
     "訟" => "i",
     "訢" => "i",
     "訣" => "i",
     "訥" => "i",
     "訧" => "i",
     "訪" => "i",
     "訬" => "i",
     "設" => "i",
     "訰" => "i",
     "許" => "i",
     "訴" => "i",
     "訶" => "i",
     "訹" => "i",
     "診" => "i",
     "註" => "i",
     "証" => "i",
     "訿" => "i",
     "詀" => "i",
     "詁" => "i",
     "詄" => "i",
     "詅" => "i",
     "詆" => "i",
     "詊" => "i",
     "詌" => "i",
     "詍" => "i",
     "詎" => "i",
     "詏" => "i",
     "詐" => "i",
     "詑" => "i",
     "詒" => "i",
     "詔" => "i",
     "評" => "i",
     "詖" => "i",
     "詗" => "i",
     "詘" => "i",
     "詙" => "i",
     "詛" => "i",
     "詞" => "i",
     "詠" => "i",
     "詡" => "i",
     "詢" => "i",
     "詣" => "i",
     "試" => "i",
     "詨" => "i",
     "詩" => "i",
     "詫" => "i",
     "詬" => "i",
     "詭" => "i",
     "詮" => "i",
     "詰" => "i",
     "話" => "i",
     "該" => "i",
     "詳" => "i",
     "詴" => "i",
     "詵" => "i",
     "詶" => "i",
     "詷" => "i",
     "詺" => "i",
     "詻" => "i",
     "詼" => "i",
     "詿" => "i",
     "誁" => "i",
     "誂" => "i",
     "誃" => "i",
     "誄" => "i",
     "誅" => "i",
     "誆" => "i",
     "誇" => "i",
     "誋" => "i",
     "誌" => "i",
     "認" => "i",
     "誏" => "i",
     "誑" => "i",
     "誒" => "i",
     "誕" => "i",
     "誖" => "i",
     "誘" => "i",
     "誙" => "i",
     "誚" => "i",
     "語" => "i",
     "誠" => "i",
     "誡" => "i",
     "誣" => "i",
     "誤" => "i",
     "誥" => "i",
     "誦" => "i",
     "誧" => "i",
     "誨" => "i",
     "說" => "i",
     "誫" => "i",
     "誰" => "i",
     "課" => "i",
     "誶" => "i",
     "誸" => "i",
     "誹" => "i",
     "誺" => "i",
     "誻" => "i",
     "誼" => "i",
     "誽" => "i",
     "調" => "i",
     "諀" => "i",
     "諂" => "i",
     "諃" => "i",
     "諄" => "i",
     "諆" => "i",
     "談" => "i",
     "諈" => "i",
     "諉" => "i",
     "請" => "i",
     "諍" => "i",
     "諏" => "i",
     "諑" => "i",
     "諒" => "i",
     "諓" => "i",
     "諔" => "i",
     "諕" => "i",
     "論" => "i",
     "諗" => "i",
     "諘" => "i",
     "諙" => "i",
     "諛" => "i",
     "諜" => "i",
     "諝" => "i",
     "諞" => "i",
     "諟" => "i",
     "諠" => "i",
     "諡" => "i",
     "諢" => "i",
     "諤" => "i",
     "諦" => "i",
     "諧" => "i",
     "諨" => "i",
     "諫" => "i",
     "諭" => "i",
     "諮" => "i",
     "諯" => "i",
     "諰" => "i",
     "諱" => "i",
     "諲" => "i",
     "諳" => "i",
     "諴" => "i",
     "諵" => "i",
     "諶" => "i",
     "諷" => "i",
     "諸" => "i",
     "諺" => "i",
     "諻" => "i",
     "諼" => "i",
     "諾" => "i",
     "諿" => "i",
     "謀" => "i",
     "謁" => "i",
     "謂" => "i",
     "謅" => "i",
     "謆" => "i",
     "謊" => "i",
     "謋" => "i",
     "謎" => "i",
     "謏" => "i",
     "謐" => "i",
     "謑" => "i",
     "謒" => "i",
     "謓" => "i",
     "謔" => "i",
     "謕" => "i",
     "謖" => "i",
     "謗" => "i",
     "謘" => "i",
     "謙" => "i",
     "謚" => "i",
     "講" => "i",
     "謜" => "i",
     "謝" => "i",
     "謞" => "i",
     "謠" => "i",
     "謢" => "i",
     "謣" => "i",
     "謤" => "i",
     "謥" => "i",
     "謧" => "i",
     "謨" => "i",
     "謪" => "i",
     "謫" => "i",
     "謬" => "i",
     "謮" => "i",
     "謯" => "i",
     "謰" => "i",
     "謱" => "i",
     "謳" => "i",
     "謵" => "i",
     "謶" => "i",
     "謹" => "i",
     "謻" => "i",
     "謼" => "i",
     "謾" => "i",
     "譀" => "i",
     "譁" => "i",
     "譂" => "i",
     "譅" => "i",
     "譆" => "i",
     "譇" => "i",
     "譈" => "i",
     "證" => "i",
     "譊" => "i",
     "譋" => "i",
     "譎" => "i",
     "譏" => "i",
     "譐" => "i",
     "譑" => "i",
     "譒" => "i",
     "譓" => "i",
     "譔" => "i",
     "譕" => "i",
     "譖" => "i",
     "譗" => "i",
     "識" => "i",
     "譙" => "i",
     "譚" => "i",
     "譜" => "i",
     "譝" => "i",
     "譟" => "i",
     "譠" => "i",
     "譣" => "i",
     "譧" => "i",
     "譨" => "i",
     "譪" => "i",
     "譫" => "i",
     "譭" => "i",
     "譯" => "i",
     "議" => "i",
     "譴" => "i",
     "護" => "i",
     "譸" => "i",
     "譹" => "i",
     "譺" => "i",
     "譾" => "i",
     "譿" => "i",
     "讀" => "i",
     "讂" => "i",
     "讄" => "i",
     "讅" => "i",
     "讈" => "i",
     "變" => "i",
     "讌" => "i",
     "讒" => "i",
     "讓" => "i",
     "讔" => "i",
     "讕" => "i",
     "讖" => "i",
     "讘" => "i",
     "讙" => "i",
     "讚" => "i",
     "讜" => "i",
     "讞" => "i",
     "讟" => "i",
     "貢" => "i",
     "跡" => "i",
     "跫" => "i",
     "迪" => "i",
     "這" => "i",
     "邛" => "i",
     "銎" => "i",
     "鑾" => "i",
     "電" => "i",
     "鞏" => "i",
     "項" => "i",
     "鵝" => "i",
     "鸞" => "i",
     "世" => "j",
     "丼" => "j",
     "乾" => "j",
     "事" => "j",
     "井" => "j",
     "僰" => "j",
     "克" => "j",
     "兙" => "j",
     "兛" => "j",
     "兝" => "j",
     "兞" => "j",
     "兡" => "j",
     "兢" => "j",
     "兣" => "j",
     "冓" => "j",
     "凳" => "j",
     "刱" => "j",
     "刺" => "j",
     "剋" => "j",
     "剌" => "j",
     "剚" => "j",
     "勀" => "j",
     "勃" => "j",
     "勢" => "j",
     "十" => "j",
     "卉" => "j",
     "卒" => "j",
     "協" => "j",
     "南" => "j",
     "博" => "j",
     "古" => "j",
     "吏" => "j",
     "哉" => "j",
     "哲" => "j",
     "喪" => "j",
     "嘏" => "j",
     "囊" => "j",
     "執" => "j",
     "報" => "j",
     "墊" => "j",
     "夬" => "j",
     "妻" => "j",
     "孛" => "j",
     "巿" => "j",
     "悊" => "j",
     "慹" => "j",
     "戟" => "j",
     "戣" => "j",
     "截" => "j",
     "戴" => "j",
     "扎" => "j",
     "扐" => "j",
     "扑" => "j",
     "扒" => "j",
     "打" => "j",
     "扔" => "j",
     "托" => "j",
     "扙" => "j",
     "扚" => "j",
     "扛" => "j",
     "扜" => "j",
     "扞" => "j",
     "扠" => "j",
     "扡" => "j",
     "扢" => "j",
     "扣" => "j",
     "扤" => "j",
     "扥" => "j",
     "扦" => "j",
     "扭" => "j",
     "扮" => "j",
     "扯" => "j",
     "扰" => "j",
     "扱" => "j",
     "扲" => "j",
     "扳" => "j",
     "扴" => "j",
     "扶" => "j",
     "扷" => "j",
     "批" => "j",
     "扺" => "j",
     "扻" => "j",
     "扼" => "j",
     "扽" => "j",
     "找" => "j",
     "技" => "j",
     "抁" => "j",
     "抃" => "j",
     "抄" => "j",
     "抆" => "j",
     "抇" => "j",
     "抈" => "j",
     "抉" => "j",
     "把" => "j",
     "抌" => "j",
     "抎" => "j",
     "抏" => "j",
     "抑" => "j",
     "抒" => "j",
     "抓" => "j",
     "抔" => "j",
     "投" => "j",
     "抖" => "j",
     "抗" => "j",
     "折" => "j",
     "抨" => "j",
     "抩" => "j",
     "抪" => "j",
     "披" => "j",
     "抬" => "j",
     "抭" => "j",
     "抮" => "j",
     "抯" => "j",
     "抰" => "j",
     "抱" => "j",
     "抳" => "j",
     "抴" => "j",
     "抵" => "j",
     "抶" => "j",
     "抸" => "j",
     "抹" => "j",
     "抻" => "j",
     "押" => "j",
     "抽" => "j",
     "抾" => "j",
     "抿" => "j",
     "拂" => "j",
     "拄" => "j",
     "拆" => "j",
     "拇" => "j",
     "拈" => "j",
     "拉" => "j",
     "拊" => "j",
     "拋" => "j",
     "拌" => "j",
     "拍" => "j",
     "拎" => "j",
     "拐" => "j",
     "拑" => "j",
     "拒" => "j",
     "拓" => "j",
     "拔" => "j",
     "拖" => "j",
     "拗" => "j",
     "拘" => "j",
     "拙" => "j",
     "拚" => "j",
     "招" => "j",
     "拫" => "j",
     "括" => "j",
     "拭" => "j",
     "拮" => "j",
     "拯" => "j",
     "拰" => "j",
     "拱" => "j",
     "拴" => "j",
     "拵" => "j",
     "拶" => "j",
     "拷" => "j",
     "拸" => "j",
     "拹" => "j",
     "拺" => "j",
     "拻" => "j",
     "拼" => "j",
     "拽" => "j",
     "拾" => "j",
     "挀" => "j",
     "持" => "j",
     "挂" => "j",
     "挃" => "j",
     "指" => "j",
     "按" => "j",
     "挋" => "j",
     "挌" => "j",
     "挍" => "j",
     "挎" => "j",
     "挏" => "j",
     "挑" => "j",
     "挓" => "j",
     "挔" => "j",
     "挕" => "j",
     "挖" => "j",
     "挨" => "j",
     "挩" => "j",
     "挪" => "j",
     "挫" => "j",
     "挬" => "j",
     "挭" => "j",
     "振" => "j",
     "挲" => "j",
     "挳" => "j",
     "挴" => "j",
     "挶" => "j",
     "挸" => "j",
     "挹" => "j",
     "挺" => "j",
     "挻" => "j",
     "挼" => "j",
     "挽" => "j",
     "挾" => "j",
     "捀" => "j",
     "捁" => "j",
     "捂" => "j",
     "捃" => "j",
     "捄" => "j",
     "捅" => "j",
     "捆" => "j",
     "捇" => "j",
     "捈" => "j",
     "捉" => "j",
     "捊" => "j",
     "捋" => "j",
     "捌" => "j",
     "捍" => "j",
     "捎" => "j",
     "捏" => "j",
     "捐" => "j",
     "捑" => "j",
     "捔" => "j",
     "捕" => "j",
     "捖" => "j",
     "捗" => "j",
     "捘" => "j",
     "捙" => "j",
     "捚" => "j",
     "捥" => "j",
     "捧" => "j",
     "捨" => "j",
     "捩" => "j",
     "捫" => "j",
     "捭" => "j",
     "据" => "j",
     "捯" => "j",
     "捰" => "j",
     "捱" => "j",
     "捲" => "j",
     "捵" => "j",
     "捶" => "j",
     "捸" => "j",
     "捺" => "j",
     "捻" => "j",
     "捼" => "j",
     "捽" => "j",
     "掁" => "j",
     "掂" => "j",
     "掃" => "j",
     "掄" => "j",
     "掅" => "j",
     "掇" => "j",
     "授" => "j",
     "掉" => "j",
     "掊" => "j",
     "掍" => "j",
     "掎" => "j",
     "掏" => "j",
     "掐" => "j",
     "掑" => "j",
     "排" => "j",
     "掖" => "j",
     "掗" => "j",
     "掘" => "j",
     "掙" => "j",
     "掛" => "j",
     "掜" => "j",
     "掝" => "j",
     "掞" => "j",
     "掟" => "j",
     "掠" => "j",
     "探" => "j",
     "掤" => "j",
     "接" => "j",
     "控" => "j",
     "推" => "j",
     "掩" => "j",
     "措" => "j",
     "掫" => "j",
     "掬" => "j",
     "掭" => "j",
     "掮" => "j",
     "掯" => "j",
     "掽" => "j",
     "掾" => "j",
     "揀" => "j",
     "揂" => "j",
     "揃" => "j",
     "揄" => "j",
     "揆" => "j",
     "揇" => "j",
     "揈" => "j",
     "揉" => "j",
     "揊" => "j",
     "揋" => "j",
     "揌" => "j",
     "揍" => "j",
     "揎" => "j",
     "描" => "j",
     "提" => "j",
     "插" => "j",
     "揓" => "j",
     "揕" => "j",
     "揖" => "j",
     "揗" => "j",
     "揘" => "j",
     "揙" => "j",
     "揚" => "j",
     "換" => "j",
     "揜" => "j",
     "揝" => "j",
     "揟" => "j",
     "揠" => "j",
     "握" => "j",
     "揣" => "j",
     "揤" => "j",
     "揥" => "j",
     "揧" => "j",
     "揨" => "j",
     "揩" => "j",
     "揪" => "j",
     "揭" => "j",
     "揮" => "j",
     "揯" => "j",
     "揰" => "j",
     "揲" => "j",
     "揳" => "j",
     "援" => "j",
     "揵" => "j",
     "揶" => "j",
     "揹" => "j",
     "搆" => "j",
     "搉" => "j",
     "搊" => "j",
     "搋" => "j",
     "搌" => "j",
     "損" => "j",
     "搎" => "j",
     "搏" => "j",
     "搐" => "j",
     "搒" => "j",
     "搓" => "j",
     "搔" => "j",
     "搕" => "j",
     "搖" => "j",
     "搗" => "j",
     "搘" => "j",
     "搚" => "j",
     "搛" => "j",
     "搜" => "j",
     "搞" => "j",
     "搟" => "j",
     "搠" => "j",
     "搡" => "j",
     "搢" => "j",
     "搣" => "j",
     "搤" => "j",
     "搥" => "j",
     "搦" => "j",
     "搧" => "j",
     "搨" => "j",
     "搪" => "j",
     "搬" => "j",
     "搭" => "j",
     "搮" => "j",
     "搯" => "j",
     "搰" => "j",
     "搳" => "j",
     "搵" => "j",
     "搶" => "j",
     "搷" => "j",
     "搹" => "j",
     "搽" => "j",
     "搾" => "j",
     "摀" => "j",
     "摁" => "j",
     "摃" => "j",
     "摋" => "j",
     "摍" => "j",
     "摎" => "j",
     "摐" => "j",
     "摑" => "j",
     "摒" => "j",
     "摓" => "j",
     "摔" => "j",
     "摘" => "j",
     "摙" => "j",
     "摛" => "j",
     "摜" => "j",
     "摝" => "j",
     "摞" => "j",
     "摟" => "j",
     "摠" => "j",
     "摡" => "j",
     "摥" => "j",
     "摦" => "j",
     "摧" => "j",
     "摨" => "j",
     "摫" => "j",
     "摬" => "j",
     "摭" => "j",
     "摯" => "j",
     "摲" => "j",
     "摳" => "j",
     "摴" => "j",
     "摵" => "j",
     "摶" => "j",
     "摷" => "j",
     "摸" => "j",
     "摺" => "j",
     "摻" => "j",
     "摽" => "j",
     "摿" => "j",
     "撂" => "j",
     "撅" => "j",
     "撇" => "j",
     "撈" => "j",
     "撊" => "j",
     "撋" => "j",
     "撌" => "j",
     "撏" => "j",
     "撐" => "j",
     "撒" => "j",
     "撓" => "j",
     "撕" => "j",
     "撖" => "j",
     "撗" => "j",
     "撘" => "j",
     "撙" => "j",
     "撚" => "j",
     "撜" => "j",
     "撝" => "j",
     "撞" => "j",
     "撟" => "j",
     "撠" => "j",
     "撢" => "j",
     "撣" => "j",
     "撤" => "j",
     "撥" => "j",
     "撦" => "j",
     "撩" => "j",
     "撫" => "j",
     "撬" => "j",
     "播" => "j",
     "撮" => "j",
     "撰" => "j",
     "撱" => "j",
     "撲" => "j",
     "撳" => "j",
     "撻" => "j",
     "撼" => "j",
     "撽" => "j",
     "撾" => "j",
     "撿" => "j",
     "擁" => "j",
     "擂" => "j",
     "擃" => "j",
     "擄" => "j",
     "擅" => "j",
     "擇" => "j",
     "擉" => "j",
     "擋" => "j",
     "操" => "j",
     "擏" => "j",
     "擐" => "j",
     "擒" => "j",
     "擔" => "j",
     "擖" => "j",
     "擗" => "j",
     "擙" => "j",
     "據" => "j",
     "擛" => "j",
     "擠" => "j",
     "擢" => "j",
     "擣" => "j",
     "擤" => "j",
     "擦" => "j",
     "擨" => "j",
     "擩" => "j",
     "擫" => "j",
     "擬" => "j",
     "擭" => "j",
     "擯" => "j",
     "擰" => "j",
     "擱" => "j",
     "擲" => "j",
     "擳" => "j",
     "擴" => "j",
     "擷" => "j",
     "擸" => "j",
     "擺" => "j",
     "擻" => "j",
     "擼" => "j",
     "擽" => "j",
     "擾" => "j",
     "擿" => "j",
     "攁" => "j",
     "攃" => "j",
     "攄" => "j",
     "攆" => "j",
     "攇" => "j",
     "攉" => "j",
     "攌" => "j",
     "攍" => "j",
     "攎" => "j",
     "攏" => "j",
     "攐" => "j",
     "攓" => "j",
     "攔" => "j",
     "攕" => "j",
     "攖" => "j",
     "攗" => "j",
     "攘" => "j",
     "攙" => "j",
     "攛" => "j",
     "攜" => "j",
     "攝" => "j",
     "攠" => "j",
     "攡" => "j",
     "攢" => "j",
     "攤" => "j",
     "攥" => "j",
     "攦" => "j",
     "攩" => "j",
     "攪" => "j",
     "攫" => "j",
     "攬" => "j",
     "攭" => "j",
     "攮" => "j",
     "支" => "j",
     "攳" => "j",
     "故" => "j",
     "敕" => "j",
     "整" => "j",
     "斠" => "j",
     "斡" => "j",
     "晢" => "j",
     "朝" => "j",
     "朿" => "j",
     "束" => "j",
     "栽" => "j",
     "梊" => "j",
     "棗" => "j",
     "棘" => "j",
     "榦" => "j",
     "槷" => "j",
     "橐" => "j",
     "櫜" => "j",
     "欶" => "j",
     "歕" => "j",
     "焎" => "j",
     "熱" => "j",
     "獻" => "j",
     "疌" => "j",
     "疐" => "j",
     "癸" => "j",
     "癹" => "j",
     "登" => "j",
     "皾" => "j",
     "盩" => "j",
     "直" => "j",
     "矗" => "j",
     "硩" => "j",
     "祭" => "j",
     "索" => "j",
     "縶" => "j",
     "翅" => "j",
     "翰" => "j",
     "翸" => "j",
     "胾" => "j",
     "臷" => "j",
     "蛓" => "j",
     "蜇" => "j",
     "螒" => "j",
     "蟄" => "j",
     "蟗" => "j",
     "蠹" => "j",
     "衷" => "j",
     "裁" => "j",
     "裚" => "j",
     "覯" => "j",
     "覿" => "j",
     "誓" => "j",
     "謺" => "j",
     "豋" => "j",
     "賁" => "j",
     "賣" => "j",
     "賴" => "j",
     "贄" => "j",
     "踅" => "j",
     "載" => "j",
     "辜" => "j",
     "逝" => "j",
     "速" => "j",
     "進" => "j",
     "遘" => "j",
     "遫" => "j",
     "邆" => "j",
     "郣" => "j",
     "郪" => "j",
     "鄈" => "j",
     "鄧" => "j",
     "酨" => "j",
     "銴" => "j",
     "雗" => "j",
     "雜" => "j",
     "韓" => "j",
     "頍" => "j",
     "顛" => "j",
     "顜" => "j",
     "騺" => "j",
     "鳷" => "j",
     "鴣" => "j",
     "鵓" => "j",
     "鶈" => "j",
     "鶒" => "j",
     "鶘" => "j",
     "鶦" => "j",
     "鶾" => "j",
     "鷏" => "j",
     "鷘" => "j",
     "鷙" => "j",
     "鼖" => "j",
     "与" => "k",
     "丘" => "k",
     "丟" => "k",
     "丸" => "k",
     "乒" => "k",
     "乓" => "k",
     "九" => "k",
     "亟" => "k",
     "兵" => "k",
     "其" => "k",
     "冘" => "k",
     "冠" => "k",
     "函" => "k",
     "刑" => "k",
     "勘" => "k",
     "卍" => "k",
     "厹" => "k",
     "噩" => "k",
     "型" => "k",
     "基" => "k",
     "壬" => "k",
     "尢" => "k",
     "尥" => "k",
     "尪" => "k",
     "尰" => "k",
     "尳" => "k",
     "屔" => "k",
     "岳" => "k",
     "廷" => "k",
     "弄" => "k",
     "形" => "k",
     "徵" => "k",
     "忥" => "k",
     "惎" => "k",
     "懲" => "k",
     "戡" => "k",
     "攷" => "k",
     "斑" => "k",
     "斟" => "k",
     "斢" => "k",
     "斤" => "k",
     "斥" => "k",
     "斯" => "k",
     "斶" => "k",
     "旡" => "k",
     "旭" => "k",
     "旮" => "k",
     "朁" => "k",
     "期" => "k",
     "欣" => "k",
     "欺" => "k",
     "歁" => "k",
     "气" => "k",
     "氕" => "k",
     "氖" => "k",
     "氘" => "k",
     "氙" => "k",
     "氚" => "k",
     "氛" => "k",
     "氝" => "k",
     "氟" => "k",
     "氠" => "k",
     "氡" => "k",
     "氣" => "k",
     "氤" => "k",
     "氥" => "k",
     "氦" => "k",
     "氧" => "k",
     "氨" => "k",
     "氪" => "k",
     "氫" => "k",
     "氬" => "k",
     "氮" => "k",
     "氯" => "k",
     "氰" => "k",
     "氳" => "k",
     "沊" => "k",
     "潛" => "k",
     "玉" => "k",
     "玊" => "k",
     "王" => "k",
     "玎" => "k",
     "玒" => "k",
     "玓" => "k",
     "玔" => "k",
     "玕" => "k",
     "玖" => "k",
     "玗" => "k",
     "玝" => "k",
     "玟" => "k",
     "玠" => "k",
     "玡" => "k",
     "玢" => "k",
     "玤" => "k",
     "玥" => "k",
     "玦" => "k",
     "玨" => "k",
     "玩" => "k",
     "玫" => "k",
     "玬" => "k",
     "玭" => "k",
     "玲" => "k",
     "玳" => "k",
     "玴" => "k",
     "玵" => "k",
     "玶" => "k",
     "玷" => "k",
     "玸" => "k",
     "玹" => "k",
     "玻" => "k",
     "玼" => "k",
     "玾" => "k",
     "玿" => "k",
     "珀" => "k",
     "珂" => "k",
     "珃" => "k",
     "珅" => "k",
     "珆" => "k",
     "珇" => "k",
     "珈" => "k",
     "珊" => "k",
     "珋" => "k",
     "珌" => "k",
     "珍" => "k",
     "珒" => "k",
     "珓" => "k",
     "珔" => "k",
     "珖" => "k",
     "珗" => "k",
     "珘" => "k",
     "珙" => "k",
     "珚" => "k",
     "珛" => "k",
     "珜" => "k",
     "珝" => "k",
     "珞" => "k",
     "珠" => "k",
     "珣" => "k",
     "珥" => "k",
     "珧" => "k",
     "珨" => "k",
     "珩" => "k",
     "珪" => "k",
     "珫" => "k",
     "班" => "k",
     "珮" => "k",
     "珴" => "k",
     "珵" => "k",
     "珶" => "k",
     "珸" => "k",
     "珺" => "k",
     "珼" => "k",
     "珽" => "k",
     "現" => "k",
     "珿" => "k",
     "琀" => "k",
     "琁" => "k",
     "球" => "k",
     "琄" => "k",
     "琅" => "k",
     "理" => "k",
     "琇" => "k",
     "琈" => "k",
     "琉" => "k",
     "琊" => "k",
     "琋" => "k",
     "琌" => "k",
     "琍" => "k",
     "琖" => "k",
     "琚" => "k",
     "琛" => "k",
     "琝" => "k",
     "琠" => "k",
     "琡" => "k",
     "琢" => "k",
     "琣" => "k",
     "琤" => "k",
     "琥" => "k",
     "琦" => "k",
     "琨" => "k",
     "琩" => "k",
     "琪" => "k",
     "琫" => "k",
     "琬" => "k",
     "琭" => "k",
     "琮" => "k",
     "琯" => "k",
     "琰" => "k",
     "琱" => "k",
     "琲" => "k",
     "琳" => "k",
     "琴" => "k",
     "琵" => "k",
     "琶" => "k",
     "琺" => "k",
     "琿" => "k",
     "瑀" => "k",
     "瑁" => "k",
     "瑂" => "k",
     "瑄" => "k",
     "瑆" => "k",
     "瑊" => "k",
     "瑋" => "k",
     "瑍" => "k",
     "瑎" => "k",
     "瑏" => "k",
     "瑐" => "k",
     "瑑" => "k",
     "瑒" => "k",
     "瑔" => "k",
     "瑕" => "k",
     "瑗" => "k",
     "瑙" => "k",
     "瑚" => "k",
     "瑛" => "k",
     "瑜" => "k",
     "瑞" => "k",
     "瑟" => "k",
     "瑢" => "k",
     "瑣" => "k",
     "瑤" => "k",
     "瑧" => "k",
     "瑪" => "k",
     "瑭" => "k",
     "瑮" => "k",
     "瑯" => "k",
     "瑰" => "k",
     "瑱" => "k",
     "瑲" => "k",
     "瑳" => "k",
     "瑵" => "k",
     "瑹" => "k",
     "瑼" => "k",
     "瑽" => "k",
     "瑾" => "k",
     "璀" => "k",
     "璁" => "k",
     "璃" => "k",
     "璅" => "k",
     "璆" => "k",
     "璇" => "k",
     "璈" => "k",
     "璉" => "k",
     "璊" => "k",
     "璋" => "k",
     "璐" => "k",
     "璒" => "k",
     "璔" => "k",
     "璕" => "k",
     "璘" => "k",
     "璚" => "k",
     "璜" => "k",
     "璞" => "k",
     "璟" => "k",
     "璠" => "k",
     "璡" => "k",
     "璣" => "k",
     "璥" => "k",
     "璦" => "k",
     "璨" => "k",
     "璩" => "k",
     "璪" => "k",
     "璫" => "k",
     "璭" => "k",
     "璯" => "k",
     "環" => "k",
     "璱" => "k",
     "璲" => "k",
     "璵" => "k",
     "璶" => "k",
     "璷" => "k",
     "璸" => "k",
     "璻" => "k",
     "璾" => "k",
     "璿" => "k",
     "瓀" => "k",
     "瓁" => "k",
     "瓂" => "k",
     "瓃" => "k",
     "瓅" => "k",
     "瓊" => "k",
     "瓋" => "k",
     "瓏" => "k",
     "瓔" => "k",
     "瓖" => "k",
     "瓗" => "k",
     "瓘" => "k",
     "瓙" => "k",
     "瓚" => "k",
     "瓛" => "k",
     "甚" => "k",
     "盾" => "k",
     "瞂" => "k",
     "碁" => "k",
     "碧" => "k",
     "綦" => "k",
     "薦" => "k",
     "虓" => "k",
     "蟴" => "k",
     "訄" => "k",
     "諅" => "k",
     "賞" => "k",
     "質" => "k",
     "贊" => "k",
     "趣" => "k",
     "迋" => "k",
     "近" => "k",
     "遁" => "k",
     "邢" => "k",
     "邥" => "k",
     "邱" => "k",
     "開" => "k",
     "雃" => "k",
     "靠" => "k",
     "頄" => "k",
     "頊" => "k",
     "頎" => "k",
     "頲" => "k",
     "馗" => "k",
     "鬵" => "k",
     "鳩" => "k",
     "鳽" => "k",
     "鳿" => "k",
     "鴆" => "k",
     "鶞" => "k",
     "鷬" => "k",
     "黃" => "k",
     "黈" => "k",
     "亢" => "l",
     "交" => "l",
     "亥" => "l",
     "亦" => "l",
     "亨" => "l",
     "享" => "l",
     "京" => "l",
     "亭" => "l",
     "亮" => "l",
     "亳" => "l",
     "亶" => "l",
     "亹" => "l",
     "仄" => "l",
     "來" => "l",
     "兗" => "l",
     "六" => "l",
     "刻" => "l",
     "剖" => "l",
     "剫" => "l",
     "剷" => "l",
     "劂" => "l",
     "劘" => "l",
     "劾" => "l",
     "勍" => "l",
     "勯" => "l",
     "勷" => "l",
     "卞" => "l",
     "厂" => "l",
     "厄" => "l",
     "厊" => "l",
     "厎" => "l",
     "厏" => "l",
     "厒" => "l",
     "厔" => "l",
     "厖" => "l",
     "厗" => "l",
     "厘" => "l",
     "厙" => "l",
     "厚" => "l",
     "厜" => "l",
     "厝" => "l",
     "厞" => "l",
     "原" => "l",
     "厤" => "l",
     "厥" => "l",
     "厧" => "l",
     "厬" => "l",
     "厭" => "l",
     "厲" => "l",
     "厴" => "l",
     "反" => "l",
     "哀" => "l",
     "唐" => "l",
     "商" => "l",
     "啻" => "l",
     "喿" => "l",
     "嚲" => "l",
     "塵" => "l",
     "塺" => "l",
     "塾" => "l",
     "壅" => "l",
     "壓" => "l",
     "夜" => "l",
     "奊" => "l",
     "奕" => "l",
     "妾" => "l",
     "嬮" => "l",
     "孰" => "l",
     "市" => "l",
     "帝" => "l",
     "帟" => "l",
     "席" => "l",
     "庀" => "l",
     "庂" => "l",
     "庄" => "l",
     "庇" => "l",
     "庈" => "l",
     "庉" => "l",
     "庋" => "l",
     "庌" => "l",
     "庍" => "l",
     "序" => "l",
     "底" => "l",
     "庖" => "l",
     "店" => "l",
     "庚" => "l",
     "庛" => "l",
     "府" => "l",
     "庠" => "l",
     "庢" => "l",
     "庣" => "l",
     "庤" => "l",
     "庥" => "l",
     "度" => "l",
     "座" => "l",
     "庨" => "l",
     "庪" => "l",
     "庫" => "l",
     "庬" => "l",
     "庭" => "l",
     "庮" => "l",
     "庰" => "l",
     "庱" => "l",
     "庲" => "l",
     "庳" => "l",
     "庴" => "l",
     "庵" => "l",
     "庶" => "l",
     "康" => "l",
     "庸" => "l",
     "庹" => "l",
     "庾" => "l",
     "廁" => "l",
     "廂" => "l",
     "廄" => "l",
     "廅" => "l",
     "廆" => "l",
     "廇" => "l",
     "廈" => "l",
     "廉" => "l",
     "廊" => "l",
     "廋" => "l",
     "廌" => "l",
     "廎" => "l",
     "廑" => "l",
     "廒" => "l",
     "廓" => "l",
     "廔" => "l",
     "廕" => "l",
     "廖" => "l",
     "廗" => "l",
     "廘" => "l",
     "廙" => "l",
     "廚" => "l",
     "廛" => "l",
     "廜" => "l",
     "廝" => "l",
     "廞" => "l",
     "廟" => "l",
     "廠" => "l",
     "廡" => "l",
     "廢" => "l",
     "廣" => "l",
     "廥" => "l",
     "廦" => "l",
     "廧" => "l",
     "廨" => "l",
     "廩" => "l",
     "廬" => "l",
     "廮" => "l",
     "廯" => "l",
     "廱" => "l",
     "廲" => "l",
     "廳" => "l",
     "弈" => "l",
     "彥" => "l",
     "彰" => "l",
     "意" => "l",
     "愿" => "l",
     "慶" => "l",
     "憖" => "l",
     "憝" => "l",
     "戇" => "l",
     "戠" => "l",
     "揅" => "l",
     "摩" => "l",
     "撉" => "l",
     "效" => "l",
     "敦" => "l",
     "敨" => "l",
     "敲" => "l",
     "斫" => "l",
     "新" => "l",
     "曆" => "l",
     "欬" => "l",
     "歆" => "l",
     "歊" => "l",
     "歋" => "l",
     "歷" => "l",
     "毃" => "l",
     "毅" => "l",
     "毫" => "l",
     "氃" => "l",
     "氈" => "l",
     "泵" => "l",
     "灰" => "l",
     "烹" => "l",
     "熟" => "l",
     "爢" => "l",
     "犘" => "l",
     "猌" => "l",
     "玄" => "l",
     "玅" => "l",
     "玆" => "l",
     "率" => "l",
     "玈" => "l",
     "瓣" => "l",
     "瓤" => "l",
     "瓿" => "l",
     "甋" => "l",
     "甕" => "l",
     "產" => "l",
     "畜" => "l",
     "畝" => "l",
     "疔" => "l",
     "疕" => "l",
     "疘" => "l",
     "疙" => "l",
     "疚" => "l",
     "疝" => "l",
     "疢" => "l",
     "疣" => "l",
     "疤" => "l",
     "疥" => "l",
     "疧" => "l",
     "疪" => "l",
     "疫" => "l",
     "疰" => "l",
     "疲" => "l",
     "疳" => "l",
     "疵" => "l",
     "疶" => "l",
     "疸" => "l",
     "疹" => "l",
     "疺" => "l",
     "疻" => "l",
     "疼" => "l",
     "疽" => "l",
     "疾" => "l",
     "疿" => "l",
     "痀" => "l",
     "痁" => "l",
     "痂" => "l",
     "痄" => "l",
     "病" => "l",
     "症" => "l",
     "痊" => "l",
     "痋" => "l",
     "痌" => "l",
     "痍" => "l",
     "痎" => "l",
     "痏" => "l",
     "痐" => "l",
     "痑" => "l",
     "痒" => "l",
     "痔" => "l",
     "痕" => "l",
     "痗" => "l",
     "痘" => "l",
     "痙" => "l",
     "痚" => "l",
     "痛" => "l",
     "痝" => "l",
     "痞" => "l",
     "痟" => "l",
     "痠" => "l",
     "痡" => "l",
     "痢" => "l",
     "痣" => "l",
     "痤" => "l",
     "痦" => "l",
     "痧" => "l",
     "痭" => "l",
     "痯" => "l",
     "痰" => "l",
     "痱" => "l",
     "痲" => "l",
     "痳" => "l",
     "痴" => "l",
     "痵" => "l",
     "痶" => "l",
     "痷" => "l",
     "痸" => "l",
     "痹" => "l",
     "痺" => "l",
     "痻" => "l",
     "痼" => "l",
     "痽" => "l",
     "痾" => "l",
     "痿" => "l",
     "瘀" => "l",
     "瘁" => "l",
     "瘃" => "l",
     "瘈" => "l",
     "瘉" => "l",
     "瘊" => "l",
     "瘋" => "l",
     "瘌" => "l",
     "瘍" => "l",
     "瘏" => "l",
     "瘐" => "l",
     "瘑" => "l",
     "瘓" => "l",
     "瘔" => "l",
     "瘕" => "l",
     "瘖" => "l",
     "瘙" => "l",
     "瘚" => "l",
     "瘛" => "l",
     "瘜" => "l",
     "瘝" => "l",
     "瘞" => "l",
     "瘟" => "l",
     "瘠" => "l",
     "瘡" => "l",
     "瘢" => "l",
     "瘣" => "l",
     "瘤" => "l",
     "瘥" => "l",
     "瘦" => "l",
     "瘧" => "l",
     "瘨" => "l",
     "瘩" => "l",
     "瘭" => "l",
     "瘯" => "l",
     "瘰" => "l",
     "瘱" => "l",
     "瘲" => "l",
     "瘳" => "l",
     "瘴" => "l",
     "瘵" => "l",
     "瘸" => "l",
     "瘺" => "l",
     "瘼" => "l",
     "瘽" => "l",
     "療" => "l",
     "癃" => "l",
     "癆" => "l",
     "癇" => "l",
     "癈" => "l",
     "癉" => "l",
     "癌" => "l",
     "癐" => "l",
     "癒" => "l",
     "癓" => "l",
     "癖" => "l",
     "癗" => "l",
     "癘" => "l",
     "癙" => "l",
     "癚" => "l",
     "癜" => "l",
     "癟" => "l",
     "癠" => "l",
     "癡" => "l",
     "癢" => "l",
     "癤" => "l",
     "癥" => "l",
     "癩" => "l",
     "癪" => "l",
     "癬" => "l",
     "癭" => "l",
     "癮" => "l",
     "癰" => "l",
     "癱" => "l",
     "癲" => "l",
     "癵" => "l",
     "皽" => "l",
     "盔" => "l",
     "石" => "l",
     "矷" => "l",
     "矸" => "l",
     "矹" => "l",
     "矺" => "l",
     "矻" => "l",
     "矼" => "l",
     "矽" => "l",
     "砂" => "l",
     "砃" => "l",
     "砅" => "l",
     "砆" => "l",
     "砌" => "l",
     "砍" => "l",
     "砎" => "l",
     "砏" => "l",
     "砐" => "l",
     "砑" => "l",
     "砒" => "l",
     "砓" => "l",
     "研" => "l",
     "砝" => "l",
     "砟" => "l",
     "砠" => "l",
     "砡" => "l",
     "砢" => "l",
     "砣" => "l",
     "砥" => "l",
     "砧" => "l",
     "砨" => "l",
     "砩" => "l",
     "砪" => "l",
     "砫" => "l",
     "砬" => "l",
     "砭" => "l",
     "砯" => "l",
     "砰" => "l",
     "砱" => "l",
     "砲" => "l",
     "砳" => "l",
     "破" => "l",
     "砵" => "l",
     "砷" => "l",
     "砸" => "l",
     "硃" => "l",
     "硅" => "l",
     "硈" => "l",
     "硉" => "l",
     "硊" => "l",
     "硌" => "l",
     "硍" => "l",
     "硎" => "l",
     "硐" => "l",
     "硒" => "l",
     "硜" => "l",
     "硝" => "l",
     "硞" => "l",
     "硠" => "l",
     "硢" => "l",
     "硤" => "l",
     "硥" => "l",
     "硨" => "l",
     "硪" => "l",
     "硫" => "l",
     "硬" => "l",
     "硭" => "l",
     "确" => "l",
     "硯" => "l",
     "硱" => "l",
     "硹" => "l",
     "硼" => "l",
     "硾" => "l",
     "硿" => "l",
     "碀" => "l",
     "碃" => "l",
     "碄" => "l",
     "碅" => "l",
     "碇" => "l",
     "碉" => "l",
     "碌" => "l",
     "碎" => "l",
     "碏" => "l",
     "碑" => "l",
     "碓" => "l",
     "碔" => "l",
     "碕" => "l",
     "碖" => "l",
     "碗" => "l",
     "碘" => "l",
     "碙" => "l",
     "碚" => "l",
     "碟" => "l",
     "碠" => "l",
     "碡" => "l",
     "碢" => "l",
     "碣" => "l",
     "碤" => "l",
     "碥" => "l",
     "碨" => "l",
     "碩" => "l",
     "碪" => "l",
     "碫" => "l",
     "碬" => "l",
     "碭" => "l",
     "碰" => "l",
     "碲" => "l",
     "碳" => "l",
     "碴" => "l",
     "確" => "l",
     "碻" => "l",
     "碼" => "l",
     "碾" => "l",
     "磁" => "l",
     "磃" => "l",
     "磄" => "l",
     "磅" => "l",
     "磈" => "l",
     "磉" => "l",
     "磊" => "l",
     "磋" => "l",
     "磌" => "l",
     "磍" => "l",
     "磎" => "l",
     "磏" => "l",
     "磑" => "l",
     "磔" => "l",
     "磕" => "l",
     "磚" => "l",
     "磝" => "l",
     "磞" => "l",
     "磟" => "l",
     "磠" => "l",
     "磡" => "l",
     "磢" => "l",
     "磣" => "l",
     "磥" => "l",
     "磧" => "l",
     "磨" => "l",
     "磩" => "l",
     "磪" => "l",
     "磭" => "l",
     "磯" => "l",
     "磲" => "l",
     "磳" => "l",
     "磴" => "l",
     "磷" => "l",
     "磹" => "l",
     "磺" => "l",
     "磻" => "l",
     "磼" => "l",
     "磽" => "l",
     "磾" => "l",
     "磿" => "l",
     "礁" => "l",
     "礂" => "l",
     "礄" => "l",
     "礅" => "l",
     "礉" => "l",
     "礌" => "l",
     "礎" => "l",
     "礑" => "l",
     "礒" => "l",
     "礓" => "l",
     "礔" => "l",
     "礗" => "l",
     "礙" => "l",
     "礛" => "l",
     "礝" => "l",
     "礞" => "l",
     "礡" => "l",
     "礣" => "l",
     "礤" => "l",
     "礥" => "l",
     "礦" => "l",
     "礧" => "l",
     "礩" => "l",
     "礪" => "l",
     "礫" => "l",
     "礬" => "l",
     "礭" => "l",
     "礯" => "l",
     "礵" => "l",
     "礸" => "l",
     "礹" => "l",
     "离" => "l",
     "稟" => "l",
     "穈" => "l",
     "立" => "l",
     "竑" => "l",
     "竘" => "l",
     "站" => "l",
     "竟" => "l",
     "章" => "l",
     "竣" => "l",
     "竤" => "l",
     "童" => "l",
     "竦" => "l",
     "竫" => "l",
     "竭" => "l",
     "竮" => "l",
     "端" => "l",
     "競" => "l",
     "竷" => "l",
     "糜" => "l",
     "緳" => "l",
     "縻" => "l",
     "罋" => "l",
     "翊" => "l",
     "耒" => "l",
     "耔" => "l",
     "耕" => "l",
     "耖" => "l",
     "耗" => "l",
     "耘" => "l",
     "耙" => "l",
     "耛" => "l",
     "耜" => "l",
     "耞" => "l",
     "耟" => "l",
     "耡" => "l",
     "耤" => "l",
     "耦" => "l",
     "耨" => "l",
     "耩" => "l",
     "耪" => "l",
     "耬" => "l",
     "耰" => "l",
     "腐" => "l",
     "膏" => "l",
     "膺" => "l",
     "虒" => "l",
     "虱" => "l",
     "螷" => "l",
     "蟨" => "l",
     "蠯" => "l",
     "衣" => "l",
     "衰" => "l",
     "袌" => "l",
     "袞" => "l",
     "袤" => "l",
     "袬" => "l",
     "袲" => "l",
     "裏" => "l",
     "裒" => "l",
     "裔" => "l",
     "裛" => "l",
     "裹" => "l",
     "褎" => "l",
     "褒" => "l",
     "褢" => "l",
     "褭" => "l",
     "褱" => "l",
     "褻" => "l",
     "襄" => "l",
     "覛" => "l",
     "親" => "l",
     "豪" => "l",
     "賌" => "l",
     "賡" => "l",
     "贗" => "l",
     "贛" => "l",
     "路" => "l",
     "辛" => "l",
     "辣" => "l",
     "辨" => "l",
     "辮" => "l",
     "辯" => "l",
     "迒" => "l",
     "返" => "l",
     "遧" => "l",
     "遮" => "l",
     "邅" => "l",
     "邐" => "l",
     "邟" => "l",
     "郊" => "l",
     "部" => "l",
     "郭" => "l",
     "郲" => "l",
     "鄐" => "l",
     "鄗" => "l",
     "鄘" => "l",
     "鄜" => "l",
     "鄣" => "l",
     "鄺" => "l",
     "酈" => "l",
     "鏖" => "l",
     "雁" => "l",
     "雍" => "l",
     "離" => "l",
     "靖" => "l",
     "靡" => "l",
     "靨" => "l",
     "音" => "l",
     "韶" => "l",
     "韸" => "l",
     "韹" => "l",
     "韺" => "l",
     "韻" => "l",
     "頀" => "l",
     "頏" => "l",
     "頛" => "l",
     "頝" => "l",
     "頦" => "l",
     "顏" => "l",
     "願" => "l",
     "顫" => "l",
     "颯" => "l",
     "饔" => "l",
     "饜" => "l",
     "高" => "l",
     "髜" => "l",
     "魔" => "l",
     "魘" => "l",
     "鴈" => "l",
     "鴗" => "l",
     "鵁" => "l",
     "鶁" => "l",
     "鶆" => "l",
     "鶉" => "l",
     "鶊" => "l",
     "鶙" => "l",
     "鶶" => "l",
     "鷓" => "l",
     "鷛" => "l",
     "鷢" => "l",
     "鷹" => "l",
     "鷺" => "l",
     "鷾" => "l",
     "鸇" => "l",
     "鸝" => "l",
     "鹿" => "l",
     "麀" => "l",
     "麂" => "l",
     "麃" => "l",
     "麆" => "l",
     "麇" => "l",
     "麈" => "l",
     "麋" => "l",
     "麌" => "l",
     "麍" => "l",
     "麎" => "l",
     "麑" => "l",
     "麒" => "l",
     "麔" => "l",
     "麗" => "l",
     "麙" => "l",
     "麚" => "l",
     "麛" => "l",
     "麜" => "l",
     "麝" => "l",
     "麟" => "l",
     "麠" => "l",
     "麡" => "l",
     "麤" => "l",
     "麻" => "l",
     "麼" => "l",
     "麾" => "l",
     "黀" => "l",
     "黂" => "l",
     "黶" => "l",
     "龐" => "l",
     "且" => "m",
     "亃" => "m",
     "兕" => "m",
     "具" => "m",
     "冊" => "m",
     "凹" => "m",
     "刞" => "m",
     "刪" => "m",
     "則" => "m",
     "劀" => "m",
     "助" => "m",
     "務" => "m",
     "勫" => "m",
     "問" => "m",
     "垼" => "m",
     "堥" => "m",
     "婁" => "m",
     "婺" => "m",
     "嬃" => "m",
     "嬰" => "m",
     "彳" => "m",
     "彴" => "m",
     "彶" => "m",
     "彷" => "m",
     "彸" => "m",
     "役" => "m",
     "彼" => "m",
     "彽" => "m",
     "彾" => "m",
     "彿" => "m",
     "往" => "m",
     "征" => "m",
     "徂" => "m",
     "徆" => "m",
     "徇" => "m",
     "徉" => "m",
     "徊" => "m",
     "律" => "m",
     "徐" => "m",
     "徑" => "m",
     "徒" => "m",
     "徖" => "m",
     "徘" => "m",
     "徙" => "m",
     "徛" => "m",
     "徜" => "m",
     "徟" => "m",
     "徠" => "m",
     "御" => "m",
     "徥" => "m",
     "徦" => "m",
     "徨" => "m",
     "復" => "m",
     "循" => "m",
     "徫" => "m",
     "徬" => "m",
     "徭" => "m",
     "微" => "m",
     "徯" => "m",
     "徲" => "m",
     "徶" => "m",
     "德" => "m",
     "徹" => "m",
     "徻" => "m",
     "徼" => "m",
     "徽" => "m",
     "徾" => "m",
     "徿" => "m",
     "忀" => "m",
     "忁" => "m",
     "悶" => "m",
     "愆" => "m",
     "懣" => "m",
     "懸" => "m",
     "敉" => "m",
     "敗" => "m",
     "數" => "m",
     "料" => "m",
     "柔" => "m",
     "楘" => "m",
     "毛" => "m",
     "毢" => "m",
     "毧" => "m",
     "毨" => "m",
     "毬" => "m",
     "毯" => "m",
     "毰" => "m",
     "毳" => "m",
     "毸" => "m",
     "毽" => "m",
     "氀" => "m",
     "氁" => "m",
     "氄" => "m",
     "氆" => "m",
     "氌" => "m",
     "氍" => "m",
     "滿" => "m",
     "焛" => "m",
     "熧" => "m",
     "狊" => "m",
     "甐" => "m",
     "甖" => "m",
     "番" => "m",
     "目" => "m",
     "盯" => "m",
     "盰" => "m",
     "盱" => "m",
     "盳" => "m",
     "盵" => "m",
     "盷" => "m",
     "盹" => "m",
     "盺" => "m",
     "盻" => "m",
     "盼" => "m",
     "眃" => "m",
     "眄" => "m",
     "眅" => "m",
     "眇" => "m",
     "眈" => "m",
     "眊" => "m",
     "眐" => "m",
     "眑" => "m",
     "眒" => "m",
     "眓" => "m",
     "眕" => "m",
     "眙" => "m",
     "眛" => "m",
     "眝" => "m",
     "眠" => "m",
     "眣" => "m",
     "眧" => "m",
     "眨" => "m",
     "眩" => "m",
     "眭" => "m",
     "眯" => "m",
     "眱" => "m",
     "眲" => "m",
     "眳" => "m",
     "眴" => "m",
     "眵" => "m",
     "眶" => "m",
     "眸" => "m",
     "眹" => "m",
     "眺" => "m",
     "眻" => "m",
     "眼" => "m",
     "眽" => "m",
     "睄" => "m",
     "睅" => "m",
     "睆" => "m",
     "睇" => "m",
     "睊" => "m",
     "睋" => "m",
     "睌" => "m",
     "睍" => "m",
     "睎" => "m",
     "睏" => "m",
     "睒" => "m",
     "睔" => "m",
     "睕" => "m",
     "睖" => "m",
     "睙" => "m",
     "睚" => "m",
     "睛" => "m",
     "睜" => "m",
     "睞" => "m",
     "睟" => "m",
     "睠" => "m",
     "睡" => "m",
     "睢" => "m",
     "睥" => "m",
     "睦" => "m",
     "睧" => "m",
     "睨" => "m",
     "睩" => "m",
     "睫" => "m",
     "睬" => "m",
     "睭" => "m",
     "睮" => "m",
     "睼" => "m",
     "睽" => "m",
     "瞀" => "m",
     "瞁" => "m",
     "瞃" => "m",
     "瞄" => "m",
     "瞅" => "m",
     "瞇" => "m",
     "瞈" => "m",
     "瞋" => "m",
     "瞌" => "m",
     "瞍" => "m",
     "瞎" => "m",
     "瞑" => "m",
     "瞕" => "m",
     "瞗" => "m",
     "瞙" => "m",
     "瞚" => "m",
     "瞛" => "m",
     "瞜" => "m",
     "瞝" => "m",
     "瞞" => "m",
     "瞟" => "m",
     "瞠" => "m",
     "瞡" => "m",
     "瞣" => "m",
     "瞧" => "m",
     "瞨" => "m",
     "瞪" => "m",
     "瞫" => "m",
     "瞬" => "m",
     "瞭" => "m",
     "瞰" => "m",
     "瞱" => "m",
     "瞲" => "m",
     "瞳" => "m",
     "瞴" => "m",
     "瞵" => "m",
     "瞶" => "m",
     "瞷" => "m",
     "瞺" => "m",
     "瞻" => "m",
     "瞼" => "m",
     "瞿" => "m",
     "矂" => "m",
     "矄" => "m",
     "矇" => "m",
     "矉" => "m",
     "矊" => "m",
     "矌" => "m",
     "矍" => "m",
     "矎" => "m",
     "矏" => "m",
     "矐" => "m",
     "矓" => "m",
     "矔" => "m",
     "矘" => "m",
     "矙" => "m",
     "矚" => "m",
     "矛" => "m",
     "矜" => "m",
     "矞" => "m",
     "矠" => "m",
     "禦" => "m",
     "米" => "m",
     "籵" => "m",
     "籸" => "m",
     "籹" => "m",
     "籺" => "m",
     "籽" => "m",
     "籿" => "m",
     "粀" => "m",
     "粁" => "m",
     "粄" => "m",
     "粅" => "m",
     "粈" => "m",
     "粉" => "m",
     "粌" => "m",
     "粍" => "m",
     "粑" => "m",
     "粒" => "m",
     "粔" => "m",
     "粕" => "m",
     "粖" => "m",
     "粗" => "m",
     "粘" => "m",
     "粞" => "m",
     "粡" => "m",
     "粣" => "m",
     "粧" => "m",
     "粨" => "m",
     "粯" => "m",
     "粳" => "m",
     "粴" => "m",
     "粹" => "m",
     "粺" => "m",
     "粻" => "m",
     "粼" => "m",
     "粽" => "m",
     "精" => "m",
     "粿" => "m",
     "糅" => "m",
     "糈" => "m",
     "糊" => "m",
     "糋" => "m",
     "糌" => "m",
     "糎" => "m",
     "糐" => "m",
     "糑" => "m",
     "糒" => "m",
     "糔" => "m",
     "糕" => "m",
     "糖" => "m",
     "糗" => "m",
     "糙" => "m",
     "糝" => "m",
     "糞" => "m",
     "糟" => "m",
     "糠" => "m",
     "糢" => "m",
     "糧" => "m",
     "糨" => "m",
     "糬" => "m",
     "糮" => "m",
     "糯" => "m",
     "糰" => "m",
     "糲" => "m",
     "糷" => "m",
     "縣" => "m",
     "纇" => "m",
     "罌" => "m",
     "翷" => "m",
     "翻" => "m",
     "聞" => "m",
     "蝥" => "m",
     "蟊" => "m",
     "蠈" => "m",
     "行" => "m",
     "衍" => "m",
     "衎" => "m",
     "衒" => "m",
     "衕" => "m",
     "衖" => "m",
     "街" => "m",
     "衙" => "m",
     "衚" => "m",
     "衛" => "m",
     "衝" => "m",
     "衡" => "m",
     "衢" => "m",
     "見" => "m",
     "覞" => "m",
     "覹" => "m",
     "誾" => "m",
     "譻" => "m",
     "讆" => "m",
     "貝" => "m",
     "財" => "m",
     "貤" => "m",
     "貥" => "m",
     "販" => "m",
     "貯" => "m",
     "貶" => "m",
     "貹" => "m",
     "貺" => "m",
     "貼" => "m",
     "貽" => "m",
     "貾" => "m",
     "賂" => "m",
     "賄" => "m",
     "賅" => "m",
     "賊" => "m",
     "賏" => "m",
     "賑" => "m",
     "賒" => "m",
     "賕" => "m",
     "賗" => "m",
     "賙" => "m",
     "賜" => "m",
     "賝" => "m",
     "賟" => "m",
     "賠" => "m",
     "賤" => "m",
     "賥" => "m",
     "賦" => "m",
     "賧" => "m",
     "賬" => "m",
     "賭" => "m",
     "賰" => "m",
     "賱" => "m",
     "賳" => "m",
     "賵" => "m",
     "賹" => "m",
     "賺" => "m",
     "賻" => "m",
     "購" => "m",
     "贂" => "m",
     "贆" => "m",
     "贈" => "m",
     "贉" => "m",
     "贍" => "m",
     "贐" => "m",
     "贓" => "m",
     "贔" => "m",
     "贖" => "m",
     "躗" => "m",
     "迷" => "m",
     "遴" => "m",
     "遹" => "m",
     "郥" => "m",
     "郹" => "m",
     "郻" => "m",
     "鄱" => "m",
     "釆" => "m",
     "鍪" => "m",
     "門" => "m",
     "閂" => "m",
     "閃" => "m",
     "閆" => "m",
     "閈" => "m",
     "閉" => "m",
     "閌" => "m",
     "閍" => "m",
     "閎" => "m",
     "閏" => "m",
     "閐" => "m",
     "閑" => "m",
     "閒" => "m",
     "間" => "m",
     "閔" => "m",
     "閘" => "m",
     "閛" => "m",
     "閜" => "m",
     "閞" => "m",
     "閟" => "m",
     "閡" => "m",
     "閣" => "m",
     "閤" => "m",
     "閥" => "m",
     "閨" => "m",
     "閩" => "m",
     "閫" => "m",
     "閬" => "m",
     "閭" => "m",
     "閮" => "m",
     "閰" => "m",
     "閱" => "m",
     "閵" => "m",
     "閶" => "m",
     "閹" => "m",
     "閺" => "m",
     "閻" => "m",
     "閼" => "m",
     "閽" => "m",
     "閾" => "m",
     "閿" => "m",
     "闀" => "m",
     "闃" => "m",
     "闅" => "m",
     "闆" => "m",
     "闇" => "m",
     "闈" => "m",
     "闉" => "m",
     "闊" => "m",
     "闋" => "m",
     "闌" => "m",
     "闍" => "m",
     "闐" => "m",
     "闑" => "m",
     "闒" => "m",
     "闓" => "m",
     "闔" => "m",
     "闕" => "m",
     "闖" => "m",
     "闚" => "m",
     "闛" => "m",
     "闞" => "m",
     "闟" => "m",
     "闠" => "m",
     "闡" => "m",
     "闢" => "m",
     "闣" => "m",
     "闤" => "m",
     "闥" => "m",
     "雎" => "m",
     "鞪" => "m",
     "須" => "m",
     "類" => "m",
     "颿" => "m",
     "馬" => "m",
     "馭" => "m",
     "馯" => "m",
     "馰" => "m",
     "馱" => "m",
     "馲" => "m",
     "馳" => "m",
     "馴" => "m",
     "馵" => "m",
     "馹" => "m",
     "馺" => "m",
     "馻" => "m",
     "馽" => "m",
     "駁" => "m",
     "駃" => "m",
     "駇" => "m",
     "駉" => "m",
     "駋" => "m",
     "駍" => "m",
     "駎" => "m",
     "駏" => "m",
     "駒" => "m",
     "駓" => "m",
     "駔" => "m",
     "駖" => "m",
     "駗" => "m",
     "駘" => "m",
     "駙" => "m",
     "駛" => "m",
     "駜" => "m",
     "駝" => "m",
     "駟" => "m",
     "駢" => "m",
     "駣" => "m",
     "駤" => "m",
     "駥" => "m",
     "駧" => "m",
     "駩" => "m",
     "駪" => "m",
     "駬" => "m",
     "駭" => "m",
     "駮" => "m",
     "駰" => "m",
     "駱" => "m",
     "駴" => "m",
     "駶" => "m",
     "駷" => "m",
     "駸" => "m",
     "駹" => "m",
     "駺" => "m",
     "駻" => "m",
     "駼" => "m",
     "駽" => "m",
     "駾" => "m",
     "駿" => "m",
     "騁" => "m",
     "騂" => "m",
     "騃" => "m",
     "騄" => "m",
     "騅" => "m",
     "騆" => "m",
     "騇" => "m",
     "騉" => "m",
     "騊" => "m",
     "騋" => "m",
     "騍" => "m",
     "騎" => "m",
     "騏" => "m",
     "騑" => "m",
     "騔" => "m",
     "騕" => "m",
     "騖" => "m",
     "騙" => "m",
     "騚" => "m",
     "騛" => "m",
     "騜" => "m",
     "騝" => "m",
     "騞" => "m",
     "騠" => "m",
     "騢" => "m",
     "騣" => "m",
     "騤" => "m",
     "騥" => "m",
     "騧" => "m",
     "騩" => "m",
     "騪" => "m",
     "騬" => "m",
     "騮" => "m",
     "騱" => "m",
     "騲" => "m",
     "騴" => "m",
     "騵" => "m",
     "騶" => "m",
     "騷" => "m",
     "騸" => "m",
     "騹" => "m",
     "騽" => "m",
     "騾" => "m",
     "騿" => "m",
     "驂" => "m",
     "驃" => "m",
     "驄" => "m",
     "驅" => "m",
     "驆" => "m",
     "驈" => "m",
     "驉" => "m",
     "驊" => "m",
     "驌" => "m",
     "驍" => "m",
     "驎" => "m",
     "驏" => "m",
     "驐" => "m",
     "驒" => "m",
     "驓" => "m",
     "驔" => "m",
     "驕" => "m",
     "驖" => "m",
     "驗" => "m",
     "驙" => "m",
     "驛" => "m",
     "驞" => "m",
     "驟" => "m",
     "驠" => "m",
     "驢" => "m",
     "驤" => "m",
     "驥" => "m",
     "驦" => "m",
     "驧" => "m",
     "驨" => "m",
     "驩" => "m",
     "驪" => "m",
     "驫" => "m",
     "鰴" => "m",
     "鵙" => "m",
     "鶔" => "m",
     "鶩" => "m",
     "鶪" => "m",
     "鷜" => "m",
     "鷭" => "m",
     "鷳" => "m",
     "鷴" => "m",
     "鷸" => "m",
     "鸚" => "m",
     "麊" => "m",
     "黴" => "m",
     "鼎" => "m",
     "丹" => "n",
     "久" => "n",
     "內" => "n",
     "冉" => "n",
     "冏" => "n",
     "冗" => "n",
     "冞" => "n",
     "冢" => "n",
     "冤" => "n",
     "冥" => "n",
     "冪" => "n",
     "刎" => "n",
     "刐" => "n",
     "刨" => "n",
     "剛" => "n",
     "剜" => "n",
     "割" => "n",
     "劖" => "n",
     "劬" => "n",
     "勺" => "n",
     "勻" => "n",
     "勼" => "n",
     "勾" => "n",
     "勿" => "n",
     "包" => "n",
     "匆" => "n",
     "匈" => "n",
     "匉" => "n",
     "匊" => "n",
     "匋" => "n",
     "匍" => "n",
     "匎" => "n",
     "匐" => "n",
     "匑" => "n",
     "匒" => "n",
     "危" => "n",
     "句" => "n",
     "同" => "n",
     "周" => "n",
     "塞" => "n",
     "奐" => "n",
     "字" => "n",
     "宁" => "n",
     "它" => "n",
     "宄" => "n",
     "宅" => "n",
     "宇" => "n",
     "守" => "n",
     "安" => "n",
     "宋" => "n",
     "完" => "n",
     "宎" => "n",
     "宏" => "n",
     "宒" => "n",
     "宓" => "n",
     "宕" => "n",
     "宗" => "n",
     "官" => "n",
     "宙" => "n",
     "定" => "n",
     "宛" => "n",
     "宜" => "n",
     "客" => "n",
     "室" => "n",
     "宥" => "n",
     "宦" => "n",
     "宧" => "n",
     "宨" => "n",
     "宬" => "n",
     "宭" => "n",
     "宮" => "n",
     "宰" => "n",
     "害" => "n",
     "宴" => "n",
     "宵" => "n",
     "家" => "n",
     "宸" => "n",
     "容" => "n",
     "宿" => "n",
     "寀" => "n",
     "寁" => "n",
     "寂" => "n",
     "寄" => "n",
     "寅" => "n",
     "密" => "n",
     "寇" => "n",
     "寊" => "n",
     "寋" => "n",
     "寍" => "n",
     "寎" => "n",
     "寐" => "n",
     "寑" => "n",
     "寒" => "n",
     "寓" => "n",
     "寔" => "n",
     "寖" => "n",
     "寘" => "n",
     "寙" => "n",
     "寞" => "n",
     "察" => "n",
     "寠" => "n",
     "寡" => "n",
     "寢" => "n",
     "寣" => "n",
     "寤" => "n",
     "寥" => "n",
     "實" => "n",
     "寧" => "n",
     "寨" => "n",
     "審" => "n",
     "寪" => "n",
     "寫" => "n",
     "寬" => "n",
     "寮" => "n",
     "寯" => "n",
     "寰" => "n",
     "寱" => "n",
     "寲" => "n",
     "寵" => "n",
     "寶" => "n",
     "岡" => "n",
     "島" => "n",
     "巾" => "n",
     "帄" => "n",
     "帆" => "n",
     "帊" => "n",
     "帎" => "n",
     "帔" => "n",
     "帕" => "n",
     "帖" => "n",
     "帗" => "n",
     "帘" => "n",
     "帙" => "n",
     "帡" => "n",
     "帢" => "n",
     "帨" => "n",
     "帩" => "n",
     "帳" => "n",
     "帴" => "n",
     "帷" => "n",
     "帽" => "n",
     "帾" => "n",
     "幀" => "n",
     "幁" => "n",
     "幃" => "n",
     "幄" => "n",
     "幅" => "n",
     "幊" => "n",
     "幌" => "n",
     "幍" => "n",
     "幎" => "n",
     "幏" => "n",
     "幓" => "n",
     "幔" => "n",
     "幗" => "n",
     "幘" => "n",
     "幙" => "n",
     "幛" => "n",
     "幜" => "n",
     "幝" => "n",
     "幟" => "n",
     "幠" => "n",
     "幡" => "n",
     "幢" => "n",
     "幧" => "n",
     "幨" => "n",
     "幩" => "n",
     "幪" => "n",
     "幬" => "n",
     "幭" => "n",
     "幮" => "n",
     "幯" => "n",
     "幰" => "n",
     "彤" => "n",
     "彫" => "n",
     "忽" => "n",
     "急" => "n",
     "悹" => "n",
     "惌" => "n",
     "憲" => "n",
     "憼" => "n",
     "戙" => "n",
     "戭" => "n",
     "搴" => "n",
     "擎" => "n",
     "敬" => "n",
     "敻" => "n",
     "斛" => "n",
     "斪" => "n",
     "旬" => "n",
     "曶" => "n",
     "案" => "n",
     "梟" => "n",
     "檠" => "n",
     "欨" => "n",
     "毚" => "n",
     "灸" => "n",
     "災" => "n",
     "炰" => "n",
     "煞" => "n",
     "爾" => "n",
     "牢" => "n",
     "璽" => "n",
     "甔" => "n",
     "用" => "n",
     "甩" => "n",
     "甮" => "n",
     "甯" => "n",
     "甸" => "n",
     "當" => "n",
     "皸" => "n",
     "皺" => "n",
     "禸" => "n",
     "穴" => "n",
     "穵" => "n",
     "究" => "n",
     "穸" => "n",
     "穹" => "n",
     "空" => "n",
     "穻" => "n",
     "穾" => "n",
     "穿" => "n",
     "窀" => "n",
     "突" => "n",
     "窄" => "n",
     "窅" => "n",
     "窆" => "n",
     "窇" => "n",
     "窈" => "n",
     "窉" => "n",
     "窊" => "n",
     "窋" => "n",
     "窌" => "n",
     "窏" => "n",
     "窐" => "n",
     "窒" => "n",
     "窔" => "n",
     "窕" => "n",
     "窖" => "n",
     "窗" => "n",
     "窘" => "n",
     "窙" => "n",
     "窞" => "n",
     "窟" => "n",
     "窠" => "n",
     "窢" => "n",
     "窣" => "n",
     "窨" => "n",
     "窩" => "n",
     "窪" => "n",
     "窫" => "n",
     "窬" => "n",
     "窮" => "n",
     "窯" => "n",
     "窱" => "n",
     "窲" => "n",
     "窳" => "n",
     "窴" => "n",
     "窵" => "n",
     "窶" => "n",
     "窷" => "n",
     "窸" => "n",
     "窺" => "n",
     "窾" => "n",
     "窿" => "n",
     "竀" => "n",
     "竁" => "n",
     "竄" => "n",
     "竅" => "n",
     "竇" => "n",
     "竊" => "n",
     "簾" => "n",
     "網" => "n",
     "网" => "n",
     "罔" => "n",
     "罕" => "n",
     "翢" => "n",
     "肉" => "n",
     "芻" => "n",
     "蜜" => "n",
     "蟹" => "n",
     "蟼" => "n",
     "裊" => "n",
     "褰" => "n",
     "覭" => "n",
     "覾" => "n",
     "角" => "n",
     "觓" => "n",
     "觔" => "n",
     "觖" => "n",
     "觙" => "n",
     "觚" => "n",
     "觛" => "n",
     "觝" => "n",
     "觟" => "n",
     "觡" => "n",
     "解" => "n",
     "觤" => "n",
     "觥" => "n",
     "触" => "n",
     "觨" => "n",
     "觩" => "n",
     "觫" => "n",
     "觬" => "n",
     "觭" => "n",
     "觰" => "n",
     "觲" => "n",
     "觴" => "n",
     "觶" => "n",
     "觸" => "n",
     "觻" => "n",
     "觼" => "n",
     "觾" => "n",
     "觿" => "n",
     "訇" => "n",
     "詹" => "n",
     "謇" => "n",
     "警" => "n",
     "豁" => "n",
     "象" => "n",
     "賓" => "n",
     "賨" => "n",
     "賽" => "n",
     "蹇" => "n",
     "軍" => "n",
     "迥" => "n",
     "迵" => "n",
     "迿" => "n",
     "逭" => "n",
     "週" => "n",
     "運" => "n",
     "邂" => "n",
     "邃" => "n",
     "邇" => "n",
     "郇" => "n",
     "鄆" => "n",
     "鄍" => "n",
     "鄒" => "n",
     "鄡" => "n",
     "酁" => "n",
     "雊" => "n",
     "雕" => "n",
     "雘" => "n",
     "雛" => "n",
     "頞" => "n",
     "頠" => "n",
     "顁" => "n",
     "額" => "n",
     "顐" => "n",
     "騫" => "n",
     "鳥" => "n",
     "鳦" => "n",
     "鳧" => "n",
     "鴃" => "n",
     "鴅" => "n",
     "鴕" => "n",
     "鴝" => "n",
     "鴥" => "n",
     "鴳" => "n",
     "鵌" => "n",
     "鵔" => "n",
     "鵰" => "n",
     "鵴" => "n",
     "鵷" => "n",
     "鵻" => "n",
     "鵿" => "n",
     "鶀" => "n",
     "鶟" => "n",
     "鶤" => "n",
     "鶱" => "n",
     "鶳" => "n",
     "鶴" => "n",
     "鶵" => "n",
     "鶷" => "n",
     "鷈" => "n",
     "鷌" => "n",
     "鷻" => "n",
     "鸃" => "n",
     "鸋" => "n",
     "鸔" => "n",
     "鼆" => "n",
     "鼏" => "n",
     "龜" => "n",
     "兄" => "o",
     "刡" => "o",
     "別" => "o",
     "剮" => "o",
     "劋" => "o",
     "勛" => "o",
     "口" => "o",
     "另" => "o",
     "叨" => "o",
     "叩" => "o",
     "只" => "o",
     "叫" => "o",
     "叭" => "o",
     "叮" => "o",
     "叱" => "o",
     "叻" => "o",
     "叼" => "o",
     "吁" => "o",
     "吃" => "o",
     "吆" => "o",
     "吇" => "o",
     "吊" => "o",
     "吋" => "o",
     "吐" => "o",
     "吒" => "o",
     "吘" => "o",
     "吙" => "o",
     "吜" => "o",
     "吟" => "o",
     "吠" => "o",
     "吤" => "o",
     "吥" => "o",
     "吧" => "o",
     "吨" => "o",
     "吩" => "o",
     "吪" => "o",
     "听" => "o",
     "吭" => "o",
     "吮" => "o",
     "吰" => "o",
     "吱" => "o",
     "吳" => "o",
     "吵" => "o",
     "吶" => "o",
     "吷" => "o",
     "吸" => "o",
     "吹" => "o",
     "吻" => "o",
     "吼" => "o",
     "吽" => "o",
     "呀" => "o",
     "呁" => "o",
     "呂" => "o",
     "呃" => "o",
     "呅" => "o",
     "呆" => "o",
     "呈" => "o",
     "呎" => "o",
     "呏" => "o",
     "呔" => "o",
     "呠" => "o",
     "呡" => "o",
     "呢" => "o",
     "呣" => "o",
     "呤" => "o",
     "呥" => "o",
     "呦" => "o",
     "呧" => "o",
     "呫" => "o",
     "呬" => "o",
     "呯" => "o",
     "呱" => "o",
     "呲" => "o",
     "味" => "o",
     "呴" => "o",
     "呵" => "o",
     "呶" => "o",
     "呷" => "o",
     "呸" => "o",
     "呺" => "o",
     "呻" => "o",
     "呼" => "o",
     "呾" => "o",
     "呿" => "o",
     "咀" => "o",
     "咁" => "o",
     "咂" => "o",
     "咄" => "o",
     "咆" => "o",
     "咇" => "o",
     "咈" => "o",
     "咋" => "o",
     "咍" => "o",
     "咐" => "o",
     "咑" => "o",
     "咒" => "o",
     "咕" => "o",
     "咖" => "o",
     "咘" => "o",
     "咚" => "o",
     "咠" => "o",
     "咡" => "o",
     "咢" => "o",
     "咥" => "o",
     "咦" => "o",
     "咧" => "o",
     "咩" => "o",
     "咪" => "o",
     "咬" => "o",
     "咭" => "o",
     "咮" => "o",
     "咯" => "o",
     "咰" => "o",
     "咱" => "o",
     "咳" => "o",
     "咶" => "o",
     "咷" => "o",
     "咺" => "o",
     "咻" => "o",
     "咽" => "o",
     "咾" => "o",
     "咿" => "o",
     "品" => "o",
     "哂" => "o",
     "哃" => "o",
     "哄" => "o",
     "哅" => "o",
     "哆" => "o",
     "哇" => "o",
     "哈" => "o",
     "哎" => "o",
     "哏" => "o",
     "哖" => "o",
     "哞" => "o",
     "哠" => "o",
     "員" => "o",
     "哢" => "o",
     "哤" => "o",
     "哦" => "o",
     "哧" => "o",
     "哨" => "o",
     "哩" => "o",
     "哪" => "o",
     "哫" => "o",
     "哭" => "o",
     "哮" => "o",
     "哱" => "o",
     "哳" => "o",
     "哷" => "o",
     "哸" => "o",
     "哺" => "o",
     "哻" => "o",
     "哼" => "o",
     "哽" => "o",
     "唁" => "o",
     "唃" => "o",
     "唄" => "o",
     "唅" => "o",
     "唆" => "o",
     "唈" => "o",
     "唉" => "o",
     "唊" => "o",
     "唋" => "o",
     "唌" => "o",
     "唎" => "o",
     "唏" => "o",
     "唑" => "o",
     "唒" => "o",
     "唔" => "o",
     "唗" => "o",
     "唚" => "o",
     "唦" => "o",
     "唧" => "o",
     "唪" => "o",
     "唬" => "o",
     "唭" => "o",
     "唯" => "o",
     "唰" => "o",
     "唱" => "o",
     "唲" => "o",
     "唳" => "o",
     "唴" => "o",
     "唵" => "o",
     "唶" => "o",
     "唷" => "o",
     "唸" => "o",
     "唹" => "o",
     "唻" => "o",
     "唼" => "o",
     "唾" => "o",
     "啀" => "o",
     "啁" => "o",
     "啃" => "o",
     "啄" => "o",
     "啅" => "o",
     "啈" => "o",
     "啊" => "o",
     "啋" => "o",
     "啍" => "o",
     "啐" => "o",
     "啑" => "o",
     "啒" => "o",
     "啕" => "o",
     "啖" => "o",
     "啗" => "o",
     "啜" => "o",
     "啞" => "o",
     "啡" => "o",
     "啢" => "o",
     "啣" => "o",
     "啤" => "o",
     "啥" => "o",
     "啦" => "o",
     "啪" => "o",
     "啵" => "o",
     "啶" => "o",
     "啷" => "o",
     "啼" => "o",
     "啽" => "o",
     "啾" => "o",
     "啿" => "o",
     "喀" => "o",
     "喁" => "o",
     "喂" => "o",
     "喃" => "o",
     "喇" => "o",
     "喈" => "o",
     "喉" => "o",
     "喊" => "o",
     "喋" => "o",
     "喌" => "o",
     "喍" => "o",
     "喎" => "o",
     "喏" => "o",
     "喑" => "o",
     "喒" => "o",
     "喓" => "o",
     "喔" => "o",
     "喕" => "o",
     "喘" => "o",
     "喙" => "o",
     "喚" => "o",
     "喝" => "o",
     "喟" => "o",
     "喡" => "o",
     "喢" => "o",
     "喣" => "o",
     "喤" => "o",
     "喥" => "o",
     "喦" => "o",
     "喧" => "o",
     "喨" => "o",
     "喫" => "o",
     "喭" => "o",
     "喱" => "o",
     "喲" => "o",
     "喳" => "o",
     "喵" => "o",
     "喻" => "o",
     "嗂" => "o",
     "嗃" => "o",
     "嗄" => "o",
     "嗅" => "o",
     "嗆" => "o",
     "嗈" => "o",
     "嗉" => "o",
     "嗊" => "o",
     "嗋" => "o",
     "嗌" => "o",
     "嗍" => "o",
     "嗎" => "o",
     "嗏" => "o",
     "嗐" => "o",
     "嗑" => "o",
     "嗒" => "o",
     "嗓" => "o",
     "嗔" => "o",
     "嗕" => "o",
     "嗖" => "o",
     "嗙" => "o",
     "嗚" => "o",
     "嗛" => "o",
     "嗜" => "o",
     "嗝" => "o",
     "嗟" => "o",
     "嗡" => "o",
     "嗢" => "o",
     "嗣" => "o",
     "嗤" => "o",
     "嗥" => "o",
     "嗦" => "o",
     "嗨" => "o",
     "嗩" => "o",
     "嗯" => "o",
     "嗲" => "o",
     "嗶" => "o",
     "嗷" => "o",
     "嗹" => "o",
     "嗺" => "o",
     "嗼" => "o",
     "嗽" => "o",
     "嗾" => "o",
     "嗿" => "o",
     "嘀" => "o",
     "嘁" => "o",
     "嘂" => "o",
     "嘄" => "o",
     "嘆" => "o",
     "嘈" => "o",
     "嘌" => "o",
     "嘍" => "o",
     "嘎" => "o",
     "嘐" => "o",
     "嘒" => "o",
     "嘓" => "o",
     "嘔" => "o",
     "嘕" => "o",
     "嘖" => "o",
     "嘛" => "o",
     "嘜" => "o",
     "嘝" => "o",
     "嘟" => "o",
     "嘧" => "o",
     "嘩" => "o",
     "嘪" => "o",
     "嘬" => "o",
     "嘮" => "o",
     "嘯" => "o",
     "嘰" => "o",
     "嘲" => "o",
     "嘳" => "o",
     "嘴" => "o",
     "嘵" => "o",
     "嘶" => "o",
     "嘸" => "o",
     "嘹" => "o",
     "嘺" => "o",
     "嘻" => "o",
     "嘽" => "o",
     "嘾" => "o",
     "嘿" => "o",
     "噀" => "o",
     "噁" => "o",
     "噂" => "o",
     "噅" => "o",
     "噆" => "o",
     "噈" => "o",
     "噉" => "o",
     "噊" => "o",
     "噌" => "o",
     "噎" => "o",
     "噓" => "o",
     "噗" => "o",
     "噘" => "o",
     "噙" => "o",
     "噚" => "o",
     "噞" => "o",
     "噠" => "o",
     "噢" => "o",
     "噣" => "o",
     "噤" => "o",
     "噥" => "o",
     "噦" => "o",
     "器" => "o",
     "噪" => "o",
     "噫" => "o",
     "噬" => "o",
     "噭" => "o",
     "噮" => "o",
     "噯" => "o",
     "噰" => "o",
     "噱" => "o",
     "噲" => "o",
     "噳" => "o",
     "噴" => "o",
     "噶" => "o",
     "噷" => "o",
     "噸" => "o",
     "噹" => "o",
     "噾" => "o",
     "噿" => "o",
     "嚀" => "o",
     "嚁" => "o",
     "嚂" => "o",
     "嚃" => "o",
     "嚄" => "o",
     "嚅" => "o",
     "嚆" => "o",
     "嚇" => "o",
     "嚌" => "o",
     "嚍" => "o",
     "嚎" => "o",
     "嚏" => "o",
     "嚐" => "o",
     "嚓" => "o",
     "嚕" => "o",
     "嚗" => "o",
     "嚘" => "o",
     "嚙" => "o",
     "嚚" => "o",
     "嚜" => "o",
     "嚝" => "o",
     "嚥" => "o",
     "嚦" => "o",
     "嚧" => "o",
     "嚨" => "o",
     "嚪" => "o",
     "嚫" => "o",
     "嚬" => "o",
     "嚵" => "o",
     "嚶" => "o",
     "嚷" => "o",
     "嚼" => "o",
     "嚽" => "o",
     "嚾" => "o",
     "囀" => "o",
     "囁" => "o",
     "囂" => "o",
     "囃" => "o",
     "囅" => "o",
     "囆" => "o",
     "囈" => "o",
     "囉" => "o",
     "囋" => "o",
     "囌" => "o",
     "囑" => "o",
     "囓" => "o",
     "囔" => "o",
     "囗" => "o",
     "囚" => "o",
     "囝" => "o",
     "回" => "o",
     "因" => "o",
     "囡" => "o",
     "囤" => "o",
     "囥" => "o",
     "囧" => "o",
     "囫" => "o",
     "囮" => "o",
     "困" => "o",
     "囷" => "o",
     "囹" => "o",
     "固" => "o",
     "囿" => "o",
     "圁" => "o",
     "圂" => "o",
     "圃" => "o",
     "圄" => "o",
     "圇" => "o",
     "圈" => "o",
     "圉" => "o",
     "圊" => "o",
     "國" => "o",
     "圌" => "o",
     "圍" => "o",
     "園" => "o",
     "圓" => "o",
     "圔" => "o",
     "圖" => "o",
     "團" => "o",
     "圚" => "o",
     "圛" => "o",
     "圜" => "o",
     "圞" => "o",
     "堊" => "o",
     "嵒" => "o",
     "巳" => "o",
     "恩" => "o",
     "愍" => "o",
     "慁" => "o",
     "戢" => "o",
     "敃" => "o",
     "敯" => "o",
     "斝" => "o",
     "斲" => "o",
     "暋" => "o",
     "欭" => "o",
     "毋" => "o",
     "毌" => "o",
     "母" => "o",
     "氉" => "o",
     "民" => "o",
     "異" => "o",
     "睯" => "o",
     "碞" => "o",
     "籲" => "o",
     "聽" => "o",
     "肙" => "o",
     "葉" => "o",
     "號" => "o",
     "蝁" => "o",
     "貫" => "o",
     "足" => "o",
     "趴" => "o",
     "趵" => "o",
     "趶" => "o",
     "趷" => "o",
     "趹" => "o",
     "趺" => "o",
     "趼" => "o",
     "趾" => "o",
     "趿" => "o",
     "跁" => "o",
     "跂" => "o",
     "跅" => "o",
     "跆" => "o",
     "跇" => "o",
     "跈" => "o",
     "跋" => "o",
     "跌" => "o",
     "跍" => "o",
     "跎" => "o",
     "跏" => "o",
     "跐" => "o",
     "跑" => "o",
     "跓" => "o",
     "跕" => "o",
     "跖" => "o",
     "跗" => "o",
     "跘" => "o",
     "跙" => "o",
     "跚" => "o",
     "跛" => "o",
     "跜" => "o",
     "距" => "o",
     "跟" => "o",
     "跠" => "o",
     "跢" => "o",
     "跣" => "o",
     "跤" => "o",
     "跦" => "o",
     "跧" => "o",
     "跨" => "o",
     "跩" => "o",
     "跪" => "o",
     "跬" => "o",
     "跮" => "o",
     "跰" => "o",
     "跱" => "o",
     "跲" => "o",
     "跳" => "o",
     "跴" => "o",
     "跺" => "o",
     "跼" => "o",
     "跽" => "o",
     "跿" => "o",
     "踀" => "o",
     "踂" => "o",
     "踃" => "o",
     "踄" => "o",
     "踆" => "o",
     "踇" => "o",
     "踉" => "o",
     "踊" => "o",
     "踍" => "o",
     "踏" => "o",
     "踐" => "o",
     "踑" => "o",
     "踒" => "o",
     "踓" => "o",
     "踔" => "o",
     "踕" => "o",
     "踖" => "o",
     "踗" => "o",
     "踘" => "o",
     "踙" => "o",
     "踚" => "o",
     "踛" => "o",
     "踜" => "o",
     "踝" => "o",
     "踞" => "o",
     "踟" => "o",
     "踠" => "o",
     "踡" => "o",
     "踢" => "o",
     "踣" => "o",
     "踤" => "o",
     "踥" => "o",
     "踦" => "o",
     "踧" => "o",
     "踩" => "o",
     "踫" => "o",
     "踮" => "o",
     "踰" => "o",
     "踱" => "o",
     "踳" => "o",
     "踴" => "o",
     "踵" => "o",
     "踶" => "o",
     "踸" => "o",
     "踹" => "o",
     "踼" => "o",
     "踽" => "o",
     "踾" => "o",
     "踿" => "o",
     "蹀" => "o",
     "蹁" => "o",
     "蹂" => "o",
     "蹄" => "o",
     "蹅" => "o",
     "蹈" => "o",
     "蹉" => "o",
     "蹊" => "o",
     "蹋" => "o",
     "蹌" => "o",
     "蹍" => "o",
     "蹎" => "o",
     "蹐" => "o",
     "蹓" => "o",
     "蹕" => "o",
     "蹖" => "o",
     "蹗" => "o",
     "蹚" => "o",
     "蹛" => "o",
     "蹜" => "o",
     "蹝" => "o",
     "蹞" => "o",
     "蹟" => "o",
     "蹠" => "o",
     "蹡" => "o",
     "蹢" => "o",
     "蹣" => "o",
     "蹤" => "o",
     "蹥" => "o",
     "蹦" => "o",
     "蹧" => "o",
     "蹪" => "o",
     "蹬" => "o",
     "蹭" => "o",
     "蹯" => "o",
     "蹲" => "o",
     "蹳" => "o",
     "蹴" => "o",
     "蹶" => "o",
     "蹸" => "o",
     "蹺" => "o",
     "蹻" => "o",
     "蹼" => "o",
     "躁" => "o",
     "躂" => "o",
     "躅" => "o",
     "躆" => "o",
     "躇" => "o",
     "躈" => "o",
     "躊" => "o",
     "躋" => "o",
     "躌" => "o",
     "躍" => "o",
     "躎" => "o",
     "躐" => "o",
     "躑" => "o",
     "躒" => "o",
     "躓" => "o",
     "躔" => "o",
     "躕" => "o",
     "躖" => "o",
     "躘" => "o",
     "躚" => "o",
     "躝" => "o",
     "躞" => "o",
     "躟" => "o",
     "躡" => "o",
     "躣" => "o",
     "躤" => "o",
     "躥" => "o",
     "躦" => "o",
     "躨" => "o",
     "躩" => "o",
     "躪" => "o",
     "辴" => "o",
     "迴" => "o",
     "逞" => "o",
     "遐" => "o",
     "遻" => "o",
     "邑" => "o",
     "郘" => "o",
     "郢" => "o",
     "鄂" => "o",
     "鄖" => "o",
     "鄙" => "o",
     "鄲" => "o",
     "鄵" => "o",
     "雖" => "o",
     "響" => "o",
     "顎" => "o",
     "饕" => "o",
     "鳴" => "o",
     "鴞" => "o",
     "鵑" => "o",
     "鶚" => "o",
     "鷕" => "o",
     "鷤" => "o",
     "鼉" => "o",
     "么" => "p",
     "什" => "p",
     "仁" => "p",
     "仂" => "p",
     "仃" => "p",
     "仆" => "p",
     "仇" => "p",
     "仈" => "p",
     "仉" => "p",
     "仍" => "p",
     "仔" => "p",
     "仕" => "p",
     "他" => "p",
     "仗" => "p",
     "付" => "p",
     "仙" => "p",
     "仜" => "p",
     "仞" => "p",
     "仟" => "p",
     "仡" => "p",
     "代" => "p",
     "仨" => "p",
     "仩" => "p",
     "仰" => "p",
     "仱" => "p",
     "仲" => "p",
     "仳" => "p",
     "仴" => "p",
     "仵" => "p",
     "件" => "p",
     "价" => "p",
     "任" => "p",
     "份" => "p",
     "仿" => "p",
     "伀" => "p",
     "伂" => "p",
     "伄" => "p",
     "伅" => "p",
     "伈" => "p",
     "伉" => "p",
     "伊" => "p",
     "伋" => "p",
     "伍" => "p",
     "伎" => "p",
     "伏" => "p",
     "伐" => "p",
     "休" => "p",
     "伒" => "p",
     "伓" => "p",
     "伔" => "p",
     "伕" => "p",
     "优" => "p",
     "伙" => "p",
     "伝" => "p",
     "伢" => "p",
     "伬" => "p",
     "伭" => "p",
     "伯" => "p",
     "估" => "p",
     "伳" => "p",
     "伴" => "p",
     "伶" => "p",
     "伸" => "p",
     "伺" => "p",
     "伻" => "p",
     "似" => "p",
     "伽" => "p",
     "伾" => "p",
     "伿" => "p",
     "佁" => "p",
     "佃" => "p",
     "但" => "p",
     "佇" => "p",
     "佈" => "p",
     "佉" => "p",
     "佌" => "p",
     "位" => "p",
     "低" => "p",
     "住" => "p",
     "佐" => "p",
     "佑" => "p",
     "佒" => "p",
     "体" => "p",
     "佔" => "p",
     "何" => "p",
     "佖" => "p",
     "佗" => "p",
     "佚" => "p",
     "佛" => "p",
     "作" => "p",
     "佝" => "p",
     "佞" => "p",
     "佟" => "p",
     "你" => "p",
     "佡" => "p",
     "佢" => "p",
     "佣" => "p",
     "佤" => "p",
     "佧" => "p",
     "佩" => "p",
     "佪" => "p",
     "佫" => "p",
     "佬" => "p",
     "佮" => "p",
     "佯" => "p",
     "佰" => "p",
     "佴" => "p",
     "併" => "p",
     "佶" => "p",
     "佷" => "p",
     "佸" => "p",
     "佹" => "p",
     "佺" => "p",
     "佻" => "p",
     "佼" => "p",
     "佽" => "p",
     "佾" => "p",
     "使" => "p",
     "侀" => "p",
     "侁" => "p",
     "侂" => "p",
     "侃" => "p",
     "侄" => "p",
     "侅" => "p",
     "侇" => "p",
     "侈" => "p",
     "侉" => "p",
     "例" => "p",
     "侍" => "p",
     "侏" => "p",
     "侐" => "p",
     "侑" => "p",
     "侒" => "p",
     "侔" => "p",
     "侕" => "p",
     "侗" => "p",
     "侘" => "p",
     "侚" => "p",
     "供" => "p",
     "侜" => "p",
     "依" => "p",
     "侞" => "p",
     "侮" => "p",
     "侲" => "p",
     "侳" => "p",
     "侵" => "p",
     "侶" => "p",
     "侷" => "p",
     "侹" => "p",
     "侺" => "p",
     "侻" => "p",
     "便" => "p",
     "俀" => "p",
     "俁" => "p",
     "係" => "p",
     "促" => "p",
     "俄" => "p",
     "俅" => "p",
     "俇" => "p",
     "俉" => "p",
     "俊" => "p",
     "俋" => "p",
     "俍" => "p",
     "俏" => "p",
     "俐" => "p",
     "俑" => "p",
     "俓" => "p",
     "俔" => "p",
     "俖" => "p",
     "俗" => "p",
     "俘" => "p",
     "俙" => "p",
     "俚" => "p",
     "俛" => "p",
     "俜" => "p",
     "保" => "p",
     "俟" => "p",
     "俠" => "p",
     "信" => "p",
     "俬" => "p",
     "修" => "p",
     "俯" => "p",
     "俱" => "p",
     "俳" => "p",
     "俴" => "p",
     "俵" => "p",
     "俶" => "p",
     "俷" => "p",
     "俸" => "p",
     "俺" => "p",
     "俾" => "p",
     "倀" => "p",
     "倅" => "p",
     "倆" => "p",
     "倇" => "p",
     "倌" => "p",
     "倍" => "p",
     "倎" => "p",
     "倏" => "p",
     "們" => "p",
     "倒" => "p",
     "倓" => "p",
     "倔" => "p",
     "倕" => "p",
     "倖" => "p",
     "倗" => "p",
     "倘" => "p",
     "候" => "p",
     "倚" => "p",
     "倛" => "p",
     "倜" => "p",
     "倞" => "p",
     "借" => "p",
     "倠" => "p",
     "倡" => "p",
     "倢" => "p",
     "倣" => "p",
     "倥" => "p",
     "倦" => "p",
     "倧" => "p",
     "倨" => "p",
     "倩" => "p",
     "倪" => "p",
     "倫" => "p",
     "倬" => "p",
     "倭" => "p",
     "倯" => "p",
     "倰" => "p",
     "倱" => "p",
     "倳" => "p",
     "倵" => "p",
     "倷" => "p",
     "值" => "p",
     "偀" => "p",
     "偁" => "p",
     "偃" => "p",
     "偅" => "p",
     "偆" => "p",
     "假" => "p",
     "偈" => "p",
     "偉" => "p",
     "偊" => "p",
     "偋" => "p",
     "偌" => "p",
     "偍" => "p",
     "偎" => "p",
     "偏" => "p",
     "偑" => "p",
     "偓" => "p",
     "偕" => "p",
     "偗" => "p",
     "做" => "p",
     "偛" => "p",
     "停" => "p",
     "偝" => "p",
     "偞" => "p",
     "偟" => "p",
     "偠" => "p",
     "偡" => "p",
     "偢" => "p",
     "偣" => "p",
     "偤" => "p",
     "健" => "p",
     "偨" => "p",
     "偩" => "p",
     "偪" => "p",
     "偫" => "p",
     "偭" => "p",
     "偮" => "p",
     "偯" => "p",
     "偰" => "p",
     "偲" => "p",
     "偳" => "p",
     "側" => "p",
     "偵" => "p",
     "偶" => "p",
     "偷" => "p",
     "偺" => "p",
     "偽" => "p",
     "傀" => "p",
     "傂" => "p",
     "傃" => "p",
     "傅" => "p",
     "傇" => "p",
     "傋" => "p",
     "傌" => "p",
     "傍" => "p",
     "傎" => "p",
     "傑" => "p",
     "傒" => "p",
     "傔" => "p",
     "傕" => "p",
     "傖" => "p",
     "備" => "p",
     "傚" => "p",
     "傛" => "p",
     "傜" => "p",
     "傝" => "p",
     "傞" => "p",
     "傢" => "p",
     "傣" => "p",
     "催" => "p",
     "傭" => "p",
     "傮" => "p",
     "傯" => "p",
     "傰" => "p",
     "傱" => "p",
     "傲" => "p",
     "傳" => "p",
     "傴" => "p",
     "傶" => "p",
     "傷" => "p",
     "傸" => "p",
     "傺" => "p",
     "傻" => "p",
     "傽" => "p",
     "傾" => "p",
     "傿" => "p",
     "僁" => "p",
     "僂" => "p",
     "僄" => "p",
     "僅" => "p",
     "僆" => "p",
     "僇" => "p",
     "僈" => "p",
     "僊" => "p",
     "僋" => "p",
     "僎" => "p",
     "像" => "p",
     "僑" => "p",
     "僓" => "p",
     "僔" => "p",
     "僕" => "p",
     "僖" => "p",
     "僗" => "p",
     "僚" => "p",
     "僛" => "p",
     "僝" => "p",
     "僠" => "p",
     "僣" => "p",
     "僤" => "p",
     "僥" => "p",
     "僦" => "p",
     "僧" => "p",
     "僨" => "p",
     "僩" => "p",
     "僪" => "p",
     "僬" => "p",
     "僭" => "p",
     "僮" => "p",
     "僯" => "p",
     "僱" => "p",
     "僳" => "p",
     "僵" => "p",
     "僶" => "p",
     "僸" => "p",
     "價" => "p",
     "僻" => "p",
     "僽" => "p",
     "僾" => "p",
     "僿" => "p",
     "儀" => "p",
     "儂" => "p",
     "儃" => "p",
     "億" => "p",
     "儅" => "p",
     "儆" => "p",
     "儇" => "p",
     "儈" => "p",
     "儉" => "p",
     "儊" => "p",
     "儋" => "p",
     "儌" => "p",
     "儐" => "p",
     "儑" => "p",
     "儒" => "p",
     "儓" => "p",
     "儔" => "p",
     "儕" => "p",
     "儗" => "p",
     "儘" => "p",
     "儚" => "p",
     "儜" => "p",
     "償" => "p",
     "儠" => "p",
     "儡" => "p",
     "儢" => "p",
     "儤" => "p",
     "儥" => "p",
     "儦" => "p",
     "儩" => "p",
     "優" => "p",
     "儭" => "p",
     "儮" => "p",
     "儰" => "p",
     "儱" => "p",
     "儲" => "p",
     "儳" => "p",
     "儴" => "p",
     "儵" => "p",
     "儷" => "p",
     "儸" => "p",
     "儹" => "p",
     "儺" => "p",
     "儻" => "p",
     "儼" => "p",
     "儽" => "p",
     "冬" => "p",
     "凡" => "p",
     "到" => "p",
     "劓" => "p",
     "化" => "p",
     "卑" => "p",
     "卜" => "p",
     "卹" => "p",
     "及" => "p",
     "各" => "p",
     "向" => "p",
     "咎" => "p",
     "囟" => "p",
     "囪" => "p",
     "堡" => "p",
     "夆" => "p",
     "姇" => "p",
     "岱" => "p",
     "峊" => "p",
     "嶴" => "p",
     "帛" => "p",
     "帥" => "p",
     "師" => "p",
     "平" => "p",
     "延" => "p",
     "怤" => "p",
     "怹" => "p",
     "恁" => "p",
     "息" => "p",
     "悠" => "p",
     "您" => "p",
     "憊" => "p",
     "攸" => "p",
     "昝" => "p",
     "柋" => "p",
     "栠" => "p",
     "條" => "p",
     "歸" => "p",
     "泉" => "p",
     "灥" => "p",
     "烋" => "p",
     "焂" => "p",
     "煲" => "p",
     "片" => "p",
     "版" => "p",
     "牉" => "p",
     "牊" => "p",
     "牋" => "p",
     "牌" => "p",
     "牏" => "p",
     "牒" => "p",
     "牓" => "p",
     "牖" => "p",
     "牘" => "p",
     "牮" => "p",
     "甈" => "p",
     "甪" => "p",
     "白" => "p",
     "癿" => "p",
     "皁" => "p",
     "皂" => "p",
     "皇" => "p",
     "皈" => "p",
     "皉" => "p",
     "皊" => "p",
     "皋" => "p",
     "皎" => "p",
     "皏" => "p",
     "皒" => "p",
     "皓" => "p",
     "皖" => "p",
     "皚" => "p",
     "皛" => "p",
     "皜" => "p",
     "皝" => "p",
     "皞" => "p",
     "皤" => "p",
     "皦" => "p",
     "皪" => "p",
     "皫" => "p",
     "皭" => "p",
     "皮" => "p",
     "皯" => "p",
     "皰" => "p",
     "睾" => "p",
     "禹" => "p",
     "粵" => "p",
     "絛" => "p",
     "綿" => "p",
     "翛" => "p",
     "翱" => "p",
     "胤" => "p",
     "脩" => "p",
     "自" => "p",
     "臬" => "p",
     "臭" => "p",
     "臮" => "p",
     "臲" => "p",
     "至" => "p",
     "致" => "p",
     "臸" => "p",
     "臹" => "p",
     "臻" => "p",
     "興" => "p",
     "處" => "p",
     "蛗" => "p",
     "蜑" => "p",
     "螽" => "p",
     "血" => "p",
     "衃" => "p",
     "衄" => "p",
     "衈" => "p",
     "衊" => "p",
     "袋" => "p",
     "譥" => "p",
     "貨" => "p",
     "賃" => "p",
     "跾" => "p",
     "迫" => "p",
     "追" => "p",
     "逄" => "p",
     "逢" => "p",
     "遑" => "p",
     "邀" => "p",
     "邍" => "p",
     "郅" => "p",
     "郋" => "p",
     "郔" => "p",
     "郫" => "p",
     "鄅" => "p",
     "鄇" => "p",
     "鄎" => "p",
     "釁" => "p",
     "鎥" => "p",
     "阜" => "p",
     "鞗" => "p",
     "頗" => "p",
     "頧" => "p",
     "顊" => "p",
     "體" => "p",
     "鬼" => "p",
     "鬾" => "p",
     "鬿" => "p",
     "魁" => "p",
     "魃" => "p",
     "魄" => "p",
     "魅" => "p",
     "魆" => "p",
     "魈" => "p",
     "魊" => "p",
     "魋" => "p",
     "魌" => "p",
     "魍" => "p",
     "魎" => "p",
     "魑" => "p",
     "魒" => "p",
     "魕" => "p",
     "魖" => "p",
     "鯈" => "p",
     "鳪" => "p",
     "鴭" => "p",
     "鵀" => "p",
     "鵂" => "p",
     "鵅" => "p",
     "鵖" => "p",
     "鵯" => "p",
     "鷍" => "p",
     "鷎" => "p",
     "鸄" => "p",
     "黛" => "p",
     "鼻" => "p",
     "鼽" => "p",
     "鼾" => "p",
     "齀" => "p",
     "齁" => "p",
     "齂" => "p",
     "齃" => "p",
     "齆" => "p",
     "齇" => "p",
     "齈" => "p",
     "齉" => "p",
     "丈" => "q",
     "剺" => "q",
     "卓" => "q",
     "咼" => "q",
     "堯" => "q",
     "墅" => "q",
     "墨" => "q",
     "壘" => "q",
     "壨" => "q",
     "夥" => "q",
     "夫" => "q",
     "嫠" => "q",
     "嫢" => "q",
     "嬲" => "q",
     "孷" => "q",
     "峱" => "q",
     "弓" => "q",
     "弔" => "q",
     "引" => "q",
     "弘" => "q",
     "弛" => "q",
     "弝" => "q",
     "弢" => "q",
     "弣" => "q",
     "弤" => "q",
     "弦" => "q",
     "弧" => "q",
     "弨" => "q",
     "弭" => "q",
     "弰" => "q",
     "弱" => "q",
     "弳" => "q",
     "張" => "q",
     "弶" => "q",
     "強" => "q",
     "弸" => "q",
     "弼" => "q",
     "彃" => "q",
     "彄" => "q",
     "彈" => "q",
     "彉" => "q",
     "彊" => "q",
     "彋" => "q",
     "彌" => "q",
     "彏" => "q",
     "思" => "q",
     "悐" => "q",
     "悲" => "q",
     "愚" => "q",
     "敤" => "q",
     "斄" => "q",
     "替" => "q",
     "未" => "q",
     "末" => "q",
     "果" => "q",
     "槼" => "q",
     "櫐" => "q",
     "毗" => "q",
     "毘" => "q",
     "氂" => "q",
     "漦" => "q",
     "燅" => "q",
     "犛" => "q",
     "犯" => "q",
     "犰" => "q",
     "犴" => "q",
     "犵" => "q",
     "犺" => "q",
     "犽" => "q",
     "犿" => "q",
     "狁" => "q",
     "狂" => "q",
     "狃" => "q",
     "狄" => "q",
     "狅" => "q",
     "狆" => "q",
     "狉" => "q",
     "狋" => "q",
     "狌" => "q",
     "狎" => "q",
     "狐" => "q",
     "狑" => "q",
     "狒" => "q",
     "狔" => "q",
     "狖" => "q",
     "狗" => "q",
     "狘" => "q",
     "狙" => "q",
     "狚" => "q",
     "狜" => "q",
     "狟" => "q",
     "狠" => "q",
     "狡" => "q",
     "狣" => "q",
     "狤" => "q",
     "狦" => "q",
     "狨" => "q",
     "狩" => "q",
     "狪" => "q",
     "狫" => "q",
     "狳" => "q",
     "狴" => "q",
     "狶" => "q",
     "狷" => "q",
     "狸" => "q",
     "狺" => "q",
     "狻" => "q",
     "狼" => "q",
     "狽" => "q",
     "狾" => "q",
     "狿" => "q",
     "猀" => "q",
     "猁" => "q",
     "猇" => "q",
     "猈" => "q",
     "猊" => "q",
     "猏" => "q",
     "猑" => "q",
     "猓" => "q",
     "猖" => "q",
     "猗" => "q",
     "猘" => "q",
     "猙" => "q",
     "猛" => "q",
     "猜" => "q",
     "猝" => "q",
     "猞" => "q",
     "猢" => "q",
     "猣" => "q",
     "猥" => "q",
     "猦" => "q",
     "猧" => "q",
     "猩" => "q",
     "猭" => "q",
     "猰" => "q",
     "猱" => "q",
     "猲" => "q",
     "猳" => "q",
     "猴" => "q",
     "猵" => "q",
     "猶" => "q",
     "猺" => "q",
     "猻" => "q",
     "猼" => "q",
     "猾" => "q",
     "猿" => "q",
     "獀" => "q",
     "獂" => "q",
     "獄" => "q",
     "獅" => "q",
     "獉" => "q",
     "獊" => "q",
     "獌" => "q",
     "獍" => "q",
     "獐" => "q",
     "獑" => "q",
     "獗" => "q",
     "獙" => "q",
     "獚" => "q",
     "獛" => "q",
     "獝" => "q",
     "獞" => "q",
     "獟" => "q",
     "獠" => "q",
     "獡" => "q",
     "獢" => "q",
     "獥" => "q",
     "獦" => "q",
     "獧" => "q",
     "獨" => "q",
     "獩" => "q",
     "獪" => "q",
     "獫" => "q",
     "獬" => "q",
     "獮" => "q",
     "獯" => "q",
     "獰" => "q",
     "獲" => "q",
     "獳" => "q",
     "獵" => "q",
     "獶" => "q",
     "獷" => "q",
     "獺" => "q",
     "獼" => "q",
     "獽" => "q",
     "獾" => "q",
     "獿" => "q",
     "玀" => "q",
     "玁" => "q",
     "玂" => "q",
     "玃" => "q",
     "瓕" => "q",
     "田" => "q",
     "甲" => "q",
     "男" => "q",
     "町" => "q",
     "甽" => "q",
     "甿" => "q",
     "畀" => "q",
     "畇" => "q",
     "畈" => "q",
     "畋" => "q",
     "界" => "q",
     "畎" => "q",
     "畏" => "q",
     "畔" => "q",
     "畛" => "q",
     "畟" => "q",
     "畤" => "q",
     "略" => "q",
     "畦" => "q",
     "畯" => "q",
     "畷" => "q",
     "畸" => "q",
     "畹" => "q",
     "畽" => "q",
     "畾" => "q",
     "疄" => "q",
     "疆" => "q",
     "疇" => "q",
     "疊" => "q",
     "盄" => "q",
     "礨" => "q",
     "禺" => "q",
     "粥" => "q",
     "累" => "q",
     "繳" => "q",
     "纍" => "q",
     "罍" => "q",
     "翹" => "q",
     "胃" => "q",
     "蒙" => "q",
     "褁" => "q",
     "規" => "q",
     "謽" => "q",
     "輦" => "q",
     "逖" => "q",
     "逛" => "q",
     "逴" => "q",
     "遇" => "q",
     "邞" => "q",
     "鄻" => "q",
     "里" => "q",
     "野" => "q",
     "釐" => "q",
     "顆" => "q",
     "顒" => "q",
     "顝" => "q",
     "骨" => "q",
     "骫" => "q",
     "骭" => "q",
     "骯" => "q",
     "骰" => "q",
     "骱" => "q",
     "骳" => "q",
     "骴" => "q",
     "骷" => "q",
     "骸" => "q",
     "骹" => "q",
     "骻" => "q",
     "骼" => "q",
     "骾" => "q",
     "骿" => "q",
     "髀" => "q",
     "髁" => "q",
     "髂" => "q",
     "髆" => "q",
     "髇" => "q",
     "髊" => "q",
     "髍" => "q",
     "髏" => "q",
     "髐" => "q",
     "髑" => "q",
     "髒" => "q",
     "髓" => "q",
     "髕" => "q",
     "髖" => "q",
     "鬻" => "q",
     "鳺" => "q",
     "鴨" => "q",
     "鵟" => "q",
     "鵫" => "q",
     "鶸" => "q",
     "鶻" => "q",
     "鶼" => "q",
     "鷝" => "q",
     "鸑" => "q",
     "鸓" => "q",
     "黑" => "q",
     "黓" => "q",
     "黔" => "q",
     "黕" => "q",
     "黖" => "q",
     "默" => "q",
     "黚" => "q",
     "黜" => "q",
     "黝" => "q",
     "黟" => "q",
     "黠" => "q",
     "黤" => "q",
     "黥" => "q",
     "黦" => "q",
     "黫" => "q",
     "黭" => "q",
     "黮" => "q",
     "黯" => "q",
     "黰" => "q",
     "黲" => "q",
     "黵" => "q",
     "黷" => "q",
     "乃" => "r",
     "二" => "r",
     "亍" => "r",
     "亓" => "r",
     "儿" => "r",
     "元" => "r",
     "兆" => "r",
     "共" => "r",
     "几" => "r",
     "凰" => "r",
     "凸" => "r",
     "刓" => "r",
     "刵" => "r",
     "剁" => "r",
     "剒" => "r",
     "剕" => "r",
     "勒" => "r",
     "募" => "r",
     "勤" => "r",
     "勱" => "r",
     "勸" => "r",
     "取" => "r",
     "堅" => "r",
     "堇" => "r",
     "墓" => "r",
     "夃" => "r",
     "夙" => "r",
     "夢" => "r",
     "奜" => "r",
     "娶" => "r",
     "婓" => "r",
     "婜" => "r",
     "媐" => "r",
     "孕" => "r",
     "孽" => "r",
     "尕" => "r",
     "幕" => "r",
     "廾" => "r",
     "廿" => "r",
     "恥" => "r",
     "恧" => "r",
     "恭" => "r",
     "惹" => "r",
     "慕" => "r",
     "懃" => "r",
     "戁" => "r",
     "戤" => "r",
     "拲" => "r",
     "掔" => "r",
     "摹" => "r",
     "散" => "r",
     "斐" => "r",
     "斮" => "r",
     "斳" => "r",
     "昔" => "r",
     "暮" => "r",
     "曹" => "r",
     "朢" => "r",
     "朵" => "r",
     "棐" => "r",
     "棸" => "r",
     "棻" => "r",
     "歎" => "r",
     "歡" => "r",
     "殳" => "r",
     "毦" => "r",
     "氋" => "r",
     "焣" => "r",
     "熙" => "r",
     "燕" => "r",
     "爇" => "r",
     "甍" => "r",
     "皵" => "r",
     "盈" => "r",
     "監" => "r",
     "盬" => "r",
     "瞢" => "r",
     "硻" => "r",
     "示" => "r",
     "礽" => "r",
     "社" => "r",
     "礿" => "r",
     "祀" => "r",
     "祁" => "r",
     "祂" => "r",
     "祄" => "r",
     "祅" => "r",
     "祆" => "r",
     "祇" => "r",
     "祈" => "r",
     "祉" => "r",
     "祊" => "r",
     "祋" => "r",
     "祌" => "r",
     "祏" => "r",
     "祐" => "r",
     "祑" => "r",
     "祒" => "r",
     "祓" => "r",
     "祔" => "r",
     "祕" => "r",
     "祖" => "r",
     "祗" => "r",
     "祚" => "r",
     "祛" => "r",
     "祜" => "r",
     "祝" => "r",
     "神" => "r",
     "祠" => "r",
     "祣" => "r",
     "祤" => "r",
     "祥" => "r",
     "祧" => "r",
     "祩" => "r",
     "祪" => "r",
     "祫" => "r",
     "祰" => "r",
     "祲" => "r",
     "祳" => "r",
     "祴" => "r",
     "祹" => "r",
     "祺" => "r",
     "祼" => "r",
     "祽" => "r",
     "祿" => "r",
     "禂" => "r",
     "禈" => "r",
     "禊" => "r",
     "禋" => "r",
     "禎" => "r",
     "福" => "r",
     "禐" => "r",
     "禒" => "r",
     "禓" => "r",
     "禔" => "r",
     "禕" => "r",
     "禖" => "r",
     "禗" => "r",
     "禘" => "r",
     "禚" => "r",
     "禛" => "r",
     "禠" => "r",
     "禡" => "r",
     "禢" => "r",
     "禤" => "r",
     "禧" => "r",
     "禨" => "r",
     "禪" => "r",
     "禫" => "r",
     "禬" => "r",
     "禭" => "r",
     "禮" => "r",
     "禰" => "r",
     "禱" => "r",
     "禲" => "r",
     "禳" => "r",
     "禴" => "r",
     "禶" => "r",
     "禷" => "r",
     "節" => "r",
     "緊" => "r",
     "繭" => "r",
     "翡" => "r",
     "考" => "r",
     "而" => "r",
     "耍" => "r",
     "耎" => "r",
     "耏" => "r",
     "耐" => "r",
     "耳" => "r",
     "耴" => "r",
     "耵" => "r",
     "耶" => "r",
     "耹" => "r",
     "耽" => "r",
     "耾" => "r",
     "耿" => "r",
     "聃" => "r",
     "聆" => "r",
     "聇" => "r",
     "聈" => "r",
     "聊" => "r",
     "聏" => "r",
     "聐" => "r",
     "聑" => "r",
     "聒" => "r",
     "聖" => "r",
     "聘" => "r",
     "聚" => "r",
     "聜" => "r",
     "聝" => "r",
     "聤" => "r",
     "聧" => "r",
     "聬" => "r",
     "聯" => "r",
     "聰" => "r",
     "聵" => "r",
     "聶" => "r",
     "職" => "r",
     "聸" => "r",
     "聹" => "r",
     "腎" => "r",
     "臡" => "r",
     "臣" => "r",
     "臥" => "r",
     "臨" => "r",
     "艱" => "r",
     "艼" => "r",
     "艽" => "r",
     "艾" => "r",
     "艿" => "r",
     "芀" => "r",
     "芃" => "r",
     "芄" => "r",
     "芅" => "r",
     "芊" => "r",
     "芋" => "r",
     "芍" => "r",
     "芎" => "r",
     "芏" => "r",
     "芐" => "r",
     "芑" => "r",
     "芒" => "r",
     "芓" => "r",
     "芘" => "r",
     "芙" => "r",
     "芚" => "r",
     "芛" => "r",
     "芝" => "r",
     "芞" => "r",
     "芟" => "r",
     "芠" => "r",
     "芡" => "r",
     "芢" => "r",
     "芣" => "r",
     "芤" => "r",
     "芥" => "r",
     "芧" => "r",
     "芨" => "r",
     "芩" => "r",
     "芫" => "r",
     "芬" => "r",
     "芭" => "r",
     "芮" => "r",
     "芯" => "r",
     "芰" => "r",
     "花" => "r",
     "芳" => "r",
     "芴" => "r",
     "芵" => "r",
     "芶" => "r",
     "芷" => "r",
     "芸" => "r",
     "芹" => "r",
     "芺" => "r",
     "芼" => "r",
     "芽" => "r",
     "芾" => "r",
     "苀" => "r",
     "苂" => "r",
     "苃" => "r",
     "苑" => "r",
     "苒" => "r",
     "苓" => "r",
     "苔" => "r",
     "苕" => "r",
     "苖" => "r",
     "苗" => "r",
     "苙" => "r",
     "苛" => "r",
     "苜" => "r",
     "苞" => "r",
     "苟" => "r",
     "苠" => "r",
     "苡" => "r",
     "苣" => "r",
     "苤" => "r",
     "若" => "r",
     "苦" => "r",
     "苧" => "r",
     "苨" => "r",
     "苪" => "r",
     "苫" => "r",
     "苬" => "r",
     "苭" => "r",
     "苯" => "r",
     "苰" => "r",
     "英" => "r",
     "苲" => "r",
     "苳" => "r",
     "苴" => "r",
     "苵" => "r",
     "苶" => "r",
     "苹" => "r",
     "苺" => "r",
     "苻" => "r",
     "苾" => "r",
     "茀" => "r",
     "茁" => "r",
     "茂" => "r",
     "范" => "r",
     "茄" => "r",
     "茅" => "r",
     "茆" => "r",
     "茇" => "r",
     "茈" => "r",
     "茉" => "r",
     "茌" => "r",
     "茍" => "r",
     "茖" => "r",
     "茗" => "r",
     "茙" => "r",
     "茛" => "r",
     "茜" => "r",
     "茞" => "r",
     "茠" => "r",
     "茢" => "r",
     "茤" => "r",
     "茥" => "r",
     "茦" => "r",
     "茧" => "r",
     "茨" => "r",
     "茩" => "r",
     "茪" => "r",
     "茫" => "r",
     "茬" => "r",
     "茭" => "r",
     "茯" => "r",
     "茱" => "r",
     "茳" => "r",
     "茴" => "r",
     "茵" => "r",
     "茶" => "r",
     "茷" => "r",
     "茸" => "r",
     "茹" => "r",
     "茺" => "r",
     "茼" => "r",
     "茿" => "r",
     "荀" => "r",
     "荁" => "r",
     "荂" => "r",
     "荃" => "r",
     "荄" => "r",
     "荅" => "r",
     "荇" => "r",
     "荈" => "r",
     "草" => "r",
     "荊" => "r",
     "荋" => "r",
     "荌" => "r",
     "荍" => "r",
     "荎" => "r",
     "荏" => "r",
     "荐" => "r",
     "荑" => "r",
     "荒" => "r",
     "荓" => "r",
     "荔" => "r",
     "荖" => "r",
     "荳" => "r",
     "荴" => "r",
     "荵" => "r",
     "荶" => "r",
     "荷" => "r",
     "荸" => "r",
     "荺" => "r",
     "荻" => "r",
     "荼" => "r",
     "荽" => "r",
     "荾" => "r",
     "荿" => "r",
     "莁" => "r",
     "莃" => "r",
     "莆" => "r",
     "莇" => "r",
     "莈" => "r",
     "莉" => "r",
     "莊" => "r",
     "莋" => "r",
     "莌" => "r",
     "莍" => "r",
     "莎" => "r",
     "莏" => "r",
     "莐" => "r",
     "莒" => "r",
     "莓" => "r",
     "莔" => "r",
     "莕" => "r",
     "莖" => "r",
     "莗" => "r",
     "莘" => "r",
     "莙" => "r",
     "莚" => "r",
     "莛" => "r",
     "莝" => "r",
     "莞" => "r",
     "莠" => "r",
     "莢" => "r",
     "莣" => "r",
     "莤" => "r",
     "莥" => "r",
     "莦" => "r",
     "莧" => "r",
     "莨" => "r",
     "莩" => "r",
     "莪" => "r",
     "莫" => "r",
     "莮" => "r",
     "莯" => "r",
     "莰" => "r",
     "莽" => "r",
     "莿" => "r",
     "菀" => "r",
     "菁" => "r",
     "菂" => "r",
     "菃" => "r",
     "菄" => "r",
     "菅" => "r",
     "菆" => "r",
     "菇" => "r",
     "菈" => "r",
     "菉" => "r",
     "菊" => "r",
     "菋" => "r",
     "菌" => "r",
     "菎" => "r",
     "菏" => "r",
     "菑" => "r",
     "菔" => "r",
     "菕" => "r",
     "菖" => "r",
     "菗" => "r",
     "菘" => "r",
     "菙" => "r",
     "菛" => "r",
     "菜" => "r",
     "菝" => "r",
     "菞" => "r",
     "菟" => "r",
     "菠" => "r",
     "菡" => "r",
     "菢" => "r",
     "菣" => "r",
     "菤" => "r",
     "菥" => "r",
     "菧" => "r",
     "菨" => "r",
     "菩" => "r",
     "菪" => "r",
     "菫" => "r",
     "菬" => "r",
     "菮" => "r",
     "菰" => "r",
     "菱" => "r",
     "菲" => "r",
     "菳" => "r",
     "菴" => "r",
     "菵" => "r",
     "菶" => "r",
     "菸" => "r",
     "菹" => "r",
     "菺" => "r",
     "菻" => "r",
     "菼" => "r",
     "菽" => "r",
     "菾" => "r",
     "菿" => "r",
     "萁" => "r",
     "萃" => "r",
     "萄" => "r",
     "萆" => "r",
     "萇" => "r",
     "萉" => "r",
     "萊" => "r",
     "萋" => "r",
     "萌" => "r",
     "萍" => "r",
     "萎" => "r",
     "萏" => "r",
     "萐" => "r",
     "萑" => "r",
     "萒" => "r",
     "萓" => "r",
     "萛" => "r",
     "萣" => "r",
     "萩" => "r",
     "萫" => "r",
     "萬" => "r",
     "萭" => "r",
     "萯" => "r",
     "萰" => "r",
     "萱" => "r",
     "萲" => "r",
     "萳" => "r",
     "萴" => "r",
     "萵" => "r",
     "萶" => "r",
     "萷" => "r",
     "萸" => "r",
     "萹" => "r",
     "萺" => "r",
     "萻" => "r",
     "萼" => "r",
     "落" => "r",
     "萿" => "r",
     "葀" => "r",
     "葂" => "r",
     "葃" => "r",
     "葄" => "r",
     "葅" => "r",
     "葆" => "r",
     "葇" => "r",
     "葋" => "r",
     "葌" => "r",
     "葍" => "r",
     "葎" => "r",
     "葐" => "r",
     "葑" => "r",
     "葒" => "r",
     "葔" => "r",
     "葖" => "r",
     "葙" => "r",
     "葚" => "r",
     "葛" => "r",
     "葝" => "r",
     "葞" => "r",
     "葟" => "r",
     "葠" => "r",
     "葡" => "r",
     "董" => "r",
     "葥" => "r",
     "葦" => "r",
     "葧" => "r",
     "葨" => "r",
     "葩" => "r",
     "葫" => "r",
     "葬" => "r",
     "葭" => "r",
     "葮" => "r",
     "葯" => "r",
     "葰" => "r",
     "葳" => "r",
     "葴" => "r",
     "葵" => "r",
     "葶" => "r",
     "葷" => "r",
     "葸" => "r",
     "葹" => "r",
     "葺" => "r",
     "葽" => "r",
     "葾" => "r",
     "蒂" => "r",
     "蒆" => "r",
     "蒍" => "r",
     "蒎" => "r",
     "蒏" => "r",
     "蒐" => "r",
     "蒑" => "r",
     "蒔" => "r",
     "蒗" => "r",
     "蒘" => "r",
     "蒚" => "r",
     "蒛" => "r",
     "蒜" => "r",
     "蒝" => "r",
     "蒞" => "r",
     "蒟" => "r",
     "蒠" => "r",
     "蒡" => "r",
     "蒢" => "r",
     "蒤" => "r",
     "蒧" => "r",
     "蒨" => "r",
     "蒩" => "r",
     "蒪" => "r",
     "蒫" => "r",
     "蒬" => "r",
     "蒮" => "r",
     "蒯" => "r",
     "蒰" => "r",
     "蒱" => "r",
     "蒲" => "r",
     "蒴" => "r",
     "蒶" => "r",
     "蒸" => "r",
     "蒹" => "r",
     "蒺" => "r",
     "蒻" => "r",
     "蒼" => "r",
     "蒿" => "r",
     "蓀" => "r",
     "蓁" => "r",
     "蓂" => "r",
     "蓄" => "r",
     "蓅" => "r",
     "蓆" => "r",
     "蓇" => "r",
     "蓉" => "r",
     "蓊" => "r",
     "蓌" => "r",
     "蓍" => "r",
     "蓎" => "r",
     "蓏" => "r",
     "蓐" => "r",
     "蓑" => "r",
     "蓒" => "r",
     "蓓" => "r",
     "蓔" => "r",
     "蓖" => "r",
     "蓗" => "r",
     "蓛" => "r",
     "蓧" => "r",
     "蓨" => "r",
     "蓩" => "r",
     "蓪" => "r",
     "蓫" => "r",
     "蓬" => "r",
     "蓮" => "r",
     "蓯" => "r",
     "蓰" => "r",
     "蓱" => "r",
     "蓲" => "r",
     "蓳" => "r",
     "蓴" => "r",
     "蓶" => "r",
     "蓷" => "r",
     "蓹" => "r",
     "蓺" => "r",
     "蓻" => "r",
     "蓼" => "r",
     "蓽" => "r",
     "蓾" => "r",
     "蓿" => "r",
     "蔀" => "r",
     "蔂" => "r",
     "蔆" => "r",
     "蔇" => "r",
     "蔈" => "r",
     "蔉" => "r",
     "蔊" => "r",
     "蔋" => "r",
     "蔌" => "r",
     "蔍" => "r",
     "蔎" => "r",
     "蔏" => "r",
     "蔑" => "r",
     "蔒" => "r",
     "蔓" => "r",
     "蔔" => "r",
     "蔕" => "r",
     "蔖" => "r",
     "蔗" => "r",
     "蔘" => "r",
     "蔙" => "r",
     "蔚" => "r",
     "蔜" => "r",
     "蔝" => "r",
     "蔞" => "r",
     "蔟" => "r",
     "蔠" => "r",
     "蔡" => "r",
     "蔣" => "r",
     "蔤" => "r",
     "蔥" => "r",
     "蔦" => "r",
     "蔧" => "r",
     "蔨" => "r",
     "蔩" => "r",
     "蔪" => "r",
     "蔫" => "r",
     "蔬" => "r",
     "蔭" => "r",
     "蔮" => "r",
     "蔯" => "r",
     "蔰" => "r",
     "蔱" => "r",
     "蔻" => "r",
     "蔽" => "r",
     "蔾" => "r",
     "蕀" => "r",
     "蕁" => "r",
     "蕃" => "r",
     "蕄" => "r",
     "蕅" => "r",
     "蕆" => "r",
     "蕇" => "r",
     "蕈" => "r",
     "蕉" => "r",
     "蕊" => "r",
     "蕍" => "r",
     "蕎" => "r",
     "蕑" => "r",
     "蕓" => "r",
     "蕔" => "r",
     "蕕" => "r",
     "蕖" => "r",
     "蕗" => "r",
     "蕘" => "r",
     "蕙" => "r",
     "蕛" => "r",
     "蕝" => "r",
     "蕞" => "r",
     "蕠" => "r",
     "蕡" => "r",
     "蕢" => "r",
     "蕣" => "r",
     "蕤" => "r",
     "蕥" => "r",
     "蕦" => "r",
     "蕧" => "r",
     "蕨" => "r",
     "蕩" => "r",
     "蕪" => "r",
     "蕫" => "r",
     "蕬" => "r",
     "蕭" => "r",
     "蕮" => "r",
     "蕱" => "r",
     "蕵" => "r",
     "蕶" => "r",
     "蕷" => "r",
     "蕸" => "r",
     "蕹" => "r",
     "蕺" => "r",
     "蕻" => "r",
     "蕼" => "r",
     "蕾" => "r",
     "薀" => "r",
     "薁" => "r",
     "薂" => "r",
     "薃" => "r",
     "薄" => "r",
     "薅" => "r",
     "薆" => "r",
     "薇" => "r",
     "薈" => "r",
     "薉" => "r",
     "薊" => "r",
     "薋" => "r",
     "薌" => "r",
     "薍" => "r",
     "薎" => "r",
     "薏" => "r",
     "薐" => "r",
     "薑" => "r",
     "薔" => "r",
     "薕" => "r",
     "薖" => "r",
     "薘" => "r",
     "薙" => "r",
     "薚" => "r",
     "薛" => "r",
     "薜" => "r",
     "薝" => "r",
     "薞" => "r",
     "薟" => "r",
     "薠" => "r",
     "薡" => "r",
     "薢" => "r",
     "薣" => "r",
     "薤" => "r",
     "薧" => "r",
     "薨" => "r",
     "薩" => "r",
     "薪" => "r",
     "薯" => "r",
     "薰" => "r",
     "薱" => "r",
     "薳" => "r",
     "薴" => "r",
     "薵" => "r",
     "薶" => "r",
     "薷" => "r",
     "薸" => "r",
     "薹" => "r",
     "薺" => "r",
     "薽" => "r",
     "薾" => "r",
     "薿" => "r",
     "藀" => "r",
     "藂" => "r",
     "藃" => "r",
     "藄" => "r",
     "藅" => "r",
     "藆" => "r",
     "藇" => "r",
     "藈" => "r",
     "藉" => "r",
     "藋" => "r",
     "藍" => "r",
     "藎" => "r",
     "藏" => "r",
     "藐" => "r",
     "藑" => "r",
     "藒" => "r",
     "藕" => "r",
     "藗" => "r",
     "藘" => "r",
     "藙" => "r",
     "藚" => "r",
     "藜" => "r",
     "藝" => "r",
     "藞" => "r",
     "藟" => "r",
     "藡" => "r",
     "藢" => "r",
     "藣" => "r",
     "藤" => "r",
     "藥" => "r",
     "藦" => "r",
     "藨" => "r",
     "藩" => "r",
     "藪" => "r",
     "藫" => "r",
     "藬" => "r",
     "藭" => "r",
     "藯" => "r",
     "藰" => "r",
     "藱" => "r",
     "藲" => "r",
     "藶" => "r",
     "藷" => "r",
     "藸" => "r",
     "藹" => "r",
     "藺" => "r",
     "藻" => "r",
     "藽" => "r",
     "藾" => "r",
     "藿" => "r",
     "蘀" => "r",
     "蘁" => "r",
     "蘄" => "r",
     "蘅" => "r",
     "蘆" => "r",
     "蘇" => "r",
     "蘉" => "r",
     "蘊" => "r",
     "蘋" => "r",
     "蘌" => "r",
     "蘑" => "r",
     "蘗" => "r",
     "蘘" => "r",
     "蘙" => "r",
     "蘚" => "r",
     "蘛" => "r",
     "蘜" => "r",
     "蘞" => "r",
     "蘟" => "r",
     "蘠" => "r",
     "蘡" => "r",
     "蘢" => "r",
     "蘣" => "r",
     "蘤" => "r",
     "蘥" => "r",
     "蘦" => "r",
     "蘧" => "r",
     "蘩" => "r",
     "蘪" => "r",
     "蘬" => "r",
     "蘮" => "r",
     "蘱" => "r",
     "蘲" => "r",
     "蘳" => "r",
     "蘴" => "r",
     "蘵" => "r",
     "蘶" => "r",
     "蘸" => "r",
     "蘹" => "r",
     "蘺" => "r",
     "蘻" => "r",
     "蘼" => "r",
     "蘾" => "r",
     "蘿" => "r",
     "虀" => "r",
     "虃" => "r",
     "虆" => "r",
     "虇" => "r",
     "虈" => "r",
     "虋" => "r",
     "虌" => "r",
     "虧" => "r",
     "蛬" => "r",
     "蜚" => "r",
     "蜸" => "r",
     "蝨" => "r",
     "裴" => "r",
     "褧" => "r",
     "視" => "r",
     "覜" => "r",
     "覲" => "r",
     "覽" => "r",
     "觀" => "r",
     "豎" => "r",
     "賢" => "r",
     "賾" => "r",
     "躉" => "r",
     "躠" => "r",
     "輂" => "r",
     "輩" => "r",
     "迅" => "r",
     "逃" => "r",
     "逽" => "r",
     "遠" => "r",
     "遭" => "r",
     "遳" => "r",
     "邧" => "r",
     "郰" => "r",
     "鄀" => "r",
     "鄚" => "r",
     "鄞" => "r",
     "鄸" => "r",
     "鄹" => "r",
     "鄿" => "r",
     "酀" => "r",
     "酄" => "r",
     "鋻" => "r",
     "鑒" => "r",
     "雈" => "r",
     "雚" => "r",
     "難" => "r",
     "非" => "r",
     "革" => "r",
     "靪" => "r",
     "靬" => "r",
     "靮" => "r",
     "靰" => "r",
     "靲" => "r",
     "靳" => "r",
     "靴" => "r",
     "靶" => "r",
     "靷" => "r",
     "靸" => "r",
     "靺" => "r",
     "靻" => "r",
     "靼" => "r",
     "靽" => "r",
     "靾" => "r",
     "靿" => "r",
     "鞀" => "r",
     "鞁" => "r",
     "鞂" => "r",
     "鞃" => "r",
     "鞄" => "r",
     "鞅" => "r",
     "鞈" => "r",
     "鞊" => "r",
     "鞋" => "r",
     "鞍" => "r",
     "鞎" => "r",
     "鞔" => "r",
     "鞘" => "r",
     "鞙" => "r",
     "鞚" => "r",
     "鞜" => "r",
     "鞝" => "r",
     "鞞" => "r",
     "鞠" => "r",
     "鞡" => "r",
     "鞢" => "r",
     "鞣" => "r",
     "鞥" => "r",
     "鞦" => "r",
     "鞨" => "r",
     "鞫" => "r",
     "鞬" => "r",
     "鞭" => "r",
     "鞮" => "r",
     "鞳" => "r",
     "鞹" => "r",
     "鞻" => "r",
     "鞿" => "r",
     "韁" => "r",
     "韃" => "r",
     "韄" => "r",
     "韅" => "r",
     "韆" => "r",
     "韇" => "r",
     "韉" => "r",
     "韭" => "r",
     "頑" => "r",
     "頤" => "r",
     "頫" => "r",
     "顢" => "r",
     "顳" => "r",
     "顴" => "r",
     "風" => "r",
     "颩" => "r",
     "颬" => "r",
     "颭" => "r",
     "颮" => "r",
     "颱" => "r",
     "颲" => "r",
     "颳" => "r",
     "颶" => "r",
     "颸" => "r",
     "颺" => "r",
     "颼" => "r",
     "颾" => "r",
     "飀" => "r",
     "飂" => "r",
     "飉" => "r",
     "飋" => "r",
     "飌" => "r",
     "餥" => "r",
     "驀" => "r",
     "鳳" => "r",
     "鳵" => "r",
     "鴯" => "r",
     "鴱" => "r",
     "鵲" => "r",
     "鶜" => "r",
     "鶧" => "r",
     "鷋" => "r",
     "鷰" => "r",
     "鸍" => "r",
     "鸏" => "r",
     "鸛" => "r",
     "鹽" => "r",
     "黿" => "r",
     "鼐" => "r",
     "三" => "s",
     "先" => "s",
     "光" => "s",
     "党" => "s",
     "兟" => "s",
     "制" => "s",
     "削" => "s",
     "剿" => "s",
     "劗" => "s",
     "劣" => "s",
     "劮" => "s",
     "勂" => "s",
     "勦" => "s",
     "勩" => "s",
     "卅" => "s",
     "告" => "s",
     "嘗" => "s",
     "嚳" => "s",
     "堂" => "s",
     "壆" => "s",
     "失" => "s",
     "學" => "s",
     "射" => "s",
     "小" => "s",
     "尐" => "s",
     "少" => "s",
     "尖" => "s",
     "尚" => "s",
     "嶨" => "s",
     "川" => "s",
     "巡" => "s",
     "巢" => "s",
     "常" => "s",
     "掌" => "s",
     "掣" => "s",
     "揱" => "s",
     "敞" => "s",
     "朱" => "s",
     "棠" => "s",
     "氅" => "s",
     "淑" => "s",
     "澩" => "s",
     "燢" => "s",
     "爂" => "s",
     "爨" => "s",
     "牚" => "s",
     "牛" => "s",
     "牝" => "s",
     "牞" => "s",
     "牠" => "s",
     "牡" => "s",
     "牣" => "s",
     "牧" => "s",
     "物" => "s",
     "牪" => "s",
     "牬" => "s",
     "牯" => "s",
     "牰" => "s",
     "牲" => "s",
     "牳" => "s",
     "牴" => "s",
     "牷" => "s",
     "牸" => "s",
     "特" => "s",
     "牻" => "s",
     "牼" => "s",
     "牾" => "s",
     "牿" => "s",
     "犄" => "s",
     "犅" => "s",
     "犆" => "s",
     "犈" => "s",
     "犉" => "s",
     "犋" => "s",
     "犌" => "s",
     "犍" => "s",
     "犐" => "s",
     "犑" => "s",
     "犒" => "s",
     "犓" => "s",
     "犕" => "s",
     "犗" => "s",
     "犝" => "s",
     "犞" => "s",
     "犡" => "s",
     "犢" => "s",
     "犣" => "s",
     "犤" => "s",
     "犥" => "s",
     "犦" => "s",
     "犧" => "s",
     "犪" => "s",
     "璺" => "s",
     "瓽" => "s",
     "生" => "s",
     "甡" => "s",
     "甥" => "s",
     "甾" => "s",
     "疀" => "s",
     "省" => "s",
     "眚" => "s",
     "礐" => "s",
     "糸" => "s",
     "糽" => "s",
     "糾" => "s",
     "紀" => "s",
     "紁" => "s",
     "紂" => "s",
     "紃" => "s",
     "約" => "s",
     "紅" => "s",
     "紆" => "s",
     "紇" => "s",
     "紈" => "s",
     "紉" => "s",
     "紋" => "s",
     "紌" => "s",
     "納" => "s",
     "紎" => "s",
     "紏" => "s",
     "紐" => "s",
     "紑" => "s",
     "紒" => "s",
     "紓" => "s",
     "純" => "s",
     "紕" => "s",
     "紖" => "s",
     "紗" => "s",
     "紘" => "s",
     "紙" => "s",
     "級" => "s",
     "紛" => "s",
     "紜" => "s",
     "紝" => "s",
     "紞" => "s",
     "紟" => "s",
     "紡" => "s",
     "紨" => "s",
     "紩" => "s",
     "紬" => "s",
     "細" => "s",
     "紱" => "s",
     "紲" => "s",
     "紳" => "s",
     "紵" => "s",
     "紶" => "s",
     "紸" => "s",
     "紹" => "s",
     "紺" => "s",
     "紻" => "s",
     "紼" => "s",
     "紽" => "s",
     "紾" => "s",
     "紿" => "s",
     "絀" => "s",
     "絁" => "s",
     "終" => "s",
     "絃" => "s",
     "組" => "s",
     "絅" => "s",
     "絆" => "s",
     "絇" => "s",
     "絊" => "s",
     "絎" => "s",
     "絏" => "s",
     "結" => "s",
     "絑" => "s",
     "絒" => "s",
     "絓" => "s",
     "絔" => "s",
     "絕" => "s",
     "絖" => "s",
     "絘" => "s",
     "絞" => "s",
     "絟" => "s",
     "絡" => "s",
     "絢" => "s",
     "絣" => "s",
     "給" => "s",
     "絧" => "s",
     "絨" => "s",
     "絩" => "s",
     "絪" => "s",
     "絯" => "s",
     "絰" => "s",
     "統" => "s",
     "絲" => "s",
     "絳" => "s",
     "絹" => "s",
     "絺" => "s",
     "絻" => "s",
     "絼" => "s",
     "絽" => "s",
     "絿" => "s",
     "綀" => "s",
     "綁" => "s",
     "綃" => "s",
     "綄" => "s",
     "綅" => "s",
     "綆" => "s",
     "綈" => "s",
     "綌" => "s",
     "綍" => "s",
     "綎" => "s",
     "綏" => "s",
     "綑" => "s",
     "綒" => "s",
     "經" => "s",
     "綖" => "s",
     "綜" => "s",
     "綝" => "s",
     "綞" => "s",
     "綟" => "s",
     "綠" => "s",
     "綡" => "s",
     "綢" => "s",
     "綣" => "s",
     "綧" => "s",
     "綩" => "s",
     "綪" => "s",
     "綬" => "s",
     "維" => "s",
     "綯" => "s",
     "綰" => "s",
     "綱" => "s",
     "綴" => "s",
     "綵" => "s",
     "綷" => "s",
     "綸" => "s",
     "綹" => "s",
     "綺" => "s",
     "綻" => "s",
     "綼" => "s",
     "綽" => "s",
     "綾" => "s",
     "緀" => "s",
     "緁" => "s",
     "緂" => "s",
     "緄" => "s",
     "緅" => "s",
     "緆" => "s",
     "緇" => "s",
     "緉" => "s",
     "緋" => "s",
     "緌" => "s",
     "緎" => "s",
     "緒" => "s",
     "緗" => "s",
     "緘" => "s",
     "緙" => "s",
     "線" => "s",
     "緛" => "s",
     "緝" => "s",
     "緞" => "s",
     "緟" => "s",
     "締" => "s",
     "緡" => "s",
     "緣" => "s",
     "緦" => "s",
     "緧" => "s",
     "編" => "s",
     "緩" => "s",
     "緪" => "s",
     "緬" => "s",
     "緮" => "s",
     "緯" => "s",
     "緰" => "s",
     "緱" => "s",
     "緲" => "s",
     "練" => "s",
     "緶" => "s",
     "緷" => "s",
     "緹" => "s",
     "緺" => "s",
     "緻" => "s",
     "縃" => "s",
     "縉" => "s",
     "縊" => "s",
     "縋" => "s",
     "縌" => "s",
     "縍" => "s",
     "縎" => "s",
     "縐" => "s",
     "縑" => "s",
     "縒" => "s",
     "縓" => "s",
     "縔" => "s",
     "縕" => "s",
     "縖" => "s",
     "縗" => "s",
     "縚" => "s",
     "縛" => "s",
     "縜" => "s",
     "縝" => "s",
     "縞" => "s",
     "縟" => "s",
     "縡" => "s",
     "縤" => "s",
     "縥" => "s",
     "縩" => "s",
     "縪" => "s",
     "縫" => "s",
     "縭" => "s",
     "縮" => "s",
     "縯" => "s",
     "縰" => "s",
     "縱" => "s",
     "縲" => "s",
     "縳" => "s",
     "縴" => "s",
     "縵" => "s",
     "縷" => "s",
     "縸" => "s",
     "縹" => "s",
     "縺" => "s",
     "縼" => "s",
     "績" => "s",
     "縿" => "s",
     "繀" => "s",
     "繂" => "s",
     "繃" => "s",
     "繅" => "s",
     "繆" => "s",
     "繈" => "s",
     "繉" => "s",
     "繌" => "s",
     "繐" => "s",
     "繑" => "s",
     "繒" => "s",
     "繓" => "s",
     "織" => "s",
     "繕" => "s",
     "繖" => "s",
     "繗" => "s",
     "繘" => "s",
     "繙" => "s",
     "繚" => "s",
     "繜" => "s",
     "繞" => "s",
     "繟" => "s",
     "繡" => "s",
     "繢" => "s",
     "繣" => "s",
     "繨" => "s",
     "繩" => "s",
     "繪" => "s",
     "繯" => "s",
     "繰" => "s",
     "繲" => "s",
     "繵" => "s",
     "繶" => "s",
     "繷" => "s",
     "繸" => "s",
     "繹" => "s",
     "繺" => "s",
     "繻" => "s",
     "繼" => "s",
     "繽" => "s",
     "繾" => "s",
     "纀" => "s",
     "纁" => "s",
     "纆" => "s",
     "纈" => "s",
     "纊" => "s",
     "纋" => "s",
     "續" => "s",
     "纏" => "s",
     "纑" => "s",
     "纓" => "s",
     "纔" => "s",
     "纕" => "s",
     "纖" => "s",
     "纗" => "s",
     "纘" => "s",
     "纙" => "s",
     "纚" => "s",
     "纜" => "s",
     "耀" => "s",
     "肖" => "s",
     "舋" => "s",
     "虩" => "s",
     "蠽" => "s",
     "裳" => "s",
     "製" => "s",
     "覺" => "s",
     "觕" => "s",
     "觷" => "s",
     "貰" => "s",
     "身" => "s",
     "躬" => "s",
     "躲" => "s",
     "躺" => "s",
     "躽" => "s",
     "軀" => "s",
     "軂" => "s",
     "軉" => "s",
     "輝" => "s",
     "迣" => "s",
     "迭" => "s",
     "逍" => "s",
     "造" => "s",
     "邋" => "s",
     "邕" => "s",
     "邾" => "s",
     "郜" => "s",
     "鄛" => "s",
     "酇" => "s",
     "雀" => "s",
     "雝" => "s",
     "順" => "s",
     "鱟" => "s",
     "鴩" => "s",
     "鴸" => "s",
     "鵠" => "s",
     "鶅" => "s",
     "鶭" => "s",
     "鷥" => "s",
     "鷽" => "s",
     "黌" => "s",
     "黨" => "s",
     "丁" => "t",
     "丏" => "t",
     "云" => "t",
     "充" => "t",
     "勇" => "t",
     "可" => "t",
     "哥" => "t",
     "埜" => "t",
     "夏" => "t",
     "夒" => "t",
     "奡" => "t",
     "婪" => "t",
     "彬" => "t",
     "恿" => "t",
     "惁" => "t",
     "想" => "t",
     "懋" => "t",
     "戛" => "t",
     "攀" => "t",
     "更" => "t",
     "木" => "t",
     "本" => "t",
     "札" => "t",
     "朳" => "t",
     "朴" => "t",
     "朸" => "t",
     "朹" => "t",
     "机" => "t",
     "朻" => "t",
     "朼" => "t",
     "朽" => "t",
     "朾" => "t",
     "杅" => "t",
     "杆" => "t",
     "杇" => "t",
     "杈" => "t",
     "杉" => "t",
     "杋" => "t",
     "杌" => "t",
     "杍" => "t",
     "李" => "t",
     "杏" => "t",
     "材" => "t",
     "杓" => "t",
     "杕" => "t",
     "杖" => "t",
     "杙" => "t",
     "杚" => "t",
     "杜" => "t",
     "杝" => "t",
     "杞" => "t",
     "杠" => "t",
     "杪" => "t",
     "杬" => "t",
     "杭" => "t",
     "杯" => "t",
     "杰" => "t",
     "杳" => "t",
     "杴" => "t",
     "杵" => "t",
     "杶" => "t",
     "杷" => "t",
     "杸" => "t",
     "杹" => "t",
     "杺" => "t",
     "杻" => "t",
     "杼" => "t",
     "杽" => "t",
     "松" => "t",
     "板" => "t",
     "极" => "t",
     "枃" => "t",
     "构" => "t",
     "枅" => "t",
     "枆" => "t",
     "枇" => "t",
     "枉" => "t",
     "枋" => "t",
     "枌" => "t",
     "枍" => "t",
     "枎" => "t",
     "析" => "t",
     "枑" => "t",
     "枒" => "t",
     "枓" => "t",
     "枔" => "t",
     "枕" => "t",
     "林" => "t",
     "枘" => "t",
     "枙" => "t",
     "枚" => "t",
     "枝" => "t",
     "枟" => "t",
     "枮" => "t",
     "枯" => "t",
     "枰" => "t",
     "枳" => "t",
     "枴" => "t",
     "枵" => "t",
     "枷" => "t",
     "枸" => "t",
     "枹" => "t",
     "枺" => "t",
     "枻" => "t",
     "柀" => "t",
     "柁" => "t",
     "柂" => "t",
     "柃" => "t",
     "柄" => "t",
     "柅" => "t",
     "柆" => "t",
     "柈" => "t",
     "柉" => "t",
     "柊" => "t",
     "柌" => "t",
     "柍" => "t",
     "柎" => "t",
     "柏" => "t",
     "柑" => "t",
     "柘" => "t",
     "柙" => "t",
     "柚" => "t",
     "柛" => "t",
     "柜" => "t",
     "柝" => "t",
     "柞" => "t",
     "柟" => "t",
     "柢" => "t",
     "柣" => "t",
     "柤" => "t",
     "查" => "t",
     "柦" => "t",
     "柧" => "t",
     "柩" => "t",
     "柪" => "t",
     "柫" => "t",
     "柭" => "t",
     "柮" => "t",
     "柯" => "t",
     "柰" => "t",
     "柱" => "t",
     "柲" => "t",
     "柳" => "t",
     "柵" => "t",
     "柶" => "t",
     "柷" => "t",
     "柸" => "t",
     "柺" => "t",
     "柼" => "t",
     "柿" => "t",
     "栒" => "t",
     "栓" => "t",
     "栖" => "t",
     "栘" => "t",
     "栚" => "t",
     "栜" => "t",
     "栝" => "t",
     "栟" => "t",
     "校" => "t",
     "栦" => "t",
     "栨" => "t",
     "栩" => "t",
     "株" => "t",
     "栫" => "t",
     "栭" => "t",
     "栮" => "t",
     "栯" => "t",
     "栱" => "t",
     "栲" => "t",
     "栳" => "t",
     "栴" => "t",
     "栵" => "t",
     "核" => "t",
     "根" => "t",
     "栺" => "t",
     "栻" => "t",
     "格" => "t",
     "桁" => "t",
     "桂" => "t",
     "桃" => "t",
     "桄" => "t",
     "桅" => "t",
     "框" => "t",
     "桉" => "t",
     "桋" => "t",
     "桍" => "t",
     "桎" => "t",
     "桏" => "t",
     "桐" => "t",
     "桓" => "t",
     "桔" => "t",
     "桫" => "t",
     "桭" => "t",
     "桮" => "t",
     "桯" => "t",
     "桱" => "t",
     "桲" => "t",
     "桴" => "t",
     "桵" => "t",
     "桶" => "t",
     "桷" => "t",
     "桸" => "t",
     "桹" => "t",
     "桻" => "t",
     "桽" => "t",
     "桾" => "t",
     "桿" => "t",
     "梀" => "t",
     "梂" => "t",
     "梃" => "t",
     "梅" => "t",
     "梆" => "t",
     "梇" => "t",
     "梉" => "t",
     "梋" => "t",
     "梌" => "t",
     "梏" => "t",
     "梐" => "t",
     "梑" => "t",
     "梒" => "t",
     "梓" => "t",
     "梔" => "t",
     "梖" => "t",
     "梗" => "t",
     "梛" => "t",
     "梜" => "t",
     "梠" => "t",
     "梡" => "t",
     "梢" => "t",
     "梣" => "t",
     "梤" => "t",
     "梧" => "t",
     "梩" => "t",
     "梪" => "t",
     "梫" => "t",
     "梬" => "t",
     "梭" => "t",
     "梮" => "t",
     "梯" => "t",
     "械" => "t",
     "梱" => "t",
     "梲" => "t",
     "梳" => "t",
     "梴" => "t",
     "梵" => "t",
     "棄" => "t",
     "棆" => "t",
     "棇" => "t",
     "棈" => "t",
     "棉" => "t",
     "棋" => "t",
     "棌" => "t",
     "棍" => "t",
     "棎" => "t",
     "棑" => "t",
     "棒" => "t",
     "棓" => "t",
     "棔" => "t",
     "棕" => "t",
     "棖" => "t",
     "棚" => "t",
     "棜" => "t",
     "棝" => "t",
     "棞" => "t",
     "棟" => "t",
     "棡" => "t",
     "棣" => "t",
     "棤" => "t",
     "棦" => "t",
     "棧" => "t",
     "棩" => "t",
     "棪" => "t",
     "棫" => "t",
     "棬" => "t",
     "森" => "t",
     "棯" => "t",
     "棰" => "t",
     "棱" => "t",
     "棲" => "t",
     "棳" => "t",
     "棴" => "t",
     "棵" => "t",
     "棶" => "t",
     "棷" => "t",
     "棹" => "t",
     "棺" => "t",
     "棼" => "t",
     "棽" => "t",
     "椄" => "t",
     "椅" => "t",
     "椆" => "t",
     "椇" => "t",
     "椈" => "t",
     "椊" => "t",
     "椋" => "t",
     "椌" => "t",
     "植" => "t",
     "椎" => "t",
     "椏" => "t",
     "椐" => "t",
     "椑" => "t",
     "椒" => "t",
     "椓" => "t",
     "椔" => "t",
     "椕" => "t",
     "椗" => "t",
     "椥" => "t",
     "椪" => "t",
     "椯" => "t",
     "椰" => "t",
     "椲" => "t",
     "椳" => "t",
     "椴" => "t",
     "椵" => "t",
     "椷" => "t",
     "椸" => "t",
     "椹" => "t",
     "椻" => "t",
     "椼" => "t",
     "椽" => "t",
     "椿" => "t",
     "楀" => "t",
     "楁" => "t",
     "楂" => "t",
     "楄" => "t",
     "楅" => "t",
     "楈" => "t",
     "楉" => "t",
     "楊" => "t",
     "楋" => "t",
     "楌" => "t",
     "楎" => "t",
     "楏" => "t",
     "楑" => "t",
     "楒" => "t",
     "楓" => "t",
     "楔" => "t",
     "楖" => "t",
     "楗" => "t",
     "楙" => "t",
     "楚" => "t",
     "楛" => "t",
     "楜" => "t",
     "楝" => "t",
     "楞" => "t",
     "楟" => "t",
     "楠" => "t",
     "楢" => "t",
     "楣" => "t",
     "楥" => "t",
     "楦" => "t",
     "楨" => "t",
     "楩" => "t",
     "楪" => "t",
     "楫" => "t",
     "楬" => "t",
     "楮" => "t",
     "楯" => "t",
     "楰" => "t",
     "楱" => "t",
     "楴" => "t",
     "極" => "t",
     "楷" => "t",
     "楸" => "t",
     "楹" => "t",
     "楺" => "t",
     "楻" => "t",
     "概" => "t",
     "榃" => "t",
     "榆" => "t",
     "榍" => "t",
     "榎" => "t",
     "榐" => "t",
     "榑" => "t",
     "榓" => "t",
     "榔" => "t",
     "榕" => "t",
     "榗" => "t",
     "榙" => "t",
     "榚" => "t",
     "榛" => "t",
     "榜" => "t",
     "榞" => "t",
     "榠" => "t",
     "榡" => "t",
     "榣" => "t",
     "榤" => "t",
     "榥" => "t",
     "榧" => "t",
     "榨" => "t",
     "榩" => "t",
     "榪" => "t",
     "榫" => "t",
     "榬" => "t",
     "榭" => "t",
     "榯" => "t",
     "榰" => "t",
     "榱" => "t",
     "榳" => "t",
     "榴" => "t",
     "榵" => "t",
     "榶" => "t",
     "榷" => "t",
     "榹" => "t",
     "榻" => "t",
     "榼" => "t",
     "榽" => "t",
     "榾" => "t",
     "榿" => "t",
     "槁" => "t",
     "槂" => "t",
     "槄" => "t",
     "槆" => "t",
     "槉" => "t",
     "構" => "t",
     "槌" => "t",
     "槍" => "t",
     "槎" => "t",
     "槏" => "t",
     "槐" => "t",
     "槓" => "t",
     "槔" => "t",
     "槙" => "t",
     "槢" => "t",
     "槤" => "t",
     "槥" => "t",
     "槦" => "t",
     "槨" => "t",
     "槫" => "t",
     "槬" => "t",
     "槭" => "t",
     "槮" => "t",
     "槱" => "t",
     "槲" => "t",
     "槴" => "t",
     "槶" => "t",
     "槸" => "t",
     "槻" => "t",
     "槽" => "t",
     "槾" => "t",
     "槿" => "t",
     "樀" => "t",
     "樁" => "t",
     "樄" => "t",
     "樅" => "t",
     "樆" => "t",
     "樇" => "t",
     "樈" => "t",
     "樉" => "t",
     "樊" => "t",
     "樍" => "t",
     "樏" => "t",
     "樑" => "t",
     "樓" => "t",
     "樔" => "t",
     "樕" => "t",
     "樗" => "t",
     "樘" => "t",
     "標" => "t",
     "樛" => "t",
     "樝" => "t",
     "樞" => "t",
     "樟" => "t",
     "樠" => "t",
     "模" => "t",
     "樣" => "t",
     "樥" => "t",
     "樦" => "t",
     "樧" => "t",
     "樨" => "t",
     "樲" => "t",
     "樴" => "t",
     "樵" => "t",
     "樸" => "t",
     "樹" => "t",
     "樺" => "t",
     "樻" => "t",
     "樼" => "t",
     "樽" => "t",
     "樾" => "t",
     "樿" => "t",
     "橀" => "t",
     "橁" => "t",
     "橄" => "t",
     "橇" => "t",
     "橈" => "t",
     "橉" => "t",
     "橋" => "t",
     "橍" => "t",
     "橎" => "t",
     "橏" => "t",
     "橑" => "t",
     "橔" => "t",
     "橕" => "t",
     "橖" => "t",
     "橘" => "t",
     "橙" => "t",
     "橚" => "t",
     "橛" => "t",
     "橝" => "t",
     "橞" => "t",
     "橠" => "t",
     "橡" => "t",
     "橢" => "t",
     "橦" => "t",
     "橧" => "t",
     "橨" => "t",
     "橩" => "t",
     "橪" => "t",
     "橫" => "t",
     "橭" => "t",
     "橯" => "t",
     "橶" => "t",
     "橾" => "t",
     "橿" => "t",
     "檀" => "t",
     "檁" => "t",
     "檄" => "t",
     "檅" => "t",
     "檇" => "t",
     "檉" => "t",
     "檌" => "t",
     "檍" => "t",
     "檎" => "t",
     "檐" => "t",
     "檑" => "t",
     "檒" => "t",
     "檓" => "t",
     "檔" => "t",
     "檖" => "t",
     "檚" => "t",
     "檛" => "t",
     "檜" => "t",
     "檞" => "t",
     "檟" => "t",
     "檡" => "t",
     "檢" => "t",
     "檣" => "t",
     "檤" => "t",
     "檥" => "t",
     "檦" => "t",
     "檨" => "t",
     "檬" => "t",
     "檭" => "t",
     "檮" => "t",
     "檯" => "t",
     "檳" => "t",
     "檴" => "t",
     "檶" => "t",
     "檷" => "t",
     "檸" => "t",
     "檹" => "t",
     "檺" => "t",
     "檻" => "t",
     "檽" => "t",
     "櫂" => "t",
     "櫃" => "t",
     "櫅" => "t",
     "櫆" => "t",
     "櫇" => "t",
     "櫋" => "t",
     "櫌" => "t",
     "櫍" => "t",
     "櫏" => "t",
     "櫑" => "t",
     "櫓" => "t",
     "櫙" => "t",
     "櫚" => "t",
     "櫛" => "t",
     "櫝" => "t",
     "櫞" => "t",
     "櫟" => "t",
     "櫠" => "t",
     "櫡" => "t",
     "櫥" => "t",
     "櫧" => "t",
     "櫨" => "t",
     "櫪" => "t",
     "櫬" => "t",
     "櫮" => "t",
     "櫯" => "t",
     "櫰" => "t",
     "櫳" => "t",
     "櫸" => "t",
     "櫹" => "t",
     "櫺" => "t",
     "櫻" => "t",
     "櫼" => "t",
     "欀" => "t",
     "欂" => "t",
     "欃" => "t",
     "欄" => "t",
     "欈" => "t",
     "欉" => "t",
     "權" => "t",
     "欋" => "t",
     "欏" => "t",
     "欐" => "t",
     "欑" => "t",
     "欓" => "t",
     "欖" => "t",
     "欗" => "t",
     "欘" => "t",
     "欙" => "t",
     "欚" => "t",
     "欞" => "t",
     "歌" => "t",
     "焚" => "t",
     "甦" => "t",
     "甬" => "t",
     "百" => "t",
     "皕" => "t",
     "皙" => "t",
     "相" => "t",
     "禁" => "t",
     "紮" => "t",
     "翉" => "t",
     "育" => "t",
     "臺" => "t",
     "蚻" => "t",
     "蜤" => "t",
     "蠜" => "t",
     "蠠" => "t",
     "通" => "t",
     "郠" => "t",
     "郴" => "t",
     "鄾" => "t",
     "面" => "t",
     "靦" => "t",
     "頁" => "t",
     "頂" => "t",
     "鬱" => "t",
     "魂" => "t",
     "鸉" => "t",
     "麓" => "t",
     "予" => "u",
     "于" => "u",
     "以" => "u",
     "允" => "u",
     "凵" => "u",
     "刖" => "u",
     "剟" => "u",
     "剼" => "u",
     "勝" => "u",
     "參" => "u",
     "又" => "u",
     "叉" => "u",
     "台" => "u",
     "圣" => "u",
     "塍" => "u",
     "媵" => "u",
     "弁" => "u",
     "怠" => "u",
     "戲" => "u",
     "才" => "u",
     "敪" => "u",
     "昶" => "u",
     "月" => "u",
     "朊" => "u",
     "朋" => "u",
     "服" => "u",
     "朏" => "u",
     "朐" => "u",
     "朒" => "u",
     "朓" => "u",
     "朕" => "u",
     "朘" => "u",
     "朠" => "u",
     "朡" => "u",
     "朣" => "u",
     "朦" => "u",
     "朧" => "u",
     "枲" => "u",
     "桑" => "u",
     "欼" => "u",
     "歠" => "u",
     "毲" => "u",
     "毿" => "u",
     "永" => "u",
     "滕" => "u",
     "炙" => "u",
     "炱" => "u",
     "熊" => "u",
     "牟" => "u",
     "瓵" => "u",
     "畚" => "u",
     "盂" => "u",
     "穌" => "u",
     "絫" => "u",
     "縢" => "u",
     "肊" => "u",
     "肋" => "u",
     "肌" => "u",
     "肐" => "u",
     "肒" => "u",
     "肕" => "u",
     "肘" => "u",
     "肚" => "u",
     "肛" => "u",
     "肜" => "u",
     "肝" => "u",
     "股" => "u",
     "肢" => "u",
     "肣" => "u",
     "肥" => "u",
     "肪" => "u",
     "肫" => "u",
     "肭" => "u",
     "肮" => "u",
     "肱" => "u",
     "肵" => "u",
     "肸" => "u",
     "肺" => "u",
     "胂" => "u",
     "胅" => "u",
     "胇" => "u",
     "胈" => "u",
     "胉" => "u",
     "胊" => "u",
     "胍" => "u",
     "胎" => "u",
     "胏" => "u",
     "胐" => "u",
     "胑" => "u",
     "胕" => "u",
     "胖" => "u",
     "胗" => "u",
     "胘" => "u",
     "胙" => "u",
     "胚" => "u",
     "胛" => "u",
     "胜" => "u",
     "胝" => "u",
     "胞" => "u",
     "胠" => "u",
     "胣" => "u",
     "胦" => "u",
     "胭" => "u",
     "胯" => "u",
     "胰" => "u",
     "胱" => "u",
     "胲" => "u",
     "胳" => "u",
     "胴" => "u",
     "胵" => "u",
     "胸" => "u",
     "胹" => "u",
     "胺" => "u",
     "胻" => "u",
     "胼" => "u",
     "能" => "u",
     "脁" => "u",
     "脂" => "u",
     "脆" => "u",
     "脈" => "u",
     "脕" => "u",
     "脖" => "u",
     "脘" => "u",
     "脙" => "u",
     "脛" => "u",
     "脝" => "u",
     "脞" => "u",
     "脟" => "u",
     "脡" => "u",
     "脢" => "u",
     "脤" => "u",
     "脥" => "u",
     "脧" => "u",
     "脫" => "u",
     "脬" => "u",
     "脭" => "u",
     "脯" => "u",
     "脰" => "u",
     "脹" => "u",
     "脺" => "u",
     "脽" => "u",
     "脾" => "u",
     "腃" => "u",
     "腄" => "u",
     "腆" => "u",
     "腇" => "u",
     "腊" => "u",
     "腋" => "u",
     "腌" => "u",
     "腍" => "u",
     "腏" => "u",
     "腑" => "u",
     "腒" => "u",
     "腓" => "u",
     "腔" => "u",
     "腕" => "u",
     "腛" => "u",
     "腜" => "u",
     "腞" => "u",
     "腠" => "u",
     "腡" => "u",
     "腢" => "u",
     "腤" => "u",
     "腥" => "u",
     "腦" => "u",
     "腧" => "u",
     "腩" => "u",
     "腫" => "u",
     "腮" => "u",
     "腯" => "u",
     "腰" => "u",
     "腱" => "u",
     "腲" => "u",
     "腳" => "u",
     "腴" => "u",
     "腶" => "u",
     "腷" => "u",
     "腸" => "u",
     "腹" => "u",
     "腺" => "u",
     "腿" => "u",
     "膀" => "u",
     "膃" => "u",
     "膆" => "u",
     "膇" => "u",
     "膈" => "u",
     "膉" => "u",
     "膊" => "u",
     "膌" => "u",
     "膍" => "u",
     "膕" => "u",
     "膗" => "u",
     "膘" => "u",
     "膙" => "u",
     "膚" => "u",
     "膛" => "u",
     "膜" => "u",
     "膝" => "u",
     "膞" => "u",
     "膟" => "u",
     "膠" => "u",
     "膢" => "u",
     "膣" => "u",
     "膦" => "u",
     "膧" => "u",
     "膨" => "u",
     "膩" => "u",
     "膫" => "u",
     "膬" => "u",
     "膮" => "u",
     "膰" => "u",
     "膱" => "u",
     "膲" => "u",
     "膳" => "u",
     "膴" => "u",
     "膵" => "u",
     "膷" => "u",
     "膹" => "u",
     "膻" => "u",
     "膼" => "u",
     "膽" => "u",
     "膾" => "u",
     "膿" => "u",
     "臃" => "u",
     "臄" => "u",
     "臅" => "u",
     "臆" => "u",
     "臇" => "u",
     "臉" => "u",
     "臊" => "u",
     "臌" => "u",
     "臍" => "u",
     "臏" => "u",
     "臐" => "u",
     "臑" => "u",
     "臒" => "u",
     "臕" => "u",
     "臗" => "u",
     "臘" => "u",
     "臙" => "u",
     "臚" => "u",
     "臛" => "u",
     "臞" => "u",
     "臟" => "u",
     "臢" => "u",
     "蚤" => "u",
     "蜰" => "u",
     "螚" => "u",
     "螣" => "u",
     "豚" => "u",
     "豫" => "u",
     "貵" => "u",
     "賸" => "u",
     "越" => "u",
     "軬" => "u",
     "迂" => "u",
     "迨" => "u",
     "遯" => "u",
     "邘" => "u",
     "邰" => "u",
     "鄠" => "u",
     "酃" => "u",
     "雙" => "u",
     "雨" => "u",
     "雩" => "u",
     "雪" => "u",
     "雯" => "u",
     "雰" => "u",
     "雱" => "u",
     "雲" => "u",
     "雵" => "u",
     "零" => "u",
     "雷" => "u",
     "雸" => "u",
     "雹" => "u",
     "雺" => "u",
     "雽" => "u",
     "雿" => "u",
     "需" => "u",
     "霂" => "u",
     "霄" => "u",
     "霅" => "u",
     "霆" => "u",
     "震" => "u",
     "霈" => "u",
     "霉" => "u",
     "霋" => "u",
     "霍" => "u",
     "霎" => "u",
     "霏" => "u",
     "霐" => "u",
     "霑" => "u",
     "霒" => "u",
     "霓" => "u",
     "霖" => "u",
     "霘" => "u",
     "霙" => "u",
     "霜" => "u",
     "霝" => "u",
     "霞" => "u",
     "霟" => "u",
     "霠" => "u",
     "霢" => "u",
     "霣" => "u",
     "霤" => "u",
     "霥" => "u",
     "霦" => "u",
     "霧" => "u",
     "霨" => "u",
     "霩" => "u",
     "霪" => "u",
     "霫" => "u",
     "霬" => "u",
     "霮" => "u",
     "霯" => "u",
     "霰" => "u",
     "露" => "u",
     "霵" => "u",
     "霹" => "u",
     "霺" => "u",
     "霽" => "u",
     "霾" => "u",
     "霿" => "u",
     "靂" => "u",
     "靃" => "u",
     "靄" => "u",
     "靆" => "u",
     "靇" => "u",
     "靉" => "u",
     "靋" => "u",
     "預" => "u",
     "顙" => "u",
     "騰" => "u",
     "魚" => "u",
     "魛" => "u",
     "魟" => "u",
     "魠" => "u",
     "魡" => "u",
     "魤" => "u",
     "魦" => "u",
     "魧" => "u",
     "魨" => "u",
     "魬" => "u",
     "魯" => "u",
     "魰" => "u",
     "魱" => "u",
     "魴" => "u",
     "魵" => "u",
     "魶" => "u",
     "魷" => "u",
     "魺" => "u",
     "魻" => "u",
     "魼" => "u",
     "魽" => "u",
     "魾" => "u",
     "鮀" => "u",
     "鮂" => "u",
     "鮅" => "u",
     "鮇" => "u",
     "鮈" => "u",
     "鮐" => "u",
     "鮑" => "u",
     "鮒" => "u",
     "鮓" => "u",
     "鮕" => "u",
     "鮚" => "u",
     "鮛" => "u",
     "鮞" => "u",
     "鮠" => "u",
     "鮡" => "u",
     "鮢" => "u",
     "鮥" => "u",
     "鮦" => "u",
     "鮨" => "u",
     "鮪" => "u",
     "鮫" => "u",
     "鮭" => "u",
     "鮮" => "u",
     "鮯" => "u",
     "鮵" => "u",
     "鮶" => "u",
     "鮸" => "u",
     "鮹" => "u",
     "鮽" => "u",
     "鮿" => "u",
     "鯀" => "u",
     "鯁" => "u",
     "鯃" => "u",
     "鯄" => "u",
     "鯆" => "u",
     "鯇" => "u",
     "鯉" => "u",
     "鯓" => "u",
     "鯔" => "u",
     "鯕" => "u",
     "鯖" => "u",
     "鯙" => "u",
     "鯚" => "u",
     "鯛" => "u",
     "鯜" => "u",
     "鯞" => "u",
     "鯠" => "u",
     "鯡" => "u",
     "鯢" => "u",
     "鯤" => "u",
     "鯥" => "u",
     "鯦" => "u",
     "鯧" => "u",
     "鯨" => "u",
     "鯪" => "u",
     "鯫" => "u",
     "鯰" => "u",
     "鯷" => "u",
     "鯸" => "u",
     "鯽" => "u",
     "鰅" => "u",
     "鰆" => "u",
     "鰇" => "u",
     "鰈" => "u",
     "鰉" => "u",
     "鰋" => "u",
     "鰍" => "u",
     "鰎" => "u",
     "鰒" => "u",
     "鰓" => "u",
     "鰔" => "u",
     "鰗" => "u",
     "鰜" => "u",
     "鰝" => "u",
     "鰡" => "u",
     "鰣" => "u",
     "鰤" => "u",
     "鰥" => "u",
     "鰨" => "u",
     "鰩" => "u",
     "鰫" => "u",
     "鰬" => "u",
     "鰭" => "u",
     "鰱" => "u",
     "鰳" => "u",
     "鰶" => "u",
     "鰷" => "u",
     "鰹" => "u",
     "鰻" => "u",
     "鰼" => "u",
     "鰽" => "u",
     "鰾" => "u",
     "鰿" => "u",
     "鱁" => "u",
     "鱄" => "u",
     "鱆" => "u",
     "鱈" => "u",
     "鱊" => "u",
     "鱋" => "u",
     "鱌" => "u",
     "鱍" => "u",
     "鱎" => "u",
     "鱐" => "u",
     "鱒" => "u",
     "鱔" => "u",
     "鱕" => "u",
     "鱖" => "u",
     "鱗" => "u",
     "鱘" => "u",
     "鱙" => "u",
     "鱞" => "u",
     "鱠" => "u",
     "鱢" => "u",
     "鱣" => "u",
     "鱦" => "u",
     "鱧" => "u",
     "鱨" => "u",
     "鱭" => "u",
     "鱮" => "u",
     "鱱" => "u",
     "鱳" => "u",
     "鱴" => "u",
     "鱵" => "u",
     "鱷" => "u",
     "鱸" => "u",
     "鱹" => "u",
     "鱺" => "u",
     "鴘" => "u",
     "鴾" => "u",
     "鵩" => "u",
     "鵬" => "u",
     "鵽" => "u",
     "鼒" => "u",
     "乍" => "v",
     "乞" => "v",
     "佳" => "v",
     "刉" => "v",
     "刜" => "v",
     "初" => "v",
     "劁" => "v",
     "售" => "v",
     "复" => "v",
     "年" => "v",
     "弗" => "v",
     "怎" => "v",
     "敏" => "v",
     "智" => "v",
     "橆" => "v",
     "每" => "v",
     "毓" => "v",
     "瀪" => "v",
     "焦" => "v",
     "犨" => "v",
     "矢" => "v",
     "知" => "v",
     "矧" => "v",
     "矨" => "v",
     "矩" => "v",
     "矬" => "v",
     "短" => "v",
     "矮" => "v",
     "矯" => "v",
     "矰" => "v",
     "矱" => "v",
     "矲" => "v",
     "繁" => "v",
     "舞" => "v",
     "艴" => "v",
     "衧" => "v",
     "衩" => "v",
     "衪" => "v",
     "衫" => "v",
     "衭" => "v",
     "衯" => "v",
     "衱" => "v",
     "衲" => "v",
     "衴" => "v",
     "衵" => "v",
     "衶" => "v",
     "衹" => "v",
     "衼" => "v",
     "衽" => "v",
     "衿" => "v",
     "袀" => "v",
     "袂" => "v",
     "袉" => "v",
     "袍" => "v",
     "袎" => "v",
     "袑" => "v",
     "袒" => "v",
     "袓" => "v",
     "袕" => "v",
     "袖" => "v",
     "袗" => "v",
     "袘" => "v",
     "袙" => "v",
     "袚" => "v",
     "袛" => "v",
     "袟" => "v",
     "袡" => "v",
     "袢" => "v",
     "袧" => "v",
     "袨" => "v",
     "袪" => "v",
     "被" => "v",
     "袱" => "v",
     "袶" => "v",
     "袷" => "v",
     "袸" => "v",
     "袹" => "v",
     "袺" => "v",
     "袼" => "v",
     "袽" => "v",
     "袾" => "v",
     "裀" => "v",
     "裉" => "v",
     "裋" => "v",
     "裌" => "v",
     "裍" => "v",
     "裎" => "v",
     "裐" => "v",
     "裕" => "v",
     "裖" => "v",
     "裗" => "v",
     "裙" => "v",
     "補" => "v",
     "裞" => "v",
     "裡" => "v",
     "裧" => "v",
     "裨" => "v",
     "裫" => "v",
     "裬" => "v",
     "裮" => "v",
     "裯" => "v",
     "裰" => "v",
     "裱" => "v",
     "裲" => "v",
     "裶" => "v",
     "裷" => "v",
     "裸" => "v",
     "裺" => "v",
     "裼" => "v",
     "裾" => "v",
     "褂" => "v",
     "褅" => "v",
     "褆" => "v",
     "複" => "v",
     "褉" => "v",
     "褊" => "v",
     "褋" => "v",
     "褌" => "v",
     "褐" => "v",
     "褑" => "v",
     "褓" => "v",
     "褔" => "v",
     "褕" => "v",
     "褖" => "v",
     "褗" => "v",
     "褘" => "v",
     "褙" => "v",
     "褚" => "v",
     "褞" => "v",
     "褟" => "v",
     "褡" => "v",
     "褣" => "v",
     "褥" => "v",
     "褦" => "v",
     "褪" => "v",
     "褫" => "v",
     "褬" => "v",
     "褯" => "v",
     "褲" => "v",
     "褳" => "v",
     "褵" => "v",
     "褶" => "v",
     "褷" => "v",
     "褸" => "v",
     "褼" => "v",
     "褾" => "v",
     "襁" => "v",
     "襂" => "v",
     "襆" => "v",
     "襉" => "v",
     "襋" => "v",
     "襌" => "v",
     "襏" => "v",
     "襐" => "v",
     "襑" => "v",
     "襒" => "v",
     "襓" => "v",
     "襖" => "v",
     "襗" => "v",
     "襘" => "v",
     "襙" => "v",
     "襚" => "v",
     "襛" => "v",
     "襜" => "v",
     "襝" => "v",
     "襟" => "v",
     "襠" => "v",
     "襡" => "v",
     "襢" => "v",
     "襣" => "v",
     "襤" => "v",
     "襦" => "v",
     "襩" => "v",
     "襪" => "v",
     "襫" => "v",
     "襬" => "v",
     "襭" => "v",
     "襮" => "v",
     "襯" => "v",
     "襱" => "v",
     "襳" => "v",
     "襴" => "v",
     "襶" => "v",
     "襹" => "v",
     "襺" => "v",
     "襻" => "v",
     "襼" => "v",
     "讎" => "v",
     "費" => "v",
     "迄" => "v",
     "迤" => "v",
     "迮" => "v",
     "鄪" => "v",
     "隹" => "v",
     "隻" => "v",
     "隼" => "v",
     "集" => "v",
     "雉" => "v",
     "雋" => "v",
     "雔" => "v",
     "雥" => "v",
     "髟" => "v",
     "髡" => "v",
     "髣" => "v",
     "髦" => "v",
     "髧" => "v",
     "髫" => "v",
     "髬" => "v",
     "髭" => "v",
     "髯" => "v",
     "髱" => "v",
     "髲" => "v",
     "髳" => "v",
     "髶" => "v",
     "髷" => "v",
     "髹" => "v",
     "髺" => "v",
     "髻" => "v",
     "髼" => "v",
     "髽" => "v",
     "髾" => "v",
     "鬁" => "v",
     "鬃" => "v",
     "鬄" => "v",
     "鬅" => "v",
     "鬆" => "v",
     "鬈" => "v",
     "鬊" => "v",
     "鬋" => "v",
     "鬌" => "v",
     "鬍" => "v",
     "鬎" => "v",
     "鬐" => "v",
     "鬑" => "v",
     "鬒" => "v",
     "鬕" => "v",
     "鬖" => "v",
     "鬗" => "v",
     "鬘" => "v",
     "鬙" => "v",
     "鬚" => "v",
     "鬞" => "v",
     "鬟" => "v",
     "鬠" => "v",
     "鬢" => "v",
     "鬣" => "v",
     "鬤" => "v",
     "鴙" => "v",
     "鷦" => "v",
     "丞" => "w",
     "了" => "w",
     "五" => "w",
     "劑" => "w",
     "午" => "w",
     "卸" => "w",
     "吝" => "w",
     "吾" => "w",
     "呇" => "w",
     "啎" => "w",
     "嗇" => "w",
     "嚮" => "w",
     "垽" => "w",
     "堻" => "w",
     "塗" => "w",
     "塣" => "w",
     "娑" => "w",
     "婆" => "w",
     "孑" => "w",
     "孓" => "w",
     "巫" => "w",
     "巹" => "w",
     "幻" => "w",
     "幼" => "w",
     "幽" => "w",
     "忞" => "w",
     "惉" => "w",
     "懘" => "w",
     "承" => "w",
     "敔" => "w",
     "文" => "w",
     "斌" => "w",
     "斒" => "w",
     "斔" => "w",
     "斕" => "w",
     "斖" => "w",
     "染" => "w",
     "梁" => "w",
     "歍" => "w",
     "水" => "w",
     "氶" => "w",
     "氻" => "w",
     "氾" => "w",
     "氿" => "w",
     "汀" => "w",
     "汁" => "w",
     "汃" => "w",
     "汊" => "w",
     "汋" => "w",
     "汌" => "w",
     "汍" => "w",
     "汎" => "w",
     "汏" => "w",
     "汐" => "w",
     "汒" => "w",
     "汔" => "w",
     "汕" => "w",
     "汗" => "w",
     "汙" => "w",
     "汛" => "w",
     "汜" => "w",
     "汝" => "w",
     "江" => "w",
     "池" => "w",
     "污" => "w",
     "汥" => "w",
     "汦" => "w",
     "汧" => "w",
     "汨" => "w",
     "汩" => "w",
     "汪" => "w",
     "汫" => "w",
     "汭" => "w",
     "汯" => "w",
     "汰" => "w",
     "汱" => "w",
     "汲" => "w",
     "汳" => "w",
     "汴" => "w",
     "汶" => "w",
     "汸" => "w",
     "汻" => "w",
     "汽" => "w",
     "汾" => "w",
     "沀" => "w",
     "沁" => "w",
     "沂" => "w",
     "沃" => "w",
     "沄" => "w",
     "沅" => "w",
     "沆" => "w",
     "沇" => "w",
     "沈" => "w",
     "沉" => "w",
     "沋" => "w",
     "沌" => "w",
     "沍" => "w",
     "沎" => "w",
     "沏" => "w",
     "沐" => "w",
     "沒" => "w",
     "沓" => "w",
     "沔" => "w",
     "沕" => "w",
     "沘" => "w",
     "沙" => "w",
     "沚" => "w",
     "沛" => "w",
     "沜" => "w",
     "沝" => "w",
     "沫" => "w",
     "沬" => "w",
     "沭" => "w",
     "沮" => "w",
     "沰" => "w",
     "沱" => "w",
     "河" => "w",
     "沴" => "w",
     "沶" => "w",
     "沷" => "w",
     "沸" => "w",
     "油" => "w",
     "沺" => "w",
     "治" => "w",
     "沼" => "w",
     "沽" => "w",
     "沾" => "w",
     "沿" => "w",
     "泀" => "w",
     "況" => "w",
     "泂" => "w",
     "泃" => "w",
     "泄" => "w",
     "泅" => "w",
     "泆" => "w",
     "泇" => "w",
     "泊" => "w",
     "泌" => "w",
     "泍" => "w",
     "泏" => "w",
     "泐" => "w",
     "泑" => "w",
     "泒" => "w",
     "泓" => "w",
     "泔" => "w",
     "法" => "w",
     "泖" => "w",
     "泗" => "w",
     "泙" => "w",
     "泚" => "w",
     "泛" => "w",
     "泜" => "w",
     "泝" => "w",
     "泞" => "w",
     "泠" => "w",
     "泡" => "w",
     "波" => "w",
     "泣" => "w",
     "泥" => "w",
     "泧" => "w",
     "注" => "w",
     "泩" => "w",
     "泫" => "w",
     "泬" => "w",
     "泭" => "w",
     "泮" => "w",
     "泯" => "w",
     "泱" => "w",
     "泲" => "w",
     "泳" => "w",
     "泹" => "w",
     "洀" => "w",
     "洁" => "w",
     "洃" => "w",
     "洄" => "w",
     "洇" => "w",
     "洈" => "w",
     "洉" => "w",
     "洊" => "w",
     "洋" => "w",
     "洌" => "w",
     "洍" => "w",
     "洎" => "w",
     "洏" => "w",
     "洐" => "w",
     "洑" => "w",
     "洒" => "w",
     "洖" => "w",
     "洗" => "w",
     "洘" => "w",
     "洙" => "w",
     "洚" => "w",
     "洛" => "w",
     "洝" => "w",
     "洞" => "w",
     "洟" => "w",
     "洠" => "w",
     "洢" => "w",
     "津" => "w",
     "洧" => "w",
     "洨" => "w",
     "洩" => "w",
     "洪" => "w",
     "洫" => "w",
     "洬" => "w",
     "洭" => "w",
     "洮" => "w",
     "洰" => "w",
     "洱" => "w",
     "洲" => "w",
     "洳" => "w",
     "洴" => "w",
     "洵" => "w",
     "洶" => "w",
     "洷" => "w",
     "洸" => "w",
     "洹" => "w",
     "洺" => "w",
     "活" => "w",
     "洼" => "w",
     "洽" => "w",
     "派" => "w",
     "洿" => "w",
     "浀" => "w",
     "流" => "w",
     "浂" => "w",
     "浘" => "w",
     "浙" => "w",
     "浚" => "w",
     "浞" => "w",
     "浟" => "w",
     "浠" => "w",
     "浡" => "w",
     "浢" => "w",
     "浣" => "w",
     "浤" => "w",
     "浥" => "w",
     "浦" => "w",
     "浧" => "w",
     "浨" => "w",
     "浩" => "w",
     "浪" => "w",
     "浬" => "w",
     "浭" => "w",
     "浮" => "w",
     "浯" => "w",
     "浰" => "w",
     "浴" => "w",
     "浵" => "w",
     "浶" => "w",
     "海" => "w",
     "浸" => "w",
     "浹" => "w",
     "浺" => "w",
     "浻" => "w",
     "浼" => "w",
     "浽" => "w",
     "浾" => "w",
     "浿" => "w",
     "涀" => "w",
     "涃" => "w",
     "涄" => "w",
     "涅" => "w",
     "涆" => "w",
     "涇" => "w",
     "消" => "w",
     "涉" => "w",
     "涊" => "w",
     "涋" => "w",
     "涌" => "w",
     "涍" => "w",
     "涎" => "w",
     "涐" => "w",
     "涑" => "w",
     "涒" => "w",
     "涓" => "w",
     "涔" => "w",
     "涕" => "w",
     "涗" => "w",
     "涘" => "w",
     "涪" => "w",
     "涫" => "w",
     "涬" => "w",
     "涮" => "w",
     "涯" => "w",
     "液" => "w",
     "涳" => "w",
     "涴" => "w",
     "涵" => "w",
     "涷" => "w",
     "涸" => "w",
     "涺" => "w",
     "涻" => "w",
     "涽" => "w",
     "涾" => "w",
     "涿" => "w",
     "淀" => "w",
     "淂" => "w",
     "淄" => "w",
     "淅" => "w",
     "淆" => "w",
     "淇" => "w",
     "淈" => "w",
     "淉" => "w",
     "淊" => "w",
     "淋" => "w",
     "淌" => "w",
     "淍" => "w",
     "淏" => "w",
     "淐" => "w",
     "淒" => "w",
     "淓" => "w",
     "淔" => "w",
     "淕" => "w",
     "淖" => "w",
     "淗" => "w",
     "淘" => "w",
     "淙" => "w",
     "淚" => "w",
     "淛" => "w",
     "淜" => "w",
     "淝" => "w",
     "淞" => "w",
     "淟" => "w",
     "淠" => "w",
     "淡" => "w",
     "淢" => "w",
     "淣" => "w",
     "淤" => "w",
     "淥" => "w",
     "淦" => "w",
     "淩" => "w",
     "淪" => "w",
     "淫" => "w",
     "淬" => "w",
     "淭" => "w",
     "淮" => "w",
     "淯" => "w",
     "淰" => "w",
     "深" => "w",
     "淲" => "w",
     "淳" => "w",
     "淴" => "w",
     "淵" => "w",
     "淶" => "w",
     "混" => "w",
     "淹" => "w",
     "淺" => "w",
     "添" => "w",
     "淼" => "w",
     "淽" => "w",
     "渀" => "w",
     "渃" => "w",
     "清" => "w",
     "渙" => "w",
     "渚" => "w",
     "渜" => "w",
     "渝" => "w",
     "渟" => "w",
     "渠" => "w",
     "渢" => "w",
     "渣" => "w",
     "渤" => "w",
     "渥" => "w",
     "渦" => "w",
     "渧" => "w",
     "渨" => "w",
     "渫" => "w",
     "測" => "w",
     "渭" => "w",
     "渮" => "w",
     "港" => "w",
     "渰" => "w",
     "渱" => "w",
     "渲" => "w",
     "渳" => "w",
     "渴" => "w",
     "渵" => "w",
     "渶" => "w",
     "游" => "w",
     "渹" => "w",
     "渺" => "w",
     "渻" => "w",
     "渼" => "w",
     "渽" => "w",
     "渾" => "w",
     "渿" => "w",
     "湀" => "w",
     "湁" => "w",
     "湃" => "w",
     "湄" => "w",
     "湅" => "w",
     "湆" => "w",
     "湇" => "w",
     "湉" => "w",
     "湋" => "w",
     "湍" => "w",
     "湎" => "w",
     "湑" => "w",
     "湒" => "w",
     "湓" => "w",
     "湔" => "w",
     "湕" => "w",
     "湖" => "w",
     "湘" => "w",
     "湚" => "w",
     "湛" => "w",
     "湜" => "w",
     "湝" => "w",
     "湞" => "w",
     "湟" => "w",
     "湠" => "w",
     "湡" => "w",
     "湢" => "w",
     "湣" => "w",
     "湤" => "w",
     "湥" => "w",
     "湦" => "w",
     "湧" => "w",
     "湨" => "w",
     "湩" => "w",
     "湫" => "w",
     "湮" => "w",
     "湯" => "w",
     "湱" => "w",
     "湲" => "w",
     "湳" => "w",
     "湴" => "w",
     "湷" => "w",
     "湸" => "w",
     "湹" => "w",
     "溈" => "w",
     "溉" => "w",
     "溍" => "w",
     "溎" => "w",
     "溏" => "w",
     "源" => "w",
     "溒" => "w",
     "溓" => "w",
     "溔" => "w",
     "溗" => "w",
     "溘" => "w",
     "溙" => "w",
     "溛" => "w",
     "溜" => "w",
     "溝" => "w",
     "溞" => "w",
     "溟" => "w",
     "溠" => "w",
     "溡" => "w",
     "溢" => "w",
     "溣" => "w",
     "溤" => "w",
     "溥" => "w",
     "溦" => "w",
     "溧" => "w",
     "溫" => "w",
     "溮" => "w",
     "溯" => "w",
     "溰" => "w",
     "溱" => "w",
     "溲" => "w",
     "溳" => "w",
     "溴" => "w",
     "溶" => "w",
     "溷" => "w",
     "溹" => "w",
     "溺" => "w",
     "溼" => "w",
     "溽" => "w",
     "溾" => "w",
     "溿" => "w",
     "滀" => "w",
     "滁" => "w",
     "滂" => "w",
     "滃" => "w",
     "滄" => "w",
     "滆" => "w",
     "滇" => "w",
     "滈" => "w",
     "滉" => "w",
     "滊" => "w",
     "滋" => "w",
     "滌" => "w",
     "滍" => "w",
     "滏" => "w",
     "滐" => "w",
     "滑" => "w",
     "滒" => "w",
     "滓" => "w",
     "滔" => "w",
     "滖" => "w",
     "滘" => "w",
     "滜" => "w",
     "滫" => "w",
     "滬" => "w",
     "滭" => "w",
     "滮" => "w",
     "滯" => "w",
     "滱" => "w",
     "滲" => "w",
     "滴" => "w",
     "滵" => "w",
     "滶" => "w",
     "滷" => "w",
     "滸" => "w",
     "滹" => "w",
     "滻" => "w",
     "滼" => "w",
     "滽" => "w",
     "滾" => "w",
     "漁" => "w",
     "漂" => "w",
     "漃" => "w",
     "漅" => "w",
     "漆" => "w",
     "漇" => "w",
     "漈" => "w",
     "漉" => "w",
     "漊" => "w",
     "漍" => "w",
     "漎" => "w",
     "漏" => "w",
     "漒" => "w",
     "漓" => "w",
     "演" => "w",
     "漕" => "w",
     "漘" => "w",
     "漙" => "w",
     "漚" => "w",
     "漜" => "w",
     "漞" => "w",
     "漟" => "w",
     "漠" => "w",
     "漡" => "w",
     "漢" => "w",
     "漣" => "w",
     "漥" => "w",
     "漧" => "w",
     "漩" => "w",
     "漪" => "w",
     "漫" => "w",
     "漬" => "w",
     "漭" => "w",
     "漮" => "w",
     "漯" => "w",
     "漰" => "w",
     "漱" => "w",
     "漲" => "w",
     "漳" => "w",
     "漵" => "w",
     "漶" => "w",
     "漷" => "w",
     "漸" => "w",
     "漹" => "w",
     "漺" => "w",
     "漻" => "w",
     "漼" => "w",
     "漾" => "w",
     "潀" => "w",
     "潃" => "w",
     "潎" => "w",
     "潏" => "w",
     "潐" => "w",
     "潑" => "w",
     "潒" => "w",
     "潓" => "w",
     "潔" => "w",
     "潕" => "w",
     "潗" => "w",
     "潘" => "w",
     "潚" => "w",
     "潝" => "w",
     "潞" => "w",
     "潟" => "w",
     "潠" => "w",
     "潡" => "w",
     "潢" => "w",
     "潣" => "w",
     "潤" => "w",
     "潦" => "w",
     "潧" => "w",
     "潩" => "w",
     "潪" => "w",
     "潫" => "w",
     "潬" => "w",
     "潭" => "w",
     "潮" => "w",
     "潯" => "w",
     "潰" => "w",
     "潲" => "w",
     "潳" => "w",
     "潶" => "w",
     "潷" => "w",
     "潸" => "w",
     "潺" => "w",
     "潻" => "w",
     "潼" => "w",
     "潽" => "w",
     "潾" => "w",
     "潿" => "w",
     "澀" => "w",
     "澂" => "w",
     "澄" => "w",
     "澅" => "w",
     "澆" => "w",
     "澇" => "w",
     "澈" => "w",
     "澉" => "w",
     "澋" => "w",
     "澌" => "w",
     "澍" => "w",
     "澎" => "w",
     "澐" => "w",
     "澒" => "w",
     "澓" => "w",
     "澔" => "w",
     "澕" => "w",
     "澖" => "w",
     "澗" => "w",
     "澞" => "w",
     "澠" => "w",
     "澡" => "w",
     "澢" => "w",
     "澣" => "w",
     "澤" => "w",
     "澥" => "w",
     "澦" => "w",
     "澧" => "w",
     "澨" => "w",
     "澪" => "w",
     "澫" => "w",
     "澬" => "w",
     "澭" => "w",
     "澮" => "w",
     "澯" => "w",
     "澰" => "w",
     "澱" => "w",
     "澲" => "w",
     "澴" => "w",
     "澶" => "w",
     "澸" => "w",
     "澹" => "w",
     "澺" => "w",
     "澼" => "w",
     "澽" => "w",
     "澿" => "w",
     "激" => "w",
     "濁" => "w",
     "濂" => "w",
     "濃" => "w",
     "濄" => "w",
     "濆" => "w",
     "濇" => "w",
     "濈" => "w",
     "濉" => "w",
     "濊" => "w",
     "濋" => "w",
     "濍" => "w",
     "濎" => "w",
     "濏" => "w",
     "濔" => "w",
     "濕" => "w",
     "濘" => "w",
     "濛" => "w",
     "濜" => "w",
     "濝" => "w",
     "濞" => "w",
     "濟" => "w",
     "濠" => "w",
     "濡" => "w",
     "濢" => "w",
     "濣" => "w",
     "濤" => "w",
     "濦" => "w",
     "濧" => "w",
     "濨" => "w",
     "濩" => "w",
     "濫" => "w",
     "濬" => "w",
     "濭" => "w",
     "濮" => "w",
     "濯" => "w",
     "濰" => "w",
     "濱" => "w",
     "濲" => "w",
     "濴" => "w",
     "濷" => "w",
     "濺" => "w",
     "濻" => "w",
     "濼" => "w",
     "濾" => "w",
     "濿" => "w",
     "瀀" => "w",
     "瀁" => "w",
     "瀄" => "w",
     "瀅" => "w",
     "瀆" => "w",
     "瀇" => "w",
     "瀉" => "w",
     "瀊" => "w",
     "瀋" => "w",
     "瀌" => "w",
     "瀍" => "w",
     "瀎" => "w",
     "瀏" => "w",
     "瀑" => "w",
     "瀔" => "w",
     "瀕" => "w",
     "瀖" => "w",
     "瀗" => "w",
     "瀘" => "w",
     "瀙" => "w",
     "瀚" => "w",
     "瀛" => "w",
     "瀜" => "w",
     "瀝" => "w",
     "瀟" => "w",
     "瀠" => "w",
     "瀡" => "w",
     "瀢" => "w",
     "瀣" => "w",
     "瀤" => "w",
     "瀦" => "w",
     "瀧" => "w",
     "瀨" => "w",
     "瀩" => "w",
     "瀫" => "w",
     "瀯" => "w",
     "瀰" => "w",
     "瀱" => "w",
     "瀲" => "w",
     "瀳" => "w",
     "瀴" => "w",
     "瀵" => "w",
     "瀷" => "w",
     "瀸" => "w",
     "瀹" => "w",
     "瀺" => "w",
     "瀻" => "w",
     "瀼" => "w",
     "瀾" => "w",
     "瀿" => "w",
     "灀" => "w",
     "灁" => "w",
     "灂" => "w",
     "灃" => "w",
     "灄" => "w",
     "灅" => "w",
     "灆" => "w",
     "灈" => "w",
     "灉" => "w",
     "灊" => "w",
     "灌" => "w",
     "灑" => "w",
     "灒" => "w",
     "灕" => "w",
     "灖" => "w",
     "灗" => "w",
     "灘" => "w",
     "灚" => "w",
     "灛" => "w",
     "灝" => "w",
     "灞" => "w",
     "灟" => "w",
     "灠" => "w",
     "灡" => "w",
     "灢" => "w",
     "灣" => "w",
     "灤" => "w",
     "灦" => "w",
     "灨" => "w",
     "灩" => "w",
     "灪" => "w",
     "烏" => "w",
     "烝" => "w",
     "燙" => "w",
     "璗" => "w",
     "瓦" => "w",
     "瓩" => "w",
     "畿" => "w",
     "盓" => "w",
     "盪" => "w",
     "盭" => "w",
     "硰" => "w",
     "碆" => "w",
     "粱" => "w",
     "紊" => "w",
     "缶" => "w",
     "缸" => "w",
     "缹" => "w",
     "缺" => "w",
     "缾" => "w",
     "缿" => "w",
     "罅" => "w",
     "罈" => "w",
     "罏" => "w",
     "罐" => "w",
     "脀" => "w",
     "舝" => "w",
     "螤" => "w",
     "蠁" => "w",
     "蠿" => "w",
     "裟" => "w",
     "覡" => "w",
     "贇" => "w",
     "迕" => "w",
     "逜" => "w",
     "逤" => "w",
     "違" => "w",
     "郚" => "w",
     "郼" => "w",
     "鄉" => "w",
     "鄔" => "w",
     "酒" => "w",
     "鋈" => "w",
     "鍌" => "w",
     "鍙" => "w",
     "鎏" => "w",
     "韋" => "w",
     "韌" => "w",
     "韍" => "w",
     "韎" => "w",
     "韐" => "w",
     "韔" => "w",
     "韕" => "w",
     "韖" => "w",
     "韗" => "w",
     "韘" => "w",
     "韜" => "w",
     "韝" => "w",
     "韞" => "w",
     "韟" => "w",
     "韡" => "w",
     "韣" => "w",
     "韥" => "w",
     "顄" => "w",
     "饗" => "w",
     "魙" => "w",
     "鯊" => "w",
     "鳼" => "w",
     "鴢" => "w",
     "鴻" => "w",
     "鸂" => "w",
     "齊" => "w",
     "齋" => "w",
     "齌" => "w",
     "齍" => "w",
     "齎" => "w",
     "齏" => "w",
     "乂" => "x",
     "兇" => "x",
     "冇" => "x",
     "凶" => "x",
     "刈" => "x",
     "剎" => "x",
     "升" => "x",
     "友" => "x",
     "右" => "x",
     "在" => "x",
     "存" => "x",
     "左" => "x",
     "布" => "x",
     "希" => "x",
     "弒" => "x",
     "戫" => "x",
     "昏" => "x",
     "有" => "x",
     "欷" => "x",
     "殺" => "x",
     "殽" => "x",
     "毻" => "x",
     "氏" => "x",
     "氐" => "x",
     "爻" => "x",
     "牙" => "x",
     "瓻" => "x",
     "翃" => "x",
     "肴" => "x",
     "蝕" => "x",
     "迓" => "x",
     "迶" => "x",
     "邪" => "x",
     "邸" => "x",
     "郁" => "x",
     "郗" => "x",
     "郩" => "x",
     "鄳" => "x",
     "閷" => "x",
     "雄" => "x",
     "雅" => "x",
     "食" => "x",
     "飢" => "x",
     "飣" => "x",
     "飥" => "x",
     "飩" => "x",
     "飪" => "x",
     "飫" => "x",
     "飭" => "x",
     "飯" => "x",
     "飲" => "x",
     "飴" => "x",
     "飶" => "x",
     "飹" => "x",
     "飼" => "x",
     "飽" => "x",
     "飾" => "x",
     "餀" => "x",
     "餂" => "x",
     "餃" => "x",
     "餅" => "x",
     "餇" => "x",
     "餉" => "x",
     "餌" => "x",
     "餑" => "x",
     "餒" => "x",
     "餓" => "x",
     "餔" => "x",
     "餕" => "x",
     "餖" => "x",
     "餗" => "x",
     "餚" => "x",
     "餛" => "x",
     "餞" => "x",
     "餟" => "x",
     "餡" => "x",
     "餤" => "x",
     "餧" => "x",
     "餩" => "x",
     "餪" => "x",
     "餫" => "x",
     "餬" => "x",
     "餭" => "x",
     "餯" => "x",
     "餰" => "x",
     "餱" => "x",
     "餲" => "x",
     "餳" => "x",
     "餵" => "x",
     "餺" => "x",
     "餼" => "x",
     "餽" => "x",
     "餾" => "x",
     "餿" => "x",
     "饁" => "x",
     "饃" => "x",
     "饅" => "x",
     "饇" => "x",
     "饈" => "x",
     "饉" => "x",
     "饋" => "x",
     "饌" => "x",
     "饎" => "x",
     "饐" => "x",
     "饑" => "x",
     "饒" => "x",
     "饓" => "x",
     "饖" => "x",
     "饘" => "x",
     "饙" => "x",
     "饛" => "x",
     "饞" => "x",
     "饟" => "x",
     "饡" => "x",
     "鬯" => "x",
     "鴉" => "x",
     "鴟" => "x",
     "鵗" => "x",
     "黽" => "x",
     "亄" => "y",
     "刁" => "y",
     "刲" => "y",
     "劫" => "y",
     "劼" => "y",
     "卦" => "y",
     "去" => "y",
     "吉" => "y",
     "喜" => "y",
     "嗀" => "y",
     "嘉" => "y",
     "嚭" => "y",
     "囍" => "y",
     "土" => "y",
     "圠" => "y",
     "圢" => "y",
     "圩" => "y",
     "圪" => "y",
     "圬" => "y",
     "圭" => "y",
     "圮" => "y",
     "圯" => "y",
     "地" => "y",
     "圳" => "y",
     "圴" => "y",
     "圻" => "y",
     "圾" => "y",
     "址" => "y",
     "坁" => "y",
     "坅" => "y",
     "均" => "y",
     "坉" => "y",
     "坊" => "y",
     "坋" => "y",
     "坍" => "y",
     "坎" => "y",
     "坏" => "y",
     "坑" => "y",
     "坡" => "y",
     "坢" => "y",
     "坤" => "y",
     "坦" => "y",
     "坨" => "y",
     "坩" => "y",
     "坪" => "y",
     "坫" => "y",
     "坭" => "y",
     "坯" => "y",
     "坰" => "y",
     "坱" => "y",
     "坲" => "y",
     "坳" => "y",
     "坴" => "y",
     "坵" => "y",
     "坶" => "y",
     "坷" => "y",
     "坻" => "y",
     "坼" => "y",
     "坽" => "y",
     "垀" => "y",
     "垃" => "y",
     "垌" => "y",
     "垏" => "y",
     "垓" => "y",
     "垗" => "y",
     "垘" => "y",
     "垙" => "y",
     "垚" => "y",
     "垛" => "y",
     "垝" => "y",
     "垞" => "y",
     "垟" => "y",
     "垠" => "y",
     "垢" => "y",
     "垣" => "y",
     "垤" => "y",
     "垥" => "y",
     "垮" => "y",
     "垵" => "y",
     "垶" => "y",
     "垸" => "y",
     "垹" => "y",
     "垺" => "y",
     "垿" => "y",
     "埁" => "y",
     "埂" => "y",
     "埃" => "y",
     "埆" => "y",
     "埇" => "y",
     "埋" => "y",
     "埌" => "y",
     "城" => "y",
     "埏" => "y",
     "埐" => "y",
     "埒" => "y",
     "埔" => "y",
     "埕" => "y",
     "域" => "y",
     "埠" => "y",
     "埡" => "y",
     "埢" => "y",
     "埣" => "y",
     "埤" => "y",
     "埥" => "y",
     "埧" => "y",
     "埩" => "y",
     "埬" => "y",
     "埭" => "y",
     "埮" => "y",
     "埰" => "y",
     "埱" => "y",
     "埲" => "y",
     "埳" => "y",
     "埴" => "y",
     "埵" => "y",
     "埶" => "y",
     "埸" => "y",
     "培" => "y",
     "埻" => "y",
     "埼" => "y",
     "埽" => "y",
     "堀" => "y",
     "堁" => "y",
     "堄" => "y",
     "堆" => "y",
     "堈" => "y",
     "堉" => "y",
     "堋" => "y",
     "堌" => "y",
     "堍" => "y",
     "堎" => "y",
     "堐" => "y",
     "堔" => "y",
     "堙" => "y",
     "堛" => "y",
     "堜" => "y",
     "堝" => "y",
     "堞" => "y",
     "堠" => "y",
     "堣" => "y",
     "堤" => "y",
     "堧" => "y",
     "堨" => "y",
     "堩" => "y",
     "堪" => "y",
     "堬" => "y",
     "堭" => "y",
     "堮" => "y",
     "堰" => "y",
     "堳" => "y",
     "場" => "y",
     "堵" => "y",
     "堶" => "y",
     "堷" => "y",
     "堸" => "y",
     "堹" => "y",
     "堽" => "y",
     "堿" => "y",
     "塉" => "y",
     "塊" => "y",
     "塌" => "y",
     "塎" => "y",
     "塏" => "y",
     "塒" => "y",
     "塓" => "y",
     "塔" => "y",
     "塕" => "y",
     "塘" => "y",
     "塙" => "y",
     "塚" => "y",
     "塛" => "y",
     "塝" => "y",
     "塢" => "y",
     "塤" => "y",
     "塥" => "y",
     "塨" => "y",
     "填" => "y",
     "塭" => "y",
     "塯" => "y",
     "塴" => "y",
     "塶" => "y",
     "塻" => "y",
     "塼" => "y",
     "塽" => "y",
     "塿" => "y",
     "墀" => "y",
     "墁" => "y",
     "墂" => "y",
     "境" => "y",
     "墆" => "y",
     "墇" => "y",
     "墈" => "y",
     "墉" => "y",
     "墋" => "y",
     "墎" => "y",
     "墐" => "y",
     "墑" => "y",
     "墔" => "y",
     "墘" => "y",
     "墝" => "y",
     "增" => "y",
     "墟" => "y",
     "墠" => "y",
     "墡" => "y",
     "墣" => "y",
     "墥" => "y",
     "墦" => "y",
     "墩" => "y",
     "墫" => "y",
     "墱" => "y",
     "墳" => "y",
     "墺" => "y",
     "墻" => "y",
     "墽" => "y",
     "墿" => "y",
     "壇" => "y",
     "壈" => "y",
     "壉" => "y",
     "壎" => "y",
     "壏" => "y",
     "壒" => "y",
     "壔" => "y",
     "壕" => "y",
     "壖" => "y",
     "壙" => "y",
     "壚" => "y",
     "壛" => "y",
     "壝" => "y",
     "壞" => "y",
     "壢" => "y",
     "壣" => "y",
     "壤" => "y",
     "壧" => "y",
     "壩" => "y",
     "士" => "y",
     "壴" => "y",
     "壺" => "y",
     "壼" => "y",
     "壾" => "y",
     "壿" => "y",
     "夌" => "y",
     "孝" => "y",
     "寺" => "y",
     "封" => "y",
     "尌" => "y",
     "州" => "y",
     "幸" => "y",
     "彀" => "y",
     "彭" => "y",
     "志" => "y",
     "恚" => "y",
     "愨" => "y",
     "懿" => "y",
     "摰" => "y",
     "敼" => "y",
     "朅" => "y",
     "榖" => "y",
     "欯" => "y",
     "歖" => "y",
     "殼" => "y",
     "毊" => "y",
     "毐" => "y",
     "漀" => "y",
     "熹" => "y",
     "犎" => "y",
     "瓡" => "y",
     "甏" => "y",
     "疋" => "y",
     "疏" => "y",
     "瞉" => "y",
     "瞽" => "y",
     "磬" => "y",
     "穀" => "y",
     "縠" => "y",
     "罄" => "y",
     "翿" => "y",
     "老" => "y",
     "耄" => "y",
     "耆" => "y",
     "耇" => "y",
     "耋" => "y",
     "聲" => "y",
     "螜" => "y",
     "螫" => "y",
     "袁" => "y",
     "覟" => "y",
     "觳" => "y",
     "謦" => "y",
     "豰" => "y",
     "赤" => "y",
     "赦" => "y",
     "赧" => "y",
     "赨" => "y",
     "赩" => "y",
     "赫" => "y",
     "赬" => "y",
     "赭" => "y",
     "赮" => "y",
     "赯" => "y",
     "走" => "y",
     "赲" => "y",
     "赳" => "y",
     "赴" => "y",
     "赶" => "y",
     "起" => "y",
     "赸" => "y",
     "赹" => "y",
     "赻" => "y",
     "赽" => "y",
     "趀" => "y",
     "趁" => "y",
     "趄" => "y",
     "超" => "y",
     "趉" => "y",
     "趌" => "y",
     "趍" => "y",
     "趎" => "y",
     "趏" => "y",
     "趐" => "y",
     "趑" => "y",
     "趒" => "y",
     "趓" => "y",
     "趔" => "y",
     "趕" => "y",
     "趖" => "y",
     "趙" => "y",
     "趛" => "y",
     "趜" => "y",
     "趟" => "y",
     "趠" => "y",
     "趡" => "y",
     "趥" => "y",
     "趧" => "y",
     "趨" => "y",
     "趪" => "y",
     "趫" => "y",
     "趬" => "y",
     "趭" => "y",
     "趮" => "y",
     "趯" => "y",
     "趲" => "y",
     "轂" => "y",
     "迼" => "y",
     "逵" => "y",
     "遶" => "y",
     "邽" => "y",
     "邿" => "y",
     "郝" => "y",
     "鋆" => "y",
     "鏧" => "y",
     "鞤" => "y",
     "韾" => "y",
     "頡" => "y",
     "顤" => "y",
     "馨" => "y",
     "鴶" => "y",
     "鵱" => "y",
     "鷇" => "y",
     "鼀" => "y",
     "鼁" => "y",
     "鼓" => "y",
     "鼕" => "y",
     "鼘" => "y",
     "鼙" => "y",
     "鼚" => "y",
     "鼛" => "y",
     "鼜" => "y",
     "鼞" => "y",
     "嗀" => "y",
     "丮" => "z",
     "乙" => "z",
     "乩" => "z",
     "些" => "z",
     "劄" => "z",
     "勴" => "z",
     "占" => "z",
     "卣" => "z",
     "叡" => "z",
     "呰" => "z",
     "壑" => "z",
     "奿" => "z",
     "媻" => "z",
     "子" => "z",
     "孔" => "z",
     "孖" => "z",
     "孜" => "z",
     "孟" => "z",
     "孢" => "z",
     "孤" => "z",
     "孩" => "z",
     "孫" => "z",
     "孮" => "z",
     "孲" => "z",
     "孺" => "z",
     "孻" => "z",
     "幋" => "z",
     "彪" => "z",
     "愻" => "z",
     "慮" => "z",
     "搫" => "z",
     "敁" => "z",
     "敹" => "z",
     "柴" => "z",
     "桌" => "z",
     "槃" => "z",
     "欳" => "z",
     "歑" => "z",
     "歔" => "z",
     "止" => "z",
     "此" => "z",
     "步" => "z",
     "歧" => "z",
     "歭" => "z",
     "歶" => "z",
     "甗" => "z",
     "甝" => "z",
     "皻" => "z",
     "盤" => "z",
     "盧" => "z",
     "眥" => "z",
     "睿" => "z",
     "砦" => "z",
     "磐" => "z",
     "祡" => "z",
     "竹" => "z",
     "竺" => "z",
     "竻" => "z",
     "竽" => "z",
     "竿" => "z",
     "笀" => "z",
     "笁" => "z",
     "笄" => "z",
     "笅" => "z",
     "笆" => "z",
     "笈" => "z",
     "笉" => "z",
     "笊" => "z",
     "笎" => "z",
     "笏" => "z",
     "笐" => "z",
     "笑" => "z",
     "笒" => "z",
     "笓" => "z",
     "笘" => "z",
     "笙" => "z",
     "笚" => "z",
     "笛" => "z",
     "笝" => "z",
     "笞" => "z",
     "笠" => "z",
     "笢" => "z",
     "笣" => "z",
     "笤" => "z",
     "笥" => "z",
     "符" => "z",
     "笨" => "z",
     "笪" => "z",
     "笫" => "z",
     "第" => "z",
     "笭" => "z",
     "笮" => "z",
     "笯" => "z",
     "笰" => "z",
     "笱" => "z",
     "笲" => "z",
     "笳" => "z",
     "笴" => "z",
     "笵" => "z",
     "笸" => "z",
     "笻" => "z",
     "筀" => "z",
     "筄" => "z",
     "筅" => "z",
     "筆" => "z",
     "筇" => "z",
     "筈" => "z",
     "等" => "z",
     "筊" => "z",
     "筋" => "z",
     "筌" => "z",
     "筍" => "z",
     "筎" => "z",
     "筏" => "z",
     "筐" => "z",
     "筑" => "z",
     "筒" => "z",
     "答" => "z",
     "策" => "z",
     "筘" => "z",
     "筠" => "z",
     "筡" => "z",
     "筣" => "z",
     "筤" => "z",
     "筥" => "z",
     "筦" => "z",
     "筧" => "z",
     "筩" => "z",
     "筭" => "z",
     "筮" => "z",
     "筰" => "z",
     "筱" => "z",
     "筲" => "z",
     "筳" => "z",
     "筴" => "z",
     "筵" => "z",
     "筶" => "z",
     "筷" => "z",
     "筸" => "z",
     "箂" => "z",
     "箄" => "z",
     "箅" => "z",
     "箇" => "z",
     "箈" => "z",
     "箊" => "z",
     "箋" => "z",
     "箌" => "z",
     "箍" => "z",
     "箎" => "z",
     "箏" => "z",
     "箐" => "z",
     "箑" => "z",
     "箔" => "z",
     "箕" => "z",
     "箖" => "z",
     "算" => "z",
     "箘" => "z",
     "箙" => "z",
     "箛" => "z",
     "箜" => "z",
     "箝" => "z",
     "箠" => "z",
     "箤" => "z",
     "箬" => "z",
     "箭" => "z",
     "箯" => "z",
     "箱" => "z",
     "箴" => "z",
     "箵" => "z",
     "箷" => "z",
     "箸" => "z",
     "箹" => "z",
     "箾" => "z",
     "篁" => "z",
     "範" => "z",
     "篆" => "z",
     "篇" => "z",
     "築" => "z",
     "篊" => "z",
     "篋" => "z",
     "篌" => "z",
     "篎" => "z",
     "篔" => "z",
     "篕" => "z",
     "篘" => "z",
     "篙" => "z",
     "篚" => "z",
     "篛" => "z",
     "篜" => "z",
     "篝" => "z",
     "篞" => "z",
     "篟" => "z",
     "篠" => "z",
     "篡" => "z",
     "篢" => "z",
     "篣" => "z",
     "篤" => "z",
     "篥" => "z",
     "篦" => "z",
     "篧" => "z",
     "篨" => "z",
     "篩" => "z",
     "篪" => "z",
     "篫" => "z",
     "篰" => "z",
     "篱" => "z",
     "篲" => "z",
     "篳" => "z",
     "篴" => "z",
     "篷" => "z",
     "篸" => "z",
     "篹" => "z",
     "篻" => "z",
     "篽" => "z",
     "篾" => "z",
     "篿" => "z",
     "簀" => "z",
     "簁" => "z",
     "簂" => "z",
     "簃" => "z",
     "簅" => "z",
     "簆" => "z",
     "簇" => "z",
     "簉" => "z",
     "簊" => "z",
     "簋" => "z",
     "簌" => "z",
     "簍" => "z",
     "簎" => "z",
     "簏" => "z",
     "簐" => "z",
     "簑" => "z",
     "簙" => "z",
     "簜" => "z",
     "簝" => "z",
     "簞" => "z",
     "簟" => "z",
     "簠" => "z",
     "簡" => "z",
     "簢" => "z",
     "簣" => "z",
     "簥" => "z",
     "簦" => "z",
     "簧" => "z",
     "簨" => "z",
     "簩" => "z",
     "簪" => "z",
     "簫" => "z",
     "簬" => "z",
     "簭" => "z",
     "簰" => "z",
     "簳" => "z",
     "簷" => "z",
     "簸" => "z",
     "簹" => "z",
     "簻" => "z",
     "簼" => "z",
     "簽" => "z",
     "簿" => "z",
     "籀" => "z",
     "籃" => "z",
     "籅" => "z",
     "籇" => "z",
     "籈" => "z",
     "籉" => "z",
     "籊" => "z",
     "籌" => "z",
     "籍" => "z",
     "籐" => "z",
     "籓" => "z",
     "籔" => "z",
     "籗" => "z",
     "籙" => "z",
     "籚" => "z",
     "籛" => "z",
     "籜" => "z",
     "籟" => "z",
     "籠" => "z",
     "籣" => "z",
     "籤" => "z",
     "籥" => "z",
     "籦" => "z",
     "籧" => "z",
     "籩" => "z",
     "籪" => "z",
     "籫" => "z",
     "籬" => "z",
     "籮" => "z",
     "籯" => "z",
     "粲" => "z",
     "紫" => "z",
     "縏" => "z",
     "纂" => "z",
     "翽" => "z",
     "肯" => "z",
     "胔" => "z",
     "舟" => "z",
     "舠" => "z",
     "舡" => "z",
     "舢" => "z",
     "舥" => "z",
     "舨" => "z",
     "航" => "z",
     "舫" => "z",
     "般" => "z",
     "舯" => "z",
     "舲" => "z",
     "舳" => "z",
     "舴" => "z",
     "舵" => "z",
     "舶" => "z",
     "舷" => "z",
     "舸" => "z",
     "船" => "z",
     "舺" => "z",
     "舼" => "z",
     "舽" => "z",
     "舿" => "z",
     "艀" => "z",
     "艂" => "z",
     "艄" => "z",
     "艅" => "z",
     "艇" => "z",
     "艉" => "z",
     "艋" => "z",
     "艎" => "z",
     "艏" => "z",
     "艐" => "z",
     "艑" => "z",
     "艒" => "z",
     "艓" => "z",
     "艕" => "z",
     "艖" => "z",
     "艗" => "z",
     "艘" => "z",
     "艙" => "z",
     "艚" => "z",
     "艛" => "z",
     "艜" => "z",
     "艞" => "z",
     "艟" => "z",
     "艡" => "z",
     "艣" => "z",
     "艤" => "z",
     "艨" => "z",
     "艩" => "z",
     "艫" => "z",
     "艬" => "z",
     "艭" => "z",
     "虍" => "z",
     "虎" => "z",
     "虐" => "z",
     "虔" => "z",
     "虖" => "z",
     "虙" => "z",
     "虛" => "z",
     "虜" => "z",
     "虞" => "z",
     "虡" => "z",
     "虤" => "z",
     "虥" => "z",
     "虨" => "z",
     "虪" => "z",
     "褩" => "z",
     "覘" => "z",
     "覤" => "z",
     "覷" => "z",
     "觜" => "z",
     "訾" => "z",
     "豦" => "z",
     "貞" => "z",
     "貲" => "z",
     "贙" => "z",
     "迠" => "z",
     "逌" => "z",
     "遉" => "z",
     "遜" => "z",
     "遽" => "z",
     "遾" => "z",
     "鈭" => "z",
     "雌" => "z",
     "鞶" => "z",
     "韰" => "z",
     "頻" => "z",
     "顪" => "z",
     "顰" => "z",
     "顱" => "z",
     "飺" => "z",
     "餐" => "z",
     "鬳" => "z",
     "鮆" => "z",
     "鵃" => "z",
     "鷑" => "z",
     "鸆" => "z",
     "鸕" => "z",
     "鹵" => "z",
     "鹹" => "z",
     "鹺" => "z",
     "鹼" => "z",
     "齒" => "z",
     "齔" => "z",
     "齕" => "z",
     "齖" => "z",
     "齗" => "z",
     "齘" => "z",
     "齙" => "z",
     "齛" => "z",
     "齜" => "z",
     "齝" => "z",
     "齞" => "z",
     "齟" => "z",
     "齠" => "z",
     "齡" => "z",
     "齣" => "z",
     "齥" => "z",
     "齦" => "z",
     "齪" => "z",
     "齫" => "z",
     "齬" => "z",
     "齮" => "z",
     "齯" => "z",
     "齰" => "z",
     "齱" => "z",
     "齲" => "z",
     "齴" => "z",
     "齵" => "z",
     "齶" => "z",
     "齷" => "z",
     "齸" => "z",
     "齺" => "z",
     "齻" => "z",
     "齾" => "z"}

# 簡速字根 (repeat.table.one.hash)
S = {"佘" => "b",
     "余" => "b",
     "侖" => "b",
     "倉" => "b",
     "僉" => "o",
     "兮" => "b",
     "冰" => "b",
     "創" => "b",
     "劃" => "e",
     "劃" => "t",
     "劊" => "b",
     "劍" => "o",
     "咸" => "k",
     "壟" => "l",
     "壟" => "y",
     "壹" => "y",
     "奧" => "p",
     "尃" => "i",
     "彧" => "h",
     "惑" => "h",
     "感" => "k",
     "慦" => "n",
     "懟" => "f",
     "懟" => "u",
     "戔" => "k",
     "或" => "h",
     "救" => "n",
     "敘" => "b",
     "敷" => "i",
     "斂" => "o",
     "斜" => "b",
     "族" => "f",
     "書" => "e",
     "會" => "b",
     "欸" => "u",
     "歛" => "o",
     "求" => "n",
     "澳" => "w",
     "甫" => "i",
     "畣" => "b",
     "發" => "f",
     "發" => "j",
     "盚" => "n",
     "盞" => "k",
     "矣" => "u",
     "礱" => "l",
     "缽" => "w",
     "義" => "b",
     "聾" => "l",
     "華" => "p",
     "華" => "r",
     "蠪" => "l",
     "術" => "m",
     "裘" => "n",
     "襲" => "l",
     "觱" => "k",
     "讋" => "l",
     "貳" => "e",
     "貸" => "p",
     "逋" => "i",
     "逑" => "n",
     "途" => "b",
     "過" => "q",
     "郙" => "i",
     "鄰" => "b",
     "鄰" => "m",
     "鄰" => "x",
     "銜" => "m",
     "錄" => "e",
     "顑" => "k",
     "顩" => "o",
     "飆" => "f",
     "飆" => "r",
     "餘" => "b",
     "餘" => "x",
     "駐" => "m",
     "髮" => "v",
     "鵏" => "i",
     "鶬" => "b",
     "鷨" => "r",
     "鸗" => "l",
     "點" => "q",
     "點" => "z",
     "龍" => "l",
     "龑" => "l",
     "龒" => "l",
     "龔" => "l",
     "龘" => "l",
     "丫" => "y",
     "乏" => "p",
     "亡" => "f",
     "介" => "v",
     "個" => "p",
     "個" => "v",
     "兼" => "q",
     "凞" => "g",
     "剃" => "t",
     "卷" => "p",
     "卻" => "w",
     "卻" => "y",
     "叢" => "f",
     "咨" => "r",
     "單" => "o",
     "塑" => "z",
     "夔" => "h",
     "夔" => "r",
     "姿" => "r",
     "嫳" => "s",
     "孳" => "l",
     "孳" => "r",
     "導" => "d",
     "導" => "h",
     "導" => "o",
     "差" => "v",
     "幣" => "p",
     "幣" => "s",
     "弊" => "s",
     "弟" => "t",
     "彆" => "s",
     "從" => "m",
     "恣" => "r",
     "慈" => "l",
     "慈" => "r",
     "慫" => "m",
     "慾" => "w",
     "憋" => "s",
     "憑" => "p",
     "戰" => "o",
     "戰" => "z",
     "敝" => "s",
     "斃" => "s",
     "柒" => "w",
     "栥" => "r",
     "楶" => "r",
     "次" => "r",
     "欲" => "w",
     "歉" => "q",
     "決" => "w",
     "沖" => "w",
     "涂" => "w",
     "涼" => "w",
     "淨" => "w",
     "減" => "w",
     "湊" => "w",
     "準" => "w",
     "為" => "e",
     "為" => "u",
     "為" => "w",
     "狹" => "q",
     "獘" => "s",
     "獸" => "o",
     "瓷" => "r",
     "畢" => "q",
     "益" => "y",
     "盜" => "r",
     "盜" => "w",
     "眾" => "f",
     "眾" => "p",
     "瞥" => "s",
     "秶" => "r",
     "粢" => "r",
     "總" => "s",
     "羋" => "i",
     "羋" => "r",
     "羋" => "y",
     "聳" => "m",
     "脊" => "f",
     "脊" => "r",
     "脊" => "w",
     "茲" => "r",
     "著" => "r",
     "蓋" => "r",
     "蘭" => "r",
     "螸" => "w",
     "蟞" => "s",
     "蠲" => "y",
     "謄" => "u",
     "谷" => "w",
     "谹" => "w",
     "谻" => "w",
     "谼" => "w",
     "谽" => "w",
     "谾" => "w",
     "豂" => "w",
     "豃" => "w",
     "豅" => "w",
     "資" => "r",
     "蹩" => "s",
     "送" => "g",
     "道" => "h",
     "遞" => "l",
     "遞" => "t",
     "還" => "f",
     "還" => "o",
     "郤" => "w",
     "郤" => "y",
     "鄨" => "s",
     "鄬" => "e",
     "鄬" => "w",
     "鄬" => "y",
     "鄭" => "g",
     "鄰" => "m",
     "鄰" => "x",
     "關" => "m",
     "隨" => "x",
     "頭" => "d",
     "餈" => "r",
     "養" => "k",
     "餘" => "x",
     "館" => "x",
     "首" => "h",
     "馘" => "h",
     "鱉" => "s",
     "鴔" => "p",
     "鵒" => "w",
     "鵜" => "t",
     "鶺" => "r",
     "鶺" => "w",
     "鶿" => "r",
     "鷁" => "y",
     "鷩" => "s",
     "麶" => "g",
     "麶" => "l",
     "乜" => "y",
     "剝" => "e",
     "剸" => "j",
     "剸" => "x",
     "劇" => "z",
     "劈" => "p",
     "壁" => "p",
     "夠" => "n",
     "嬖" => "p",
     "宣" => "n",
     "專" => "j",
     "專" => "q",
     "專" => "x",
     "局" => "o",
     "幦" => "p",
     "彝" => "e",
     "惠" => "j",
     "憵" => "p",
     "捷" => "j",
     "擊" => "q",
     "擊" => "y",
     "擘" => "p",
     "晝" => "e",
     "東" => "j",
     "柬" => "j",
     "檗" => "p",
     "溪" => "w",
     "璧" => "p",
     "甓" => "p",
     "盍" => "y",
     "盡" => "e",
     "禍" => "r",
     "糪" => "p",
     "繫" => "p",
     "繴" => "p",
     "臂" => "p",
     "襞" => "p",
     "襾" => "e",
     "襾" => "r",
     "要" => "v",
     "覃" => "x",
     "覆" => "v",
     "譬" => "p",
     "貴" => "q",
     "躄" => "p",
     "輿" => "g",
     "轡" => "s",
     "辟" => "p",
     "遣" => "u",
     "遷" => "g",
     "遺" => "q",
     "避" => "p",
     "鄟" => "j",
     "鄟" => "x",
     "雒" => "p",
     "霸" => "u",
     "飧" => "d",
     "餮" => "d",
     "駂" => "f",
     "鴇" => "f",
     "鶇" => "j",
     "鷒" => "j",
     "鷒" => "x",
     "鷣" => "x",
     "鷿" => "p",
     "鼊" => "p",
     "亙" => "e",
     "債" => "p",
     "免" => "e",
     "免" => "n",
     "兔" => "e",
     "兔" => "n",
     "兔" => "p",
     "刳" => "x",
     "剔" => "e",
     "剞" => "v",
     "剬" => "e",
     "劉" => "o",
     "劉" => "w",
     "勉" => "e",
     "勉" => "n",
     "匏" => "x",
     "匙" => "j",
     "即" => "g",
     "卵" => "e",
     "卵" => "f",
     "墾" => "e",
     "墾" => "u",
     "夸" => "x",
     "奄" => "x",
     "奇" => "v",
     "奭" => "j",
     "孵" => "e",
     "孵" => "f",
     "導" => "h",
     "導" => "o",
     "尟" => "j",
     "待" => "m",
     "得" => "m",
     "態" => "u",
     "懇" => "e",
     "懇" => "u",
     "攲" => "v",
     "敧" => "v",
     "既" => "p",
     "易" => "e",
     "昜" => "e",
     "是" => "j",
     "時" => "h",
     "暨" => "p",
     "曼" => "m",
     "欹" => "v",
     "欿" => "n",
     "歂" => "e",
     "死" => "e",
     "毈" => "e",
     "毈" => "f",
     "渡" => "w",
     "燄" => "n",
     "爽" => "j",
     "牽" => "l",
     "瓠" => "x",
     "留" => "o",
     "的" => "p",
     "綔" => "x",
     "耑" => "e",
     "脅" => "u",
     "色" => "n",
     "負" => "n",
     "貿" => "o",
     "贕" => "e",
     "辦" => "l",
     "逸" => "e",
     "逸" => "n",
     "逿" => "e",
     "遄" => "e",
     "達" => "y",
     "遛" => "o",
     "遼" => "l",
     "遼" => "w",
     "邊" => "m",
     "邊" => "p",
     "鄤" => "m",
     "鄮" => "o",
     "韙" => "j",
     "題" => "j",
     "顓" => "e",
     "鬥" => "m",
     "鴮" => "x",
     "鵪" => "x",
     "鵵" => "e",
     "鵵" => "n",
     "鵸" => "v",
     "鶗" => "j",
     "鶹" => "o",
     "鷞" => "j",
     "鷯" => "l",
     "万" => "v",
     "丙" => "t",
     "亂" => "g",
     "亞" => "o",
     "免" => "n",
     "兔" => "n",
     "兔" => "p",
     "兩" => "t",
     "再" => "t",
     "出" => "r",
     "剄" => "s",
     "剄" => "u",
     "副" => "v",
     "劃" => "t",
     "劌" => "z",
     "勁" => "s",
     "勁" => "u",
     "勉" => "n",
     "卵" => "f",
     "司" => "y",
     "吞" => "g",
     "吞" => "p",
     "喬" => "g",
     "喬" => "p",
     "嚴" => "o",
     "墾" => "u",
     "天" => "g",
     "夷" => "j",
     "孵" => "f",
     "尬" => "k",
     "尷" => "k",
     "巠" => "s",
     "巠" => "u",
     "巰" => "s",
     "巰" => "u",
     "彩" => "m",
     "忝" => "g",
     "忝" => "p",
     "悉" => "m",
     "惡" => "o",
     "愛" => "h",
     "懇" => "u",
     "戩" => "o",
     "採" => "j",
     "敿" => "g",
     "敿" => "p",
     "昋" => "g",
     "昋" => "p",
     "晉" => "o",
     "村" => "t",
     "武" => "w",
     "歲" => "z",
     "毈" => "f",
     "滅" => "w",
     "為" => "u",
     "為" => "w",
     "無" => "g",
     "無" => "v",
     "然" => "j",
     "然" => "n",
     "然" => "u",
     "爭" => "n",
     "甒" => "g",
     "甒" => "v",
     "畫" => "t",
     "盥" => "g",
     "盥" => "w",
     "管" => "z",
     "系" => "p",
     "繇" => "u",
     "舉" => "s",
     "虢" => "u",
     "虣" => "w",
     "蚕" => "g",
     "蚕" => "p",
     "蠆" => "r",
     "蠆" => "v",
     "蠫" => "u",
     "蠶" => "g",
     "蠶" => "k",
     "蠶" => "p",
     "襾" => "r",
     "覗" => "y",
     "譽" => "s",
     "豬" => "q",
     "豸" => "u",
     "豹" => "u",
     "豺" => "u",
     "豻" => "u",
     "豽" => "u",
     "貀" => "u",
     "貁" => "u",
     "貂" => "g",
     "貂" => "u",
     "貄" => "u",
     "貅" => "u",
     "貆" => "u",
     "貉" => "u",
     "貊" => "u",
     "貌" => "p",
     "貌" => "u",
     "貍" => "u",
     "貏" => "u",
     "貐" => "u",
     "貑" => "u",
     "貒" => "u",
     "貓" => "q",
     "貓" => "u",
     "貔" => "u",
     "貕" => "u",
     "貗" => "u",
     "貘" => "q",
     "貘" => "u",
     "貙" => "u",
     "貚" => "u",
     "貜" => "u",
     "辭" => "g",
     "迎" => "f",
     "迗" => "g",
     "迗" => "p",
     "逕" => "s",
     "逕" => "u",
     "逸" => "n",
     "遙" => "u",
     "邁" => "r",
     "邁" => "v",
     "邈" => "u",
     "鄦" => "g",
     "鄦" => "v",
     "鄬" => "w",
     "鄬" => "y",
     "酬" => "q",
     "釉" => "m",
     "釋" => "m",
     "長" => "k",
     "隸" => "t",
     "隸" => "y",
     "雞" => "u",
     "雟" => "r",
     "靈" => "u",
     "頯" => "u",
     "頸" => "s",
     "頸" => "u",
     "颻" => "u",
     "鵛" => "s",
     "鵛" => "u",
     "鵡" => "w",
     "鵵" => "n",
     "鷂" => "u",
     "鷡" => "g",
     "鷡" => "v",
     "鷮" => "g",
     "鷮" => "p",
     "丳" => "r",
     "侯" => "p",
     "兜" => "p",
     "典" => "r",
     "勞" => "r",
     "勞" => "s",
     "勵" => "l",
     "匯" => "w",
     "壽" => "y",
     "契" => "h",
     "富" => "n",
     "對" => "u",
     "對" => "w",
     "己" => "g",
     "巽" => "o",
     "帶" => "s",
     "幫" => "h",
     "幫" => "y",
     "後" => "i",
     "後" => "m",
     "恝" => "h",
     "慇" => "p",
     "懟" => "u",
     "挈" => "h",
     "斷" => "l",
     "斷" => "m",
     "斷" => "w",
     "於" => "u",
     "曲" => "r",
     "栔" => "h",
     "榮" => "r",
     "榮" => "s",
     "樂" => "p",
     "樂" => "r",
     "樂" => "w",
     "款" => "y",
     "殷" => "p",
     "洯" => "h",
     "熒" => "r",
     "燛" => "r",
     "營" => "r",
     "營" => "s",
     "燮" => "i",
     "燾" => "y",
     "犖" => "r",
     "瑩" => "r",
     "發" => "j",
     "真" => "j",
     "眾" => "p",
     "砉" => "h",
     "絜" => "h",
     "縈" => "r",
     "罪" => "u",
     "罵" => "o",
     "翾" => "o",
     "胡" => "j",
     "胥" => "y",
     "脊" => "r",
     "脊" => "w",
     "臦" => "r",
     "臩" => "r",
     "艷" => "i",
     "艷" => "r",
     "蛋" => "y",
     "蛪" => "h",
     "螢" => "r",
     "觢" => "h",
     "豊" => "r",
     "豐" => "i",
     "豔" => "i",
     "豔" => "r",
     "買" => "m",
     "買" => "y",
     "贏" => "x",
     "農" => "n",
     "農" => "r",
     "農" => "t",
     "遍" => "m",
     "選" => "o",
     "選" => "s",
     "還" => "o",
     "酆" => "i",
     "酆" => "r",
     "顧" => "l",
     "飆" => "r",
     "飛" => "l",
     "飛" => "z",
     "鶯" => "r",
     "鷶" => "m",
     "齧" => "h",
     "兒" => "i",
     "動" => "t",
     "吞" => "p",
     "喬" => "p",
     "夭" => "p",
     "就" => "l",
     "幵" => "k",
     "幹" => "j",
     "幾" => "w",
     "床" => "l",
     "忝" => "p",
     "教" => "x",
     "教" => "y",
     "敵" => "l",
     "敵" => "x",
     "敿" => "p",
     "旁" => "l",
     "昋" => "p",
     "桼" => "t",
     "機" => "t",
     "烎" => "k",
     "無" => "v",
     "甒" => "v",
     "盥" => "w",
     "艦" => "z",
     "蚕" => "p",
     "蠶" => "k",
     "蠶" => "p",
     "貂" => "u",
     "賚" => "l",
     "迗" => "p",
     "適" => "l",
     "適" => "x",
     "郵" => "i",
     "鄦" => "v",
     "鷡" => "v",
     "鷮" => "p",
     "鷲" => "l",
     "麥" => "h",
     "麥" => "l",
     "麧" => "l",
     "麩" => "l",
     "麭" => "l",
     "麮" => "l",
     "麰" => "l",
     "麴" => "l",
     "麵" => "h",
     "麵" => "l",
     "麵" => "t",
     "麶" => "l",
     "麷" => "l",
     "夔" => "r",
     "導" => "o",
     "巷" => "r",
     "幫" => "y",
     "很" => "m",
     "憂" => "t",
     "憂" => "y",
     "懼" => "q",
     "摮" => "y",
     "敖" => "y",
     "煮" => "y",
     "熬" => "y",
     "獒" => "y",
     "皴" => "u",
     "睹" => "m",
     "睹" => "y",
     "翥" => "y",
     "者" => "y",
     "聱" => "y",
     "螯" => "y",
     "表" => "v",
     "謷" => "y",
     "贅" => "y",
     "逡" => "u",
     "遨" => "y",
     "都" => "y",
     "鏊" => "y",
     "驁" => "y",
     "驚" => "n",
     "驚" => "r",
     "鰲" => "y",
     "麥" => "l",
     "麵" => "l",
     "麵" => "t",
     "鼇" => "y",
     "奱" => "s",
     "孌" => "l",
     "孌" => "s",
     "孿" => "l",
     "孿" => "s",
     "巒" => "l",
     "巒" => "s",
     "彎" => "l",
     "彎" => "s",
     "後" => "m",
     "憨" => "t",
     "應" => "l",
     "戀" => "l",
     "戀" => "s",
     "掀" => "j",
     "攣" => "l",
     "攣" => "s",
     "敢" => "t",
     "曫" => "l",
     "曫" => "s",
     "曳" => "q",
     "欒" => "l",
     "欒" => "s",
     "矕" => "l",
     "矕" => "s",
     "羋" => "r",
     "羋" => "y",
     "臠" => "l",
     "臠" => "s",
     "舊" => "r",
     "艷" => "r",
     "蠻" => "l",
     "蠻" => "s",
     "託" => "j",
     "諸" => "x",
     "護" => "j",
     "護" => "r",
     "變" => "l",
     "變" => "s",
     "豔" => "r",
     "跡" => "l",
     "跡" => "o",
     "這" => "w",
     "酆" => "r",
     "鑾" => "l",
     "鑾" => "s",
     "電" => "u",
     "鸞" => "l",
     "鸞" => "s",
     "世" => "s",
     "事" => "v",
     "剌" => "v",
     "剚" => "v",
     "剸" => "x",
     "勢" => "y",
     "南" => "n",
     "吏" => "v",
     "喪" => "w",
     "囊" => "v",
     "執" => "y",
     "報" => "y",
     "墊" => "y",
     "專" => "q",
     "專" => "x",
     "慹" => "y",
     "戣" => "k",
     "挲" => "w",
     "授" => "k",
     "揧" => "v",
     "摯" => "y",
     "操" => "x",
     "敕" => "v",
     "整" => "v",
     "整" => "z",
     "束" => "v",
     "槷" => "y",
     "橐" => "v",
     "櫜" => "v",
     "欶" => "v",
     "然" => "n",
     "然" => "u",
     "熱" => "y",
     "獻" => "n",
     "獻" => "z",
     "疌" => "z",
     "癸" => "k",
     "皾" => "y",
     "盩" => "y",
     "縶" => "y",
     "蟄" => "y",
     "蟗" => "v",
     "蠹" => "v",
     "衷" => "l",
     "衷" => "v",
     "覿" => "y",
     "誓" => "o",
     "謺" => "y",
     "護" => "r",
     "賣" => "x",
     "賣" => "y",
     "賴" => "v",
     "贄" => "y",
     "踅" => "t",
     "速" => "v",
     "進" => "v",
     "遫" => "v",
     "鄈" => "k",
     "鄟" => "x",
     "鄧" => "u",
     "雜" => "k",
     "騺" => "y",
     "鶒" => "v",
     "鷒" => "x",
     "鷘" => "v",
     "鷙" => "y",
     "丘" => "p",
     "丸" => "z",
     "乒" => "p",
     "乓" => "p",
     "亟" => "w",
     "兵" => "p",
     "冠" => "n",
     "函" => "w",
     "卍" => "z",
     "噩" => "o",
     "噩" => "t",
     "屔" => "p",
     "岳" => "p",
     "徵" => "m",
     "懲" => "m",
     "斢" => "r",
     "潛" => "w",
     "盾" => "x",
     "瞂" => "x",
     "薦" => "r",
     "蠶" => "p",
     "賞" => "s",
     "質" => "x",
     "贊" => "s",
     "趣" => "y",
     "遁" => "x",
     "邱" => "p",
     "開" => "m",
     "靠" => "s",
     "鶞" => "x",
     "鷬" => "r",
     "黃" => "r",
     "黈" => "r",
     "剷" => "w",
     "原" => "y",
     "厭" => "y",
     "厴" => "y",
     "商" => "x",
     "喿" => "o",
     "塵" => "s",
     "壓" => "y",
     "壟" => "y",
     "奊" => "y",
     "嬮" => "y",
     "孌" => "s",
     "孳" => "r",
     "孿" => "s",
     "巒" => "s",
     "市" => "n",
     "店" => "z",
     "彎" => "s",
     "彥" => "w",
     "愿" => "y",
     "慈" => "r",
     "戀" => "s",
     "攣" => "s",
     "敲" => "q",
     "敵" => "x",
     "斷" => "m",
     "斷" => "w",
     "曫" => "s",
     "欒" => "s",
     "歊" => "q",
     "毃" => "q",
     "氈" => "m",
     "灰" => "x",
     "甋" => "x",
     "產" => "w",
     "盔" => "x",
     "矕" => "s",
     "碼" => "t",
     "礙" => "v",
     "礬" => "t",
     "离" => "w",
     "膏" => "q",
     "臠" => "s",
     "虱" => "z",
     "蠻" => "s",
     "衷" => "v",
     "袬" => "t",
     "變" => "s",
     "跡" => "o",
     "路" => "o",
     "遞" => "t",
     "適" => "x",
     "遼" => "w",
     "鄗" => "q",
     "鑾" => "s",
     "離" => "w",
     "靨" => "y",
     "顏" => "w",
     "願" => "y",
     "飛" => "z",
     "饜" => "y",
     "高" => "q",
     "髜" => "q",
     "魘" => "y",
     "鷺" => "o",
     "鸞" => "s",
     "麵" => "t",
     "麼" => "p",
     "黶" => "y",
     "兕" => "u",
     "冊" => "n",
     "凹" => "u",
     "刪" => "n",
     "務" => "p",
     "嬰" => "s",
     "徐" => "x",
     "復" => "v",
     "微" => "r",
     "懣" => "w",
     "斷" => "w",
     "滿" => "w",
     "甖" => "s",
     "睹" => "y",
     "糕" => "x",
     "罌" => "s",
     "衍" => "w",
     "衖" => "r",
     "街" => "s",
     "衙" => "w",
     "衛" => "p",
     "衡" => "u",
     "譻" => "s",
     "買" => "y",
     "賏" => "s",
     "邊" => "p",
     "鄰" => "x",
     "闊" => "w",
     "鸚" => "s",
     "兔" => "p",
     "密" => "x",
     "憼" => "r",
     "擎" => "r",
     "敬" => "r",
     "檠" => "r",
     "災" => "s",
     "然" => "u",
     "爾" => "r",
     "獻" => "z",
     "璽" => "r",
     "甔" => "v",
     "當" => "s",
     "簾" => "z",
     "網" => "s",
     "網" => "x",
     "蜜" => "x",
     "蟼" => "r",
     "詹" => "v",
     "警" => "r",
     "農" => "r",
     "農" => "t",
     "運" => "t",
     "邇" => "r",
     "驚" => "r",
     "剮" => "q",
     "劉" => "w",
     "噩" => "t",
     "戰" => "z",
     "斲" => "x",
     "異" => "q",
     "籲" => "z",
     "聽" => "r",
     "葉" => "r",
     "跟" => "q",
     "選" => "s",
     "雖" => "u",
     "響" => "w",
     "響" => "x",
     "么" => "w",
     "個" => "v",
     "們" => "q",
     "偵" => "z",
     "傑" => "t",
     "儲" => "x",
     "凡" => "r",
     "及" => "r",
     "帥" => "r",
     "帥" => "y",
     "師" => "r",
     "師" => "y",
     "幣" => "s",
     "樂" => "r",
     "樂" => "w",
     "歸" => "r",
     "歸" => "y",
     "粵" => "u",
     "綿" => "s",
     "胤" => "r",
     "興" => "s",
     "華" => "r",
     "處" => "z",
     "貌" => "u",
     "釁" => "s",
     "體" => "q",
     "鬼" => "v",
     "鬾" => "v",
     "鬿" => "v",
     "魁" => "v",
     "魃" => "v",
     "魅" => "v",
     "魆" => "v",
     "魈" => "v",
     "魊" => "v",
     "魋" => "v",
     "魌" => "v",
     "魍" => "v",
     "魎" => "v",
     "魑" => "v",
     "魒" => "v",
     "魕" => "v",
     "魖" => "v",
     "剺" => "y",
     "卓" => "z",
     "堯" => "y",
     "壘" => "u",
     "嫠" => "y",
     "孷" => "y",
     "專" => "x",
     "悲" => "r",
     "擊" => "y",
     "斄" => "y",
     "替" => "t",
     "未" => "y",
     "末" => "y",
     "果" => "r",
     "氂" => "y",
     "漦" => "y",
     "燅" => "y",
     "犛" => "y",
     "獲" => "r",
     "疊" => "u",
     "繳" => "s",
     "翹" => "y",
     "蒙" => "r",
     "貓" => "u",
     "貘" => "u",
     "逴" => "z",
     "釐" => "y",
     "骯" => "u",
     "髒" => "u",
     "鵫" => "z",
     "點" => "z",
     "凸" => "t",
     "勞" => "s",
     "勸" => "u",
     "勸" => "v",
     "夃" => "w",
     "夢" => "t",
     "帥" => "y",
     "師" => "y",
     "恧" => "t",
     "戁" => "u",
     "戤" => "w",
     "榮" => "s",
     "樂" => "w",
     "歡" => "u",
     "歡" => "v",
     "歸" => "y",
     "營" => "s",
     "盈" => "w",
     "盜" => "w",
     "節" => "z",
     "羋" => "y",
     "考" => "y",
     "而" => "t",
     "耍" => "t",
     "耎" => "t",
     "耏" => "t",
     "耐" => "t",
     "聖" => "u",
     "脊" => "w",
     "艱" => "u",
     "萬" => "v",
     "蓄" => "x",
     "薄" => "x",
     "藉" => "x",
     "虧" => "z",
     "蝨" => "z",
     "蠆" => "v",
     "覽" => "v",
     "觀" => "u",
     "觀" => "v",
     "農" => "t",
     "迅" => "z",
     "遠" => "y",
     "邁" => "v",
     "難" => "u",
     "鳵" => "z",
     "鴯" => "t",
     "鶺" => "w",
     "鹽" => "y",
     "剄" => "u",
     "勁" => "u",
     "巠" => "u",
     "巰" => "u",
     "淑" => "w",
     "紙" => "x",
     "絲" => "w",
     "綠" => "x",
     "網" => "x",
     "逕" => "u",
     "頸" => "u",
     "鵛" => "u",
     "鷥" => "w",
     "恿" => "w",
     "憂" => "y",
     "臺" => "y",
     "鄾" => "y",
     "隸" => "y",
     "勸" => "v",
     "對" => "w",
     "戲" => "z",
     "歡" => "v",
     "為" => "w",
     "膚" => "z",
     "膳" => "x",
     "觀" => "v",
     "越" => "y",
     "雙" => "v",
     "整" => "z",
     "卻" => "y",
     "嚮" => "x",
     "孑" => "z",
     "孓" => "z",
     "蠁" => "x",
     "郤" => "y",
     "鄉" => "x",
     "鄬" => "y",
     "響" => "x",
     "饗" => "x",
     "教" => "y",
     "牙" => "y",
     "賣" => "y",
     "迓" => "y",
     "邪" => "y",
     "雅" => "y",
     "鴉" => "y",
     "趨" => "z"}

# 正常字根加詞
def phra(s)
  ch = s.split(//)
  if ch.length == 3
    H[ch[0]] + H[ch[1]] + H[ch[2]] + ', '
  elsif ch.length >= 4
    H[ch[0]] + H[ch[1]] + H[ch[2]] + H[ch[3]] + ', '
  else
    puts "Not support!"
    exit
  end
end

# 簡速字根加詞
def simp(s)
  ch = s.split(//)
  if ch.length == 3
    if S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2])
      S[ch[0]] + S[ch[1]] + S[ch[2]] + ', '
    elsif S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2])
      S[ch[0]] + S[ch[1]] + H[ch[2]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2])
      S[ch[0]] + H[ch[1]] + S[ch[2]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2])
      H[ch[0]] + S[ch[1]] + S[ch[2]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && !S.key?(ch[2])
      S[ch[0]] + H[ch[1]] + H[ch[2]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2])
      H[ch[0]] + S[ch[1]] + H[ch[2]] + ', '
    elsif !S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2])
      H[ch[0]] + H[ch[1]] + S[ch[2]] + ', '
    end
  elsif ch.length >= 4
    if S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2]) && S.key?(ch[3])
      S[ch[0]] + S[ch[1]] + S[ch[2]] + S[ch[3]] + ', '
    elsif S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2]) && !S.key?(ch[3])
      S[ch[0]] + S[ch[1]] + S[ch[2]] + H[ch[3]] + ', '
    elsif S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2]) && S.key?(ch[3])
      S[ch[0]] + S[ch[1]] + H[ch[2]] + S[ch[3]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2]) && S.key?(ch[3])
      S[ch[0]] + H[ch[1]] + S[ch[2]] + S[ch[3]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2]) && S.key?(ch[3])
      H[ch[0]] + S[ch[1]] + S[ch[2]] + S[ch[3]] + ', '
    elsif S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2]) && !S.key?(ch[3])
      S[ch[0]] + S[ch[1]] + H[ch[2]] + H[ch[3]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2]) && !S.key?(ch[3])
      S[ch[0]] + H[ch[1]] + S[ch[2]] + H[ch[3]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && S.key?(ch[2]) && !S.key?(ch[3])
      H[ch[0]] + S[ch[1]] + S[ch[2]] + H[ch[3]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && !S.key?(ch[2]) && S.key?(ch[3])
      S[ch[0]] + H[ch[1]] + H[ch[2]] + S[ch[3]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2]) && S.key?(ch[3])
      H[ch[0]] + S[ch[1]] + H[ch[2]] + S[ch[3]] + ', '
    elsif !S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2]) && S.key?(ch[3])
      H[ch[0]] + H[ch[1]] + S[ch[2]] + S[ch[3]] + ', '
    elsif S.key?(ch[0]) && !S.key?(ch[1]) && !S.key?(ch[2]) && !S.key?(ch[3])
      S[ch[0]] + H[ch[1]] + H[ch[2]] + H[ch[3]] + ', '
    elsif !S.key?(ch[0]) && !S.key?(ch[1]) && !S.key?(ch[2]) && S.key?(ch[3])
      H[ch[0]] + H[ch[1]] + H[ch[2]] + S[ch[3]] + ', '
    elsif !S.key?(ch[0]) && S.key?(ch[1]) && !S.key?(ch[2]) && !S.key?(ch[3])
      H[ch[0]] + S[ch[1]] + H[ch[2]] + H[ch[3]] + ', '
    elsif !S.key?(ch[0]) && !S.key?(ch[1]) && S.key?(ch[2]) && !S.key?(ch[3])
      H[ch[0]] + H[ch[1]] + S[ch[2]] + H[ch[3]] + ', '
    end
  end
end

# file manipulation
#def fmanipu()
#  if !test ?f, "noseeing.gtab.orig"
#    File.cp("noseeing.gtab", "noseeing.gtab.orig")
#  end
#  `gtab-merge noseeing.gtab noseeadd.tmp noseeing.add.gtab`
#  File.mv("noseeing.gtab", "noseeing.gtab.noseeadd")
#  File.mv("noseeing.add.gtab", "noseeing.gtab")
#end

# main()
if locale =~ /UTF/i
  pname = File.basename($0)
  if ARGV.length == 0 or ARGV[0] =~ /-*[Hh].*/
    puts
    puts "Usage: #{pname} phrase"
    puts
    exit
  elsif ARGV.length == 1
    Dir.chdir(ghome)
    f = open("noseeing.gtab.append", "a")
    key1 = phra(ARGV[0]) + ARGV[0]
    if simp(ARGV[0])
      key2 = simp(ARGV[0]) + ARGV[0]
      f.puts(key2)
    end
    f.puts(key1)
    f.close
  else
    puts
    puts "Usage: #{pname} phrase"
    puts
  end
else
  puts "I need UTF-8 locale."
  exit
end
