#!/bin/bash

clear
echo ""
echo "[34;1m#########################################"
echo "#                                       #"
echo "# DEMO 1 : Run GPFS in DRBL environment #"
echo "#                                       #"
echo "#########################################"
echo "-----------------------------------------"
read

echo ""
echo "##################################"
echo "# 1. Edit GPFS nodes information #"
echo "##################################[m"
echo "[32;1mcat gpfs.nodes[m"
read
cat gpfs.nodes
read

echo ""
echo "[34;1m##############################"
echo "# 2. Config GPFS Environment #"
echo "##############################[0m"
echo "[32;1mmmcrcluster -N gpfs.nodes -s gpfs00 -p gpfs01 -r /usr/bin/ssh -R /usr/bin/scp[0m"
read
mmcrcluster -N gpfs.nodes -s gpfs00 -p gpfs01 -r /usr/bin/ssh -R /usr/bin/scp 
read
clear

echo ""
echo "[34;1m#################################"
echo "# 3. Check mmcrcluster command  #"
echo "#################################[0m"
echo "[32;1mmmlscluster[0m"
read
mmlscluster
read
clear

echo ""
echo "[34;1m####################################"
echo "# 4. Edit GPFS disks information   #"
echo "####################################[0m"
echo "[32;1mcat gpfs.disks[0m"
read
cp gpfs.disks.backup gpfs.disks
cat gpfs.disks
read

echo ""
echo "[34;1m##############################"
echo "# 5. Create GPFS NSD         #"
echo "##############################[0m"
echo "[32;1mmmcrnsd -F gpfs.disks -v no[0m"
read
mmcrnsd -F gpfs.disks -v no
read
clear

echo ""
echo "[34;1m###########################"
echo "# 6. Check GPFS NSD       #"
echo "###########################[0m"
echo "[32;1mmmlsnsd[0m"
read
mmlsnsd
read
clear

echo ""
echo "[34;1m###########################"
echo "# 7. Startup GPFS daemon  #"
echo "###########################[0m"
echo "[32;1mmmstartup -a[0m"
read
mmstartup -a
echo "GPFS Daemon is runnung"
read
clear

echo ""
echo "[34;1m###########################"
echo "# 8. Check GPFS daemon    #"
echo "###########################[0m"
echo "[32;1mps aux | grep mm[0m"
read
ps aux | grep mm
read
echo "[32;1mmmgetstate -a[0m"
read
mmgetstate -a
read
clear

echo ""
echo "[34;1m##############################"
echo "# 9. Create GPFS File System #"
echo "##############################[0m"
echo "[32;1mmmcrfs /home/gpfs_mount /dev/gpfs0 -F gpfs.disks -B 1M -m 2 -r 2 -v no[0m"
read
mkdir /home/gpfs_mount
mmcrfs /home/gpfs_mount /dev/gpfs0 -F gpfs.disks -B 1M -m 2 -r 2 -v no
read
clear

echo ""
echo "[34;1m###############################"
echo "# 10. Mount GPFS File System  #"
echo "###############################[0m"
echo "[32;1mmmmount gpfs0 /home/gpfs_mount -a[0m"
read
mmmount gpfs0 /home/gpfs_mount -a
echo "Mounting OK"
read
clear

echo "[34;1m###############################"
echo "# 11. Check GPFS File System  #"
echo "###############################[0m"
echo "[32;1mmmdf gpfs0[0m"
read
mmdf gpfs0
read

echo ""
echo "[34;1m###############################"
echo "# 12. Check GPFS File System  #"
echo "###############################[0m"
echo "[32;1mdf -h[0m"
read
df -h
read



