#!/bin/bash
IP_LIST="192.168.100.1 192.168.100.2 192.168.100.4 192.168.100.5 192.168.100.11 192.168.100.12 192.168.100.13 192.168.100.14 192.168.100.21 192.168.100.22 192.168.100.24 192.168.100.25"
export LANG=en_US
export LC_ALL=en_US
log_start=$(date +"%y%m%d-%H%M%S_")
log_file="/var/log/${log_start}diskless-benchmark.log"
status_file="/var/log/${log_start}diskless-benchmark-status.log"
echo "0. Rebooting...." > $log_file
echo "0. Rebooting...."
/opt/drbl/sbin/dcs -h "$IP_LIST" remote-linux-txt 2>&1 > $status_file
source /home/jazz/.bash_aliases
up-host-a > /root/.dsh/machines.list

function mydsh()
{
  dsh -a -c "date > /var/log/$2.time.$1; /usr/bin/time -o /var/log/$2.time $3; cat /var/log/$2.time >> /var/log/$2.time.$1; date >> /var/log/$2.time.$1" 2>&1 >> $status_file
}

echo "START Disk-less Benchmark ...." >> $log_file
for ((i=1;i<=1;i++)); do
  echo "[$i] 1. Booting...." >> $log_file
  echo "[$i] 1. Booting...."
  dsh -a -c "reboot" 2>&1 >> $status_file
  `date >> $log_file`
  sleep 120
  dsh -a -c "echo 3 > /proc/sys/vm/drop_caches"
  echo "[$i] 2. Running dd ...." >> $log_file
  echo "[$i] 2. Running dd ...."
  `date >> $log_file`
  mydsh "$i" "dd" "dd if=/dev/zero of=/root/E2CC.img bs=1M count=500"
  `date >> $log_file`
  sleep 120
  echo "[$i] 3. Running tar ...." >> $log_file
  echo "[$i] 3. Running tar ...."
  `date >> $log_file`
  mydsh "$i" "tar" "tar zcvf /root/E2CC.img.tar.gz /root/E2CC.img"
  `date >> $log_file`
  sleep 120
  echo "[$i] 4. Running bonnie++ ...." >> $log_file
  echo "[$i] 4. Running bonnie++ ...."
  `date >> $log_file`
  mydsh "$i" "bonnie++" "bonnie++ -u root -d /root -s 500"
  `date >> $log_file`
  sleep 120
  echo "[$i] *. Download Kernel ...." >> $log_file
  echo "[$i] *. Download Kernel ...."
  mydsh "$i" "download-kernel" "wget -O /tmp/linux-2.6.30.tar.bz2 http://www.kernel.org/pub/linux/kernel/v2.6/linux-2.6.30.tar.bz2"
  echo "[$i] *. Extract Kernel ...." >> $log_file
  echo "[$i] *. Extract Kernel ...."
  mydsh "$i" "extrac-kernel" "tar jxvf /tmp/linux-2.6.30.tar.bz2 -C /tmp"
  mydsh "$i" "make-allnoconf" "make -C /tmp/linux-2.6.30 allnoconfig"
  echo "[$i] 5. Running make -j 1 ...." >> $log_file
  echo "[$i] 5. Running make -j 1 ...."
  mydsh "$i" "make-clean" "make clean -C /tmp/linux-2.6.30"
  `date >> $log_file`
  mydsh "$i" "make-j1" "make -j 1 -C /tmp/linux-2.6.30"
  `date >> $log_file`
  sleep 120
  echo "[$i] 6. Running make -j 2 ...." >> $log_file
  echo "[$i] 6. Running make -j 2 ...."
  mydsh "$i" "make-clean" "make clean -C /tmp/linux-2.6.30"
  `date >> $log_file`
  mydsh "$i" "make-j2" "make -j 2 -C /tmp/linux-2.6.30"
  `date >> $log_file`
  sleep 120
  echo "[$i] 7. Running make -j 3 ...." >> $log_file
  echo "[$i] 7. Running make -j 3 ...."
  mydsh "$i" "make-clean" "make clean -C /tmp/linux-2.6.30"
  `date >> $log_file`
  mydsh "$i" "make-j3" "make -j 3 -C /tmp/linux-2.6.30"
  `date >> $log_file`
  sleep 120
  echo "[$i] 8. Running make -j 4 ...." >> $log_file
  echo "[$i] 8. Running make -j 4 ...."
  mydsh "$i" "make-clean" "make clean -C /tmp/linux-2.6.30"
  `date >> $log_file`
  mydsh "$i" "make-j4" "make -j 4 -C /tmp/linux-2.6.30"
  `date >> $log_file`
done
