dojo.declare("Main", wm.Page, {
  start: function() {
    if (GBrowserIsCompatible()) {
     var map = new GMap2(dojo.byId(this.map).domNode);    // 透過 Dojo 取得 DOM 中,名稱為 map 的元件
     map.addControl(new GLargeMapControl());          // 加入左上角比例尺規控制列
     map.addControl(new GScaleControl());            // 加入左下角比例尺狀態列
     map.addControl(new GMapTypeControl());           // 加入右上角"地圖","衛星","混合地圖"按鈕
     map.setCenter(new GLatLng(23.8,121), 7);         // 設定預設經緯度北緯 23.8, 東經 121, 預設比例尺 100 公里(7)
     map.setMapType(G_SATELLITE_MAP);              // 設定預設底圖為"衛星"
    }
    var request = GXmlHttp.create();                      // 產生一個非同步的 AJAX XMLHttp 物件
    var GetDataXml="getdeepstaxml.xml";
    request.open("GET",GetDataXml, true);                    // 用 XMLHttp 物件去開啟 http://deepsea.biodiv.tw/getdeepstaxml.asp
    request.onreadystatechange = function() {                 // 定義 XMLHttp 有狀態改變的事件處理函數 callback function
     if (request.readyState == 4) {                     // XMLHttp 的狀態是 Ready (4) 繼續處理 Server 傳回的 XML 資料
      var xmlDoc = request.responseXML;                   // xmlDoc = 回傳的 XML 資料
      var markers = xmlDoc.documentElement.getElementsByTagName("marker");  // 取出名稱為 marker 的 xml 元件, 結果是陣列
      for (var i = 0; i < markers.length; i++) {
       var points2 = [];                          // 宣告一個空的陣列 point2 來存起始與結束座標點
       // 把 lat1 跟 lng1 塞進起始座標點 GLatLng 物件
       points2.push(new GLatLng(parseFloat(markers[i].getAttribute("lat1")),parseFloat(markers[i].getAttribute("lng1"))));
       // 把 lat2 跟 lng2 塞進起始座標點 GLatLng 物件
       points2.push(new GLatLng(parseFloat(markers[i].getAttribute("lat2")),parseFloat(markers[i].getAttribute("lng2"))));
       // 用 point2 產生 GPolyline 物件,畫從 point2[2] 到 point2[1] 的線條
       // - 參考 http://code.google.com/apis/maps/documentation/reference.html#GPolyline
       // - GPolyline(座標點, 顏色, 線條粗細(pixel), 透明度(0: 反鋸齒, 1: 半透明))
       // 然後用 addOverlay 函數把線條疊到地圖上
       map.addOverlay(new GPolyline(points2,'#FF0000',2,1));
      }
     }
    }
    request.send(null);                                      // 送出 XMLHttp 物件的要求
  },
  _end: 0
});