#include "GSEXmlParser.h"

void   Data::Dump()
{
    LOG("Sample iid: " << iid);
    LOG("Source: " << source);
    LOG("Supplementary-Data Type: " << supp_type);
    LOG("Supplementary-Data: " << supp_data);
    LOG("\n-------- Description --------");
    for(int i = 0; i < desc.GetCount(); i++)
        LOG("   " << desc.GetKey(i) << " ..... " << desc[i]);
    LOG("-------- Description --------\n");
}

String   Data::ToXML()
{
    String descs; //descriptions
    for(int i = 0; i < desc.GetCount(); i++)
        descs << XmlTag("Description")("name", desc.GetKey(i)).Text(desc[i]);

    return XmlTag("Sample")("iid", iid)(
                     XmlTag("Source").Text(source) + 
                     XmlTag("Supplementary-Data")("type", supp_type).Text(supp_data) +
                     XmlTag("Descriptions") (descs) 
                 );
}

String Data::ToTSV()
{
	String tsv, tab, nl;
	tab = "\t";
	nl = "\n";
	tsv = source + tab + "Sample-iid" + tab + iid + nl +
	      source + tab + "Supplementary-Data:" + supp_type + tab + supp_data + nl;
	for(int i = 0; i < desc.GetCount(); i++)      
	    tsv += source + tab + "Description:" + desc.GetKey(i) + tab + desc[i] + nl; 
	      
	return tsv;
}

void   GSEParser::Dump()
{
	LOG("\n======== GSE XML ========\n");
	for (int i=0; i < data.GetCount(); i++) {
		data[i].Dump();
	}
}

void GSEParser::LoadXML(String filename) {
	//Load XML File
    //LOG("\n---- GSE 2109 XML ----");
    
    String gse;
    /*
    Cout() << filename << "\n";
    String fn;
    fn = GetDataFile(filename);
    Cout() << fn << "\n";
    */
    gse = LoadFile(filename);
    //Cout() << gse << "\n";
    XmlNode rnode = ParseXML(gse);
    
    //Clear Data Array
    data.Clear();
    
    //Get Root Node    
    const XmlNode &xnode = rnode["MINiML"];
    
    //Save Data Array, one by one
    Vector<String> lines, des;
    String str, lstr, rstr;
    for (int i=0; i<xnode.GetCount(); i++) {
       if (xnode[i].GetTag()=="Sample") {  
          //LOG("Sample(iid):" << xnode[i].Attr("iid"));
          //LOG("Source:" << xnode[i]["Channel"]["Source"].GatherText());
          //LOG("\n-------- Description --------");
          Data d;
          d.iid = xnode[i].Attr("iid");
          d.source = xnode[i]["Channel"]["Source"].GatherText();
          d.supp_type = xnode[i]["Supplementary-Data"].Attr("type");
          d.supp_data = xnode[i]["Supplementary-Data"].GatherText();
          lines = Split(xnode[i]["Description"].GatherText(),'\n');
          for (int j=0; j<lines.GetCount(); j++) {
              if (lines[j].Find("=") > -1) {
                  des = Split(lines[j], '=');
              } else if (lines[j].Find(":") > -1) {
                  des = Split(lines[j], ':');
              }
              if (des.GetCount()>1) {
                  lstr = TrimSpace(des[0]);
                  rstr = TrimSpace(des[1]);                  
                  //LOG(lstr << ":" << rstr);
                  String& v = d.desc.GetAdd(lstr);
                  v = rstr;
              }
          }
          data.Add(d);
          //LOG("-------- Description --------\n");
       }
    }
    //    
}

String   GSEParser::ToXML()
{
	String datas; // Datas
    for (int i = 0; i < data.GetCount(); i++) {
        datas << data[i].ToXML();
    }
    return XmlHeader() + XmlTag("GSEFAMILY")(datas);
}

String   GSEParser::ToTSV()
{
	String tsv, tab; 
	tab = "\t";
	tsv = "# rowkey" + tab + "columnkey" + tab + "value\n";
	
	for (int i = 0; i < data.GetCount(); i++) {
		tsv << data[i].ToTSV();
	}
	return tsv;
}

void   GSEParser::ToMySQL(String username, String password, String db, String db_ip)
{
	//
	MySqlSession session;
	if(!session.Connect("gse", "nchcnchc", "gse", "localhost")) {
		printf("Can't connect with MySql\n");
		return;
	}
	Sql sql(session);
	sql.Execute("use gse");	
	String cmd;
	//
	Cout() << "Total Record Count:" << data.GetCount() << "\n";
	int sid;
    int did;
    String name;	
	for (int i = 0; i < data.GetCount(); i++) {		
		// check gsefamily record
		cmd = "select * from gsefamily where iid = \"" + data[i].iid + "\"";
		sql.Execute(cmd);		
		if (sql.GetRowsProcessed()>0) {
			Cout() << "Warnning: IID ["+data[i].iid+"] is exist." << "\n";			
		} else {
			// add a new gsefamily record
			cmd = "insert into gsefamily (iid,source) values (\""+data[i].iid+"\",\""+data[i].source+"\");";
			if (!sql.Execute(cmd)) {
				Cout() << "Execution Error: " << sql.GetErrorCodeString() << "  Cmd: " << sql.GetErrorStatement() << "\n";			
			}
		}
		//Cout() << "IID ["+data[i].iid+"]" << "\n";
		
		sid = 0;
		// check supplementary		
        cmd = "select sid from supplementary where type = \"" + data[i].supp_type + "\";";        
        sql.Execute(cmd);        
        if (sql.GetRowsProcessed()==0) {  
            //new a supplementary record
            cmd = "insert into supplementary (type) values (\"" + data[i].supp_type + "\");";            
            if (!sql.Execute(cmd)) {
                Cout() << "Execution Error: " << sql.GetErrorCode() << "  Cmd: " << sql.GetErrorStatement() << "\n";			
            }       
            sid = sql.GetInsertedId();     
        } else {
            if (sql.Fetch())
               sid = sql[0];
            //Cout() << "sid: " << sid << "\n";
        }
        
        //new a supplementary-map record        
        cmd = "insert into `supplementary-map` (iid,sid,value) values (\""+data[i].iid+"\",\""+AsString(sid)+"\",\""+data[i].supp_data+"\")";        
        if (!sql.Execute(cmd)) {            
            Cout() << "\nExecution Error: " << sql.GetErrorCode() << "  Cmd: " << sql.GetErrorStatement() << "\n";			
        }
                       
        //Cout() << "data[" << i << "].desc.GetCount() = " << data[i].desc.GetCount() << "\n";
        VectorMap<String, String> desc = data[i].desc;
        for (int j=0; j<desc.GetCount(); j++) {
            
			// check description
			name = desc.GetKey(j);			
	        cmd = "select did from description where name = \"" + name + "\"";
	        sql.Execute(cmd);
	        
	        did = 0;
	        if (sql.GetRowsProcessed()==0) {  
	            //new a description record
	            cmd = "insert into description (name) values (\"" + name + "\");";
	            if (!sql.Execute(cmd)) {
	                Cout() << "Execution Error: " << sql.GetErrorCodeString() << "  Cmd: " << sql.GetErrorStatement() << "\n";			
	            }   
	            did = sql.GetInsertedId();         
	        } else {
	            if (sql.Fetch())
	            	did = sql[0];
	        }
	        
	        cmd = "insert into `description-map` (iid,did,value) values (\"" + data[i].iid + "\",\"" + AsString(did) + "\",\"" + desc.Get(name) + "\")";
	        if (!sql.Execute(cmd)) {
	            Cout() << "Execution Error: " << sql.GetErrorCodeString() << "  Cmd: " << sql.GetErrorStatement() << "\n";			
	        }
	        	        
        }
        
	}	
}

String TrimSpace(String str) {
	while (str.StartsWith(" ") && str.GetLength()) {
		str = str.Mid(1);
	}
	while (str.EndsWith(" ") && str.GetLength()) {
		str = str.Left(str.GetLength()-1);
	}
	return str;
}

CONSOLE_APP_MAIN
{
	String in, out, fmt, user, pwd, db, ip, arg_flag;
	/*
	in = "GSE2109_family.xml";
	out = "GSEFamily.tsv";
	fmt = "tsv";
	*/
	const Vector<String>& cmdline = CommandLine();
		
	for(int i = 0; i < cmdline.GetCount(); i++) {
		if (cmdline[i].StartsWith("-")){
			arg_flag = cmdline[i];			
		} else if (arg_flag.IsEqual("-i")) {
			in = cmdline[i];		
		} else if (arg_flag.IsEqual("-o")) {
			out = cmdline[i];			
		} else if (arg_flag.IsEqual("-f")) {
			fmt = cmdline[i];
		} else if (arg_flag.IsEqual("-u")) {
			user = cmdline[i];			
		} else if (arg_flag.IsEqual("-p")) {
			pwd = cmdline[i];			
		} else if (arg_flag.IsEqual("-db")) {
			db = cmdline[i];			
		} else if (arg_flag.IsEqual("-ip")) {
			ip = cmdline[i];			
		} else if (arg_flag.StartsWith("-")) {
			//Error argument
			Cout() << "Usage Error: invalid argument "<< arg_flag << "\n";
			exit(0);
		}
	}
	
	if (cmdline.GetCount()==0 || 
	    ( (fmt.IsEqual("xml") || fmt.IsEqual("tsv")) && (in.IsEmpty() || out.IsEmpty() || fmt.IsEmpty()) ) ||
	    ( fmt.IsEqual("mysql") && (in.IsEmpty() || user.IsEmpty() || db.IsEmpty() || ip.IsEmpty()) )
	   ) {
		Cout() << "# Usage #\n";
		Cout() << "For linux:   GSEXmlParser -f (xml|tsv) -i (input file) -o (output file)\n";
		Cout() << "For windows: GSEXmlParser.exe -f (xml|tsv) -i (input file) -o (output file)\n";
		Cout() << "             GSEXmlParser.exe -f (mysql) -i (input file) -u (username) -p (password) -db (database) -ip (db host)\n";
		exit(0);	
	}	
	GSEParser parser;
	parser.LoadXML(in);
	if (fmt.IsEqual("xml"))
		SaveFile(out,parser.ToXML());
	else if (fmt.IsEqual("tsv"))	{
		SaveFile(out,parser.ToTSV());
	} else if (fmt.IsEqual("mysql")) {
		parser.ToMySQL(user,pwd,db,ip);
		Cout() << "Completed.\n";
	}
	
	
	
}

