#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <time.h>

void Die(char *mess)
{
    perror(mess);
    exit(1);
}

int main(int argc, char *argv[])
{
    struct sockaddr_in recv_sockopt;
    int	   recv_sock;
    int	   recv_length = sizeof(recv_sockopt);
    int	   received;
    char   BLACK_LIST[1024];

    if (argc <= 1)
    {
	fprintf(stderr, "USAGE: %s <RECV_PORT>\n", argv[0]);
	fprintf(stderr, "Ex: %s 3838\n", argv[0]);
	exit(1);
    }

    /* Create the UDP socket to send response to icas_recv */
    if ((recv_sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0)
    {
	Die("Failed to create socket for sending black list.");
    }

    /* Construct the server sockaddr_in structure */
    memset(&recv_sockopt,  0, sizeof(recv_sockopt));      /* Clear struct */
    memset(&BLACK_LIST,    0, sizeof(BLACK_LIST));	  /* Clear string */

    // socket option of icas_send socket
    recv_sockopt.sin_family = AF_INET;                   /* Internet/IP */
    recv_sockopt.sin_addr.s_addr = htonl(INADDR_ANY);	 /* Any IP address */
    recv_sockopt.sin_port = htons(atoi(argv[1]));        /* server port */

    /* Bind the socket */
    if (bind(recv_sock, (struct sockaddr *) &recv_sockopt, recv_length) < 0)
    {
	Die("Failed to bind server socket");
    }
    fprintf(stderr,"Finished binding port #%s for icas_recv socket.\n",argv[1]);

    while(1)
    {
	if ((received = recvfrom(recv_sock, BLACK_LIST, sizeof(BLACK_LIST), 0, 
		                 (struct sockaddr *) &recv_sockopt, 
		                 (socklen_t *) &recv_length)) < 0)
	{
	    Die("Failed to receive message");
	}
	fprintf(stderr,"Received: %s\n", BLACK_LIST);
    }

    close(recv_sock);
    exit(0);
}
