import  wx, sys, os, gettext, string, time
import  wx.wizard as wiz
import  wx.lib.layoutf as layoutf

from config import main_functions,remote_functions
from remoteLinuxWizard import remoteLinuxPage, setAllClientsPage,selectClientsPage,remoteLinuxFinalPage

cat = gettext.GNUTranslations(open('../langs/%s.mo' % os.getenv('LANG')))
_ = cat.gettext


#----------------------------------------------------------------------
class MainFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, parent=None, title=_('msg_nchc_title'), pos=wx.DefaultPosition, size=(400,400))

        mainlist = []
        for i in range(0, len(main_functions)):
            mainlist.append(main_functions[i][0] + '  ' + ' --- ' + '  ' + main_functions[i][1])

        self.SetAutoLayout(True)

        self.panelA = wx.Panel(self)
        #self.panelA.SetBackgroundColour(wx.RED)
        self.panelA.SetConstraints(layoutf.Layoutf('t=t#1;l=l10#1;b%b35#1;r=r10#1',(self,)))

        self.panelB = wx.Panel(self)
        #self.panelB.SetBackgroundColour(wx.BLUE)
        self.panelB.SetConstraints(layoutf.Layoutf('t_5#2;l=l10#1;b%b85#1;r=r10#1',(self,self.panelA)))

        self.panelC = wx.Panel(self)
        #self.panelC.SetBackgroundColour(wx.GREEN)
        self.panelC.SetConstraints(layoutf.Layoutf('t_10#2;l=l10#1;b=b10#1;r=r10#1',(self,self.panelB)))

        gif = wx.Image('../images/drbl-logo.gif', wx.BITMAP_TYPE_GIF).ConvertToBitmap()
        image = wx.StaticBitmap(self.panelA, -1, gif, wx.DefaultPosition, (gif.GetWidth(), gif.GetHeight()))
        #text = wx.StaticText(self.panelA, -1, _('msg_warnning_content'), wx.DefaultPosition, (375,65), style=wx.TE_MULTILINE)
        #font = wx.Font(10, wx.SWISS, wx.BOLD, wx.NORMAL)
        #text.SetFont(font)
        #image.SetConstraints(layoutf.Layoutf('X%X50#1;Y=Y#1;h*;w%w50#1', (self.panelA,)))
        image.SetConstraints(layoutf.Layoutf('X=X#1;Y=Y#1;h*;w*', (self.panelA,)))

        rb = wx.RadioBox(self.panelB, -1, _('msg_choose_action'), wx.DefaultPosition, wx.DefaultSize, mainlist, 1, wx.RA_SPECIFY_COLS)
        rb.SetConstraints(layoutf.Layoutf('X=X#1;Y=Y#1;h*;w*', (self.panelB,)))
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)

        self.b_ok = wx.Button(self.panelC, wx.ID_OK)
        self.b_ok.SetSize(self.b_ok.GetBestSize())
        self.b_ok.SetConstraints(layoutf.Layoutf('X%X150#1;Y=Y#1;h*;w*', (self.panelC,)))
        self.b_exit = wx.Button(self.panelC, wx.ID_EXIT)
        self.b_exit.SetSize(self.b_exit.GetBestSize())
        self.b_exit.SetConstraints(layoutf.Layoutf('X%X50#1;Y=Y#1;h*;w*', (self.panelC,)))

        #self.Bind(wiz.EVT_WIZARD_PAGE_CHANGED, self.OnWizPageChanged)
        self.Bind(wx.EVT_BUTTON, self.remoteLinuxWizard, self.b_ok)
        self.Bind(wx.EVT_BUTTON, self.OnCloseWindow, self.b_exit)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        #warnning = wx.MessageDialog(self, _('msg_warnning_content'), _('msg_warnning'), wx.OK|wx.ICON_INFORMATION)
        #warnning.Centre()
        #warnning.SetFocus()
        #warnning.ShowModal()
        #warnning.Destroy()

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            self.Bind(wx.EVT_BUTTON, self.remoteLinuxWizard, self.b_ok)
        #if event.GetSelection() == 1:
            #self.Bind(wx.EVT_BUTTON, self.clonezillaSaveWizard, self.b_ok)
        #if event.GetSelection() == 2:
            #self.Bind(wx.EVT_BUTTON, self.clonezillaRestoreWizard, self.b_ok)
        #if event.GetSelection() == 3:
            #self.Bind(wx.EVT_BUTTON, self.TDWDemoWizard, self.b_ok)
        #if event.GetSelection() == 4:
            #self.Bind(wx.EVT_BUTTON, self.StreamDemoWizard, self.b_ok)
        #if event.GetSelection() == 5:
            #self.Bind(wx.EVT_BUTTON, self.RunWizard, self.b_ok)
        #if event.GetSelection() == 6:
            #self.Bind(wx.EVT_BUTTON, self.HelpWizard, self.b_ok)

#----------------------------------------------------------------------
    def OnCloseWindow(self, event):
        self.Destroy()


#------------------------------Wizard Modules--------------------------
    def remoteLinuxWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_linux'))

        page1 = remoteLinuxPage(wizard, _('msg_choose'))
        page2 = setAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page3 = selectClientsPage(wizard, _('msg_select_clients'))
        page4 = remoteLinuxFinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500, 320))
        #wizard.FitToPage(page1)

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        #wizard.GetPageAreaSizer().Add(page1)
        wizard.RunWizard(page1)

#------------------------------------------------------------------------
if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = MainFrame()
    frame.Centre()
    frame.Show()
    app.MainLoop()

