import  wx, sys, os, gettext, string, time
import  wx.wizard as wiz
from wx.lib.mixins.listctrl import CheckListCtrlMixin
import  wx.lib.filebrowsebutton as filebrowse
import	wx.lib.layoutf as layoutf

cat = gettext.GNUTranslations(open('%s.mo' % os.getenv('LANG')))
_ = cat.gettext

global FinalArgs
for i in range(0,37):
    FinalArgs.insert(i,'')

#----------------------------------------------------------------------
ClonezillaStartSaveArgs = {
1: ("-q", _('msg_ocs_param_q')),
2: ("-c", _('msg_ocs_param_c')),
3: ("-nogui", _('msg_ocs_param_nogui')),
4: ("-a", _('msg_ocs_param_a')),
5: ("-f", _('msg_ocs_param_f')),
6: ("-s", _('msg_ocs_param_s')),
7: ("-ntfs-ok", _('msg_ocs_param_notfs_ok')),
}

#----------------------------------------------------------------------
ClonezillaStartRestoreArgs = {
1: ("-g auto", _('msg_ocs_param_g_auto')),
2: ("-x", _('msg_ocs_param_x')),
3: ("-brdcst", _('msg_ocs_param_broadcast')),
4: ("-v", _('msg_ocs_param_v')),
5: ("-nogui", _('msg_ocs_param_nogui')),
6: ("-c", _('msg_ocs_param_c')),
7: ("-u", _('msg_ocs_param_u')),
8: ("-t", _('msg_ocs_param_t')),
9: ("-j0", _('msg_ocs_param_j0')),
10: ("-ns", _('msg_ocs_param_ns')),
11: ("-k", _('msg_ocs_param_k')),
12: ("-r", _('msg_ocs_param_r')),
13: ("-e", _('msg_ocs_param_e')),
14: ("-f", _('msg_ocs_param_f')),
15: ("-s", _('msg_ocs_param_s')),
16: ("-a", _('msg_ocs_param_a')),
17: ("-o0", _('msg_ocs_param_o0')),
18: ("-o1", _('msg_ocs_param_o1')),
19: ("-hn0", _('msg_ocs_param_hn0')),
20: ("-hn1", _('msg_ocs_param_hn1')),
}

#----------------------------------------------------------------------
class CSSCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartSaveArgs[data][0]
        if flag:
	    FinalArgs[index+3] = arg
        else:
	    FinalArgs[index+3] = ''

#----------------------------------------------------------------------
class CSRCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartRestoreArgs[data][0]
        if flag:
	    if index == 19:
		FinalArgs[index+4] = arg
	    else:
		FinalArgs[index+3] = arg
        else:
	    if index == 19:
		FinalArgs[index+4] = ''
	    else:
		FinalArgs[index+3] = ''

#----------------------------------------------------------------------
def makePageTitle(wizPg, title):
    sizer = wx.BoxSizer(wx.VERTICAL)
    wizPg.SetSizer(sizer)
    title = wx.StaticText(wizPg, -1, title)
    title.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))
    sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
    sizer.Add(wx.StaticLine(wizPg, -1), 0, wx.EXPAND|wx.ALL, 5)
    return sizer

#----------------------------------------------------------------------
class WizardBasePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SetAllClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_select_all_clients_or_select_part_them'), pos=(10,60), size=(400,100), style=wx.TE_MULTILINE)
	wx.StaticText(self, -1, _('msg_set_all_clients_des'), pos=(10,80), size=(400,100), style=wx.TE_MULTILINE)
	ox = ['Yes', 'No']
	self.rb = wx.RadioBox(self, -1, _('msg_set_all_clients'), (10,150), (250,75), ox, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
	self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.rb)
	FinalArgs[1] = '-nl'

    def EvtRadioBox(self, event):
	if event.GetSelection() == 0:
	    FinalArgs[1] = '-nl'
	if event.GetSelection() == 1:
	    FinalArgs[1] = '-h'

    def SetNext(self, next):
        self.next = next

    def GetNext(self):
	next = self.next
	if self.rb.GetSelection()==0:
	    next = next.GetNext()
        return next

#----------------------------------------------------------------------
class SelectClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	self.SelectedClientsArray = []
	self.SelectedClientsStr = ''
	self.fuse_next = self.fuse_prev = 0
	
        AllClientsArray = os.popen('sudo /opt/drbl/bin/get-client-ip-list').read().split('\n')
	AllClientsArray.remove('')
        self.lb = wx.CheckListBox(self, -1, (10,50), (470,250), AllClientsArray)
        self.Bind(wx.EVT_CHECKLISTBOX, self.EvtCheckListBox, self.lb)
        self.lb.SetSelection(0)

    def EvtCheckListBox(self, event):
	global PXE_CFG
        index = event.GetSelection()
        label = self.lb.GetString(index)
        if self.lb.IsChecked(index):
	    self.SelectedClientsArray.append(label)
        if not (self.lb.IsChecked(index)):
	    self.SelectedClientsArray.remove(label)
        self.lb.SetSelection(index)    #so that (un)checking also selects (moves the highlight)
	self.SelectedClientsStr = ''
	PXE_CFG = []
	for x in self.SelectedClientsArray:
	    self.SelectedClientsStr = x + ' ' + self.SelectedClientsStr
	    SinglePXECfgFileName = string.upper('%02x' % int(x.split('.')[0],10) + '%02x' % int(x.split('.')[1],10) + '%02x' % int(x.split('.')[2],10) + '%02x' % int(x.split('.')[3],10))
	    PXE_CFG.append(SinglePXECfgFileName)
        self.SelectedClientsStr = '\"' + self.SelectedClientsStr + '\"'
	#print self.SelectedClientsStr
	#print PXE_CFG[:]

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global PXE_CFG
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if FinalArgs[1] == '-nl':
                FinalArgs[2] = ''
                PXE_CFG = []
	    elif (self.SelectedClientsStr == '\"\"') or (self.SelectedClientsStr == ''):
	        war = wx.MessageDialog(self, 'YOU MUST CHOOSE ONE!!', 'WARNNING!!', wx.OK|wx.ICON_INFORMATION)
                war.ShowModal()
                war.Destroy()
                return self
	    else:
		FinalArgs[2] = self.SelectedClientsStr
		#print FinalArgs[2]
		#print PXE_CFG[:]
	    if (FinalArgs[3] == 'remote-linux-gra') or (FinalArgs[3] == 'remote-linux-txt') or (FinalArgs[3] == 'terminal') or (FinalArgs[3] == 'remote-memtest') or (FinalArgs[3] == 'remote-fdos') or (FinalArgs[3] == 'remote-local') or (FinalArgs[3] == 'local') or (FinalArgs[3] == 'Wake-on-LAN'):
                for i in range(0,4):
                    if FinalArgs[i] != '':
                        command = command + FinalArgs[i] + ' '
                FinalCommand.SetLabel('%s' % command)
                CommandLog.WriteText(os.popen('sudo %s' % command).read())
	    elif (FinalArgs[3] == 'reboot') or (FinalArgs[3] == 'shutdown'):
		for i in range(0,4):
		    if FinalArgs[i] != '':
			command = command + FinalArgs[i] + ' '
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % command)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
		file.close()
		os.remove('tmp.log')
		FinalCommand.SetLabel('%s' % command)
                CommandLog.WriteText('%s' % command_log)
	    elif (FinalArgs[0] == '/opt/drbl/sbin/drbl-client-reautologin'):
		if FinalArgs[1] == '-nl':
		    FinalArgs[1] = ''
		    FinalCommand.SetLabel('%s' % command)
		    CommandLog.WriteText(os.popen('sudo %s' % FinalArgs[0]).read())
		else:
                    FinalCommand.SetLabel('%s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[2]))
                    CommandLog.WriteText(os.popen('sudo %s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[2])).read())
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_prev = 0

        ModeList = [_('msg_clonezilla_save_disk'), _('msg_clonezilla_save_parts')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35, 50), (260,90), ModeList, 1, wx.RA_SPECIFY_COLS)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
	FinalArgs[12] = 'startdisk'
	FinalArgs[13] = 'save'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
                FinalArgs[12] = 'startdisk'
		FinalArgs[13] = 'save'
        if event.GetInt() == 1:
                FinalArgs[12] = 'startparts'
		FinalArgs[13] = 'save'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
        return self.next

    def GetPrev(self):
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
	    prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0
	global CSSP2rb

        choice = [_('msg_now_input_in_server'), _('msg_later_input_in_client')]
	wx.StaticText(self, -1, _('msg_ask_if_input_save_image_name_in_server'), (10,60),(470,100), style=wx.TE_MULTILINE)
        CSSP2rb = wx.RadioBox(self, -1, _('msg_choose_action'), (10,120), (210,80), choice, 1, wx.RA_SPECIFY_COLS)
        CSSP2rb.SetSelection(0)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_next = self.fuse_next + 1
	next = self.next
	if self.fuse_next == 2:
	    if CSSP2rb.GetSelection() == 1:
		next = next.GetNext()
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        self.text_img = wx.TextCtrl(self, -1, '', (10, 180), size=(200, -1))
        wx.StaticText(self, -1,  _('msg_input_image_name'), (10, 160))
        self.text_img = wx.TextCtrl(self, -1, '', (10, 180), size=(200, -1))
        wx.StaticText(self, -1,  _('msg_input_device_name'), (10, 210))
        self.text_dev = wx.TextCtrl(self, -1, '', (10, 230), size=(190, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global CSSP2rb
	self.fuse_next = self.fuse_next + 1
	self.fuse_prev = 0
	if self.fuse_next == 2:
	    if CSSP2rb.GetSelection() == 1:
                FinalArgs[14] = ''
                FinalArgs[15] = ''
		#print ('FinalArgs[14] is %s, FinalArgs[15] is %s' % (FinalArgs[14], FinalArgs[15]))
	    elif self.text_img.GetValue() == '' or self.text_dev.GetValue() == '':
		warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
		warnning.ShowModal()
		warnning.Destroy()
		return self
	    else:
	        FinalArgs[14] = self.text_img.GetValue()
	        FinalArgs[15] = self.text_dev.GetValue()
	        #print ('FinalArgs[14] is %s, FinalArgs[15] is %s' % (FinalArgs[14], FinalArgs[15]))
	return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.fuse_next = self.fuse_prev = 0

        ox = [_('msg_yes'), _('msg_no')]
	wx.StaticText(self, -1, _('msg_skip_set_advanced_extra_param'), (10,60), (470,100), wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, _('msg_choose_action'), (10,100), (100,50), ox, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(1)
	self.SkipExtraParam = 'no'

    def EvtRadioBox(self, event):
	if event.GetSelection() == 0:
	   self.SkipExtraParam = 'yes' 
	else:
	   self.SkipExtraParam = 'no'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global CSSP2rb
	next = self.next
	command = command_log = ''
        self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if self.SkipExtraParam == 'yes':
		if CSSP2rb.GetSelection() == 1:
		    if FinalArgs[1] == '-nl':
		        command = ('%s %s %s' % (FinalArgs[0], FinalArgs[12], FinalArgs[13]))
		    elif FinalArgs[1] == '-h':
			command = ('%s %s %s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[2], FinalArgs[12], FinalArgs[13]))
		elif CSSP2rb.GetSelection() == 0:
                    if FinalArgs[1] == '-nl':
                        command = ('%s %s %s %s %s' % (FinalArgs[0], FinalArgs[12], FinalArgs[13], FinalArgs[14], FinalArgs[15]))
                    elif FinalArgs[1] == '-h':
                        command = ('%s %s %s %s %s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[2], FinalArgs[12], FinalArgs[13], FinalArgs[14], FinalArgs[15]))
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % command)
                time.sleep(6)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
            	file.close()
            	os.remove('tmp.log')
            	FinalCommand.SetLabel('%s' % command)
            	CommandLog.WriteText('%s' % command_log)
		for i in range(0,3):
		    next = next.GetNext()
        return next

    def GetPrev(self):
	self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        prev = self.prev
        if self.fuse_prev == 1:
            if FinalArgs[14] == '' and FinalArgs[15] == '':
                prev = prev.GetPrev()
        return prev


#----------------------------------------------------------------------
class ClonezillaStartSavePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        self.list = CSSCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))	#not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT)	#not translated

        for key, data in ClonezillaStartSaveArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
        return self.next

    def GetPrev(self):
	return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (10,100), (250,100), ArgList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	rb.SetSelection(0)
	FinalArgs[10] = '-p choose'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            FinalArgs[10] = '-p choose'
        if event.GetSelection() == 1:
            FinalArgs[10] = '-p true'
        if event.GetSelection() == 2:
            FinalArgs[10] = '-p poweroff'
        if event.GetSelection() == 3:
            FinalArgs[10] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage7(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        ArgList = [ _('msg_ocs_param_z0'), _('msg_ocs_param_z1'), _('msg_ocs_param_z2'), _('msg_ocs_param_z3')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (10,100), (300,100), ArgList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	rb.SetSelection(3)
	FinalArgs[11] = '-z3'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[11] = '-z0'
        if event.GetSelection() == 1:
                FinalArgs[11] = '-z1'
        if event.GetSelection() == 2:
                FinalArgs[11] = '-z2'
        if event.GetSelection() == 3:
                FinalArgs[11] = '-z3'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
	    if FinalArgs[1] == '-nl':
		FinalArgs[1] = ''
            for i in range(0,20):
                if FinalArgs[i] != '':
                    command = command + FinalArgs[i] + ' '
	    file = open('tmp.log','w')
	    os.system('sudo %s > tmp.log' % command)
	    time.sleep(6)
	    file.close()
	    file = open('tmp.log')
	    while True:
		line = file.readline()
		if len(line) == 0: # Zero length indicates EOF
        	    break
		command_log = command_log + line
	    file.close()
	    os.remove('tmp.log')
	    FinalCommand.SetLabel('%s' % command)
	    CommandLog.WriteText('%s' % command_log)
	return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0	

        ModeList = [_('msg_clonezilla_restore_disk'), _('msg_clonezilla_restore_parts')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35, 50), (260,90), ModeList, 1, wx.RA_SPECIFY_COLS | wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
        FinalArgs[33] = 'startdisk'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[33] = 'startdisk'
        if event.GetInt() == 1:
            FinalArgs[33] = 'startparts'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	#self.fuse_next = self.fuse_next + 1
	#if self.fuse_next == 2:
	    #print ('ClonezillaRestorePage1: FinalArgs[33] is %s' % FinalArgs[33])
        return self.next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        self.list = CSRCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))        	       #not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT) #not translated

        for key, data in ClonezillaStartRestoreArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if not (self.list.IsChecked(18) or self.list.IsChecked(19)):
	        next = next.GetNext()
	        next = next.GetNext()
	    #print ('ClonezillaRestorePage2: arguments are : %s' % FinalArgs[3:24])
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self,-1 ,_('msg_write_MS_WIN_is_necessary'), (10, 60), (470, 200), wx.TE_MULTILINE)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        wx.StaticText(self, -1, _('msg_What_the_win_hostname_prefix'), (5, 80))
        self.text = wx.TextCtrl(self, -1, "PC", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if FinalArgs[21] == '-hn0':
                FinalArgs[22] = self.text.GetValue()
            else:
                FinalArgs[22] = ''
            if FinalArgs[23] == '-hn1':
                FinalArgs[24] = self.text.GetValue()
            else:
                FinalArgs[24] = ''
	    #print ('ClonezillaRestorePage4 : FinalArgs[21-24] are %s' % FinalArgs[21:25])
	    #print ('FinalArgs[22] is %s, FinalArgs[24] is %s' % (FinalArgs[22], FinalArgs[24]))
        return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
        wx.StaticText(self, -1, _('msg_if_always_provide_clonezilla_srv'), (10, 60), (470, 200),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (10,100), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[25] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[25] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[25] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[25] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	#self.fuse_next = self.fuse_next + 1
	#if self.fuse_next == 2:
	    #print ('ClonezillaRestorePage5 : FinalArgs[25](-y) is %s' % FinalArgs[25])
        return self.next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[21] == '' and FinalArgs[23] == '':
	        prev = prev.GetPrev()
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.fuse_prev = self.fuse_next = 0

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (10,100), (250,100), ArgList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
        FinalArgs[26] = '-p reboot'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[26] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[26] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[26] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[26] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		if FinalArgs[1] == '-nl':
		    FinalArgs[1] = ''
		FinalArgs[27] = FinalArgs[29] = ''
		FinalArgs[34] = 'restore'
                for i in range(0,37):
                    if FinalArgs[i] != '':
                        command = command + FinalArgs[i] + ' '
		#print ('ClonezillaRestorePage6 : FinalArgs[26] (-z) is %s' % FinalArgs[26])
		#print ('FinalCommands : %s' % command)
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % command)
                time.sleep(6)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
		file.close()
		os.remove('tmp.log')
		FinalCommand.SetLabel('%s' % command)
                CommandLog.WriteText('%s' % command_log)
		for i in range(0,8):
		    next = next.GetNext()
	    #else:
	        #print ('ClonezillaRestorePage6 : FinalArgs[26] (-z) is %s' % FinalArgs[26])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[34] = 'multicast_restore'
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage7(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        wx.StaticText(self, -1, _('msg_choose_the_image_to_restore'), (5,80))
        self.fbb = filebrowse.FileBrowseButton(self, -1, pos=(50,150), size=(350, -1), buttonText='browse', 
toolTip='Enter the img name or click browse button to choose img', fileMask='*.img', changeCallback = self.fbbCallback)

    def fbbCallback(self, evt):
        FinalArgs[35] = evt.GetString()

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		FinalArgs[35] = ''
		next = next.GetNext()
		#print ('ClonezillaRestorePage7 : FinalArgs[9] = -u')
	    elif (FinalArgs[35] == '') or (os.path.exists(FinalArgs[35]) == 'False'):
                warnning = wx.MessageDialog(self, 'Image File Not Found!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                warnning.ShowModal()
                warnning.Destroy()
		return self			
	    elif FinalArgs[33] == 'startparts':
	        next = next.GetNext()
		#print ('ClonezillaRestorePage7 : FinalArgs[33] = startparts')
	    #print ('ClonezillaRestorePage7 : FinalArgs[35] is %s' % FinalArgs[35])
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage8a(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        wx.StaticText(self, -1, _('msg_choose_the_disks_to_restore'), (5,80))
        self.text = wx.TextCtrl(self, -1, "sda", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		next = next.GetNext()
		FinalArgs[36] = ''
		#print ('ClonezillaRestorePage8a : FinalArgs[9] = -u')
	    elif FinalArgs[33] == 'startdisk':
	        if self.text.GetValue() == '':
                    warnning = wx.MessageDialog(self, 'Disks Not Found!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                    warnning.ShowModal()
                    warnning.Destroy()
                    return self
	        else:
	            FinalArgs[36] = self.text.GetValue()
	            next = next.GetNext()
		    #print ('ClonezillaRestorePage8a : FinalArgs[33] = startdisk, FinalArgs[36] is %s' % FinalArgs[36])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[36] = ''
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage8b(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        wx.StaticText(self, -1, _('msg_choose_the_parts_to_restore'), (5,80))
        self.text = wx.TextCtrl(self, -1, "sda", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		next = next.GetNext()
		FinalArgs[36] = ''
		#print ('ClonezillaRestorePage8b : FinalArgs[9] = -u')
	    elif FinalArgs[33] == 'startparts':
	        if self.text.GetValue() == '':
                    warnning = wx.MessageDialog(self, 'Partitions Not Found', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                    warnning.ShowModal()
                    warnning.Destroy()
                    return self
	        else:		
                    FinalArgs[36] = self.text.GetValue()
	            next = next.GetNext()
		    #print ('ClonezillaRestorePage8b : FinalArgs[33] = startparts, FinalArgs[36] is %s' % FinalArgs[36])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startparts':
		FinalArgs[36] = ''
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage9a(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_multicast_restore'), _('msg_unicast_restore')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_disk'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	FinalArgs[34] = 'multicast_restore'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[34] = 'multicast_restore'
        if event.GetInt() == 1:
            FinalArgs[34] = 'restore'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[33] == 'startdisk':
	        if FinalArgs[9] != '-u' and FinalArgs[34] == 'restore':
		    if FinalArgs[1] == '-nl':
			FinalArgs[1] = ''
		    FinalArgs[27] = FinalArgs[29] = ''
                    for i in range(0,37):
                        if FinalArgs[i] != '':
                            command = command + FinalArgs[i] + ' '
                    #print ('ClonezillaStartRestorePage9a : FinalArgs[9] is empty, FinalArgs[34] is %s' % FinalArgs[34])
		    #print ('FinalCommands : %s' % command)
            	    file = open('tmp.log','w')
            	    os.system('sudo %s > tmp.log' % command)
            	    time.sleep(6)
            	    file.close()
            	    file = open('tmp.log')
            	    while True:
                	line = file.readline()
                	if len(line) == 0: # Zero length indicates EOF
                    	    break
                	command_log = command_log + line
		    file.close()
		    os.remove('tmp.log')
		    FinalCommand.SetLabel('%s' % command)
            	    CommandLog.WriteText('%s' % command_log)
                    #CommandLog.WriteText(os.popen('sudo %s' % command).read())
		    for i in range(0,4):
			next = next.GetNext()
		else:
		    next = next.GetNext()
		    #print ('ClonezillaStartRestorePage9a : FinalArgs[34] is %s (should be multicast_restore)' % FinalArgs[34])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startdisk':
		FinalArgs[27] = '--clients-to-wait'
		FinalArgs[29] = '--max-time-to-wait'
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage9b(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_multicast_restore'), _('msg_unicast_restore')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_parts'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[34] = 'multicast_restore'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[34] = 'multicast_restore'
        if event.GetInt() == 1:
            FinalArgs[34] = 'restore'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[33] == 'startparts':
		if FinalArgs[9] != '-u' and FinalArgs[34] == 'restore':
		    if FinalArgs[1] == '-nl':
			FinalArgs[1] = ''
		    FinalArgs[27] = FinalArgs[29] = ''
                    for i in range(0,37):
                        if FinalArgs[i] != '':
                            command = command + FinalArgs[i] + ' '
                    #print ('ClonezillaStartRestorePage9b : FinalArgs[9] is empty, FinalArgs[34] is %s' % FinalArgs[34])
		    #print ('FinalCommands : %s' % command)
            	    file = open('tmp.log','w')
            	    os.system('sudo %s > tmp.log' % command)
            	    time.sleep(6)
            	    file.close()
            	    file = open('tmp.log')
            	    while True:
                	line = file.readline()
                	if len(line) == 0: # Zero length indicates EOF
                    	    break
                	command_log = command_log + line
		    file.close()
		    os.remove('tmp.log')
		    FinalCommand.SetLabel('%s' % command)
            	    CommandLog.WriteText('%s' % command_log)
                    #CommandLog.WriteText(os.popen('sudo %s' % command).read())
		    for i in range(0,3):
			next = next.GetNext()
                #else:
                    #print ('ClonezillaStartRestorePage9b : FinalArgs[34] is %s (should be multicast_restore)' % FinalArgs[34])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startparts':
		prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage10(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_clients_time_to_wait'), _('msg_time_to_wait'), _('msg_clients_to_wait')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (10,60), (200, 100), ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	FinalArgs[27] = '--clients-to-wait'
	FinalArgs[29] = '--max-time-to-wait'

    def EvtRadioBox(self, event):
	if event.GetInt() == 0:
	    FinalArgs[27] = '--clients-to-wait'
	    FinalArgs[29] = '--max-time-to-wait'
	elif event.GetInt() == 1:
	    FinalArgs[27] = ''
	    FinalArgs[29] = '--max-time-to-wait'
	elif event.GetInt() == 2:
	    FinalArgs[27] = '--clients-to-wait'
	    FinalArgs[29] = ''
 
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[27] == '' and FinalArgs[29] != '':
	        next = next.GetNext()
		#print ('ClonezillaRestorePage10 : just time-to-wait')
	    #elif FinalArgs[27] != '' and FinalArgs[29] == '':
		#print ('ClonezillaRestorePage10 : just clients-to-wait')
	    #elif FinalArgs[27] != '' and FinalArgs[29] != '':
		#print ('ClonezillaRestorePage10 : both time-to-wait and clients-to-wait')
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startdisk':
	  	prev = prev.GetPrev()
        return prev
#----------------------------------------------------------------------
class ClonezillaStartRestorePage11(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        wx.StaticText(self, -1, _('msg_how_many_clients_to_restore'), (10, 80))
	self.text = wx.TextCtrl(self, -1, '5', (20, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if self.text.GetValue() == '':
                warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                warnning.ShowModal()
                warnning.Destroy()
                return self
	    if FinalArgs[27] != '' and FinalArgs[29] == '':
	        FinalArgs[28] = self.text.GetValue()
                if FinalArgs[1] == '-nl':
                    FinalArgs[1] = ''
                for i in range(0,37):
                    if FinalArgs[i] != '':
                        command = command + FinalArgs[i] + ' '
                #print ('FinalCommands : %s' % command)
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % command)
                time.sleep(6)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
		file.close()
		os.remove('tmp.log')
		FinalCommand.SetLabel('%s' % command)
                CommandLog.WriteText('%s' % command_log)
	    elif FinalArgs[27] != '' and FinalArgs[29] != '':
		FinalArgs[28] = self.text.GetValue()	
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[28] = ''
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage12(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.fuse_next = self.fuse_prev  = 0

        wx.StaticText(self, -1, _('msg_max_time_to_wait_sec'), pos=(10, 60), size=(475, 200), style=wx.TE_MULTILINE)
        self.text = wx.TextCtrl(self, -1, "300", (10, 150), size=(100, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = command_log = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if self.text.GetValue() == '':
		warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
		warnning.ShowModal()
		warnning.Destroy()
		return self
	    FinalArgs[30] = self.text.GetValue()
	    if FinalArgs[1] == '-nl':
		FinalArgs[1] = ''
            for i in range(0,37):
                if FinalArgs[i] != '':
                    command = command + FinalArgs[i] + ' '
            #print ('FinalCommands : %s' % command)
            file = open('tmp.log','w')
            os.system('sudo %s > tmp.log' % command)
            time.sleep(6)
            file.close()
            file = open('tmp.log')
            while True:
                line = file.readline()
                if len(line) == 0: # Zero length indicates EOF
                    break
                command_log = command_log + line
	    file.close()
	    os.remove('tmp.log')
	    FinalCommand.SetLabel('%s' % command)
	    CommandLog.WriteText('%s' % command_log)
	return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[30] = ''
	    if FinalArgs[27] == '':
		prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaSelectPage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_prev = 0

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
        wx.StaticText(self,-1,_('msg_if_always_provide_clonezilla_srv'), (10, 60), (470, 200),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (10,100), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(1)
	FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
	FinalArgs[5] = '-y1'
	FinalArgs[7] = 'select_in_client'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[5] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[5] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[5] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[5] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
        return self.next

    def GetPrev(self):
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaSelectPage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (10,60), (470,200), ArgList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)
        FinalArgs[6] = '-p choose'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[6] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[6] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[6] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[6] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = ''
        self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            for i in range(0,8):
                if FinalArgs[i] != '':
                    command = command + FinalArgs[i] + ' '
	    FinalCommand.SetLabel('%s' % command)
	    CommandLog.WriteText(os.popen('sudo %s' % command).read())
        return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

	ModeList = [_('msg_hide_pxe_menus'), _('msg_reveal_pxe_menus'), _('msg_setdefault_pxe_menu')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_action'), (10, 60), (470,200), ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
        FinalArgs[3] = 'hide'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
	    FinalArgs[3] = 'hide'
        if event.GetSelection() == 1:
            FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
            FinalArgs[3] = 'reveal'
        if event.GetSelection() == 2:
	    FinalArgs[0] = '/opt/drbl/sbin/set-default-pxe-img'
	    FinalArgs[3] = '-i'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if FinalArgs[3] == '-i':
	        next = next.GetNext()
        return next

    def GetPrev(self):
	self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	self.fuse_next = self.fuse_prev = index = 0
	self.AllLabelsArray = []
	self.SelectedLabelsArray = []

        file = open('/tftpboot/nbi_img/pxelinux.cfg/default')
        content = file.read()
        for word in content.split():
	    if word == 'label':
		self.AllLabelsArray.append(content.split()[index + 1])
	    index = index + 1
	file.close()

        self.LabelBox = wx.CheckListBox(self, -1, (10,60), (470,250), self.AllLabelsArray)
        self.Bind(wx.EVT_CHECKLISTBOX, self.EvtCheckListBox, self.LabelBox)
        self.LabelBox.SetSelection(0)

    def EvtCheckListBox(self, event):
        index = event.GetSelection()
        label = self.LabelBox.GetString(index)
        if self.LabelBox.IsChecked(index):
            self.SelectedLabelsArray.append(label)
        if not (self.LabelBox.IsChecked(index)):
            self.SelectedLabelsArray.remove(label)
        self.LabelBox.SetSelection(index)	#so that (un)checking also selects (moves the highlight)
        #print self.SelectedLabelsArray[:]

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if (FinalArgs[3] == 'hide') or (FinalArgs[3] == 'reveal'):
	        if FinalArgs[1] == '-nl':
		    for k in range(0,len(self.SelectedLabelsArray[:])):
		    	os.system('sudo rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*')
		    	CommandLog.WriteText('remove all the pxe_cfg files under /tftpboot/nbi_img/pxelinux.cfg/, except default!\n')
			CommandLog.WriteText(os.popen('sudo %s %s %s' % (FinalArgs[0], self.SelectedLabelsArray[k], FinalArgs[3])).read())
	        else:
		    for i in range(0, len(PXE_CFG[:])):
			for k in range(0, len(self.SelectedLabelsArray[:])):
			    if ((len(self.SelectedLabelsArray[:]) == len(self.AllLabelsArray[:])) and (FinalArgs[3] == 'hide')):
				warnning = wx.MessageDialog(self, 'YOU CANNOT HIDE ALL LABELS', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
				warnning.ShowModal()
				warnning.Destroy()
				return self
			    elif os.path.exists('/tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG[i]):
				CommandLog.WriteText(os.popen('sudo %s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s' % (FinalArgs[0], self.SelectedLabelsArray[k], FinalArgs[3], PXE_CFG[i])).read())
				CommandLog.WriteText('%s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s' % (FinalArgs[0], self.SelectedLabelsArray[k], FinalArgs[3], PXE_CFG[i]))
			    else:
				os.system('sudo cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG[i])
				CommandLog.WriteText('copy /tftpboot/nbi_img/pxelinux.cfg/default to %s\n' % PXE_CFG[i])
				CommandLog.WriteText(os.popen('sudo %s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s' % (FinalArgs[0], self.SelectedLabelsArray[k], FinalArgs[3], PXE_CFG[i])).read())
				CommandLog.WriteText('%s -c /tftpboot/nbi_img/pxelinux.cfg/%s -i %s %s' % (FinalArgs[0], PXE_CFG[i] ,self.SelectedLabelsArray[k], FinalArgs[3]))
	    next = next.GetNext()
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
        return prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.fuse_next = self.fuse_prev = index = 0
        AllLabelsArray = []

        file = open('/tftpboot/nbi_img/pxelinux.cfg/default')
        content = file.read()
        for word in content.split():
            if word == 'label':
                AllLabelsArray.append(content.split()[index + 1])
            index = index + 1
        file.close()

        self.LabelBox = wx.RadioBox(self, -1, _('msg_setdefault_list_des'), (10,60), (470,250), AllLabelsArray, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.LabelBox)
        self.LabelBox.SetSelection(0)
	self.SelectedLabel = AllLabelsArray[0]

    def EvtRadioBox(self, event):
	self.SelectedLabel = event.GetString()
        #print self.SelectedLabel

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if (FinalArgs[1] == '-nl') and (FinalArgs[3] == '-i'):
		os.system('sudo rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*')
		CommandLog.WriteText('remove all the pxe_cfg files under /tftpboot/nbi_img/pxelinux.cfg/, except default!\n')
                CommandLog.WriteText(os.popen('sudo %s %s %s' % (FinalArgs[0], FinalArgs[3], self.SelectedLabel)).read())
            elif (FinalArgs[1] == '-h') and (FinalArgs[3] == '-i'):
                for i in range(0, len(PXE_CFG[:])):
		    if os.path.exists('/tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG[i]):
			CommandLog.WriteText(os.popen('sudo %s -c /tftpboot/nbi_img/pxelinux.cfg/%s %s %s' % (FinalArgs[0], PXE_CFG[i], FinalArgs[3], self.SelectedLabel)).read())
		    else:
                        os.system('sudo cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG[i])
                        CommandLog.WriteText(os.popen('%s -c /tftpboot/nbi_img/pxelinux.cfg/%s %s %s' % (FinalArgs[0], PXE_CFG[i], FinalArgs[3], self.SelectedLabel)).read())
        return self.next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[3] == '-i':
		prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class SwitchPXEModePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_pxemenu_text'), _('msg_pxemenu_graphic')]
        rb = wx.RadioBox(self, -1, '', (10,150), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/switch-pxe-bg-mode'
        FinalArgs[5] = '-m'
	FinalArgs[6] = 'text'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            FinalArgs[6] = 'text'
        if event.GetSelection() == 1:
            FinalArgs[6] = 'graphic'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        self.fuse_prev = 0
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
	    if FinalArgs[1] == '-nl':
		CommandLog.WriteText(os.popen('sudo %s %s %s' % (FinalArgs[0], FinalArgs[5], FinalArgs[6])).read())
	    else:
	        for i in range(0,len(PXE_CFG[:])):
		    CommandLog.WriteText(os.popen('sudo %s -c /tftpboot/nbi_img/pxelinux.cfg/%s %s %s' % (FinalArgs[0], PXE_CFG[i], FinalArgs[5], FinalArgs[6])).read())
	return self.next

    def GetPrev(self):
        self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class DRBLModePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_drbl_mode_0'), _('msg_drbl_mode_1'), _('msg_drbl_mode_2')]
	wx.StaticText(self,-1,_('msg_drbl_mode_switch_long'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 320, 300),wx.TE_MULTILINE)
	rb = wx.RadioBox(self, -1, '', (10,220), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)	
	self.fuse_next = self.fuse_prev = 0

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/tune-clientdir-opt'
	FinalArgs[1] = '-d'
	FinalArgs[2] = '0'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    FinalArgs[2] = '0'
	if event.GetSelection() == 1:
	    FinalArgs[2] = '1'
	if event.GetSelection() == 2:
	    FinalArgs[2] = '2'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = ''
	self.fuse_prev = 0
        self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            for i in range(0,3):
                command = command + FinalArgs[i] + ' '
            CommandLog.WriteText(os.popen('sudo %s' % command).read())
        return self.next

    def GetPrev(self):
        self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaModePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_clonezilla_mode_0'), _('msg_clonezilla_mode_1'), _('msg_clonezilla_mode_2')]
	wx.StaticText(self,-1,_('msg_clonezilla_mode_switch_long'), (10, 60), (475, 300),wx.TE_MULTILINE)
	rb = wx.RadioBox(self, -1, '', (10,180), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/tune-clientdir-opt'
        FinalArgs[1] = '-z'
        FinalArgs[2] = '0'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[2] = '0'
        elif event.GetInt() == 1:
            FinalArgs[2] = '1'
        elif event.GetInt() == 2:
            FinalArgs[2] = '2'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        command = ''
	self.fuse_prev = 0
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
            for i in range(0,3):
                command = command + FinalArgs[i] + ' '
            CommandLog.WriteText(os.popen('sudo %s' % command).read())
        return self.next

    def GetPrev(self):
        self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class LoginSwitchPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

	ModeList = [_('msg_normal_login'), _('msg_auto_login'), _('msg_timed_login')]
        wx.StaticText(self, -1, _('msg_login_switch'),(10,60))
	rb = wx.RadioBox(self, -1, _('msg_choose_action'), (10, 120), (200, 200),ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
	self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-login-switch'
	FinalArgs[3] = '-n'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    FinalArgs[0] = '/opt/drbl/sbin/drbl-login-switch'
	    FinalArgs[3] = '-n'
            FinalArgs[4] = ''
	    FinalArgs[5] = ''
        if event.GetSelection() == 1:
	    FinalArgs[0] = '/opt/drbl/sbin/drbl-client-switch'
	    FinalArgs[3] = 'remote-linux-gra'
	    FinalArgs[4] = '/opt/drbl/sbin/drbl-login-switch'
            FinalArgs[5] = '-a'
        if event.GetSelection() == 2:
            FinalArgs[0] = '/opt/drbl/sbin/drbl-client-switch'
	    FinalArgs[3] = 'remote-linux-gra'
            FinalArgs[4] = '/opt/drbl/sbin/drbl-login-switch'
            FinalArgs[5] = '-t'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
        self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[3] == '-n':
		FinalArgs[1] = FinalArgs[2] = ''
		CommandLog.WriteText(os.popen('sudo %s %s' % (FinalArgs[0], FinalArgs[3])).read())
	    elif (FinalArgs[3] != '-n') and (FinalArgs[1] == '-nl'):
		CommandLog.WriteText(os.popen('sudo %s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[3])).read())
		CommandLog.WriteText(os.popen('sudo %s %s' % (FinalArgs[4], FinalArgs[5])).read())
	    elif (FinalArgs[3] != '-n') and (FinalArgs[1] == '-h'):
		CommandLog.WriteText(os.popen('sudo %s %s %s %s' % (FinalArgs[0], FinalArgs[1], FinalArgs[2], FinalArgs[3])).read())
            	CommandLog.WriteText(os.popen('sudo %s %s' % (FinalArgs[4], FinalArgs[5])).read())
        return next

    def GetPrev(self):
        self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class CleanAutoLoginAccountPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_clean_autologin_account'),(50,100))
	FinalArgs[0] = '/opt/drbl/sbin/drbl-clean-autologin-account'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class SwitchDRBLServPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        ModeList = [_('msg_start_drbl_all_services'), _('msg_stop_drbl_all_services'), _('msg_restart_drbl_all_services'), _('msg_add_drbl_all_services'), _('msg_del_drbl_all_services')]
        wx.StaticText(self, -1, _('msg_switch_drbl_service'),(10,60))
        rb = wx.RadioBox(self, -1, _('msg_choose_action'), (10, 120), (250,200), ModeList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-all-service'
        FinalArgs[1] = 'start'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            FinalArgs[1] = 'start'
        if event.GetSelection() == 1:
            FinalArgs[1] = 'stop'
        if event.GetSelection() == 2:
            FinalArgs[1] = 'restart'
        if event.GetSelection() == 3:
            FinalArgs[1] = 'add'
        if event.GetSelection() == 4:
            FinalArgs[1] = 'del'

    def SetNext(self, next):
        self.next = next

    def GetNext(self):
        command = ''
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
            for i in range(0,3):
                command = command + FinalArgs[i] + ' '
	    FinalCommand.SetLabel('%s' % command)
            CommandLog.WriteText(os.popen('sudo %s' % command).read()) 
        return self.next

#----------------------------------------------------------------------
class FinalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	global FinalCommand, CommandLog

	FinalCommand = wx.StaticText(self, -1, '', pos=(10,60), size=(400,100))
        CommandLog = wx.TextCtrl(self, -1, '', pos=(10,100), size=(470,200), style=wx.TE_MULTILINE|wx.TE_READONLY)
	
    def SetNext(self, next):
        self.next = next

    def GetNext(self):
        return self.next

#----------------------------------------------------------------------
class MainFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, parent=None, title=_('msg_nchc_title'), size=(850,500))
	self.SetAutoLayout(True)

        FunctionList = [_('msg_remote_linux_graphic'), _('msg_remote_linux_text'), _('msg_thin_client')
		        , _('msg_remote_memtest'), _('msg_remote_fdos'), _('msg_start_clonezilla_save_mode')
			, _('msg_start_clonezilla_restore_mode'), _('msg_clonezilla_selec_in_client'), _('msg_clonezilla_stop')
			, _('msg_local'), _('msg_reboot'), _('msg_shutdown'), _('msg_Wake_on_LAN')
			, _('msg_switch_pxe_menu'), _('msg_switch_pxe_bg_mode'), _('msg_drbl_mode_switch')
			, _('msg_clonezilla_mode_switch'), _('msg_gen_template_files'), _('msg_login_switch')
			, _('msg_client_reautologin'), _('msg_reset_autologin_account')
			, _('msg_switch_drbl_service'), _('msg_re_deploy'), _('msg_clean_dhcpd_lease')
			, _('msg_regenerate_nfs_nis_nat_config')]

	self.panelA = wx.Panel(self)
	self.panelA.SetBackgroundColour(wx.RED)
	self.panelA.SetConstraints(layoutf.Layoutf('t=t#1;l=l10#1;b%b15#1;r=r10#1',(self,)))

        self.panelB = wx.Panel(self)
        self.panelB.SetBackgroundColour(wx.BLUE)
        self.panelB.SetConstraints(layoutf.Layoutf('t_5#2;l=l10#1;b%b90#1;r=r10#1',(self,self.panelA)))

        self.panelC = wx.Panel(self)
        self.panelC.SetBackgroundColour(wx.GREEN)
        self.panelC.SetConstraints(layoutf.Layoutf('t_5#2;l=l10#1;b=b10#1;r=r10#1',(self,self.panelB)))

        text = wx.StaticText(self.panelA, -1, _('TEST'), wx.DefaultPosition, (500,65), style=wx.TE_MULTILINE)
        font = wx.Font(10, wx.SWISS, wx.BOLD, wx.NORMAL)
        text.SetFont(font)
        text.SetConstraints(layoutf.Layoutf('X%X50#1;Y=Y#1;h*;w%w50#1', (self.panelA,)))

	rb = wx.RadioBox(self.panelB, -1, '', wx.DefaultPosition, wx.DefaultSize, FunctionList, 2, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        rb.SetConstraints(layoutf.Layoutf('X=X#1;Y=Y#1;h*;w%w90#1', (self.panelB,)))
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)

        self.b_ok = wx.Button(self.panelC, wx.ID_OK)
        self.b_ok.SetSize(self.b_ok.GetBestSize())
        self.b_ok.SetConstraints(layoutf.Layoutf('X%X150#1;Y=Y#1;h*;w*', (self.panelC,)))
        self.b_exit = wx.Button(self.panelC, wx.ID_EXIT)
        self.b_exit.SetSize(self.b_exit.GetBestSize())
        self.b_exit.SetConstraints(layoutf.Layoutf('X%X50#1;Y=Y#1;h*;w*', (self.panelC,)))

        self.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b_ok)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.b_exit)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b_ok)
        if event.GetSelection() == 1:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxTxtWizard, self.b_ok)
        if event.GetSelection() == 2:
	    self.scroll.Bind(wx.EVT_BUTTON, self.TerminalWizard, self.b_ok)
        if event.GetSelection() == 3:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteMemTestWizard, self.b_ok)
        if event.GetSelection() == 4:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemotefdosWizard, self.b_ok)
        if event.GetSelection() == 5:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartSaveWizard, self.b_ok)
        if event.GetSelection() == 6:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartRestoreWizard, self.b_ok)
        if event.GetSelection() == 7:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaSelectWizard, self.b_ok)
        if event.GetSelection() == 8:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStopWizard, self.b_ok)
        if event.GetSelection() == 9:
            self.scroll.Bind(wx.EVT_BUTTON, self.LocalWizard, self.b_ok)
        if event.GetSelection() == 10:
            self.scroll.Bind(wx.EVT_BUTTON, self.RebootWizard, self.b_ok)
        if event.GetSelection() == 11:
            self.scroll.Bind(wx.EVT_BUTTON, self.ShutdownWizard, self.b_ok)
        if event.GetSelection() == 12:
            self.scroll.Bind(wx.EVT_BUTTON, self.WakeOnLANWizard, self.b_ok)
        if event.GetSelection() == 13:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchPXEMenuWizard, self.b_ok)
        if event.GetSelection() == 14:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchPXEModeWizard, self.b_ok)
        if event.GetSelection() == 15:
            self.scroll.Bind(wx.EVT_BUTTON, self.DRBLModeWizard, self.b_ok)
        if event.GetSelection() == 16:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaModeWizard, self.b_ok)
        if event.GetSelection() == 17:
            self.scroll.Bind(wx.EVT_BUTTON, self.GenTemplateFileWizard, self.b_ok)
        if event.GetSelection() == 18:
            self.scroll.Bind(wx.EVT_BUTTON, self.LoginSwitchWizard, self.b_ok)
        if event.GetSelection() == 19:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClientReAutoLoginWizard, self.b_ok)
        if event.GetSelection() == 20:
            self.scroll.Bind(wx.EVT_BUTTON, self.CleanAutoLoginAccountWizard, self.b_ok)
        if event.GetSelection() == 21:
            self.scroll.Bind(wx.EVT_BUTTON, self.ResetAutoLoginAccountWizard, self.b_ok)
        if event.GetSelection() == 22:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchDRBLServWizard, self.b_ok)
        if event.GetSelection() == 23:
            self.scroll.Bind(wx.EVT_BUTTON, self.ReDeployWizard, self.b_ok)
        if event.GetSelection() == 24:
            self.scroll.Bind(wx.EVT_BUTTON, self.CleanDHCPLeaseWizard, self.b_ok)
        if event.GetSelection() == 25:
            self.scroll.Bind(wx.EVT_BUTTON, self.Regenerate3NWizard, self.b_ok)

    def OnWizCancel(self, evt):
        con = wx.MessageBox("Do you wnat to cancel this wizard?", "Confirm Again!", wx.CENTRE | wx.YES_NO | wx.ICON_QUESTION)
	if con == wx.NO:
	    evt.Veto()

#----------------------------------------------------------------------
    def OnCloseWindow(self, event):
	self.Destroy()
#----------------------------------------------------------------------
    def OnCloseMe(self, event):
	self.Close(True)

#------------------------------Wizard Modules--------------------------
    def RemoteLinuxGraWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_linux_graphic'))

	page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
	page2 = SelectClientsPage(wizard, _('msg_select_clients'))
	page3 = FinalPage(wizard, _('msg_done'))
	FinalArgs[0] = '/opt/drbl/sbin/dcs'
	FinalArgs[3] = 'remote-linux-gra'

	self.page1 = page1
	#wizard.FitToPage(page1)
	wizard.SetPageSize((500,300))

	page1.SetNext(page2)
	page2.SetPrev(page1)
	page2.SetNext(page3)

        if wizard.RunWizard(page1):
	    for i in range(0,36):
		FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''
	    
#------------------------------Wizard Modules--------------------------
    def RemoteLinuxTxtWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_linux_text'), pos = (350,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-linux-txt'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def TerminalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_thin_client'), pos = (350,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'terminal'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RemoteMemTestWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_memtest'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-memtest'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RemotefdosWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_fdos'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard,_('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-fdos'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartSaveWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_start_clonezilla_save_mode'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
	page3 = ClonezillaStartSavePage1(wizard, _('msg_choose_mode'))
	page4 = ClonezillaStartSavePage2(wizard, _('msg_title_input_save_image_name_in_server'))
	page5 = ClonezillaStartSavePage3(wizard, _('msg_input_image_name'))
	page6 = ClonezillaStartSavePage4(wizard, _('msg_clonezilla_advanced_extra_param'))
	page7 = ClonezillaStartSavePage5(wizard, _('msg_clonezilla_advanced_extra_param'))
	page8 = ClonezillaStartSavePage6(wizard, _('msg_clonezilla_advanced_extra_param'))
	page9 = ClonezillaStartSavePage7(wizard, _('msg_clonezilla_advanced_extra_param'))
        page10 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)
	page5.SetPrev(page4)
	page5.SetNext(page6)
	page6.SetPrev(page5)
	page6.SetNext(page7)
	page7.SetPrev(page6)
	page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)
	page9.SetPrev(page8)
	page9.SetNext(page10)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
	    wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartRestoreWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_start_clonezilla_restore_mode'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = ClonezillaStartRestorePage1(wizard, _('msg_choose_mode'))
        page4 = ClonezillaStartRestorePage2(wizard, _('msg_clonezilla_advanced_extra_param'))
        page5 = ClonezillaStartRestorePage3(wizard, _('msg_change_hostname_of_MS_WIN_on_the_fly'))
        page6 = ClonezillaStartRestorePage4(wizard, _('msg_What_the_win_hostname_prefix'))
        page7 = ClonezillaStartRestorePage5(wizard, _('msg_clonezilla_advanced_extra_param'))
	page8 = ClonezillaStartRestorePage6(wizard, _('msg_clonezilla_advanced_extra_param'))
        page9 = ClonezillaStartRestorePage7(wizard, _('msg_choose_the_image_to_restore'))
	page10 = ClonezillaStartRestorePage8a(wizard, _('msg_choose_the_disks_to_restore'))
	page11 = ClonezillaStartRestorePage8b(wizard, _('msg_choose_the_parts_to_restore'))
	page12 = ClonezillaStartRestorePage9a(wizard, _('msg_choose_mode'))
	page13 = ClonezillaStartRestorePage9b(wizard, _('msg_choose_mode'))
	page14 = ClonezillaStartRestorePage10(wizard, _('msg_clonezilla_advanced_extra_param'))
	page15 = ClonezillaStartRestorePage11(wizard, _('msg_clonezilla_advanced_extra_param'))
	page16 = ClonezillaStartRestorePage12(wizard, _('msg_clonezilla_advanced_extra_param'))
        page17 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
        page4.SetPrev(page3)
        page4.SetNext(page5)
        page5.SetPrev(page4)
        page5.SetNext(page6)
        page6.SetPrev(page5)
        page6.SetNext(page7)
        page7.SetPrev(page6)
        page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)
	page9.SetPrev(page8)
	page9.SetNext(page10)
	page10.SetPrev(page9)
	page10.SetNext(page11)
	page11.SetPrev(page10)
	page11.SetNext(page12)
	page12.SetPrev(page11)
	page12.SetNext(page13)
	page13.SetPrev(page12)
	page13.SetNext(page14)
	page14.SetPrev(page13)
	page14.SetNext(page15)
	page15.SetPrev(page14)
	page15.SetNext(page16)
	page16.SetPrev(page15)
	page16.SetNext(page17)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaSelectWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clonezilla_selec_in_client'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = ClonezillaSelectPage1(wizard, _('msg_clonezilla_advanced_extra_param'))
	page4 = ClonezillaSelectPage2(wizard, _('msg_clonezilla_advanced_extra_param'))
        page5 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStopWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clonezilla_stop'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'clonezilla-stop'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def LocalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_local'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'local'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RebootWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_reboot'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'reboot'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ShutdownWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_shutdown'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'shutdown'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
	    wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def WakeOnLANWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_Wake_on_LAN'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'Wake-on-LAN'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchPXEMenuWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_switch_pxe_menu'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = SwitchPXEMenuPage1(wizard, _('msg_choose_the_action'))
        page4 = SwitchPXEMenuPage2(wizard, _('msg_hide_reveal'))
	page5 = SwitchPXEMenuPage3(wizard, _('msg_setdefault_pxe_menu'))
        page6 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)
	page5.SetPrev(page4)
	page5.SetNext(page6)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchPXEModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_switch_pxe_bg_mode'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = SwitchPXEModePage(wizard, _('msg_switch_pxe_bg_mode'))
        page4 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def DRBLModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_drbl_mode_switch'), pos = (500,200))

        page1 = DRBLModePage(wizard, _('msg_drbl_mode_switch'))
        page2 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,330))

        page1.SetNext(page2)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ClonezillaModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clonezilla_mode_switch'), pos = (500,200))

        page1 = ClonezillaModePage(wizard, _('msg_clonezilla_mode_switch'))
        page2 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def GenTemplateFileWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_gen_template_files'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
	FinalCommand.SetLabel('/opt/drbl/sbin/gen_ssi_files')
	CommandLog.WriteText(os.popen('sudo /opt/drbl/sbin/gen_ssi_files').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def LoginSwitchWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_login_switch'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
	page3 = LoginSwitchPage(wizard, _('msg_login_switch'))
        page4 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ClientReAutoLoginWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_client_reautologin'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
	FinalArgs[0] = '/opt/drbl/sbin/drbl-client-reautologin'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def CleanAutoLoginAccountWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clean_autologin_account'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
	FinalCommand.SetLabel('/opt/drbl/sbin/drbl-clean-autologin-account')
	CommandLog.WriteText(os.popen('yes y | sudo /opt/drbl/sbin/drbl-clean-autologin-account').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ResetAutoLoginAccountWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_reset_autologin_account'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
	FinalCommand.SetLabel('/opt/drbl/sbin/drbl-user-env-reset --auto-login')
	CommandLog.WriteText(os.popen('yes y | sudo /opt/drbl/sbin/drbl-user-env-reset --auto-login').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchDRBLServWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_switch_drbl_service'), pos = (500,200))

        page1 = SwitchDRBLServPage(wizard, _('msg_switch_drbl_service'))
        page2 = FinalPage(wizard, _('msg_done'))

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ReDeployWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_re_deploy'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
	FinalCommand.SetLabel('/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf')
	CommandLog.WriteText(os.popen('yes y | sudo /opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def CleanDHCPLeaseWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clean_dhcpd_lease'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
        FinalCommand.SetLabel('/opt/drbl/sbin/clean-dhcpd-lease')
        CommandLog.WriteText(os.popen('sudo /opt/drbl/sbin/clean-dhcpd-lease').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def Regenerate3NWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_regenerate_nfs_nis_nat_config'), pos = (500,200))

        page1 = FinalPage(wizard, _('msg_done'))
        FinalCommand.SetLabel('/opt/drbl/sbin/drbl-3n-conf generate')
        CommandLog.WriteText(os.popen('sudo /opt/drbl/sbin/drbl-3n-conf generate').read())

        self.page1 = page1
        wizard.SetPageSize((500,300))

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------------------------------------------------
if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = MainFrame()
    frame.Centre()
    frame.Show()
    app.MainLoop()

