#!/bin/bash
# Program:
#   Check DRBL total vm status
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/09/09  Rock    First release (1.0) 

source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt


# [Varliables]
vm_total_status_file=/tmp/vm_totoal_status.$$
vm_IP_files=$(ls $Work_Home/etc/IP_VM_eth[0-9]*)

# [Main] 
check_root

echo -e "VM_IP       VM_Hostname \t VM_Status" >> $vm_total_status_file
echo "------------------------------------------------------" >> $vm_total_status_file

for vm_IP_file in $vm_IP_files
do
    # local variables
    vm_IPs=$(cat $vm_IP_file | awk '{print $1}')
    IP_status="online"

    for vm_IP in $vm_IPs
    do
        # check network status
        ping -c1 -w1 $vm_IP > /dev/null 2>&1 || IP_status="offline"
        vm_IP_Hostname=$(sed -n "/$vm_IP/p" $vm_IP_file)
        echo -e "$vm_IP_Hostname \t\t $IP_status" >> $vm_total_status_file
    done

done
   
cat $vm_total_status_file

# dlete tmp file
rm -f $vm_total_status_file
