#!/bin/bash
# Program:
#   Deploy PXE PV VM to DRBL client
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/08/27  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt
#source ./functions_drbl_PXE_PV-VM_create


# [Declation]
# = 1. Varibales declation =
#vm_dir="/home/domains"


# = 2. Functions declation =
Usage(){
echo "Usage: drbl_xen_cmd.sh options"
echo "Options:"
echo "-h|--host           which host"
echo "-v|--vm             vm name"
echo "-x|--xen_command    xen command"
echo "Example:"
echo "drbl_xen_cmd.sh -h drbl101 -v drbl131 -x 'shutdown'"
}


# [Main]
check_root
# = 1. Parse parameters = 
if [ $# -eq 0 ]; then
Usage && exit
fi

while [ $# -gt 0 ]; do
    case "$1" in
        -h|--host)
            shift 
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                    client_name=$1
                else
                    echo "-h host_value is null"
                    Usage && exit 2
                fi
            shift 
            fi 
            ;; 
        -v|--vm)
            shift
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                    vm_name=$1
                else
                    echo "-v vm_name is null"
                    Usage && exit 2
                fi
            shift
            fi
            ;;
        -x|--xen_command)
            shift 
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                xen_command="$1"
                else
                    echo "-x xen command is null"
                    Usage && exit 2
                fi  
            shift 
            fi  
            ;;
        -*)
            echo "$0 $1 invalid option" >&2
            echo ""
            Usage >&2
            exit 2
            ;;
        *)  Usage >&2
            exit 2
            ;;
    esac
done


# = 2. Check null value =
[ -z $client_name ] && echo "[Error] no host" && Usage && exit 2
[ -z $vm_name ] && echo "[Error] no VM value" && Usage && exit 2
[ -z "$xen_command" ] && echo "[Error] no xen command" && Usage && exit 2


# = 3. Check exist
# VM name
IP_VM_files=$(ls $Work_Home/etc/IP_VM_eth[0-9]*)

for IP_VM_file in $IP_VM_files
do                                                                                                                                 
    IP_VM_ip=$(cat $IP_VM_file | grep "$vm_name" | awk '{print $1}') 
    if [ -n $IP_VM_name ]; then
        IP_VM_right_file=$IP_VM_file
        IP_VM_right_ip=$IP_VM_ip
    fi
done

if [ -z $IP_VM_right_ip ]; then
    echo ""
    echo "[Error] this vm name is wrong!"
    echo "Please check $Wokr_Home/etc/"
    exit 2
fi

cat $Work_Home/etc/IP_HOST_TABLE | grep $client_name
if [ $? -ne 0 ]; then
    echo "[Error] This host is not DRBL client"
    exit 2
fi


# = 4. ssh host to deploy VM  =
# local varibales
host_IP=$(cat $Work_Home/etc/IP_HOST_TABLE | grep $client_name | awk '{print $1}')

# start ssh
ssh -o StrictHostKeyChecking=no $host_IP "$xen_command"

