#!/bin/bash
# Program:
#  Remove DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [PATH]
Work_Home="/opt/drbl-virt"
Work_Path="/opt/drbl-virt/sbin"
Now_Path="$(dirname $0)"
PATH=${PATH}:$Work_Path

# [Source]
source $Now_Path/sbin/functions_drbl_virt
# [Main]
check_systemInfo
checkroot

# = 1. For linux distribution = 
case $Linux_Distribution in
    # for Ubuntu
    "Ubuntu")
        echo "Only support Debain"
    ;; 
    # for Debian
    "Debian")
        # check bit 
        echo $Linux_bit | grep 64                                                                                  
        if [ $? == 0 ]; then
            Linux_bit="amd64"
        else
            Linux_bit="686"
        fi  
                 
        # check version
        echo $Linux_Version | grep "^5"
        if [ $? == 0 ]; then
            hypervisior=check_hypervisior
            if [ $hypervisior == "Xen" ]; then
                aptitude remove xen-linux-system-2.6.26-2-xen-${Linux_bit} xen-tools
            else
                aptitude remove kvm
            fi
        fi  
    ;; 
    # for Fedora
    "Fedora")            
        echo "Only support Debain"
    ;; 
    *) 
        echo "Only support Debain"
    ;; 
esac

cd

# = 2. Recovery DRBL original file =
# patch file
mv -f /usr/bin/mkpxeinitrd-net.drbl-virt_bak /usr/bin/mkpxeinitrd-net
mv -f /opt/drbl/sbin/generate-pxe-menu.drbl-virt_bak /opt/drbl/sbin/generate-pxe-menu
mv -f /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init.drbl-virt_bak /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init
# drbl env file
mv -f $Work_Home/etc/IP_HOST_TABLE /etc/drbl/IP_HOST_TABLE
mv -f $Work_Home/etc/macadr-eth*[0-9].txt

# = 3. Redeploy DRBL original environment =


# = 4. Delete path =
rm -fr $Work_Home


