#!/bin/bash
# Program:
#   Path DRBL evironment to support Xen/KVM
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]

# = 1. Variables setup =
# == Get DRBL eth ==
eths=""
declare -i eth_nu=""
get_DRBL_eth                                                                                                                                                                           
     
if [ $eth_nu -gt "1" ]; then
    echo ""
    echo "DRBL environment has muiltpule netwrok card(NIC)."
fi   
   
# backup IP_HOST_TABLE
if [ -e /etc/drbl/IP_HOST_TABLE.drbl-virt_bak ]; then
    cp /etc/drbl/IP_HOST_TABLE /etc/drbl/IP_HOST_TABLE.$(date +%Y-%m-%d-%H-%M-%S).drbl-virt_bak
    cp -f /etc/drbl/IP_HOST_TABLE.drbl-virt_bak /etc/drbl/IP_HOST_TABLE
    cp -f /etc/drbl/IP_HOST_TABLE.drbl-virt_bak /opt/drbl-virt/etc/IP_HOST_TABLE
else
    cp /etc/drbl/IP_HOST_TABLE /etc/drbl/IP_HOST_TABLE.drbl-virt_bak
    cp /etc/drbl/IP_HOST_TABLE /opt/drbl-virt/etc/IP_HOST_TABLE
fi  

for eth in $eths
do   
     
    # == Get Host IP range/number  ==
    Host_first_IP=""
    Host_last_IP=""
    # get eth network
    eth_address=$(/opt/drbl/bin/drbl-get-ipadd $eth)
    eth_netmask=$(/opt/drbl/bin/drbl-get-netmask $eth)
    eth_network=$(/opt/drbl/bin/drbl-get-network $eth_address $eth_netmask)
    get_Host_IP_range
     
    # == Get VM number, IP range & prefix name ==
    declare -i VM_IP_range=""
    declare -i Host_last_IP_4=""
    declare -i VM_Host_totoal_nu=""
    VM_first_IP=""
    VM_last_IP=""
    VM_prefix_name=""

    get_VM_IP_range_and_prefix_name
    create_VM_IP_table
     
    # == Generate MAC address  ==
    # MAC address [00:16:3e:xx:xx:xx] is for Xen use
    generate_Xen_MAC_address
     
    # == Add VM IP to /etc/drbl/IP_HOST_TABLE  ==
    VM_IPs=$(cat /opt/drbl-virt/etc/IP_VM_$eth | awk '{print $1}')
    VM_IPs_nu=$(cat /opt/drbl-virt/etc/IP_VM_eth1 | awk '{print $1}' | wc -w)
    VM_hosts=$(cat /opt/drbl-virt/etc/IP_VM_$eth | awk '{print $2}')
    VM_MACs=$(cat /opt/drbl-virt/etc/macadr-VM-$eth.txt)
    
    # == Add Mac address to macadr-ethX.txt ==
    if [ -e /etc/drbl/macadr-$eth.txt ]; then
    delete_duplicating_MAC
    fi
    cat /opt/drbl-virt/etc/macadr-VM-$eth.txt >> /etc/drbl/macadr-$eth.txt
done 
     

# = 2. Re-deploy drbl client =
# == Cheange Xen Kernel ==   
Xen_Kernel=$(cat $Work_Home/etc/Xen_Kernel)
#read -p "Xen_Kernel=$Xen_Kernel"
echo "/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel"
/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel                                                                                                                        
echo "" 
# == Re-delpoy drbl client ==
echo "Re-delpoy drbl client"           
echo "/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf"
/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf
echo ""
