#!/bin/bash
# Program:
#   Create PXE PV VM
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/08/27  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
#source $Work_Path/functions_drbl_PXE_PV-VM_create
source ./functions_drbl_PXE_PV-VM_create


# [Declation]
# = 1. Varibales declation =
vm_name=""
vm_cpu=""
vm_ram=""
vm_host=""
vm_mac=""

vm_dir="/home/domains"
# = 2. Functions declation =
Usage(){
echo "Usage: drbl_PXE_PV-VM_create.sh options"
echo "Options: "
echo "-v    vm name"
echo "-c    cpu number"
echo "-r    ram size"
echo "-h    deploy vm to which host"
echo "Examples: "
echo "drbl_PXE_PV-VM_create.sh options -v drbl110 -c 2 -ram 512 -h drbl101"
}


# [Main]
check_root
# = 1. Parse parameters = 
if [ $# -eq 0 ]; then
Usage
fi

while [ $# -gt 0 ]; do
    case "$1" in
        -v)
            shift
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                    vm_name=$1
                else
                    echo "-v vm_name is null"
                    Usage && exit 2
                fi
            shift
            fi
            ;;
        -c)
            shift
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then 
                    vm_cpu=$1
                else
                    echo "-c cpu_value is null"
                    Usage && exit 2
                fi
            shift
            fi
            ;;
        -r)
            shift 
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                    vm_ram=$1
                else
                    echo "-r ram_value is null"
                    Usage && exit 2
                fi
            shift 
            fi 
            ;;  
        -h)
            shift 
            if [ -z "$(echo $1 |grep ^-.)" ]; then
                if [ -n "$(echo $1)" ]; then
                vm_host=$1
                else
                    echo "-h host_value is null"
                    Usage && exit 2
                fi
            shift 
            fi 
            ;; 
        -*)
            echo "$0 $1 invalid option" >&2
            echo ""
            Usage >&2
            exit 2
            ;;
        *)  Usage >&2
            exit 2
            ;;
    esac
done

# = 2. Get VM MAC address =
#IP_MAC_files=$(ls $Work_Home/etc | grep 'macadr-VM-eth[0-9]*.txt')
IP_VM_files=$(ls $Work_Home/etc | grep 'IP_VM_eth[0-9]*')
IP_VM_right_file=""
IP_VM_right_line=""
IP_VM_eth=""
for IP_VM_file in $IP_VM_files
do
    IP_VM_line=$(cat -n $IP_VM_file | grep "$vm_name" | awk '{print $1}') 
    if [ -n $IP_VM_line ]; then
        IP_VM_right_file=$IP_VM_file
        IP_VM_right_line=$IP_VM_line
    fi
done

# if no value, exit and check IP_VM_ethX
if [ -z $IP_VM_right_file ]; then
    echo ""
    echo "Error: don't fine ${vm_name}'s IP address"
    echo "Please check $Wokr_Home/etc/"
    exit 2
fi

# start get mac address
IP_VM_eth=$(echo $IP_VM_right_file | sed 's/IP_VM_//g' )
vm_mac=$(cat $Work_Home/etc/macadr-VM-${IP_VM_eth}.txt | sed -n "${IP_VM_right_line}")

# = 3. Generate PXE PV-VM configuration  =
if [ ! -e $vm_dir ]; then
    mkdir $vm_dir
fi

vm_cfg=${home_dir}/${vm_name}.cfg
rm $vm_cfg

# start to generate 
echo "kernel      = '/home/domains/vmlinuz-pxe'" > $vm_cfg
echo "ramdisk     = '/home/domains/initrd-pxe.img'" >> $vm_cfg
echo "memory      = '512'" >> $vm_cfg
echo "name        = \'$vm_name\'" >> $vm_cfg
echo "vcpus        = \'$vm_cpu\'" >> $vm_cfg
echo "dhcp        = 'dhcp'" >> $vm_cfg
echo "vif         = [ \'mac=$vm_mac\']" >> $vm_cfg
echo "on_poweroff = 'destroy'" >> $vm_cfg
echo "on_reboot   = 'restart'" >> $vm_cfg
echo "on_crash    = 'restart'" >> $vm_cfg
echo "vfb = [ 'type=vnc,vnclisten=0.0.0.0,vncunused=1' ]" >> $vm_cfg
echo "extra = 'console=hvc0 xencons=tty'" >> $vm_cfg

