#!/bin/bash
# Program:
#   Path DRBL evironment to support Xen/KVM
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source functions_drbl_virt
source /opt/drbl-virt/conf/drbl-virt.conf

# [Main]

# = 1. Patch DRBL xen env for client =
# == Shutdown all drbl client ==
echo "Please check all client are shutdown !!!"
read -p "Push 'Enter' to continue......"

# == Change xen kernel for drbl client ==
check_xen_nu
Xen_Kernel=$(echo $Xen_Kernel | sed 's/^vmlinuz-//g' )
echo "/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel"
#/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel
echo ""

# == Re-delpoy drbl client ==
echo "Re-delpoy drbl client"
echo "/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf"
#/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf
echo ""

# == Copy xen image to /tftpboot/nbi_img/ ==
echo "copy Xen image & Kernel to /tftpboot/nbi_img/"
#cp /boot/*xen* /tftpboot/nbi_img/
#cp /boot/vmlinuz-${Xen_Kernel} /tftpboot/nbi_img/
#cp /boot/initrd.img-${Xen_Kernel} /tftpboot/nbi_img/
#cp /boot/config-${Xen_Kernel} /tftpboot/nbi_img/
echo ""

# == Modify PXE booting menu ==
# backup generate-pxe-menu
#cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/default.drbl-virt_bak
#cp /opt/drbl/sbin/generate-pxe-menu /opt/drbl/sbin/generate-pxe-menu.drbl_virt_bak
generate_PXE_menu="/opt/drbl/sbin/generate-pxe-menu"
declare -i modify_line=$(cat -n $generate_PXE_menu | grep 'label drbl' | awk 'NR==1 {print $1}')
# modify menu
sed -i "${modify_line}i\label drbl-virt" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU DEFAULT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU LABEL DRBL-Virtualization ($Xen, $Xen_Kernel)" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  kernel mboot.c32" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  append $Xen --- vmlinuz-pxe --- initrd-pxe.img devfs=nomount drblthincli=off selinux=0 nomodeset" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  TEXT HELP" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  ENDTEXT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\ " $generate_PXE_menu


# = 2. Patch DRBL initrd to support bridge =
# == Patch /usr/bin/mkpxeinitrd-net (1)modules (2)xen network scripts ==


# == Copy xen netwrok scripts ==

# == run xen network scripts (/usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init) ==



