#!/bin/bash
# Program:
#   DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [ Intall ] 
case $Linux_Distribution in
    # for Ubuntu
    "Ubuntu")
        echo "Only support Debain"
    ;;
    # for Debian
    "Debian")
        # check bit
        echo $Linux_bit | grep 64                                                                                                                          
        if [ $? == 0 ]; then
            Linux_bit="amd64"
        else
            Linux_bit="686"
        fi  
        
        # check version
        echo $Linux_Version | grep "^5"
        if [ $? == 0 ]; then
            aptitude update
            aptitude install xen-linux-system-2.6.26-2-xen-${Linux_bit} xen-tools
        fi
    ;;
    # for Fedora
    "Fedora")        
        echo "Only support Debain"
    ;;
    *)
        echo "Only support Debain"
    ;;
esac
