import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
 
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;


public class GetTranslation {

    private static String translate(String langpair,String text) {
      
      /**********************************************************
       *  要這一行動起來, 你要有一些相依的library才行
       *  commons-logging
       *  commons-codec
       */ 
      HttpClient client = new HttpClient();
      
      
      /***********************************************************
       * 設定連線的站臺位置
       * 請別在"站臺位置"加了多餘的protocol
       * ex. setHost("http://tinyurl.com", 80, "http");
       * 不然他就噴UnknownHostException給你:P
       */
      client.getHostConfiguration().setHost("www.google.com", 80, "http");
   
      /***********************************************************
       * 觀察了表單內容是用post方法, 而使用的script name為create.php
       */
      PostMethod post = new PostMethod("/translate_t");
      //post.addParameter(new NameValuePair("url", url));
      post.addParameter("langpair", langpair);
      post.addParameter("text", text);
      
      String s = null;
      try {
        /***********************************************************
         * 透過http client來執行post/get方法
         */
        client.executeMethod(post);
        
        /***********************************************************
         * 再用您選用的方法傳回response body
         * 這裡偷懶了一下使用了getResponseBodyAsString()
         * log上會發出警告
         * 
         * 2006/5/18 上午 08:13:22 org.apache.commons.httpclient.HttpMethodBase getResponseBody
         * 警告: Going to buffer response body of large or unknown size. 
         * Using getResponseBodyAsStream instead is recommended.
         */
        InputStream in = post.getResponseBodyAsStream();        
        BufferedReader buf = new BufferedReader(new InputStreamReader(in));
        Pattern p = Pattern.compile(".*id=\"*result_box\"*\\ *dir=\"*ltr\"*\\>");
        Matcher m = null;
        
        String line;
        while ((line = buf.readLine()) != null) {        	
        	m = p.matcher(line);
        	//System.out.println(line);
        	if (m.find()) {        		
        		s = line.substring(m.end());
        		line = s;
        		p = Pattern.compile("\\<\\ */\\ *div\\ *\\>");
        		m = p.matcher(line);
        		if (m.find()) {
        		    s = line.substring(0, m.start());
        		}
        		break;
        	}
        }
                
        //s = GetTranslation.instostr(in);
      } catch (HttpException e) {
        e.printStackTrace();
      } catch (IOException e) {
        e.printStackTrace();
      }      
      return s;
    }

    public static String instostr (InputStream in) throws IOException {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        for (int n; (n = in.read(b)) != -1;) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /** @param filePath the name of the file to open. Not sure if it can accept URLs or just filenames. Path handling could be better, and buffer sizes are hardcoded
     */ 
     public static void translateFile(String langpair, String inPath,String outPath) {         
         BufferedReader reader=null;
         BufferedWriter writer=null;
		 try {
			reader = new BufferedReader(new FileReader(inPath));
			writer = new BufferedWriter(new FileWriter(outPath));
	 	 } catch (FileNotFoundException e) {			
			e.printStackTrace();
	 	 } catch (IOException e) {
			e.printStackTrace();
		}
         Pattern p = Pattern.compile("=");
         Matcher m = null;         
         int count=0;
         String var=null, val=null;
         String line=null, lines="", ret="";
         try {
			while ((line=reader.readLine())!=null) {
				 				 						
				 if (line.contains("=")) {

					 m = p.matcher(line);
					 if (m.find()) {
						 count++;
						 var = line.substring(0,m.start());
						 val = line.substring(m.end()+1,line.length()-1);
						 lines+=var+"="+val+"\n";
						 //System.out.println(var+"='"+GetTranslation.translate(langpair,val)+"'");
						 
					 }
				 } else {
					 writer.write(line);
					 writer.newLine();
				 }
				 if (count==200) {
					 ret = GetTranslation.translate(langpair,lines);	
					 ret = ret.replace("=", "=\"");
					 ret = ret.replace("<br>", "\"\n");
					 System.out.println(ret);
					 writer.write(ret);
					 lines="";
					 count=0;
					 Thread.sleep(5000);
				 }				 
			 }
			 if (count>0) {
				 ret=lines;
				 ret = GetTranslation.translate(langpair,lines);					 
				 ret = ret.replace("=", "=\"");
				 ret = ret.replace("<br>", "\"\n");
				 System.out.println(ret);	
				 writer.write(ret);
				 lines="";
				 Thread.sleep(5000);
			 }			
			 reader.close();
			 writer.close();
		} catch (IOException e) {			
			e.printStackTrace();
		} catch (InterruptedException e) {			
			e.printStackTrace();
		}
         
     }    
     
     public static void main(String[] args) throws HttpException, IOException {
    	 
    	 if(null == args || args.length < 3) {
    		 System.out.println("Usage: java GetTranslation language_pair original_file translated_file");
    		 System.out.println("Example: java GetTranslation \"en|zh-TW\" \"en_US\" \"zh_TW\"");
    		 //String ret = GetTranslation.translate("en|zh-TW","hello");
    		 //System.out.println("Return Value: "+ret);
    		 System.exit(1);
    	 }
         //System.out.println(GetTranslation.translate("en|zh-TW","hello"));    	 
         //GetTranslation.translateFile("en|zh-TW","en_US","zh_TW");
    	 GetTranslation.translateFile(args[0],args[1],args[2]);
    	 
    	 //GetTranslation.translateFile("en|zh-TW","en_US","zh_TW");
		 //String ret = GetTranslation.translate("en|zh-TW","hello");
		 //System.out.println("Return Value: "+ret);
    	 
     }
}
