#!/bin/sh

created_passwd=no
created_group=no

if [ ! -e /etc/passwd -a ! -L /etc/passwd ] ; then
  /bin/mkpasswd -l -c > /etc/passwd
  /bin/chmod 644 /etc/passwd
  created_passwd=yes
fi

if [ ! -e /etc/group -a ! -L /etc/group ] ; then
  /bin/mkgroup -l -c > /etc/group
  /bin/chmod 644 /etc/group
  created_group=yes
fi

cp -fp /etc/group /tmp/group.mkgroup && \
( [ -w /etc/group ] || chmod --silent a+w /etc/group ; ) && \
echo "root:S-1-5-32-544:0:" > /etc/group && \
sed -e '/root:S-1-5-32-544:0:/d' /tmp/group.mkgroup >> /etc/group && \
chmod --silent --reference=/etc/passwd /etc/group
rm -f /tmp/group.mkgroup

# Deferred to be sure root group entry exists
[ "$created_passwd" = "yes" ] && /bin/chgrp --silent root /etc/passwd
[ "$created_group" = "yes"  ] && /bin/chgrp --silent root /etc/group
