Attribute VB_Name = "RegkeyModule"
Option Explicit

Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_CONFIG = &H80000005
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003

Public Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Public Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Public Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long

Public Const ERROR_SUCCESS = 0&

Public Const STANDARD_RIGHTS_ALL = &H1F0000
Public Const KEY_QUERY_VALUE = &H1
Public Const KEY_SET_VALUE = &H2
Public Const KEY_CREATE_SUB_KEY = &H4
Public Const KEY_ENUMERATE_SUB_KEYS = &H8
Public Const KEY_NOTIFY = &H10
Public Const KEY_CREATE_LINK = &H20
Public Const SYNCHRONIZE = &H100000
Public Const KEY_ALL_ACCESS = _
    ((STANDARD_RIGHTS_ALL Or _
    KEY_QUERY_VALUE Or _
    KEY_SET_VALUE Or _
    KEY_CREATE_SUB_KEY Or _
    KEY_ENUMERATE_SUB_KEYS Or _
    KEY_NOTIFY Or KEY_CREATE_LINK) And _
    (Not SYNCHRONIZE))
    
' Return a registry key value.
Public Function GetRegKeyValue(ByVal root As Long, ByVal key_name As String, ByVal subkey_name As String) As String
Dim hKey As Long
Dim value As String
Dim length As Long
Dim value_type As Long
    GetRegKeyValue = ""
    ' Open the key.
    If RegOpenKeyEx(root, key_name, _
        0&, KEY_QUERY_VALUE, hKey) <> ERROR_SUCCESS _
    Then
        'MsgBox "Error opening key."
        Exit Function
    End If

    ' Get the subkey's size.
    If RegQueryValueEx(hKey, subkey_name, _
        0&, value_type, ByVal 0&, length) _
            <> ERROR_SUCCESS _
    Then
        'MsgBox "Error getting subkey length."
    End If

    ' Get the subkey's value.
    value = Space$(length)
    If RegQueryValueEx(hKey, subkey_name, _
        0&, value_type, ByVal value, length) _
            <> ERROR_SUCCESS _
    Then
        'MsgBox "Error getting subkey value."
    Else
        ' Remove the trailing null character.
        GetRegKeyValue = Left$(value, length - 1)
    End If

    ' Close the key.
    If RegCloseKey(hKey) <> ERROR_SUCCESS Then
        'MsgBox "Error closing key."
    End If
End Function


