#-*- coding: UTF-8 -*-

from google.appengine.ext import db
from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app

from model import *

class SubmitOrder(webapp.RequestHandler):
    def post(self):
        name = self.request.get('name')
        ice = self.request.get('sugar')
        if self.request.get('sugar') == 'full':
            sugar = 'full'
        elif self.request.get('sugar') == 'half':
            sugar = 'half'
        else:
            sugar = 'none'

        if self.request.get('ice') == 'normal':
            ice = True
        else:
            ice = False
        tea = Beverage(name=name,sugar=sugar,ice=ice)
        tea.put()

        u_key = tea.key()

        get_tea = db.get(u_key)
        self.response.out.write("%s, %s, %s" % (get_tea.name, get_tea.ice, get_tea.sugar))
        
        db.delete(u_key)

class MainPage(webapp.RequestHandler):
    def get(self):
        self.response.out.write("""
            <form method=post action="/Submit">
            您要點的飲料:<input type="text" name="name"/>
            <br>
            甜度:<input type=radio name=sugar value=full>全糖
                 <input type=radio name=sugar value=half>半糖
                 <input type=radio name=sugar value=none>無糖
            <br>
            冰塊:<input type=radio name=ice value=normal>正常冰
                 <input type=radio name=ice value=none>去冰
            </form>
            """)

def main():
    application = webapp.WSGIApplication([('/',MainPage),
                                          ('/Submit',SubmitOrder)],
                                         debug=True)
    run_wsgi_app(application)

if __name__ == "__main__":
    main()
    
