package edu.ntu.parallel.grep;

import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class GrepMapper extends MapReduceBase implements Mapper {
	public void map(Object key, Object value,
			OutputCollector output, Reporter reporter) throws IOException {
		
		// TODO Auto-generated method stub
		FileSplit fileSplit = (FileSplit)reporter.getInputSplit();
		String line = value.toString();
		StringTokenizer st = new StringTokenizer(line.toLowerCase());
		while(st.hasMoreTokens()){
			String word = st.nextToken();
			output.collect(new Text(word), new Text(fileSplit.getPath().getName()+":"+line));
		}
	}
}
