package edu.ntu.parallel.grep;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class Grep {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		JobClient job = new JobClient();
		JobConf conf = new JobConf(Grep.class);
		
		conf.setJobName("TK's Grep");
		
		conf.setOutputKeyClass(Text.class);
		conf.setOutputValueClass(Text.class);
		
		conf.setMapperClass(GrepMapper.class);
		conf.setReducerClass(GrepReducer.class);
		conf.setCombinerClass(GrepReducer.class);
		
		FileInputFormat.setInputPaths(conf, "/data/test/input");
		FileOutputFormat.setOutputPath(conf, new Path("1/grep7"));
				
		conf.setNumMapTasks(5);
		conf.setNumReduceTasks(1);
		
		job.setConf(conf);
		
		long start = System.nanoTime();
		try{
			job.runJob(conf);
		}catch(Exception e){
			e.printStackTrace();
		}
		long time = System.nanoTime() - start;
		System.err.println(time/1E+9 + " sec");
	}
}
