/*
 * Decompiled with CFR 0.152.
 */
package nchc.wc;

import nchc.wc.wordcountM;
import nchc.wc.wordcountR;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class wordcount {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("wordcount <inDir> <outDir> <m> <r>");
            return;
        }
        JobConf conf = new JobConf(wordcount.class);
        conf.setJobName("Word Count");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(wordcountM.class);
        conf.setReducerClass(wordcountR.class);
        conf.setCombinerClass(wordcountR.class);
        FileInputFormat.setInputPaths((JobConf)conf, (String)args[0]);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(args[1]));
        conf.setNumMapTasks(Integer.parseInt(args[2]));
        conf.setNumReduceTasks(Integer.parseInt(args[3]));
        long start = System.nanoTime();
        try {
            JobClient.runJob((JobConf)conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long duration = System.nanoTime() - start;
        System.err.println(String.valueOf((double)duration / 1.0E9) + " secs");
    }
}

