/*
 * Decompiled with CFR 0.152.
 */
package nchc.grep;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.InverseMapper;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.mapred.lib.RegexMapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class grep
extends Configured
implements Tool {
    private grep() {
    }

    public int run(String[] args) throws Exception {
        if (args.length < 5) {
            System.out.println("Grep <inDir> <outDir> <regex> <m> <r> \n ps : <regex> \u70ba\u652f\u63f4\u6b63\u898f\u8868\u793a\u6cd5\u7684\u5b57\u4e32\uff0c\u5982\uff1a\"[a-z]oo\"");
            return -1;
        }
        Path tempDir = new Path("grep-temp-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        JobConf grepJob = new JobConf(this.getConf(), grep.class);
        long duration = 0L;
        long start = 0L;
        try {
            grepJob.setJobName("search");
            FileInputFormat.setInputPaths((JobConf)grepJob, (String)args[0]);
            grepJob.setMapperClass(RegexMapper.class);
            grepJob.set("mapred.mapper.regex", args[2]);
            grepJob.setCombinerClass(LongSumReducer.class);
            grepJob.setReducerClass(LongSumReducer.class);
            FileOutputFormat.setOutputPath((JobConf)grepJob, (Path)tempDir);
            grepJob.setOutputFormat(SequenceFileOutputFormat.class);
            grepJob.setOutputKeyClass(Text.class);
            grepJob.setOutputValueClass(LongWritable.class);
            start = System.nanoTime();
            JobClient.runJob((JobConf)grepJob);
            JobConf sortJob = new JobConf(grep.class);
            sortJob.setJobName("sort");
            FileInputFormat.setInputPaths((JobConf)sortJob, (Path[])new Path[]{tempDir});
            sortJob.setInputFormat(SequenceFileInputFormat.class);
            sortJob.setMapperClass(InverseMapper.class);
            sortJob.setNumMapTasks(Integer.parseInt(args[3]));
            sortJob.setNumReduceTasks(Integer.parseInt(args[4]));
            FileOutputFormat.setOutputPath((JobConf)sortJob, (Path)new Path(args[1]));
            sortJob.setOutputKeyComparatorClass(LongWritable.DecreasingComparator.class);
            JobClient.runJob((JobConf)sortJob);
            duration = System.nanoTime() - start;
        }
        finally {
            FileSystem.get((Configuration)grepJob).delete(tempDir, true);
            System.err.println(String.valueOf((double)duration / 1.0E9) + " sec");
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new grep(), (String[])args);
        System.exit(res);
    }
}

