/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import com.facebook.thrift.*;

import com.facebook.thrift.protocol.*;
import com.facebook.thrift.transport.*;

/**
 * A Mutation object is used to either update or delete a column-value.
 */
public class Mutation implements TBase, java.io.Serializable {
  public boolean isDelete;
  public byte[] column;
  public byte[] value;

  public final Isset __isset = new Isset();
  public static final class Isset implements java.io.Serializable {
    public boolean isDelete = false;
    public boolean column = false;
    public boolean value = false;
  }

  public Mutation() {
    this.isDelete = false;

  }

  public Mutation(
    boolean isDelete,
    byte[] column,
    byte[] value)
  {
    this();
    this.isDelete = isDelete;
    this.__isset.isDelete = true;
    this.column = column;
    this.__isset.column = true;
    this.value = value;
    this.__isset.value = true;
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof Mutation)
      return this.equals((Mutation)that);
    return false;
  }

  public boolean equals(Mutation that) {
    if (that == null)
      return false;

    boolean this_present_isDelete = true;
    boolean that_present_isDelete = true;
    if (this_present_isDelete || that_present_isDelete) {
      if (!(this_present_isDelete && that_present_isDelete))
        return false;
      if (this.isDelete != that.isDelete)
        return false;
    }

    boolean this_present_column = true && (this.column != null);
    boolean that_present_column = true && (that.column != null);
    if (this_present_column || that_present_column) {
      if (!(this_present_column && that_present_column))
        return false;
      if (!java.util.Arrays.equals(this.column, that.column))
        return false;
    }

    boolean this_present_value = true && (this.value != null);
    boolean that_present_value = true && (that.value != null);
    if (this_present_value || that_present_value) {
      if (!(this_present_value && that_present_value))
        return false;
      if (!java.util.Arrays.equals(this.value, that.value))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      switch (field.id)
      {
        case 1:
          if (field.type == TType.BOOL) {
            this.isDelete = iprot.readBool();
            this.__isset.isDelete = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 2:
          if (field.type == TType.STRING) {
            this.column = iprot.readBinary();
            this.__isset.column = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 3:
          if (field.type == TType.STRING) {
            this.value = iprot.readBinary();
            this.__isset.value = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
          break;
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();
  }

  public void write(TProtocol oprot) throws TException {
    TStruct struct = new TStruct("Mutation");
    oprot.writeStructBegin(struct);
    TField field = new TField();
    field.name = "isDelete";
    field.type = TType.BOOL;
    field.id = 1;
    oprot.writeFieldBegin(field);
    oprot.writeBool(this.isDelete);
    oprot.writeFieldEnd();
    if (this.column != null) {
      field.name = "column";
      field.type = TType.STRING;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeBinary(this.column);
      oprot.writeFieldEnd();
    }
    if (this.value != null) {
      field.name = "value";
      field.type = TType.STRING;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeBinary(this.value);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("Mutation(");
    sb.append("isDelete:");
    sb.append(this.isDelete);
    sb.append(",column:");
    sb.append(this.column);
    sb.append(",value:");
    sb.append(this.value);
    sb.append(")");
    return sb.toString();
  }

}

