#!/bin/bash
hbase_ori_home=~/hbase
hbase_lib=$hbase_ori_home/lib
hadoop_lib=/usr/lib/hadoop/lib
hbase_sh=$hbase_ori_home/bin
hadoop_sh=/usr/lib/hadoop/bin
hbase_conf=$hbase_ori_home/conf
hadoop_conf=/etc/hadoop/conf

# Install lib
cd $hbase_lib
sudo cp commons-collections-3.2.jar commons-math-1.1.jar \
 jruby-complete-1.1.2.jar lucene-core-2.2.0.jar $hadoop_lib
 sudo cp ../hbase-*.jar $hadoop_lib

# Install hbase_bin
cd $hbase_sh
sudo cp Formatter.rb hbase-daemons.sh hirb.rb \
 start-hbase.sh hbase-daemon.sh HBase.rb regionservers.sh \
 stop-hbase.sh hbase $hadoop_sh
sudo cp hbase /usr/bin

# Install conf
cd $hbase_conf
sudo cp hbase-default.xml hbase-env.sh hbase-site.xml \
 log4j.properties regionservers $hadoop_conf

# Install /etc/default/hbase
sudo cp $hbase_sh/hbase-config.sh /etc/default/hbase

# Install init 
cd $hbase_ori_home
sudo cp init/* /etc/init.d/


