/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import com.facebook.thrift.*;

import com.facebook.thrift.protocol.*;
import com.facebook.thrift.transport.*;

/**
 * An HColumnDescriptor contains information about a column family
 * such as the number of versions, compression settings, etc. It is
 * used as input when creating a table or adding a column.
 */
public class ColumnDescriptor implements TBase, java.io.Serializable {
  public byte[] name;
  public int maxVersions;
  public String compression;
  public boolean inMemory;
  public int maxValueLength;
  public String bloomFilterType;
  public int bloomFilterVectorSize;
  public int bloomFilterNbHashes;
  public boolean blockCacheEnabled;
  public int timeToLive;

  public final Isset __isset = new Isset();
  public static final class Isset implements java.io.Serializable {
    public boolean name = false;
    public boolean maxVersions = false;
    public boolean compression = false;
    public boolean inMemory = false;
    public boolean maxValueLength = false;
    public boolean bloomFilterType = false;
    public boolean bloomFilterVectorSize = false;
    public boolean bloomFilterNbHashes = false;
    public boolean blockCacheEnabled = false;
    public boolean timeToLive = false;
  }

  public ColumnDescriptor() {
    this.maxVersions = 3;

    this.compression = "NONE";

    this.inMemory = false;

    this.maxValueLength = 2147483647;

    this.bloomFilterType = "NONE";

    this.bloomFilterVectorSize = 0;

    this.bloomFilterNbHashes = 0;

    this.blockCacheEnabled = false;

    this.timeToLive = -1;

  }

  public ColumnDescriptor(
    byte[] name,
    int maxVersions,
    String compression,
    boolean inMemory,
    int maxValueLength,
    String bloomFilterType,
    int bloomFilterVectorSize,
    int bloomFilterNbHashes,
    boolean blockCacheEnabled,
    int timeToLive)
  {
    this();
    this.name = name;
    this.__isset.name = true;
    this.maxVersions = maxVersions;
    this.__isset.maxVersions = true;
    this.compression = compression;
    this.__isset.compression = true;
    this.inMemory = inMemory;
    this.__isset.inMemory = true;
    this.maxValueLength = maxValueLength;
    this.__isset.maxValueLength = true;
    this.bloomFilterType = bloomFilterType;
    this.__isset.bloomFilterType = true;
    this.bloomFilterVectorSize = bloomFilterVectorSize;
    this.__isset.bloomFilterVectorSize = true;
    this.bloomFilterNbHashes = bloomFilterNbHashes;
    this.__isset.bloomFilterNbHashes = true;
    this.blockCacheEnabled = blockCacheEnabled;
    this.__isset.blockCacheEnabled = true;
    this.timeToLive = timeToLive;
    this.__isset.timeToLive = true;
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof ColumnDescriptor)
      return this.equals((ColumnDescriptor)that);
    return false;
  }

  public boolean equals(ColumnDescriptor that) {
    if (that == null)
      return false;

    boolean this_present_name = true && (this.name != null);
    boolean that_present_name = true && (that.name != null);
    if (this_present_name || that_present_name) {
      if (!(this_present_name && that_present_name))
        return false;
      if (!java.util.Arrays.equals(this.name, that.name))
        return false;
    }

    boolean this_present_maxVersions = true;
    boolean that_present_maxVersions = true;
    if (this_present_maxVersions || that_present_maxVersions) {
      if (!(this_present_maxVersions && that_present_maxVersions))
        return false;
      if (this.maxVersions != that.maxVersions)
        return false;
    }

    boolean this_present_compression = true && (this.compression != null);
    boolean that_present_compression = true && (that.compression != null);
    if (this_present_compression || that_present_compression) {
      if (!(this_present_compression && that_present_compression))
        return false;
      if (!this.compression.equals(that.compression))
        return false;
    }

    boolean this_present_inMemory = true;
    boolean that_present_inMemory = true;
    if (this_present_inMemory || that_present_inMemory) {
      if (!(this_present_inMemory && that_present_inMemory))
        return false;
      if (this.inMemory != that.inMemory)
        return false;
    }

    boolean this_present_maxValueLength = true;
    boolean that_present_maxValueLength = true;
    if (this_present_maxValueLength || that_present_maxValueLength) {
      if (!(this_present_maxValueLength && that_present_maxValueLength))
        return false;
      if (this.maxValueLength != that.maxValueLength)
        return false;
    }

    boolean this_present_bloomFilterType = true && (this.bloomFilterType != null);
    boolean that_present_bloomFilterType = true && (that.bloomFilterType != null);
    if (this_present_bloomFilterType || that_present_bloomFilterType) {
      if (!(this_present_bloomFilterType && that_present_bloomFilterType))
        return false;
      if (!this.bloomFilterType.equals(that.bloomFilterType))
        return false;
    }

    boolean this_present_bloomFilterVectorSize = true;
    boolean that_present_bloomFilterVectorSize = true;
    if (this_present_bloomFilterVectorSize || that_present_bloomFilterVectorSize) {
      if (!(this_present_bloomFilterVectorSize && that_present_bloomFilterVectorSize))
        return false;
      if (this.bloomFilterVectorSize != that.bloomFilterVectorSize)
        return false;
    }

    boolean this_present_bloomFilterNbHashes = true;
    boolean that_present_bloomFilterNbHashes = true;
    if (this_present_bloomFilterNbHashes || that_present_bloomFilterNbHashes) {
      if (!(this_present_bloomFilterNbHashes && that_present_bloomFilterNbHashes))
        return false;
      if (this.bloomFilterNbHashes != that.bloomFilterNbHashes)
        return false;
    }

    boolean this_present_blockCacheEnabled = true;
    boolean that_present_blockCacheEnabled = true;
    if (this_present_blockCacheEnabled || that_present_blockCacheEnabled) {
      if (!(this_present_blockCacheEnabled && that_present_blockCacheEnabled))
        return false;
      if (this.blockCacheEnabled != that.blockCacheEnabled)
        return false;
    }

    boolean this_present_timeToLive = true;
    boolean that_present_timeToLive = true;
    if (this_present_timeToLive || that_present_timeToLive) {
      if (!(this_present_timeToLive && that_present_timeToLive))
        return false;
      if (this.timeToLive != that.timeToLive)
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      switch (field.id)
      {
        case 1:
          if (field.type == TType.STRING) {
            this.name = iprot.readBinary();
            this.__isset.name = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 2:
          if (field.type == TType.I32) {
            this.maxVersions = iprot.readI32();
            this.__isset.maxVersions = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 3:
          if (field.type == TType.STRING) {
            this.compression = iprot.readString();
            this.__isset.compression = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 4:
          if (field.type == TType.BOOL) {
            this.inMemory = iprot.readBool();
            this.__isset.inMemory = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 5:
          if (field.type == TType.I32) {
            this.maxValueLength = iprot.readI32();
            this.__isset.maxValueLength = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 6:
          if (field.type == TType.STRING) {
            this.bloomFilterType = iprot.readString();
            this.__isset.bloomFilterType = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 7:
          if (field.type == TType.I32) {
            this.bloomFilterVectorSize = iprot.readI32();
            this.__isset.bloomFilterVectorSize = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 8:
          if (field.type == TType.I32) {
            this.bloomFilterNbHashes = iprot.readI32();
            this.__isset.bloomFilterNbHashes = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 9:
          if (field.type == TType.BOOL) {
            this.blockCacheEnabled = iprot.readBool();
            this.__isset.blockCacheEnabled = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 10:
          if (field.type == TType.I32) {
            this.timeToLive = iprot.readI32();
            this.__isset.timeToLive = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
          break;
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();
  }

  public void write(TProtocol oprot) throws TException {
    TStruct struct = new TStruct("ColumnDescriptor");
    oprot.writeStructBegin(struct);
    TField field = new TField();
    if (this.name != null) {
      field.name = "name";
      field.type = TType.STRING;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeBinary(this.name);
      oprot.writeFieldEnd();
    }
    field.name = "maxVersions";
    field.type = TType.I32;
    field.id = 2;
    oprot.writeFieldBegin(field);
    oprot.writeI32(this.maxVersions);
    oprot.writeFieldEnd();
    if (this.compression != null) {
      field.name = "compression";
      field.type = TType.STRING;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeString(this.compression);
      oprot.writeFieldEnd();
    }
    field.name = "inMemory";
    field.type = TType.BOOL;
    field.id = 4;
    oprot.writeFieldBegin(field);
    oprot.writeBool(this.inMemory);
    oprot.writeFieldEnd();
    field.name = "maxValueLength";
    field.type = TType.I32;
    field.id = 5;
    oprot.writeFieldBegin(field);
    oprot.writeI32(this.maxValueLength);
    oprot.writeFieldEnd();
    if (this.bloomFilterType != null) {
      field.name = "bloomFilterType";
      field.type = TType.STRING;
      field.id = 6;
      oprot.writeFieldBegin(field);
      oprot.writeString(this.bloomFilterType);
      oprot.writeFieldEnd();
    }
    field.name = "bloomFilterVectorSize";
    field.type = TType.I32;
    field.id = 7;
    oprot.writeFieldBegin(field);
    oprot.writeI32(this.bloomFilterVectorSize);
    oprot.writeFieldEnd();
    field.name = "bloomFilterNbHashes";
    field.type = TType.I32;
    field.id = 8;
    oprot.writeFieldBegin(field);
    oprot.writeI32(this.bloomFilterNbHashes);
    oprot.writeFieldEnd();
    field.name = "blockCacheEnabled";
    field.type = TType.BOOL;
    field.id = 9;
    oprot.writeFieldBegin(field);
    oprot.writeBool(this.blockCacheEnabled);
    oprot.writeFieldEnd();
    field.name = "timeToLive";
    field.type = TType.I32;
    field.id = 10;
    oprot.writeFieldBegin(field);
    oprot.writeI32(this.timeToLive);
    oprot.writeFieldEnd();
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("ColumnDescriptor(");
    sb.append("name:");
    sb.append(this.name);
    sb.append(",maxVersions:");
    sb.append(this.maxVersions);
    sb.append(",compression:");
    sb.append(this.compression);
    sb.append(",inMemory:");
    sb.append(this.inMemory);
    sb.append(",maxValueLength:");
    sb.append(this.maxValueLength);
    sb.append(",bloomFilterType:");
    sb.append(this.bloomFilterType);
    sb.append(",bloomFilterVectorSize:");
    sb.append(this.bloomFilterVectorSize);
    sb.append(",bloomFilterNbHashes:");
    sb.append(this.bloomFilterNbHashes);
    sb.append(",blockCacheEnabled:");
    sb.append(this.blockCacheEnabled);
    sb.append(",timeToLive:");
    sb.append(this.timeToLive);
    sb.append(")");
    return sb.toString();
  }

}

