/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import com.facebook.thrift.*;

import com.facebook.thrift.protocol.*;
import com.facebook.thrift.transport.*;

/**
 * Holds row name and then a map of columns to cells.
 */
public class TRowResult implements TBase, java.io.Serializable {
  public byte[] row;
  public Map<byte[],TCell> columns;

  public final Isset __isset = new Isset();
  public static final class Isset implements java.io.Serializable {
    public boolean row = false;
    public boolean columns = false;
  }

  public TRowResult() {
  }

  public TRowResult(
    byte[] row,
    Map<byte[],TCell> columns)
  {
    this();
    this.row = row;
    this.__isset.row = true;
    this.columns = columns;
    this.__isset.columns = true;
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof TRowResult)
      return this.equals((TRowResult)that);
    return false;
  }

  public boolean equals(TRowResult that) {
    if (that == null)
      return false;

    boolean this_present_row = true && (this.row != null);
    boolean that_present_row = true && (that.row != null);
    if (this_present_row || that_present_row) {
      if (!(this_present_row && that_present_row))
        return false;
      if (!java.util.Arrays.equals(this.row, that.row))
        return false;
    }

    boolean this_present_columns = true && (this.columns != null);
    boolean that_present_columns = true && (that.columns != null);
    if (this_present_columns || that_present_columns) {
      if (!(this_present_columns && that_present_columns))
        return false;
      if (!this.columns.equals(that.columns))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      switch (field.id)
      {
        case 1:
          if (field.type == TType.STRING) {
            this.row = iprot.readBinary();
            this.__isset.row = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case 2:
          if (field.type == TType.MAP) {
            {
              TMap _map4 = iprot.readMapBegin();
              this.columns = new HashMap<byte[],TCell>(2*_map4.size);
              for (int _i5 = 0; _i5 < _map4.size; ++_i5)
              {
                byte[] _key6;
                TCell _val7;
                _key6 = iprot.readBinary();
                _val7 = new TCell();
                _val7.read(iprot);
                this.columns.put(_key6, _val7);
              }
              iprot.readMapEnd();
            }
            this.__isset.columns = true;
          } else { 
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
          break;
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();
  }

  public void write(TProtocol oprot) throws TException {
    TStruct struct = new TStruct("TRowResult");
    oprot.writeStructBegin(struct);
    TField field = new TField();
    if (this.row != null) {
      field.name = "row";
      field.type = TType.STRING;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeBinary(this.row);
      oprot.writeFieldEnd();
    }
    if (this.columns != null) {
      field.name = "columns";
      field.type = TType.MAP;
      field.id = 2;
      oprot.writeFieldBegin(field);
      {
        oprot.writeMapBegin(new TMap(TType.STRING, TType.STRUCT, this.columns.size()));
        for (byte[] _iter8 : this.columns.keySet())        {
          oprot.writeBinary(_iter8);
          this.columns.get(_iter8).write(oprot);
        }
        oprot.writeMapEnd();
      }
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("TRowResult(");
    sb.append("row:");
    sb.append(this.row);
    sb.append(",columns:");
    sb.append(this.columns);
    sb.append(")");
    return sb.toString();
  }

}

