/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.applet.Applet;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.zhouer.utils.Convertor;
import org.zhouer.zterm.Clip;
import org.zhouer.zterm.HtmlPane;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.PreferencePane;
import org.zhouer.zterm.Resource;
import org.zhouer.zterm.Session;
import org.zhouer.zterm.Sessions;
import org.zhouer.zterm.Site;
import org.zhouer.zterm.SiteManager;
import org.zhouer.zterm.ZTerm;

public class Model {
    private static volatile Model model = null;
    private final Clip clip;
    private String colorText = null;
    private final Convertor conv;
    private final Resource resource;
    private final Sessions sessions = Sessions.getInstance();
    private String copiedLink;
    private ZTerm view;
    private PreferencePane preferencePane;
    public String w_user;
    public String w_password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Model getInstance() {
        if (model != null) return model;
        Class<Model> clazz = Model.class;
        synchronized (Model.class) {
            if (model != null) return model;
            model = new Model();
            // ** MonitorExit[var0] (shouldn't be in output)
            return model;
        }
    }

    private Model() {
        this.resource = Resource.getInstance();
        this.conv = new Convertor();
        this.clip = new Clip();
        this.preferencePane = new PreferencePane();
    }

    public void setLocale(Locale locale) {
        Locale.setDefault(locale);
        this.resource.setValue("locale.country", locale.getCountry());
        this.resource.setValue("locale.language", locale.getLanguage());
        this.resource.setValue("locale.variant", locale.getVariant());
    }

    public void autoconnect() {
        Vector<Site> favorite = this.resource.getFavorites();
        for (Site site : favorite) {
            if (!site.autoconnect) continue;
            this.connect(site, -1);
        }
    }

    public void bell(Session session) {
        if (this.resource.getBooleanValue("use-custom-bell")) {
            try {
                Applet.newAudioClip(new File(this.resource.getStringValue("custom-bell-path")).toURI().toURL()).play();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        if (!this.isTabForeground(session)) {
            session.setState(4);
        }
    }

    public void changeSession(final int index) {
        if (index >= 0 && index < this.view.tabbedPane.getTabCount()) {
            final Runnable sessionFocuser = new Runnable(){

                @Override
                public void run() {
                    ((Session)Model.this.sessions.get(index)).requestFocusInWindow();
                }
            };
            Runnable tabbedSwitcher = new Runnable(){

                @Override
                public void run() {
                    ((Model)Model.this).view.tabbedPane.setSelectedIndex(index);
                    SwingUtilities.invokeLater(sessionFocuser);
                }
            };
            SwingUtilities.invokeLater(tabbedSwitcher);
        }
    }

    public void closeCurrentTab() {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            if (!session.isClosed()) {
                if (this.showConfirm(Messages.getString("ZTerm.Message_Confirm_Close"), Messages.getString("ZTerm.Title_Confirm_Close"), 0) != 0) {
                    return;
                }
                session.close(false);
                if (!this.resource.getBooleanValue("remove-manual-disconnect")) {
                    return;
                }
            }
            session.remove();
            this.view.tabbedPane.remove(session);
            this.getSessions().remove(session);
            this.updateTabTitle();
            this.updateTab();
        }
    }

    public void colorCopy() {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            String str = session.getSelectedColorText();
            if (str.length() != 0) {
                this.colorText = str;
            }
            if (this.resource.getBooleanValue("clear-after-copy")) {
                session.resetSelected();
                session.repaint();
            }
        }
    }

    public void colorPaste() {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null && this.colorText != null) {
            session.pasteColorText(this.colorText);
        }
    }

    public void connect(Site site, int index) {
        Session session = new Session(site, this.resource, this.conv, this.view.bi, this);
        if (index == -1) {
            this.getSessions().add(session);
            ImageIcon icon = this.view.closedIcon;
            if (this.resource.getBooleanValue("tab-number")) {
                this.view.tabbedPane.addTab(String.valueOf(this.view.tabbedPane.getTabCount() + 1) + ". " + site.name, icon, session, site.host);
            } else {
                this.view.tabbedPane.addTab(site.name, icon, session, site.host);
            }
            this.view.tabbedPane.setSelectedIndex(this.view.tabbedPane.getTabCount() - 1);
        } else {
            this.getSessions().setElementAt(session, index);
            this.view.tabbedPane.setComponentAt(index, session);
        }
        new Thread(session).start();
    }

    public void copy() {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            String str = session.getSelectedText();
            if (str.length() != 0) {
                this.clip.setContent(str);
            }
            if (this.resource.getBooleanValue("clear-after-copy")) {
                session.resetSelected();
                session.repaint();
            }
        }
    }

    public void copyLink() {
        if (this.copiedLink != null) {
            this.clip.setContent(this.copiedLink);
        }
    }

    public Vector<Site> getCandidateSites(String keyWordSite) {
        Vector<Site> candidateSites = new Vector<Site>();
        if (keyWordSite.length() == 0) {
            return candidateSites;
        }
        for (Site site : this.resource.getFavorites()) {
            if (site.name.indexOf(keyWordSite) == -1 && site.alias.indexOf(keyWordSite) == -1 && site.getURL().indexOf(keyWordSite) == -1) continue;
            candidateSites.addElement(site);
        }
        Collections.sort(candidateSites);
        return candidateSites;
    }

    public String getPassword() {
        return this.w_password;
    }

    public Vector<Session> getSessions() {
        return this.sessions;
    }

    public String getUsername() {
        return this.w_user;
    }

    public boolean isTabForeground(Session session) {
        return this.view.tabbedPane.indexOfComponent(session) == this.view.tabbedPane.getSelectedIndex();
    }

    public void open() {
        String site = JOptionPane.showInputDialog(this.view, (Object)Messages.getString("ZTerm.Message_Input_Site"));
        this.connect(site);
    }

    public void openExternalBrowser(String url) {
        String cmd = this.resource.getStringValue("external-browser-command");
        if (cmd == null) {
            this.showMessage(Messages.getString("ZTerm.Message_Wrong_Explorer_Command"));
            return;
        }
        int urlIndex = cmd.indexOf("%u");
        if (urlIndex == -1) {
            this.showMessage(Messages.getString("ZTerm.Message_Wrong_Explorer_Command"));
            return;
        }
        cmd = String.valueOf(cmd.substring(0, urlIndex)) + url + cmd.substring(urlIndex + 2);
        this.runExternal(cmd);
    }

    public void openNewTab() {
        String site = this.view.siteText.getText();
        this.view.siteModel.removeAllElements();
        this.connect(site);
    }

    public void paste() {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            session.pasteText(this.clip.getContent());
        }
    }

    public void reopenSession(Session session) {
        if (session != null) {
            if (session.isClosed()) {
                this.connect(session.getSite(), this.view.tabbedPane.indexOfComponent(session));
            } else {
                this.connect(session.getSite(), -1);
            }
        }
    }

    public void runExternal(String command) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setView(ZTerm view) {
        this.view = view;
    }

    public void showAbout() {
        this.showMessage(Messages.getString("ZTerm.Message_About"));
    }

    public int showConfirm(String message, String title, int option) {
        return JOptionPane.showConfirmDialog(this.view, message, title, option);
    }

    public void showFAQ() {
        HtmlPane faqHtmlDialog = new HtmlPane(ZTerm.class.getResource("docs/faq.html"));
        JDialog dialog = faqHtmlDialog.createDialog(this.view, Messages.getString("ZTerm.Title_FAQ"));
        dialog.setSize(640, 400);
        dialog.setVisible(true);
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this.view, message);
    }

    public void showPopup(int x, int y, String link) {
        Point viewLocation = this.view.getLocationOnScreen();
        this.view.popupCopyLinkItem.setEnabled(link != null);
        this.copiedLink = link;
        this.view.popupMenu.show(this.view, x - viewLocation.x, y - viewLocation.y);
    }

    public void showPreference() {
        JDialog dialog = this.preferencePane.createDialog(this.view, Messages.getString("Preference.Title"));
        dialog.setSize(620, 300);
        dialog.setVisible(true);
        if (this.preferencePane.getValue() != null && this.preferencePane.getValue() instanceof Integer && this.preferencePane.getValue().equals(new Integer(0))) {
            this.preferencePane.submit();
        }
    }

    public void showSiteManager() {
        SiteManager siteManager = new SiteManager();
        JDialog dialog = siteManager.createDialog(this.view, "Site Manager");
        dialog.setSize(600, 350);
        dialog.setVisible(true);
        if (siteManager.getValue() != null && siteManager.getValue() instanceof Integer && siteManager.getValue().equals(new Integer(0))) {
            siteManager.submit();
        }
    }

    public void showUsage() {
        HtmlPane usageHtmlDialog = new HtmlPane(ZTerm.class.getResource("docs/usage.html"));
        JDialog dialog = usageHtmlDialog.createDialog(this.view, Messages.getString("ZTerm.Title_Manual"));
        dialog.setSize(640, 400);
        dialog.setVisible(true);
    }

    public void updateAntiIdleTime() {
        int i = 0;
        while (i < this.sessions.size()) {
            ((Session)this.sessions.elementAt(i)).updateAntiIdleTime();
            ++i;
        }
    }

    public void updateBounds() {
        int locationx = this.resource.getIntValue("geometry.x");
        int locationy = this.resource.getIntValue("geometry.y");
        int width = this.resource.getIntValue("geometry.width");
        int height = this.resource.getIntValue("geometry.height");
        this.view.setBounds(locationx, locationy, width, height);
        this.view.validate();
    }

    public void updateEncoding(String encoding) {
        Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            session.setEncoding(encoding);
        }
    }

    public void updateFavoriteMenu() {
        this.view.updateFavoriteMenu();
    }

    public void updateLookAndFeel() {
        this.view.updateLookAndFeel();
    }

    public void updateSize() {
        Rectangle bounds = this.view.getBounds();
        this.resource.setValue("geometry.x", (int)bounds.getX());
        this.resource.setValue("geometry.y", (int)bounds.getY());
        this.resource.setValue("geometry.width", (int)bounds.getWidth());
        this.resource.setValue("geometry.height", (int)bounds.getHeight());
        this.preferencePane.apperancePanel.widthSpinner.setValue((int)bounds.getWidth());
        this.preferencePane.apperancePanel.heightSpinner.setValue((int)bounds.getHeight());
        this.view.updateSize();
    }

    public void updateTab() {
        final Session session = (Session)this.view.tabbedPane.getSelectedComponent();
        if (session != null) {
            this.view.siteText.setText(session.getURL());
            this.view.siteText.select(0, 0);
            this.view.siteField.hidePopup();
            if (session.state == 4) {
                session.setState(2);
            }
            session.updateScreen();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    session.requestFocusInWindow();
                }
            });
        } else {
            this.view.siteText.setText("");
        }
    }

    public void updateTabState(int state, Session session) {
        this.view.updateTabState(state, session);
    }

    public void updateTabTitle() {
        int i = 0;
        while (i < this.view.tabbedPane.getTabCount()) {
            this.view.tabbedPane.setTitleAt(i, String.valueOf(i + 1) + ". " + this.getSessions().elementAt((int)i).getSite().name);
            this.view.tabbedPane.setTitleAt(i, String.valueOf(this.resource.getBooleanValue("tab-number") ? String.valueOf(i + 1) + ". " : "") + this.getSessions().elementAt((int)i).getSite().name);
            ++i;
        }
    }

    public void updateToolbar(boolean isShowToolbar) {
        this.preferencePane.apperancePanel.showToolbarCheckBox.setSelected(isShowToolbar);
        this.view.updateToolbar(isShowToolbar);
    }

    private void connect(String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        Site site = this.resource.getFavorite(url);
        if (site == null) {
            int port;
            String host;
            int position = url.indexOf("://");
            String protocol = "telnet";
            if (position != -1) {
                if (url.substring(0, position).equalsIgnoreCase("ssh")) {
                    protocol = "ssh";
                } else if (url.substring(0, position).equalsIgnoreCase("telnet")) {
                    protocol = "telnet";
                } else {
                    this.showMessage(Messages.getString("ZTerm.Message_Wrong_Protocal"));
                    return;
                }
                url = url.substring(position + 3);
            }
            if ((position = url.indexOf(58)) == -1) {
                host = url;
                port = protocol.equalsIgnoreCase("telnet") ? 23 : 22;
            } else {
                host = url.substring(0, position);
                port = Integer.parseInt(url.substring(position + 1));
            }
            site = new Site(host, host, port, protocol);
        }
        if (url.length() == 0) {
            return;
        }
        this.connect(site, -1);
    }

    public void refreshMessages() {
        Messages.restartBundle();
        this.view.updateText();
        this.preferencePane = new PreferencePane();
    }
}

