/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Site;
import org.zhouer.zterm.ZTerm;

public class KeyHandler
extends KeyAdapter {
    private Model model;
    private ZTerm view;

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.view.siteText && e.getKeyCode() == 27) {
            this.model.updateTab();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.view.siteText) {
            if (e.isMetaDown() || e.isAltDown()) {
                return;
            }
            if (e.getKeyChar() == '\n') {
                this.model.openNewTab();
            } else if (e.getKeyChar() != '\u001b') {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KeyHandler.this.updateCombo();
                    }
                });
            }
        }
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setView(ZTerm view) {
        this.view = view;
    }

    protected void updateCombo() {
        int dotPos = this.view.siteText.getCaretPosition();
        String text = this.view.siteText.getText();
        Iterator<Site> siteIterator = this.model.getCandidateSites(text).iterator();
        this.view.siteModel.removeAllElements();
        this.view.siteModel.addElement(text);
        while (siteIterator.hasNext()) {
            this.view.siteModel.addElement(siteIterator.next().getURL());
        }
        this.view.siteText.setCaretPosition(dotPos);
        if (this.view.siteModel.getSize() > 1) {
            this.view.siteField.showPopup();
        } else {
            this.view.siteField.hidePopup();
        }
    }
}

