/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.vt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.zhouer.utils.Convertor;
import org.zhouer.utils.TextUtils;
import org.zhouer.utils.UrlRecognizer;
import org.zhouer.vt.Application;
import org.zhouer.vt.Config;
import org.zhouer.vt.FIFOSet;
import org.zhouer.vt.User;

public class VT100
extends JComponent {
    public static final int APPLICATION_KEYPAD = 2;
    public static final int NUMERIC_KEYPAD = 1;
    private static final byte BACKGROUND = 1;
    private static final byte BLINK = 16;
    private static final byte BOLD = 1;
    private static final byte CURSOR = 2;
    private static Color cursorColor = Color.GREEN;
    private static final boolean DEBUG = false;
    private static byte defAttr = 0;
    private static byte defBg = 0;
    private static byte defFg = (byte)7;
    private static final byte FOREGROUND = 0;
    private static Color[] highlight_colors = new Color[]{new Color(128, 128, 128), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255), new Color(0, 255, 255), new Color(255, 255, 255)};
    private static Color[] normal_colors = new Color[]{new Color(0, 0, 0), new Color(128, 0, 0), new Color(0, 128, 0), new Color(128, 128, 0), new Color(0, 0, 128), new Color(128, 0, 128), new Color(0, 128, 128), new Color(192, 192, 192)};
    private static final byte REVERSE = 64;
    private static final long serialVersionUID = -5704767444883397941L;
    private static final byte UNDERLINE = 8;
    private static final byte URL = 3;
    private static Color urlColor = Color.ORANGE;
    private byte[] attrBuf;
    private byte[] fgBuf;
    private byte[] bgBuf;
    private byte[][] attributes;
    private byte[][] bgcolors;
    private BufferedImage bi;
    private byte cattribute;
    private int ccol;
    private int crow;
    private byte cfgcolor;
    private byte cbgcolor;
    private final Convertor conv;
    private int debug_counter = 0;
    private String emulation;
    private String encoding;
    private byte[][] fgcolors;
    private Font font;
    private int fontsize;
    private int fontverticalgap;
    private int fonthorizontalgap;
    private int fontdescentadj;
    private int fontwidth;
    private int fontheight;
    private int fontdescent;
    private boolean init_ready;
    private boolean[][] isurl;
    private int keypadmode;
    private int lcol;
    private int lrow;
    private boolean linefull;
    private int maxrow;
    private int maxcol;
    private int[][] mbc;
    private byte[] nvtBuf;
    private int nvtBufPos;
    private int nvtBufLen;
    private final Application parent;
    private Vector probablyurl;
    private Object repaintLock;
    private FIFOSet repaintSet;
    private final Config resource;
    private int scol;
    private int srow;
    private int scrolllines;
    private int scrolluprow;
    private boolean[][] selected;
    private char[][] text;
    private boolean text_blink;
    private boolean cursor_blink;
    private int text_blink_count;
    private int cursor_blink_count;
    private byte[] textBuf;
    private int textBufPos;
    private Timer ti;
    private int topmargin;
    private int buttommargin;
    private int leftmargin;
    private int rightmargin;
    private int toprow;
    private int totalrow;
    private int totalcol;
    private int transx;
    private int transy;
    private User user;
    private int width;
    private int height;

    public VT100(Application p, Config c, Convertor cv, BufferedImage b) {
        this.parent = p;
        this.resource = c;
        this.conv = cv;
        this.bi = b;
        this.initValue();
        this.initArray();
        this.initOthers();
    }

    public void close() {
        this.ti.stop();
        this.removeKeyListener(this.user);
        this.removeMouseListener(this.user);
        this.removeMouseMotionListener(this.user);
    }

    public boolean coverURL(int x, int y) {
        int c = (x -= this.transx) / this.fontwidth + 1;
        int r = (y -= this.transy) / this.fontheight + 1;
        if (r < 1 || r > this.maxrow || c < 1 || c > this.maxcol) {
            return false;
        }
        int prow = this.physicalRow(r - this.scrolluprow);
        return this.isurl[prow][c - 1];
    }

    public String getEmulation() {
        return this.emulation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getKeypadMode() {
        return this.keypadmode;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public String getSelectedColorText() {
        Vector<Byte> a = new Vector<Byte>();
        Vector<Byte> b = new Vector<Byte>();
        Vector<Byte> fg = new Vector<Byte>();
        Vector<Byte> bg = new Vector<Byte>();
        int i = 0;
        while (i < this.totalrow) {
            int j = 0;
            while (j < this.totalcol) {
                if (this.selected[i][j]) break;
                ++j;
            }
            if (j != this.totalcol) {
                int last = this.totalcol - 1;
                while (last >= 0) {
                    if (this.selected[i][last] && this.mbc[i][last] != 0) break;
                    --last;
                }
                j = 0;
                while (j <= last) {
                    if (this.selected[i][j]) {
                        if (this.mbc[i][j] == 0) {
                            a.addElement(new Byte(0));
                            b.addElement(new Byte(32));
                            fg.addElement(new Byte(defFg));
                            bg.addElement(new Byte(defBg));
                        } else if (this.mbc[i][j] == 1) {
                            byte[] buf = this.conv.charToBytes(this.text[i][j], this.encoding);
                            int k = 0;
                            while (k < buf.length) {
                                b.addElement(new Byte(buf[k]));
                                a.addElement(new Byte(this.attributes[i][j + Math.min(k, 2)]));
                                fg.addElement(new Byte(this.fgcolors[i][j + Math.min(k, 2)]));
                                bg.addElement(new Byte(this.bgcolors[i][j + Math.min(k, 2)]));
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                a.addElement(new Byte(0));
                b.addElement(new Byte(13));
                fg.addElement(new Byte(defFg));
                bg.addElement(new Byte(defBg));
            }
            ++i;
        }
        return this.makePasteText(a, b, fg, bg);
    }

    public String getSelectedText() {
        boolean firstLine = true;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.totalrow) {
            int j = 0;
            while (j < this.totalcol) {
                if (this.selected[i][j]) break;
                ++j;
            }
            if (j != this.totalcol) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                j = this.totalcol - 1;
                while (j >= 0) {
                    if (this.selected[i][j] && this.mbc[i][j] != 0) break;
                    --j;
                }
                int k = 0;
                while (k <= j) {
                    if (this.selected[i][k]) {
                        if (this.mbc[i][k] == 0) {
                            sb.append(" ");
                        } else if (this.mbc[i][k] == 1) {
                            sb.append(this.text[i][k]);
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String getURL(int x, int y) {
        StringBuffer sb = new StringBuffer();
        int c = (x -= this.transx) / this.fontwidth + 1;
        int r = (y -= this.transy) / this.fontheight + 1;
        if (r < 1 || r > this.maxrow || c < 1 || c > this.maxcol) {
            return new String();
        }
        int prow = this.physicalRow(r - this.scrolluprow);
        int i = c;
        while (i > 0 && this.isurl[prow][i - 1]) {
            --i;
        }
        ++i;
        while (i <= this.maxcol && this.isurl[prow][i - 1]) {
            if (this.mbc[prow][i - 1] == 1) {
                sb.append(this.text[prow][i - 1]);
            }
            ++i;
        }
        return sb.toString();
    }

    public void pasteColorText(String str) {
        byte[] tmp = new byte[str.length()];
        int i = 0;
        while (i < str.length()) {
            tmp[i] = (byte)str.charAt(i);
            ++i;
        }
        this.parent.writeBytes(tmp, 0, tmp.length);
    }

    public void pasteText(String str) {
        if (str == null) {
            return;
        }
        boolean autobreak = this.resource.getBooleanValue("auto-line-break");
        int breakcount = this.resource.getIntValue("auto-line-break-length");
        if (autobreak) {
            str = TextUtils.fmt(str, breakcount);
        }
        char[] cArr = str.toCharArray();
        int i = 0;
        while (i < cArr.length) {
            if (cArr[i] == '\n') {
                cArr[i] = 13;
            }
            ++i;
        }
        this.parent.writeChars(cArr, 0, cArr.length);
    }

    public void resetSelected() {
        int i = 0;
        while (i < this.totalrow) {
            int j = 0;
            while (j < this.totalcol) {
                if (this.selected[i][j]) {
                    this.selected[i][j] = false;
                    this.setRepaintPhysical(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void run() {
        this.requestFocusInWindow();
        this.init_ready = true;
        while (!this.parent.isClosed()) {
            this.parse();
            if (!this.isBufferEmpty()) continue;
            this.repaint();
        }
    }

    public void selectConsequtive(int x, int y) {
        int c = (x -= this.transx) / this.fontwidth + 1;
        int r = (y -= this.transy) / this.fontheight + 1;
        if (c < 1 || c > this.maxcol || r < 1 || r > this.maxrow) {
            return;
        }
        int prow = this.physicalRow(r - this.scrolluprow);
        int beginx = c;
        while (beginx > 0) {
            if (this.mbc[prow][beginx - 1] == 0 || this.mbc[prow][beginx - 1] == 1 && this.text[prow][beginx - 1] == ' ') break;
            --beginx;
        }
        int endx = c;
        while (endx <= this.maxcol) {
            if (this.mbc[prow][endx - 1] == 0 || this.mbc[prow][endx - 1] == 1 && this.text[prow][endx - 1] == ' ') break;
            ++endx;
        }
        this.resetSelected();
        int i = beginx + 1;
        while (i < endx) {
            this.selected[prow][i - 1] = true;
            this.setRepaintPhysical(prow, i - 1);
            ++i;
        }
    }

    public void selectEntireLine(int x, int y) {
        int c = (x -= this.transx) / this.fontwidth + 1;
        int r = (y -= this.transy) / this.fontheight + 1;
        if (c < 1 || c > this.maxcol || r < 1 || r > this.maxrow) {
            return;
        }
        this.resetSelected();
        int prow = this.physicalRow(r - this.scrolluprow);
        int i = 1;
        while (i < this.maxcol) {
            this.selected[prow][i - 1] = true;
            this.setRepaintPhysical(prow, i - 1);
            ++i;
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.updateSize();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.updateSize();
    }

    public void setEmulation(String emu) {
        this.emulation = emu;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public void setScrollUp(int scroll) {
        this.scrolluprow = scroll;
        this.updateScreen();
    }

    public void setSelected(int x1, int y1, int x2, int y2) {
        int tmp;
        int c1 = (x1 -= this.transx) / this.fontwidth + 1;
        int r1 = (y1 -= this.transy) / this.fontheight + 1;
        int c2 = (x2 -= this.transx) / this.fontwidth + 1;
        int r2 = (y2 -= this.transy) / this.fontheight + 1;
        if (r1 > r2) {
            tmp = r1;
            r1 = r2;
            r2 = tmp;
            tmp = c1;
            c1 = c2;
            c2 = tmp;
        } else if (r1 == r2 && c1 > c2) {
            tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        this.resetSelected();
        int i = 1;
        while (i <= this.maxrow) {
            int j = 1;
            while (j <= this.maxcol) {
                int prow = this.physicalRow(i - this.scrolluprow);
                boolean orig = this.selected[prow][j - 1];
                this.selected[prow][j - 1] = i > r1 && i < r2 ? true : (i == r1 && i == r2 ? j >= c1 && j <= c2 : (i == r1 ? j >= c1 : (i == r2 ? j <= c2 : false)));
                if (this.selected[prow][j - 1] != orig) {
                    this.setRepaintPhysical(prow, j - 1);
                }
                ++j;
            }
            ++i;
        }
    }

    public void updateFont() {
        this.fonthorizontalgap = this.resource.getIntValue("font.hoizontal-gap");
        this.fontverticalgap = this.resource.getIntValue("font.vertical-gap");
        this.fontdescentadj = this.resource.getIntValue("font.descent-adjust");
        String family = this.resource.getStringValue("font.family");
        this.fontsize = this.resource.getIntValue("font.size");
        if (this.fontsize == 0) {
            int fh = this.height / this.maxrow - this.fontverticalgap;
            int fw = this.width / this.maxcol - this.fonthorizontalgap;
            if (fh > 2 * fw) {
                fh = 2 * fw;
            }
            this.fontsize = fh;
        }
        int style = 0;
        if (this.resource.getBooleanValue("font.bold")) {
            style |= 1;
        }
        if (this.resource.getBooleanValue("font.italy")) {
            style |= 2;
        }
        this.font = new Font(family, style, this.fontsize);
        FontMetrics fm = this.getFontMetrics(this.font);
        this.fontheight = this.fontsize;
        this.fontwidth = this.fontsize / 2;
        this.fontdescent = (int)(1.0 * (double)fm.getDescent() / (double)fm.getHeight() * (double)this.fontsize);
        this.fontheight += this.fontverticalgap;
        this.fontwidth += this.fonthorizontalgap;
        this.fontdescent += this.fontdescentadj;
        this.transx = (this.width - this.fontwidth * this.maxcol) / 2;
        this.transy = (this.height - this.fontheight * this.maxrow) / 2;
    }

    public void updateImage(BufferedImage b) {
        this.bi = b;
    }

    public void updateScreen() {
        int i = 1;
        while (i <= this.maxrow) {
            int j = 1;
            while (j <= this.maxcol) {
                this.setRepaintPhysical(this.physicalRow(i - this.scrolluprow), j - 1);
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    public void updateSize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.updateFont();
        this.updateScreen();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.parent.isTabForeground() || !this.init_ready) {
            return;
        }
        this.checkURLOnScreen();
        this.draw();
        g.drawImage(this.bi, 0, 0, null);
    }

    private void bell() {
        this.parent.bell();
    }

    private void checkURLOnScreen() {
        int i = 0;
        while (i < this.maxrow) {
            int prow = this.physicalRow(i - this.scrolluprow + 1);
            String message = String.valueOf(this.text[prow]);
            int j = 0;
            while (j < this.maxcol) {
                if (UrlRecognizer.isPartOfHttp(message, j)) {
                    this.isurl[prow][j] = true;
                    this.setRepaintPhysical(prow, j);
                }
                ++j;
            }
            ++i;
        }
    }

    private void copy(int dstrow, int dstcol, int srcrow, int srccol) {
        int pdstrow = this.physicalRow(dstrow);
        int psrcrow = this.physicalRow(srcrow);
        this.text[pdstrow][dstcol - 1] = this.text[psrcrow][srccol - 1];
        this.mbc[pdstrow][dstcol - 1] = this.mbc[psrcrow][srccol - 1];
        this.fgcolors[pdstrow][dstcol - 1] = this.fgcolors[psrcrow][srccol - 1];
        this.bgcolors[pdstrow][dstcol - 1] = this.bgcolors[psrcrow][srccol - 1];
        this.attributes[pdstrow][dstcol - 1] = this.attributes[psrcrow][srccol - 1];
        this.isurl[pdstrow][dstcol - 1] = this.isurl[psrcrow][srccol - 1];
        this.setRepaint(dstrow, dstcol);
    }

    private void delete_characters(int n) {
        int i = this.ccol;
        while (i <= this.maxcol) {
            if (i <= this.maxcol - n) {
                this.copy(this.crow, i, this.crow, i + n);
            } else {
                this.reset(this.crow, i);
            }
            ++i;
        }
    }

    private void delete_lines(int n) {
        if (this.crow + n > this.buttommargin) {
            int i = this.crow;
            while (i <= this.buttommargin) {
                this.eraseline(i, 2);
                ++i;
            }
            return;
        }
        int i = this.crow + n;
        while (i <= this.buttommargin) {
            int j = this.leftmargin;
            while (j <= this.rightmargin) {
                this.copy(i - n, j, i, j);
                ++j;
            }
            ++i;
        }
        i = this.buttommargin - n + 1;
        while (i <= this.buttommargin) {
            this.eraseline(i, 2);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw() {
        Graphics2D g = this.bi.createGraphics();
        g.setFont(this.font);
        g.translate(this.transx, this.transy);
        if (this.resource.getBooleanValue("font.antialias")) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        while (!this.repaintSet.isEmpty()) {
            int pcol;
            int prow;
            Object object = this.repaintLock;
            synchronized (object) {
                int v = this.repaintSet.remove();
                prow = v >> 8;
                pcol = v & 0xFF;
            }
            int row = this.logicalRow(prow);
            int col = pcol + 1;
            if (row < 1 || row > this.maxrow || col < 1 || col > this.maxcol) continue;
            int h = (row - 1) * this.fontheight;
            int w = (col - 1) * this.fontwidth;
            boolean show_text = (this.attributes[prow][pcol] & 0x10) == 0 || this.text_blink;
            boolean show_cursor = this.physicalRow(this.crow) == prow && this.ccol == col && this.cursor_blink;
            boolean show_underline = (this.attributes[prow][pcol] & 8) != 0;
            g.setColor(this.getColor(prow, pcol, (byte)1));
            g.fillRect(w, h, this.fontwidth, this.fontheight);
            if (show_cursor) {
                g.setColor(this.getColor(prow, pcol, (byte)2));
                g.fillRect(w, h, this.fontwidth, this.fontheight);
            }
            if (this.mbc[prow][pcol] == 0) continue;
            g.setColor(this.getColor(prow, pcol, (byte)0));
            if (show_text) {
                Shape oldclip = g.getClip();
                char character = this.text[prow][pcol - this.mbc[prow][pcol] + 1];
                int x = w - this.fontwidth * (this.mbc[prow][pcol] - 1);
                int y = h + this.fontheight - this.fontdescent;
                g.clipRect(w, h, this.fontwidth, this.fontheight);
                g.drawString(Character.toString(character), x, y);
                g.setClip(oldclip);
            }
            if (!show_underline && !this.isurl[prow][pcol]) continue;
            if (this.isurl[prow][pcol]) {
                g.setColor(this.getColor(prow, pcol, (byte)3));
            }
            g.drawLine(w, h + this.fontheight - 1, w + this.fontwidth - 1, h + this.fontheight - 1);
        }
        g.dispose();
    }

    private void eraseline(int row, int mode) {
        int end;
        int begin;
        switch (mode) {
            case 0: {
                begin = this.ccol;
                end = this.rightmargin;
                break;
            }
            case 1: {
                begin = this.leftmargin;
                end = this.ccol;
                break;
            }
            case 2: {
                begin = this.leftmargin;
                end = this.rightmargin;
                break;
            }
            default: {
                begin = this.leftmargin;
                end = this.rightmargin;
            }
        }
        int i = begin;
        while (i <= end) {
            this.reset(row, i);
            ++i;
        }
    }

    private void erasescreen(int mode) {
        int end;
        int begin;
        switch (mode) {
            case 0: {
                this.eraseline(this.crow, mode);
                begin = this.crow + 1;
                end = this.maxrow;
                break;
            }
            case 1: {
                this.eraseline(this.crow, mode);
                begin = 1;
                end = this.crow - 1;
                break;
            }
            case 2: {
                begin = 1;
                end = this.maxrow;
                break;
            }
            default: {
                begin = 1;
                end = this.maxrow;
            }
        }
        int i = begin;
        while (i <= end) {
            this.eraseline(i, 2);
            ++i;
        }
    }

    private Color getColor(int prow, int pcol, byte mode) {
        Color c;
        boolean bold = (this.attributes[prow][pcol] & 1) != 0;
        boolean reverse = this.selected[prow][pcol] ^ (this.attributes[prow][pcol] & 0x40) != 0;
        if (mode == 0 && !reverse || mode == 1 && reverse) {
            c = bold ? highlight_colors[this.fgcolors[prow][pcol]] : normal_colors[this.fgcolors[prow][pcol]];
        } else if (mode == 1 && !reverse || mode == 0 && reverse) {
            c = normal_colors[this.bgcolors[prow][pcol]];
        } else if (mode == 2) {
            c = cursorColor;
        } else if (mode == 3) {
            c = urlColor;
        } else {
            System.err.println("Unknown color mode!");
            c = Color.WHITE;
        }
        return c;
    }

    private byte getNextByte() {
        if (this.nvtBufPos == this.nvtBufLen) {
            this.nvtBufLen = this.parent.readBytes(this.nvtBuf);
            if (this.nvtBufLen == -1) {
                return 0;
            }
            this.nvtBufPos = 0;
        }
        return this.nvtBuf[this.nvtBufPos++];
    }

    private void initArray() {
        int j;
        this.nvtBuf = new byte[4096];
        this.nvtBufLen = 0;
        this.nvtBufPos = 0;
        this.text = new char[this.totalrow][this.totalcol];
        this.mbc = new int[this.totalrow][this.totalcol];
        this.fgcolors = new byte[this.totalrow][this.totalcol];
        this.bgcolors = new byte[this.totalrow][this.totalcol];
        this.attributes = new byte[this.totalrow][this.totalcol];
        this.selected = new boolean[this.totalrow][this.totalcol];
        this.isurl = new boolean[this.totalrow][this.totalcol];
        this.textBuf = new byte[4];
        this.attrBuf = new byte[4];
        this.fgBuf = new byte[4];
        this.bgBuf = new byte[4];
        this.textBufPos = 0;
        this.repaintSet = new FIFOSet(this.totalrow << 8);
        this.repaintLock = new Object();
        int i = 0;
        while (i < this.totalrow) {
            j = 0;
            while (j < this.totalcol) {
                this.text[i][j] = '\u0000';
                this.mbc[i][j] = 0;
                this.fgcolors[i][j] = defFg;
                this.bgcolors[i][j] = defBg;
                this.attributes[i][j] = defAttr;
                this.isurl[i][j] = false;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.maxrow) {
            j = 1;
            while (j < this.maxcol) {
                this.setRepaint(i, j);
                ++j;
            }
            ++i;
        }
    }

    private void initOthers() {
        this.init_ready = false;
        this.ti = new Timer(250, new RepaintTask());
        this.ti.start();
        this.setFocusTraversalKeysEnabled(false);
        this.enableInputMethods(true);
        this.setSize(new Dimension(800, 600));
        this.user = new User(this.parent, this, this.resource);
        this.addKeyListener(this.user);
        this.addMouseListener(this.user);
        this.addMouseMotionListener(this.user);
    }

    private void initValue() {
        this.maxcol = this.resource.getIntValue("terminal.columns");
        this.maxrow = this.resource.getIntValue("terminal.rows");
        this.scrolllines = this.resource.getIntValue("terminal.scrolls");
        this.totalrow = this.maxrow + this.scrolllines;
        this.totalcol = this.maxcol;
        this.toprow = 0;
        this.topmargin = 1;
        this.buttommargin = this.maxrow;
        this.leftmargin = 1;
        this.rightmargin = this.maxcol;
        this.crow = 1;
        this.ccol = 1;
        this.lrow = 1;
        this.lcol = 1;
        this.srow = 1;
        this.scol = 1;
        this.cfgcolor = defFg;
        this.cbgcolor = defBg;
        this.cattribute = defAttr;
        this.probablyurl = new Vector();
        this.text_blink_count = 0;
        this.cursor_blink_count = 0;
        this.text_blink = true;
        this.cursor_blink = true;
        this.linefull = false;
        this.keypadmode = 1;
    }

    private void insert_space(int n) {
        int i = this.rightmargin;
        while (i >= this.ccol) {
            if (i >= this.ccol + n) {
                this.copy(this.crow, i, this.crow, i - n);
            } else {
                this.reset(this.crow, i);
            }
            --i;
        }
    }

    private void insertline(int r, int n) {
        int i = this.buttommargin;
        while (i >= r) {
            int j = this.leftmargin;
            while (j <= this.rightmargin) {
                if (i >= r + n) {
                    this.copy(i, j, i - n, j);
                } else {
                    this.reset(i, j);
                }
                ++j;
            }
            --i;
        }
    }

    private void insertTextBuf() {
        char c = this.conv.bytesToChar(this.textBuf, 0, this.textBufPos, this.encoding);
        boolean isWide = Convertor.isWideChar(c);
        if (this.linefull || isWide && this.ccol + 1 > this.rightmargin) {
            this.linefull = false;
            this.ccol = this.leftmargin;
            ++this.crow;
            if (this.crow > this.buttommargin) {
                this.scrollpage(1);
                --this.crow;
            }
            this.setRepaint(this.crow, this.leftmargin);
        }
        int prow = this.physicalRow(this.crow);
        this.text[prow][this.ccol - 1] = c;
        int i = 0;
        while (i < (isWide ? Math.min(this.textBufPos, 2) : 1)) {
            this.fgcolors[prow][this.ccol + i - 1] = this.fgBuf[i];
            this.bgcolors[prow][this.ccol + i - 1] = this.bgBuf[i];
            this.attributes[prow][this.ccol + i - 1] = this.attrBuf[i];
            this.mbc[prow][this.ccol + i - 1] = i + 1;
            this.isurl[prow][this.ccol + i - 1] = false;
            this.setRepaint(this.crow, this.ccol + i);
            ++i;
        }
        this.textBufPos = 0;
        ++this.ccol;
        if (isWide) {
            ++this.ccol;
        }
        if (this.ccol > this.rightmargin) {
            this.linefull = true;
            --this.ccol;
        }
    }

    private boolean isBufferEmpty() {
        return this.nvtBufPos == this.nvtBufLen;
    }

    private boolean isControlChar(char c) {
        return c >= '\u0000' && c < ' ';
    }

    private int logicalRow(int prow) {
        int row;
        int tmptop = this.toprow - this.scrolluprow;
        if (tmptop < 0) {
            tmptop += this.totalrow;
        }
        if ((row = prow - tmptop + 1) < 1) {
            row += this.totalrow;
        }
        return row;
    }

    private String makePasteText(Vector a, Vector b, Vector fg, Vector bg) {
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[32];
        buf[0] = 21;
        buf[1] = 91;
        buf[2] = 109;
        sb.append(buf, 0, 3);
        int cattr = 0;
        byte cfg = defFg;
        byte cbg = defBg;
        int i = 0;
        while (i < a.size()) {
            byte tmpattr = (Byte)a.elementAt(i);
            byte tmpfg = (Byte)fg.elementAt(i);
            byte tmpbg = (Byte)bg.elementAt(i);
            int mask = 1;
            int j = 0;
            boolean needControl = false;
            boolean needReset = false;
            while (j < 7) {
                if ((cattr & mask << j) != 0 && (tmpattr & mask << j) == 0) {
                    needReset = true;
                }
                if ((cattr & mask << j) != (tmpattr & mask << j)) {
                    needControl = true;
                }
                if (cfg != tmpfg || cbg != tmpbg) {
                    needControl = true;
                }
                ++j;
            }
            if (!needControl) {
                sb.append((char)((Byte)b.elementAt(i)).byteValue());
            } else {
                int c;
                buf[0] = 21;
                buf[1] = 91;
                if (needReset) {
                    buf[2] = 48;
                    mask = 1;
                    j = 0;
                    c = 3;
                    while (j < 7) {
                        if ((tmpattr & mask << j) != 0) {
                            buf[c++] = 59;
                            buf[c++] = (char)(49 + j);
                        }
                        ++j;
                    }
                    if (tmpfg != defFg) {
                        buf[c++] = 59;
                        buf[c++] = 51;
                        buf[c++] = (char)(tmpfg + 48);
                    }
                    if (tmpbg != defBg) {
                        buf[c++] = 59;
                        buf[c++] = 52;
                        buf[c++] = (char)(tmpbg + 48);
                    }
                } else {
                    boolean isFirst = true;
                    mask = 1;
                    j = 0;
                    c = 2;
                    while (j < 7) {
                        if ((tmpattr & mask << j) != 0 && (cattr & mask << j) == 0) {
                            if (isFirst) {
                                isFirst = false;
                            } else {
                                buf[c++] = 59;
                            }
                            buf[c++] = (char)(49 + j);
                        }
                        ++j;
                    }
                    if (cfg != tmpfg) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            buf[c++] = 59;
                        }
                        buf[c++] = 51;
                        buf[c++] = (char)(tmpfg + 48);
                    }
                    if (cbg != tmpbg) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            buf[c++] = 59;
                        }
                        buf[c++] = 52;
                        buf[c++] = (char)(tmpbg + 48);
                    }
                }
                buf[c++] = 109;
                buf[c++] = (char)((Byte)b.elementAt(i)).byteValue();
                sb.append(buf, 0, c);
                cattr = tmpattr;
                cfg = tmpfg;
                cbg = tmpbg;
            }
            ++i;
        }
        return sb.toString();
    }

    private void parse() {
        byte b = this.getNextByte();
        this.lcol = this.ccol;
        this.lrow = this.crow;
        if (this.isControlChar((char)b)) {
            this.parse_control(b);
        } else {
            this.textBuf[this.textBufPos] = b;
            this.attrBuf[this.textBufPos] = this.cattribute;
            this.fgBuf[this.textBufPos] = this.cfgcolor;
            this.bgBuf[this.textBufPos] = this.cbgcolor;
            ++this.textBufPos;
            if (this.conv.isValidMultiBytes(this.textBuf, 0, this.textBufPos, this.encoding)) {
                this.insertTextBuf();
            }
        }
        this.setRepaint(this.lrow, this.lcol);
        if (this.lcol != this.ccol || this.lrow != this.crow) {
            this.cursor_blink_count = 0;
            this.cursor_blink = true;
            this.setRepaint(this.crow, this.ccol);
            this.textBufPos = 0;
            this.linefull = false;
        }
    }

    private void parse_control(byte b) {
        switch (b) {
            case 0: {
                break;
            }
            case 7: {
                this.bell();
                break;
            }
            case 8: {
                if (this.linefull) {
                    this.linefull = false;
                    break;
                }
                if (this.ccol > this.leftmargin) {
                    --this.ccol;
                    break;
                }
                if (this.ccol != this.leftmargin || this.crow <= this.topmargin) break;
                this.ccol = this.rightmargin;
                --this.crow;
                break;
            }
            case 9: {
                this.ccol = ((this.ccol - 1) / 8 + 1) * 8 + 1;
                break;
            }
            case 10: {
                ++this.crow;
                if (this.crow <= this.buttommargin) break;
                this.scrollpage(1);
                --this.crow;
                break;
            }
            case 13: {
                this.ccol = this.leftmargin;
                break;
            }
            case 14: {
                System.out.println("SO (not yet support)");
                break;
            }
            case 15: {
                System.out.println("SI (not yet support)");
                break;
            }
            case 24: {
                System.out.println("CAN (not yet support)");
                break;
            }
            case 25: 
            case 26: {
                System.out.println("SUB (not yet support)");
                break;
            }
            case 27: {
                this.parse_esc();
                break;
            }
        }
    }

    private void parse_csi() {
        byte b;
        int[] argv = new int[256];
        int arg = -1;
        int argc = 0;
        while (true) {
            if (48 <= (b = this.getNextByte()) && b <= 57) {
                arg = arg == -1 ? 0 : (arg *= 10);
                arg += b - 48;
                continue;
            }
            if (b == 59) {
                argv[argc] = arg;
                ++argc;
                arg = -1;
                continue;
            }
            if (b != 63 && b != 33 && b != 34 && b != 39) break;
        }
        argv[argc] = arg;
        ++argc;
        switch (b) {
            case 100: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.crow = argv[0];
                break;
            }
            case 104: {
                int i = 0;
                while (i < argc) {
                    this.set_mode(argv[i]);
                    ++i;
                }
                break;
            }
            case 108: {
                int i = 0;
                while (i < argc) {
                    this.reset_mode(argv[i]);
                    ++i;
                }
                break;
            }
            case 109: {
                int i = 0;
                while (i < argc) {
                    if (argv[i] == -1) {
                        argv[i] = 0;
                    }
                    this.setColor(argv[i]);
                    ++i;
                }
                break;
            }
            case 114: {
                this.setmargin(argv[0], argv[1]);
                break;
            }
            case 115: {
                this.save_cursor_position();
                break;
            }
            case 117: {
                this.restore_cursor_position();
                break;
            }
            case 65: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.crow = Math.max(this.crow - argv[0], this.topmargin);
                break;
            }
            case 66: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.crow = Math.min(this.crow + argv[0], this.buttommargin);
                break;
            }
            case 67: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.ccol = Math.min(this.ccol + argv[0], this.rightmargin);
                break;
            }
            case 68: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.ccol = Math.max(this.ccol - argv[0], this.leftmargin);
                break;
            }
            case 72: {
                if (argv[0] < 1) {
                    argv[0] = 1;
                }
                if (argv[1] < 1) {
                    argv[1] = 1;
                }
                this.crow = Math.min(Math.max(argv[0], this.topmargin), this.buttommargin);
                this.ccol = Math.min(Math.max(argv[1], this.leftmargin), this.rightmargin);
                break;
            }
            case 74: {
                if (argv[0] == -1) {
                    argv[0] = 0;
                }
                this.erasescreen(argv[0]);
                break;
            }
            case 75: {
                if (argv[0] == -1) {
                    argv[0] = 0;
                }
                this.eraseline(this.crow, argv[0]);
                break;
            }
            case 76: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.insertline(this.crow, argv[0]);
                break;
            }
            case 77: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.delete_lines(argv[0]);
                break;
            }
            case 80: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.delete_characters(argv[0]);
                break;
            }
            case 64: {
                if (argv[0] == -1) {
                    argv[0] = 1;
                }
                this.insert_space(argv[0]);
                break;
            }
            case 62: {
                b = this.getNextByte();
                if (b == 99) {
                    System.out.println("Send Secondary Device Attributes String");
                    break;
                }
                System.out.println("Unknown control sequence: ESC [ > " + (char)b);
                break;
            }
            default: {
                System.out.println("Unknown control sequence: ESC [ " + (char)b);
            }
        }
    }

    private void parse_esc() {
        byte b = this.getNextByte();
        switch (b) {
            case 27: {
                this.parse_esc();
                break;
            }
            case 40: 
            case 41: {
                this.parse_scs(b);
                break;
            }
            case 55: {
                this.save_cursor_position();
                break;
            }
            case 56: {
                this.restore_cursor_position();
                break;
            }
            case 61: {
                this.keypadmode = 2;
                break;
            }
            case 62: {
                this.keypadmode = 1;
                break;
            }
            case 77: {
                this.reverseindex();
                break;
            }
            case 91: {
                this.parse_csi();
                break;
            }
            case 93: {
                this.parse_text_parameter();
                break;
            }
            default: {
                System.out.println("Unknown control sequence: ESC " + (char)b);
            }
        }
    }

    private void parse_scs(byte a) {
        byte b = this.getNextByte();
        System.out.println("ESC " + (char)a + " " + (char)b + "(SCS)");
        if (a == 40) {
            switch (b) {
                case 48: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 65: {
                    break;
                }
                case 66: {
                    break;
                }
            }
        } else if (a == 41) {
            switch (b) {
                case 48: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 65: {
                    break;
                }
                case 66: {
                    break;
                }
            }
        }
    }

    private void parse_text_parameter() {
        byte[] text = new byte[80];
        int f = 0;
        byte b = this.getNextByte();
        while (b != 59) {
            f *= 10;
            f += b - 48;
            b = this.getNextByte();
        }
        int count = 0;
        b = this.getNextByte();
        while (b != 7) {
            text[count++] = b;
            b = this.getNextByte();
        }
        switch (f) {
            case 0: {
                this.parent.setIconName(new String(text, 0, count));
                this.parent.setWindowTitle(new String(text, 0, count));
                break;
            }
            case 1: {
                this.parent.setIconName(new String(text, 0, count));
                break;
            }
            case 2: {
                this.parent.setWindowTitle(new String(text, 0, count));
                break;
            }
            default: {
                System.out.println("Set text parameters(not fully support)");
            }
        }
    }

    private int physicalRow(int row) {
        return (this.toprow + row + this.totalrow - 1) % this.totalrow;
    }

    private void reset(int row, int col) {
        int prow = this.physicalRow(row);
        this.text[prow][col - 1] = '\u0000';
        this.mbc[prow][col - 1] = 0;
        this.fgcolors[prow][col - 1] = defFg;
        this.bgcolors[prow][col - 1] = defBg;
        this.attributes[prow][col - 1] = defAttr;
        this.isurl[prow][col - 1] = false;
        this.setRepaint(row, col);
    }

    private void reset_mode(int m) {
        switch (m) {
            case 1: {
                this.keypadmode = 1;
                break;
            }
            case 12: {
                break;
            }
            case 25: {
                break;
            }
            default: {
                System.out.println("Reset mode " + m + " not support.");
            }
        }
    }

    private void restore_cursor_position() {
        this.ccol = this.scol;
        this.crow = this.srow;
    }

    private void reverseindex() {
        if (this.crow == this.topmargin) {
            this.insertline(this.crow, 1);
        } else {
            --this.crow;
        }
    }

    private void save_cursor_position() {
        this.scol = this.ccol;
        this.srow = this.crow;
    }

    private void scrollpage(int line) {
        if (this.topmargin == 1 && this.buttommargin == this.maxrow) {
            this.toprow += line;
            if (this.toprow >= this.totalrow) {
                this.toprow %= this.totalrow;
            }
            int i = 1;
            while (i <= this.maxrow) {
                int j = this.leftmargin;
                while (j <= this.rightmargin) {
                    if (i <= this.buttommargin - line) {
                        this.setRepaint(i, j);
                    } else {
                        this.reset(i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = this.topmargin;
            while (i <= this.buttommargin) {
                int j = this.leftmargin;
                while (j <= this.rightmargin) {
                    if (i <= this.buttommargin - line) {
                        this.copy(i, j, i + line, j);
                    } else {
                        this.reset(i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.scrolluprow != 0) {
            this.parent.scroll(-line);
        }
    }

    private void set_mode(int m) {
        switch (m) {
            case 1: {
                this.keypadmode = 2;
                break;
            }
            case 12: {
                break;
            }
            case 25: {
                break;
            }
            default: {
                System.out.println("Set mode " + m + " not support.");
            }
        }
    }

    private void setColor(int c) {
        if (c == 0) {
            this.cfgcolor = defFg;
            this.cbgcolor = defBg;
            this.cattribute = defAttr;
        } else if (c == 1) {
            this.cattribute = (byte)(this.cattribute | 1);
        } else if (c == 4) {
            this.cattribute = (byte)(this.cattribute | 8);
        } else if (c == 5) {
            this.cattribute = (byte)(this.cattribute | 0x10);
        } else if (c == 7) {
            this.cattribute = (byte)(this.cattribute ^ 0x40);
        } else if (30 <= c && c <= 37) {
            this.cfgcolor = (byte)(c - 30);
        } else if (40 <= c && c <= 47) {
            this.cbgcolor = (byte)(c - 40);
        }
    }

    private void setmargin(int top, int buttom) {
        this.topmargin = top;
        this.buttommargin = buttom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRepaint(int row, int col) {
        if (row < 1 || row > this.maxrow || col < 1 || col > this.maxcol) {
            return;
        }
        int prow = this.physicalRow(row);
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaintSet.add(prow << 8 | col - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRepaintPhysical(int prow, int pcol) {
        if (prow < 0 || prow >= this.totalrow || pcol < 0 || pcol >= this.totalcol) {
            return;
        }
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaintSet.add(prow << 8 | pcol);
        }
    }

    class RepaintTask
    implements ActionListener {
        RepaintTask() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean r = false;
            VT100 vT100 = VT100.this;
            vT100.text_blink_count = vT100.text_blink_count + 1;
            VT100 vT1002 = VT100.this;
            vT1002.cursor_blink_count = vT1002.cursor_blink_count + 1;
            if (VT100.this.resource.getBooleanValue("cursor.blink") && VT100.this.cursor_blink_count % 2 == 0) {
                VT100.this.cursor_blink = !VT100.this.cursor_blink;
                VT100.this.setRepaint(VT100.this.crow, VT100.this.ccol);
                r = true;
            }
            if (VT100.this.text_blink_count % 3 == 0) {
                VT100.this.text_blink = !VT100.this.text_blink;
                int i = 1;
                while (i <= VT100.this.maxrow) {
                    int j = 1;
                    while (j <= VT100.this.maxcol) {
                        int prow = VT100.this.physicalRow(i - VT100.this.scrolluprow);
                        if ((VT100.this.attributes[prow][j - 1] & 0x10) != 0) {
                            VT100.this.setRepaintPhysical(prow, j - 1);
                            r = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (r) {
                VT100.this.repaint();
            }
        }
    }
}

