/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    public static final int DIRECTORY = 2;
    public static final int FILE = 1;

    public static void checkFile(File f, int type) {
        try {
            switch (type) {
                case 1: {
                    if (!f.isFile()) {
                        f.deleteOnExit();
                        f.createNewFile();
                    }
                    break;
                }
                case 2: {
                    if (!f.isDirectory()) {
                        f.deleteOnExit();
                        f.mkdir();
                    }
                    break;
                }
                default: {
                    System.err.println("Unknown file type!");
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean copyFile(File oldfile, File newfile) {
        block5: {
            if (!newfile.exists()) {
                newfile.createNewFile();
            }
            if (oldfile.canRead() && newfile.canWrite()) break block5;
            return false;
        }
        try {
            int len;
            FileInputStream fis = new FileInputStream(oldfile);
            FileOutputStream fos = new FileOutputStream(newfile);
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void moveFile(File oldfile, File newfile) {
        FileUtils.copyFile(oldfile, newfile);
        oldfile.delete();
    }
}

