/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Resource;

class GeneralPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 290521402254313069L;
    public JButton bellPathButton;
    public JTextField bellPathField;
    public JLabel bellPathLabel;
    public JLabel breaklengthLabel;
    public SpinnerNumberModel breaklengthModel;
    public JSpinner breaklengthSpinner;
    public JTextField browserField;
    public JLabel browserLabel;
    public JCheckBox copyOnSelectCheckBox;
    public JCheckBox clearAfterCopyCheckBox;
    public JCheckBox removeManualCheckBox;
    public JCheckBox linebreakCheckBox;
    public JLabel copyOnSelectLabel;
    public JLabel clearAfterCopyLabel;
    public JLabel removeManualLabel;
    public JLabel linebreakLabel;
    public JCheckBox customBellCheckBox;
    public JLabel customBellLabel;
    private JFileChooser jfc;
    private String parentDirectory;
    private final Resource resource;
    private File selectedFile;

    public GeneralPanel(Resource r) {
        this.resource = r;
        this.browserLabel = new JLabel(Messages.getString("Preference.BrowserCommand_Label_Text"));
        this.browserField = new JTextField(this.resource.getStringValue("external-browser-command"), 20);
        this.copyOnSelectLabel = new JLabel(Messages.getString("Preference.CopyOnSelect_Label_Text"));
        this.copyOnSelectCheckBox = new JCheckBox();
        this.copyOnSelectCheckBox.setSelected(this.resource.getBooleanValue("copy-on-select"));
        this.clearAfterCopyLabel = new JLabel(Messages.getString("Preference.ClearAfterCopy_Label_Text"));
        this.clearAfterCopyCheckBox = new JCheckBox();
        this.clearAfterCopyCheckBox.setSelected(this.resource.getBooleanValue("clear-after-copy"));
        this.removeManualLabel = new JLabel(Messages.getString("Preference.RemoveManual_Label_Text"));
        this.removeManualCheckBox = new JCheckBox();
        this.removeManualCheckBox.setSelected(this.resource.getBooleanValue("remove-manual-disconnect"));
        this.linebreakLabel = new JLabel(Messages.getString("Preference.LineBreak_Label_Text"));
        this.linebreakCheckBox = new JCheckBox();
        this.linebreakCheckBox.setSelected(this.resource.getBooleanValue("auto-line-break"));
        this.linebreakCheckBox.addActionListener(this);
        this.breaklengthLabel = new JLabel(Messages.getString("Preference.BreakLength_Label_Text"));
        this.breaklengthModel = new SpinnerNumberModel(this.resource.getIntValue("auto-line-break-length"), 1, 512, 1);
        this.breaklengthSpinner = new JSpinner(this.breaklengthModel);
        this.breaklengthSpinner.setEnabled(this.resource.getBooleanValue("auto-line-break"));
        this.customBellLabel = new JLabel(Messages.getString("Preference.CustomBell_Label_Text"));
        this.customBellCheckBox = new JCheckBox();
        this.customBellCheckBox.setSelected(this.resource.getBooleanValue("use-custom-bell"));
        this.customBellCheckBox.addActionListener(this);
        this.bellPathLabel = new JLabel(Messages.getString("Preference.BellPath_Label_Text"));
        this.bellPathField = new JTextField(this.resource.getStringValue("custom-bell-path"), 8);
        this.bellPathField.setEnabled(this.resource.getBooleanValue("use-custom-bell"));
        this.bellPathButton = new JButton(Messages.getString("Preference.BellPath_Button_Text"));
        this.bellPathButton.setEnabled(this.resource.getBooleanValue("use-custom-bell"));
        this.bellPathButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.add((Component)this.browserLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        this.add((Component)this.browserField, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.copyOnSelectLabel, c);
        c.gridx = 1;
        this.add((Component)this.copyOnSelectCheckBox, c);
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.clearAfterCopyLabel, c);
        c.gridx = 1;
        this.add((Component)this.clearAfterCopyCheckBox, c);
        c.gridx = 0;
        c.gridy = 4;
        this.add((Component)this.removeManualLabel, c);
        c.gridx = 1;
        this.add((Component)this.removeManualCheckBox, c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.linebreakLabel, c);
        c.gridx = 1;
        this.add((Component)this.linebreakCheckBox, c);
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.breaklengthLabel, c);
        c.gridx = 1;
        this.add((Component)this.breaklengthSpinner, c);
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.customBellLabel, c);
        c.gridx = 1;
        this.add((Component)this.customBellCheckBox, c);
        c.gridx = 0;
        c.gridy = 8;
        this.add((Component)this.bellPathLabel, c);
        c.gridx = 1;
        this.add((Component)this.bellPathField, c);
        c.gridx = 2;
        this.add((Component)this.bellPathButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.linebreakCheckBox) {
            this.breaklengthSpinner.setEnabled(this.linebreakCheckBox.isSelected());
        } else if (ae.getSource() == this.customBellCheckBox) {
            this.bellPathField.setEnabled(this.customBellCheckBox.isSelected());
            this.bellPathButton.setEnabled(this.customBellCheckBox.isSelected());
        } else if (ae.getSource() == this.bellPathButton) {
            this.jfc = this.parentDirectory != null ? new JFileChooser(this.parentDirectory) : new JFileChooser();
            if (this.jfc.showOpenDialog(this) == 0) {
                this.selectedFile = this.jfc.getSelectedFile();
                this.parentDirectory = this.selectedFile.getParent();
                this.bellPathField.setText(this.selectedFile.getAbsolutePath());
            }
        }
    }
}

