/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;

class ApperancePanel
extends JPanel {
    private static final long serialVersionUID = -2051345281384271839L;
    public JLabel scrollLabel;
    public JLabel terminalRowsLabel;
    public JLabel terminalColumnsLabel;
    public SpinnerNumberModel scrollModel;
    public SpinnerNumberModel terminalRowsModel;
    public SpinnerNumberModel terminalColumnsModel;
    public JSpinner scrollSpinner;
    public JSpinner terminalRowsSpinner;
    public JSpinner terminalColumnsSpinner;
    public JCheckBox systemLookFeelCheckBox;
    public JCheckBox showToolbarCheckBox;
    public JCheckBox cursorBlinkCheckBox;
    public JLabel systemLookFeelLabel;
    public JLabel showToolbarLabel;
    public JLabel cursorBlinkLabel;
    public JCheckBox tabNumberCheckBox;
    public JCheckBox showScrollBarCheckBox;
    public JLabel tabNumberLabel;
    public JLabel showScrollBarLabel;
    public JLabel widthLabel;
    public JLabel heightLabel;
    public SpinnerNumberModel widthModel;
    public SpinnerNumberModel heightModel;
    public JSpinner widthSpinner;
    public JSpinner heightSpinner;
    private final Resource resource;

    public ApperancePanel(Resource r) {
        this.resource = r;
        this.systemLookFeelLabel = new JLabel(Messages.getString("Preference.SystemLookFeel_Label_Text"));
        this.systemLookFeelCheckBox = new JCheckBox();
        this.systemLookFeelCheckBox.setSelected(this.resource.getBooleanValue("use-system-look-and-feel"));
        this.systemLookFeelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Resource.getInstance().setValue("use-system-look-and-feel", ApperancePanel.this.systemLookFeelCheckBox.isSelected());
                Model.getInstance().updateLookAndFeel();
                new Thread(){

                    @Override
                    public void run() {
                        int option = JOptionPane.showConfirmDialog(ApperancePanel.this, Messages.getString("PreferencePane.ConfirmLookFeel_Text"), Messages.getString("PreferencePane.ConfirmLookFeel_Title"), 0);
                        if (option == 1) {
                            (this).ApperancePanel.this.systemLookFeelCheckBox.setSelected(!(this).ApperancePanel.this.systemLookFeelCheckBox.isSelected());
                            Resource.getInstance().setValue("use-system-look-and-feel", (this).ApperancePanel.this.systemLookFeelCheckBox.isSelected());
                            Model.getInstance().updateLookAndFeel();
                        }
                    }
                }.start();
            }
        });
        this.showToolbarLabel = new JLabel(Messages.getString("Preference.ShowToolbar_Label_Text"));
        this.showToolbarCheckBox = new JCheckBox();
        this.showToolbarCheckBox.setSelected(this.resource.getBooleanValue("show-toolbar"));
        this.cursorBlinkLabel = new JLabel(Messages.getString("Preference.CursorBlink_Label_Text"));
        this.cursorBlinkCheckBox = new JCheckBox();
        this.cursorBlinkCheckBox.setSelected(this.resource.getBooleanValue("cursor.blink"));
        this.widthLabel = new JLabel(Messages.getString("Preference.WindowWidth_Label_Text"));
        this.widthModel = new SpinnerNumberModel(this.resource.getIntValue("geometry.width"), 0, 4096, 1);
        this.widthSpinner = new JSpinner(this.widthModel);
        this.heightLabel = new JLabel(Messages.getString("Preference.WindowHeight_Label_Text"));
        this.heightModel = new SpinnerNumberModel(this.resource.getIntValue("geometry.height"), 0, 4096, 1);
        this.heightSpinner = new JSpinner(this.heightModel);
        this.scrollLabel = new JLabel(Messages.getString("Preference.Scroll_Label_Text"));
        this.scrollModel = new SpinnerNumberModel(this.resource.getIntValue("terminal.scrolls"), 0, 10000, 1);
        this.scrollSpinner = new JSpinner(this.scrollModel);
        this.terminalColumnsLabel = new JLabel(Messages.getString("Preference.TerminalColumns_Label_Text"));
        this.terminalColumnsModel = new SpinnerNumberModel(this.resource.getIntValue("terminal.columns"), 80, 200, 1);
        this.terminalColumnsSpinner = new JSpinner(this.terminalColumnsModel);
        this.terminalColumnsSpinner.setEnabled(false);
        this.terminalRowsLabel = new JLabel(Messages.getString("Preference.TerminalRows_Label_Text"));
        this.terminalRowsModel = new SpinnerNumberModel(this.resource.getIntValue("terminal.rows"), 24, 200, 1);
        this.terminalRowsSpinner = new JSpinner(this.terminalRowsModel);
        this.terminalRowsSpinner.setEnabled(false);
        this.tabNumberLabel = new JLabel(Messages.getString("Preference.TabNumber_Label_Text"));
        this.tabNumberCheckBox = new JCheckBox();
        this.tabNumberCheckBox.setSelected(this.resource.getBooleanValue("tab-number"));
        this.showScrollBarLabel = new JLabel(Messages.getString("Preference.ShowScrollBar_Label_Text"));
        this.showScrollBarCheckBox = new JCheckBox();
        this.showScrollBarCheckBox.setSelected(this.resource.getBooleanValue("show-scroll-bar"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.systemLookFeelLabel, c);
        c.gridx = 1;
        this.add((Component)this.systemLookFeelCheckBox, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.showToolbarLabel, c);
        c.gridx = 1;
        this.add((Component)this.showToolbarCheckBox, c);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.cursorBlinkLabel, c);
        c.gridx = 1;
        this.add((Component)this.cursorBlinkCheckBox, c);
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.widthLabel, c);
        c.gridx = 1;
        this.add((Component)this.widthSpinner, c);
        c.gridx = 0;
        c.gridy = 4;
        this.add((Component)this.heightLabel, c);
        c.gridx = 1;
        this.add((Component)this.heightSpinner, c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.scrollLabel, c);
        c.gridx = 1;
        this.add((Component)this.scrollSpinner, c);
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.terminalColumnsLabel, c);
        c.gridx = 1;
        this.add((Component)this.terminalColumnsSpinner, c);
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.terminalRowsLabel, c);
        c.gridx = 1;
        this.add((Component)this.terminalRowsSpinner, c);
        c.gridx = 0;
        c.gridy = 8;
        this.add((Component)this.tabNumberLabel, c);
        c.gridx = 1;
        this.add((Component)this.tabNumberCheckBox, c);
        c.gridx = 0;
        c.gridy = 9;
        this.add((Component)this.showScrollBarLabel, c);
        c.gridx = 1;
        this.add((Component)this.showScrollBarCheckBox, c);
    }
}

