/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;
import org.zhouer.zterm.Session;
import org.zhouer.zterm.Site;
import org.zhouer.zterm.ZTerm;

public class ActionHandler
implements ActionListener {
    private Model model;
    private final Resource resource = Resource.getInstance();
    private ZTerm view;

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.view.openItem) {
            this.model.open();
        } else if (source == this.view.openButton) {
            this.model.openNewTab();
        } else if (source == this.view.closeItem || source == this.view.closeButton) {
            this.model.closeCurrentTab();
        } else if (source == this.view.reopenItem || source == this.view.reopenButton) {
            this.model.reopenSession((Session)this.view.tabbedPane.getSelectedComponent());
        } else if (source == this.view.copyItem || source == this.view.copyButton || source == this.view.popupCopyItem) {
            this.model.copy();
        } else if (source == this.view.colorCopyItem || source == this.view.colorCopyButton || source == this.view.popupColorCopyItem) {
            this.model.colorCopy();
        } else if (source == this.view.pasteItem || source == this.view.pasteButton || source == this.view.popupPasteItem) {
            this.model.paste();
        } else if (source == this.view.colorPasteItem || source == this.view.colorPasteButton || source == this.view.popupColorPasteItem) {
            this.model.colorPaste();
        } else if (source == this.view.popupCopyLinkItem) {
            this.model.copyLink();
        } else if (source == this.view.telnetButton) {
            this.view.siteText.setText(Messages.getString("ActionHandler.TelnetHeader"));
            this.view.siteField.requestFocusInWindow();
        } else if (source == this.view.sshButton) {
            this.view.siteText.setText(Messages.getString("ActionHandler.SSHHeader"));
            this.view.siteField.requestFocusInWindow();
        } else if (source == this.view.preferenceItem) {
            this.model.showPreference();
        } else if (source == this.view.siteManagerItem) {
            this.model.showSiteManager();
        } else if (source == this.view.showToolbarItem) {
            boolean isShowToolbar = this.resource.getBooleanValue("show-toolbar");
            this.resource.setValue("show-toolbar", !isShowToolbar);
            this.model.updateToolbar(!isShowToolbar);
            this.model.updateSize();
        } else if (source == this.view.usageItem) {
            this.model.showUsage();
        } else if (source == this.view.faqItem) {
            this.model.showFAQ();
        } else if (source == this.view.aboutItem) {
            this.model.showAbout();
        } else if (source == this.view.big5Item) {
            this.model.updateEncoding("Big5");
        } else if (source == this.view.utf8Item) {
            this.model.updateEncoding("UTF-8");
        } else if (source == this.view.languageItems[0]) {
            this.model.setLocale(Locale.ENGLISH);
            this.model.refreshMessages();
            this.resource.writeFile();
        } else if (source == this.view.languageItems[1]) {
            this.model.setLocale(Locale.TAIWAN);
            this.model.refreshMessages();
            this.resource.writeFile();
        } else {
            int i = 0;
            while (i < this.view.favoriteItems.length) {
                if (source == this.view.favoriteItems[i]) {
                    Site f = this.resource.getFavorite(this.view.favoriteItems[i].getText());
                    this.model.connect(f, -1);
                    break;
                }
                ++i;
            }
        }
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setView(ZTerm view) {
        this.view = view;
    }
}

