/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public final class HMAC
implements Digest {
    Digest md;
    byte[] k_xor_ipad;
    byte[] k_xor_opad;
    byte[] tmp;
    int size;

    public HMAC(Digest md, byte[] key, int size) {
        this.md = md;
        this.size = size;
        this.tmp = new byte[md.getDigestLength()];
        int BLOCKSIZE = 64;
        this.k_xor_ipad = new byte[BLOCKSIZE];
        this.k_xor_opad = new byte[BLOCKSIZE];
        if (key.length > BLOCKSIZE) {
            md.reset();
            md.update(key);
            md.digest(this.tmp);
            key = this.tmp;
        }
        System.arraycopy(key, 0, this.k_xor_ipad, 0, key.length);
        System.arraycopy(key, 0, this.k_xor_opad, 0, key.length);
        int i = 0;
        while (i < BLOCKSIZE) {
            int n = i;
            this.k_xor_ipad[n] = (byte)(this.k_xor_ipad[n] ^ 0x36);
            int n2 = i++;
            this.k_xor_opad[n2] = (byte)(this.k_xor_opad[n2] ^ 0x5C);
        }
        md.update(this.k_xor_ipad);
    }

    @Override
    public final int getDigestLength() {
        return this.size;
    }

    @Override
    public final void update(byte b) {
        this.md.update(b);
    }

    @Override
    public final void update(byte[] b) {
        this.md.update(b);
    }

    @Override
    public final void update(byte[] b, int off, int len) {
        this.md.update(b, off, len);
    }

    @Override
    public final void reset() {
        this.md.reset();
        this.md.update(this.k_xor_ipad);
    }

    @Override
    public final void digest(byte[] out) {
        this.digest(out, 0);
    }

    @Override
    public final void digest(byte[] out, int off) {
        this.md.digest(this.tmp);
        this.md.update(this.k_xor_opad);
        this.md.update(this.tmp);
        this.md.digest(this.tmp);
        System.arraycopy(this.tmp, 0, out, off, this.size);
        this.md.update(this.k_xor_ipad);
    }
}

