/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.zhouer.zterm.ApperancePanel;
import org.zhouer.zterm.ConnectionPanel;
import org.zhouer.zterm.FontPanel;
import org.zhouer.zterm.GeneralPanel;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;

public class PreferencePane
extends JOptionPane
implements TreeSelectionListener {
    private static final long serialVersionUID = -1892496769315626958L;
    protected ApperancePanel apperancePanel;
    private JTree categoryTree;
    private final ConnectionPanel connectionPanel;
    private final FontPanel fontPanel;
    private final GeneralPanel generalPanel;
    private final JSplitPane splitPanel;
    private final Resource resource = Resource.getInstance();
    private DefaultMutableTreeNode rootNode;
    private DefaultMutableTreeNode generalNode;
    private DefaultMutableTreeNode connectionNode;
    private DefaultMutableTreeNode appearanceNode;
    private DefaultMutableTreeNode fontNode;
    private final JPanel welcomePanel;
    private final JLabel welcomeLabel;
    private final JTextArea welcomeTextArea;
    private final JScrollPane welcomeScrollPane;

    public PreferencePane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        this.makeCategoryTree();
        this.welcomeLabel = new JLabel(Messages.getString("Preference.Welcome_Label_Text"));
        this.welcomePanel = new JPanel();
        this.welcomePanel.setLayout(new BorderLayout());
        this.welcomePanel.add((Component)this.welcomeLabel, "North");
        this.welcomeTextArea = new JTextArea(Messages.getString("Preference.Welcome_Description_Text"));
        this.welcomeScrollPane = new JScrollPane(this.welcomeTextArea);
        this.welcomeTextArea.setEditable(false);
        this.welcomePanel.add((Component)this.welcomeScrollPane, "Center");
        this.splitPanel = new JSplitPane(1, this.categoryTree, this.welcomePanel);
        this.splitPanel.setOneTouchExpandable(true);
        this.splitPanel.setDividerLocation(120);
        this.generalPanel = new GeneralPanel(this.resource);
        this.connectionPanel = new ConnectionPanel(this.resource);
        this.apperancePanel = new ApperancePanel(this.resource);
        this.fontPanel = new FontPanel(this.resource);
        panel.add(this.splitPanel);
        this.setOptionType(2);
        this.setMessage(panel);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.categoryTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node == this.generalNode) {
            this.splitPanel.setRightComponent(this.generalPanel);
        } else if (node == this.connectionNode) {
            this.splitPanel.setRightComponent(this.connectionPanel);
        } else if (node == this.appearanceNode) {
            this.splitPanel.setRightComponent(this.apperancePanel);
        } else if (node == this.fontNode) {
            this.splitPanel.setRightComponent(this.fontPanel);
        } else {
            this.splitPanel.setRightComponent(this.welcomePanel);
        }
        this.splitPanel.setDividerLocation(120);
    }

    protected void submit() {
        this.resource.setValue("external-browser-command", this.generalPanel.browserField.getText());
        this.resource.setValue("copy-on-select", this.generalPanel.copyOnSelectCheckBox.isSelected());
        this.resource.setValue("clear-after-copy", this.generalPanel.clearAfterCopyCheckBox.isSelected());
        this.resource.setValue("remove-manual-disconnect", this.generalPanel.removeManualCheckBox.isSelected());
        this.resource.setValue("auto-line-break", this.generalPanel.linebreakCheckBox.isSelected());
        this.resource.setValue("auto-line-break-length", this.generalPanel.breaklengthModel.getValue().toString());
        this.resource.setValue("use-custom-bell", this.generalPanel.customBellCheckBox.isSelected());
        this.resource.setValue("custom-bell-path", this.generalPanel.bellPathField.getText());
        this.resource.setValue("connect.auto-reconnect", this.connectionPanel.autoReconnectCheckBox.isSelected());
        this.resource.setValue("connect.autoreconnect-time", this.connectionPanel.reconnectTimeModel.getValue().toString());
        this.resource.setValue("connect.auto-reconnect-interval", this.connectionPanel.reconnectIntervalModel.getValue().toString());
        this.resource.setValue("connect.anti-idle", this.connectionPanel.antiIdleCheckBox.isSelected());
        this.resource.setValue("connect.anti-idle-interval", this.connectionPanel.antiIdleModel.getValue().toString());
        this.resource.setValue("connect.anti-idle-string", this.connectionPanel.antiIdleStringField.getText());
        this.resource.setValue("use-system-look-and-feel", this.apperancePanel.systemLookFeelCheckBox.isSelected());
        this.resource.setValue("show-toolbar", this.apperancePanel.showToolbarCheckBox.isSelected());
        this.resource.setValue("cursor.blink", this.apperancePanel.cursorBlinkCheckBox.isSelected());
        this.resource.setValue("geometry.width", this.apperancePanel.widthModel.getValue().toString());
        this.resource.setValue("geometry.height", this.apperancePanel.heightModel.getValue().toString());
        this.resource.setValue("terminal.scrolls", this.apperancePanel.scrollModel.getValue().toString());
        this.resource.setValue("terminal.columns", this.apperancePanel.terminalColumnsModel.getValue().toString());
        this.resource.setValue("terminal.rows", this.apperancePanel.terminalRowsModel.getValue().toString());
        this.resource.setValue("tab-number", this.apperancePanel.tabNumberCheckBox.isSelected());
        this.resource.setValue("show-scroll-bar", this.apperancePanel.showScrollBarCheckBox.isSelected());
        this.resource.setValue("font.family", this.fontPanel.familyCombo.getSelectedItem().toString());
        this.resource.setValue("font.size", this.fontPanel.sizeModel.getValue().toString());
        this.resource.setValue("font.bold", this.fontPanel.boldCheck.isSelected());
        this.resource.setValue("font.italy", this.fontPanel.italyCheck.isSelected());
        this.resource.setValue("font.antialias", this.fontPanel.aaCheck.isSelected());
        this.resource.setValue("font.vertical-gap", this.fontPanel.fontVerticalGapModel.getValue().toString());
        this.resource.setValue("font.hoizontal-gap", this.fontPanel.fontHorizontalGapModel.getValue().toString());
        this.resource.setValue("font.descent-adjust", this.fontPanel.fontDescentAdjustModel.getValue().toString());
        this.resource.writeFile();
        Model.getInstance().updateLookAndFeel();
        Model.getInstance().updateBounds();
        Model.getInstance().updateToolbar(this.apperancePanel.showToolbarCheckBox.isSelected());
        Model.getInstance().updateSize();
        Model.getInstance().updateAntiIdleTime();
    }

    private void makeCategoryTree() {
        this.rootNode = new DefaultMutableTreeNode(Messages.getString("Preference.Tree_RootNode_Text"));
        this.generalNode = new DefaultMutableTreeNode(Messages.getString("Preference.Tree_GeneralNode_Text"));
        this.connectionNode = new DefaultMutableTreeNode(Messages.getString("Preference.Tree_ConnectionNode_Text"));
        this.appearanceNode = new DefaultMutableTreeNode(Messages.getString("Preference.Tree_AppearanceNode_Text"));
        this.fontNode = new DefaultMutableTreeNode(Messages.getString("Preference.Tree_FontNode_Text"));
        this.rootNode.add(this.generalNode);
        this.rootNode.add(this.connectionNode);
        this.rootNode.add(this.appearanceNode);
        this.rootNode.add(this.fontNode);
        this.categoryTree = new JTree(this.rootNode);
        this.categoryTree.getSelectionModel().setSelectionMode(1);
        this.categoryTree.addTreeSelectionListener(this);
    }
}

