/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Resource;

class FontPanel
extends JPanel {
    private static final long serialVersionUID = 1511310874988772350L;
    public JCheckBox boldCheck;
    public JCheckBox italyCheck;
    public JCheckBox aaCheck;
    public JLabel boldLabel;
    public JLabel italyLabel;
    public JLabel aaLabel;
    public JComboBox familyCombo;
    public JLabel familyLabel;
    public JLabel fontVerticalGapLabel;
    public JLabel fontHorizontalGapLabel;
    public JLabel fontDescentAdjustLabel;
    public SpinnerNumberModel fontVerticalGapModel;
    public SpinnerNumberModel fontHorizontalGapModel;
    public SpinnerNumberModel fontDescentAdjustModel;
    public JSpinner fontVerticalGapSpinner;
    public JSpinner fontHorizontalGapSpinner;
    public JSpinner fontDescentAdjustSpinner;
    public JLabel sizeLabel;
    public SpinnerNumberModel sizeModel;
    public JSpinner sizeSpinner;
    private final Resource resource;

    public FontPanel(Resource r) {
        this.resource = r;
        this.familyLabel = new JLabel(Messages.getString("Preference.FontFamily_Label_Text"));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] familyList = ge.getAvailableFontFamilyNames();
        this.familyCombo = new JComboBox<String>(familyList);
        this.familyCombo.setSelectedItem(this.resource.getStringValue("font.family"));
        this.sizeLabel = new JLabel(Messages.getString("Preference.FontSize_Label_Text"));
        this.sizeModel = new SpinnerNumberModel(this.resource.getIntValue("font.size"), 0, 64, 1);
        this.sizeSpinner = new JSpinner(this.sizeModel);
        this.boldLabel = new JLabel(Messages.getString("Preference.FontBold_Label_Text"));
        this.boldCheck = new JCheckBox();
        this.boldCheck.setSelected(this.resource.getBooleanValue("font.bold"));
        this.italyLabel = new JLabel(Messages.getString("Preference.FontItaly_Label_Text"));
        this.italyCheck = new JCheckBox();
        this.italyCheck.setSelected(this.resource.getBooleanValue("font.italy"));
        this.aaLabel = new JLabel(Messages.getString("Preference.FontAntiAliasing_Label_Text"));
        this.aaCheck = new JCheckBox();
        this.aaCheck.setSelected(this.resource.getBooleanValue("font.antialias"));
        this.fontVerticalGapLabel = new JLabel(Messages.getString("Preference.FontVerticalGap_Label_Text"));
        this.fontVerticalGapModel = new SpinnerNumberModel(this.resource.getIntValue("font.vertical-gap"), -10, 10, 1);
        this.fontVerticalGapSpinner = new JSpinner(this.fontVerticalGapModel);
        this.fontHorizontalGapLabel = new JLabel(Messages.getString("Preference.FontHorizontalGap_Label_Text"));
        this.fontHorizontalGapModel = new SpinnerNumberModel(this.resource.getIntValue("font.hoizontal-gap"), -10, 10, 1);
        this.fontHorizontalGapSpinner = new JSpinner(this.fontHorizontalGapModel);
        this.fontDescentAdjustLabel = new JLabel(Messages.getString("Preference.FontDescentAdjust_Label_Text"));
        this.fontDescentAdjustModel = new SpinnerNumberModel(this.resource.getIntValue("font.descent-adjust"), -10, 10, 1);
        this.fontDescentAdjustSpinner = new JSpinner(this.fontDescentAdjustModel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.familyLabel, c);
        c.gridx = 1;
        this.add((Component)this.familyCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.sizeLabel, c);
        c.gridx = 1;
        this.add((Component)this.sizeSpinner, c);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.boldLabel, c);
        c.gridx = 1;
        this.add((Component)this.boldCheck, c);
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.italyLabel, c);
        c.gridx = 1;
        this.add((Component)this.italyCheck, c);
        c.gridx = 0;
        c.gridy = 4;
        this.add((Component)this.aaLabel, c);
        c.gridx = 1;
        this.add((Component)this.aaCheck, c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.fontVerticalGapLabel, c);
        c.gridx = 1;
        this.add((Component)this.fontVerticalGapSpinner, c);
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.fontHorizontalGapLabel, c);
        c.gridx = 1;
        this.add((Component)this.fontHorizontalGapSpinner, c);
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.fontDescentAdjustLabel, c);
        c.gridx = 1;
        this.add((Component)this.fontDescentAdjustSpinner, c);
    }
}

