/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Resource;

class ConnectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5706390056762240339L;
    public JCheckBox antiIdleCheckBox;
    public JLabel antiIdleLabel;
    public JLabel antiIdleTimeLabel;
    public JLabel antiIdleStringLabel;
    public SpinnerNumberModel antiIdleModel;
    public JTextField antiIdleStringField;
    public JSpinner antiIdleTimeSpinner;
    public JCheckBox autoReconnectCheckBox;
    public JLabel autoReconnectLabel;
    public JLabel reconnectTimeLabel;
    public JLabel reconnectIntervalLabel;
    public SpinnerNumberModel reconnectTimeModel;
    public SpinnerNumberModel reconnectIntervalModel;
    public JSpinner reconnectTimeSpinner;
    public JSpinner reconnectIntervalSpinner;
    private final Resource resource;

    public ConnectionPanel(Resource r) {
        this.resource = r;
        boolean autoReconnect = this.resource.getBooleanValue("connect.auto-reconnect");
        this.autoReconnectLabel = new JLabel(Messages.getString("Preference.AutoReconnect_Label_Text"));
        this.autoReconnectCheckBox = new JCheckBox();
        this.autoReconnectCheckBox.setSelected(autoReconnect);
        this.autoReconnectCheckBox.addActionListener(this);
        this.reconnectTimeLabel = new JLabel(Messages.getString("Preference.ReconnectTime_Label_Text"));
        this.reconnectTimeModel = new SpinnerNumberModel(this.resource.getIntValue("connect.autoreconnect-time"), 0, 3600, 1);
        this.reconnectTimeSpinner = new JSpinner(this.reconnectTimeModel);
        this.reconnectTimeSpinner.setEnabled(autoReconnect);
        this.reconnectIntervalLabel = new JLabel(Messages.getString("Preference.ReconnectInterval_Label_Text"));
        this.reconnectIntervalModel = new SpinnerNumberModel(this.resource.getIntValue("connect.auto-reconnect-interval"), 0, 60000, 1);
        this.reconnectIntervalSpinner = new JSpinner(this.reconnectIntervalModel);
        this.reconnectIntervalSpinner.setEnabled(autoReconnect);
        this.antiIdleLabel = new JLabel(Messages.getString("Preference.AntiIdle_Label_Text"));
        this.antiIdleCheckBox = new JCheckBox();
        this.antiIdleCheckBox.setSelected(this.resource.getBooleanValue("connect.anti-idle"));
        this.antiIdleCheckBox.addActionListener(this);
        this.antiIdleTimeLabel = new JLabel(Messages.getString("Preference.AntiIdleTime_Label_Text"));
        this.antiIdleModel = new SpinnerNumberModel(this.resource.getIntValue("connect.anti-idle-interval"), 0, 3600, 1);
        this.antiIdleTimeSpinner = new JSpinner(this.antiIdleModel);
        this.antiIdleTimeSpinner.setEnabled(this.resource.getBooleanValue("connect.anti-idle"));
        this.antiIdleStringLabel = new JLabel(Messages.getString("Preference.AntiIdleString_Label_Text"));
        this.antiIdleStringField = new JTextField(this.resource.getStringValue("connect.anti-idle-string"), 15);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.autoReconnectLabel, c);
        c.gridx = 1;
        this.add((Component)this.autoReconnectCheckBox, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.reconnectTimeLabel, c);
        c.gridx = 1;
        this.add((Component)this.reconnectTimeSpinner, c);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.reconnectIntervalLabel, c);
        c.gridx = 1;
        this.add((Component)this.reconnectIntervalSpinner, c);
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.antiIdleLabel, c);
        c.gridx = 1;
        this.add((Component)this.antiIdleCheckBox, c);
        c.gridx = 0;
        c.gridy = 4;
        this.add((Component)this.antiIdleTimeLabel, c);
        c.gridx = 1;
        this.add((Component)this.antiIdleTimeSpinner, c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.antiIdleStringLabel, c);
        c.gridx = 1;
        this.add((Component)this.antiIdleStringField, c);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.autoReconnectCheckBox) {
            this.reconnectTimeSpinner.setEnabled(this.autoReconnectCheckBox.isSelected());
            this.reconnectIntervalSpinner.setEnabled(this.autoReconnectCheckBox.isSelected());
        } else if (ae.getSource() == this.antiIdleCheckBox) {
            this.antiIdleTimeSpinner.setEnabled(this.antiIdleCheckBox.isSelected());
        }
    }
}

