/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.zhouer.protocol.Protocol;
import org.zhouer.protocol.TelnetInputStream;
import org.zhouer.protocol.TelnetOutputStream;

public class Telnet
implements Protocol {
    public static final byte DO = -3;
    public static final byte DONT = -2;
    public static final byte ECHO = 1;
    public static final byte IAC = -1;
    public static final byte NOP = -15;
    public static final byte SB = -6;
    public static final byte SE = -16;
    public static final byte SGA = 3;
    public static final byte TS = 32;
    public static final byte TT = 24;
    public static final byte WILL = -5;
    public static final byte WONT = -4;
    public static final byte WS = 31;
    private final byte[] buf;
    private int bufpos;
    private int buflen;
    private final String host;
    private InputStream is;
    private OutputStream os;
    private final int port;
    private Socket sock;
    private String terminal_type;

    public Telnet(String h, int p) {
        this.host = h;
        this.port = p;
        this.terminal_type = "vt100";
        this.buf = new byte[4096];
        this.buflen = 0;
        this.bufpos = 0;
    }

    @Override
    public boolean connect() {
        try {
            this.sock = new Socket(this.host, this.port);
            this.sock.setTcpNoDelay(true);
            this.sock.setKeepAlive(true);
            this.is = this.sock.getInputStream();
            this.os = this.sock.getOutputStream();
        }
        catch (UnknownHostException e) {
            System.out.println("Caught UnknownHostException in Telnet::connect()");
            return false;
        }
        catch (IOException e) {
            System.out.println("Caught IOException in Telnet::connect()");
            return false;
        }
        return true;
    }

    @Override
    public void disconnect() {
        if (this.sock == null || this.sock.isClosed()) {
            return;
        }
        try {
            this.is.close();
            this.os.close();
            this.sock.close();
        }
        catch (IOException e) {
            System.out.println("Caught IOException in Network::disconnect()");
        }
        if (!this.sock.isClosed()) {
            System.out.println("Disconnect failed!");
        }
    }

    @Override
    public InputStream getInputStream() {
        return new TelnetInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return new TelnetOutputStream(this);
    }

    @Override
    public String getTerminalType() {
        return this.terminal_type;
    }

    @Override
    public boolean isClosed() {
        if (this.sock == null) {
            return true;
        }
        return this.sock.isClosed();
    }

    @Override
    public boolean isConnected() {
        if (this.sock == null) {
            return false;
        }
        return this.sock.isConnected();
    }

    public int readByte() throws IOException {
        return this.read();
    }

    public int readBytes(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    public int readBytes(byte[] b, int offset, int length) throws IOException {
        int len = 0;
        while (true) {
            if (this.bufpos == this.buflen && len == 0) {
                this.fillBuf();
                continue;
            }
            if (this.bufpos == this.buflen || len == length) break;
            if (this.buf[this.bufpos] == -1) {
                ++this.bufpos;
                this.proc_iac();
                continue;
            }
            b[offset + len++] = this.buf[this.bufpos++];
        }
        return len;
    }

    @Override
    public void setTerminalType(String tt) {
        this.terminal_type = tt;
    }

    public void writeByte(byte b) throws IOException {
        this.os.write(b);
        this.os.flush();
    }

    public void writeBytes(byte[] buf) throws IOException {
        this.os.write(buf);
        this.os.flush();
    }

    public void writeBytes(byte[] buf, int offset, int size) throws IOException {
        this.os.write(buf, offset, size);
        this.os.flush();
    }

    private void fillBuf() throws IOException {
        this.buflen = this.is.read(this.buf);
        if (this.buflen == -1) {
            throw new IOException();
        }
        this.bufpos = 0;
    }

    private void proc_do() throws IOException {
        byte b = this.read();
        if (b == 31) {
            this.send_command((byte)-5, b);
            byte[] byArray = new byte[3];
            byArray[0] = 80;
            byArray[2] = 24;
            byte[] ws = byArray;
            this.send_sb(b, (byte)0, ws, 3);
        } else if (b == 24 || b == 32) {
            this.send_command((byte)-5, b);
        } else if (b == 1) {
            this.send_command((byte)-4, b);
        } else {
            this.send_command((byte)-4, b);
        }
    }

    private void proc_dont() throws IOException {
        byte b = this.read();
        this.send_command((byte)-4, b);
    }

    private void proc_iac() throws IOException {
        byte b = this.read();
        switch (b) {
            case -6: {
                this.proc_sb();
                break;
            }
            case -5: {
                this.proc_will();
                break;
            }
            case -4: {
                this.proc_wont();
                break;
            }
            case -3: {
                this.proc_do();
                break;
            }
            case -2: {
                this.proc_dont();
                break;
            }
        }
    }

    private void proc_sb() throws IOException {
        byte buf1;
        byte b = this.read();
        byte buf2 = this.read();
        do {
            buf1 = buf2;
            buf2 = this.read();
        } while (buf1 != -1 || buf2 != -16);
        switch (b) {
            case 24: {
                byte[] ttbuf = this.terminal_type.getBytes();
                this.send_sb(b, (byte)0, ttbuf, ttbuf.length);
                break;
            }
            case 32: {
                byte[] tsbuf = new byte[]{51, 56, 52, 48, 48, 44, 51, 56, 52, 48, 48};
                this.send_sb(b, (byte)0, tsbuf, tsbuf.length);
                break;
            }
        }
    }

    private void proc_will() throws IOException {
        byte b = this.read();
        if (b == 1 || b == 3) {
            this.send_command((byte)-3, b);
        } else {
            this.send_command((byte)-2, b);
        }
    }

    private void proc_wont() throws IOException {
        byte b = this.read();
        this.send_command((byte)-2, b);
    }

    private byte read() throws IOException {
        while (this.bufpos == this.buflen) {
            this.fillBuf();
        }
        return this.buf[this.bufpos++];
    }

    private void send_command(byte comm, byte opt) throws IOException {
        byte[] buf = new byte[]{-1, comm, opt};
        this.writeBytes(buf, 0, 3);
    }

    private void send_sb(byte opt1, byte opt2, byte[] opt3, int size) throws IOException {
        byte[] buf = new byte[size + 6];
        buf[0] = -1;
        buf[1] = -6;
        buf[2] = opt1;
        buf[3] = opt2;
        int i = 0;
        while (i < size) {
            buf[4 + i] = opt3[i];
            ++i;
        }
        buf[4 + size] = -1;
        buf[5 + size] = -16;
        this.writeBytes(buf, 0, size + 6);
    }
}

