/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.protocol;

import org.zhouer.protocol.ForwardThread;
import org.zhouer.protocol.Protocol;
import org.zhouer.protocol.SSH2;
import org.zhouer.protocol.Telnet;

public class Standalone {
    public static void main(String[] args) {
        Protocol p;
        if (args.length < 2) {
            System.out.println("Not enough parameter!");
            return;
        }
        if (args[0].equalsIgnoreCase("telnet")) {
            int port = args.length == 2 ? 23 : Integer.parseInt(args[2]);
            p = new Telnet(args[1], port);
        } else if (args[0].equalsIgnoreCase("ssh2")) {
            int port = args.length == 2 ? 22 : Integer.parseInt(args[2]);
            p = new SSH2(args[1], port);
            p.setTerminalType("vt100");
        } else {
            System.out.println("Unknown protocol!");
            return;
        }
        if (!p.connect()) {
            System.out.println("Connection error!");
            return;
        }
        ForwardThread a = new ForwardThread(p.getInputStream(), System.out);
        ForwardThread b = new ForwardThread(System.in, p.getOutputStream());
        a.start();
        b.start();
        try {
            a.join();
            b.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

