/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import java.io.IOException;
import java.io.InputStream;

public class StreamGobbler
extends InputStream {
    private InputStream is;
    private GobblerThread t;
    private Object synchronizer = new Object();
    private boolean isEOF = false;
    private boolean isClosed = false;
    private IOException exception = null;
    private byte[] buffer = new byte[2048];
    private int read_pos = 0;
    private int write_pos = 0;

    public StreamGobbler(InputStream is) {
        this.is = is;
        this.t = new GobblerThread();
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            while (true) {
                if (this.read_pos != this.write_pos) {
                    return this.buffer[this.read_pos++] & 0xFF;
                }
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.isEOF) {
                    return -1;
                }
                try {
                    this.synchronizer.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            return this.write_pos - this.read_pos;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.isEOF = true;
            this.synchronizer.notifyAll();
            this.is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0 || off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            while (true) {
                block12: {
                    if (this.read_pos == this.write_pos) break block12;
                }
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.isEOF) {
                    return -1;
                }
                try {
                    this.synchronizer.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int avail = this.write_pos - this.read_pos;
            avail = avail > len ? len : avail;
            System.arraycopy(this.buffer, this.read_pos, b, off, avail);
            this.read_pos += avail;
            return avail;
        }
    }

    static /* synthetic */ InputStream access$0(StreamGobbler streamGobbler) {
        return streamGobbler.is;
    }

    static /* synthetic */ Object access$1(StreamGobbler streamGobbler) {
        return streamGobbler.synchronizer;
    }

    static /* synthetic */ void access$2(StreamGobbler streamGobbler, boolean bl) {
        streamGobbler.isEOF = bl;
    }

    static /* synthetic */ byte[] access$3(StreamGobbler streamGobbler) {
        return streamGobbler.buffer;
    }

    static /* synthetic */ int access$4(StreamGobbler streamGobbler) {
        return streamGobbler.write_pos;
    }

    static /* synthetic */ int access$5(StreamGobbler streamGobbler) {
        return streamGobbler.read_pos;
    }

    static /* synthetic */ void access$6(StreamGobbler streamGobbler, byte[] byArray) {
        streamGobbler.buffer = byArray;
    }

    static /* synthetic */ void access$7(StreamGobbler streamGobbler, int n) {
        streamGobbler.read_pos = n;
    }

    static /* synthetic */ void access$8(StreamGobbler streamGobbler, int n) {
        streamGobbler.write_pos = n;
    }

    static /* synthetic */ void access$9(StreamGobbler streamGobbler, IOException iOException) {
        streamGobbler.exception = iOException;
    }

    class GobblerThread
    extends Thread {
        GobblerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            buff = new byte[8192];
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    avail = StreamGobbler.access$0(StreamGobbler.this).read(buff);
                    var3_4 = StreamGobbler.access$1(StreamGobbler.this);
                    synchronized (var3_4) {
                        if (avail <= 0) {
                            StreamGobbler.access$2(StreamGobbler.this, true);
                            StreamGobbler.access$1(StreamGobbler.this).notifyAll();
                            return;
                        }
                        space_available = StreamGobbler.access$3(StreamGobbler.this).length - StreamGobbler.access$4(StreamGobbler.this);
                        if (space_available < avail) {
                            unread_size = StreamGobbler.access$4(StreamGobbler.this) - StreamGobbler.access$5(StreamGobbler.this);
                            need_space = unread_size + avail;
                            new_buffer = StreamGobbler.access$3(StreamGobbler.this);
                            if (need_space > StreamGobbler.access$3(StreamGobbler.this).length) {
                                inc = need_space / 3;
                                inc = inc < 256 ? 256 : inc;
                                inc = inc > 8192 ? 8192 : inc;
                                new_buffer = new byte[need_space + inc];
                            }
                            if (unread_size > 0) {
                                System.arraycopy(StreamGobbler.access$3(StreamGobbler.this), StreamGobbler.access$5(StreamGobbler.this), new_buffer, 0, unread_size);
                            }
                            StreamGobbler.access$6(StreamGobbler.this, new_buffer);
                            StreamGobbler.access$7(StreamGobbler.this, 0);
                            StreamGobbler.access$8(StreamGobbler.this, unread_size);
                        }
                        System.arraycopy(buff, 0, StreamGobbler.access$3(StreamGobbler.this), StreamGobbler.access$4(StreamGobbler.this), avail);
                        v0 = StreamGobbler.this;
                        StreamGobbler.access$8(v0, StreamGobbler.access$4(v0) + avail);
                        StreamGobbler.access$1(StreamGobbler.this).notifyAll();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                var3_5 = StreamGobbler.access$1(StreamGobbler.this);
                synchronized (var3_5) {
                    StreamGobbler.access$9(StreamGobbler.this, e);
                    StreamGobbler.access$1(StreamGobbler.this).notifyAll();
                    return;
                }
            }
            {
                ** while (true)
            }
        }
    }
}

