#!/bin/bash
source $Work_Path/install_lang
####### garbage here #############
function mainFunction ( )
{
echo "$Good"
}
function braBraBra ( )
{
echo "$Bra_Bra_Bra"
}
####### garbage end ###############

# shell檔及壓縮檔在同一目錄中

####### 環境變數section###########
User_HOME=/home/nutchuser/nutchez
NutchEZ_HOME=/opt/nutchez
Nutch_HOME=$NutchEZ_HOME/nutch
Tomcat_HOME=$NutchEZ_HOME/tomcat
Index_DB=$User_HOME/search
Admin_email=nutchuser@nutch
Start_PATH=`pwd`
MasterIP_Address=`/sbin/ifconfig eth0 | grep 'inet addr' |  sed 's/^.*addr://g' | sed 's/Bcast.*$//g' | sed 's/ .*// '` 
net_MacAddr=`/sbin/ifconfig eth0 | grep 'HW' | sed 's/^.*HWaddr //g'`

######function section section#######

##########  echo function  ##########
function debug_info () {
  if [ $? -eq 0 ]; then
    echo -e "\033[1;35;40m info - $1 \033[0m"
  fi
}


function show_info () {
  if [ $? -eq 0 ]; then
    echo -e "\033[1;32;40m $1 \033[0m"
  fi
}
##########end echo function ##########

function choose_lang(){

lang=$(locale | grep 'LANG=' | cut -d "=" -f2)

# Default: source english
. $Work_Path/install_lang.en
# if locale is zh then source chinese
echo $lang | grep 'zh' >> /dev/null && source $Work_Path/install_lang.zh

# Ask language
echo -e "\n$choose_lang_1"
read -p "$choose_lang_2 " langChoice

if [ $langChoice == "2" ]; then
    source $Work_Path/install_lang.zh
else
    source $Work_Path/install_lang.en
fi
}

function check_root(){
  debug_info "check_root"
  if [ $USER != "root" ]; then
    show_info "$check_root_1"
    exit
  fi
  show_info "$check_root_2"
}

function check_systemInfo(){
  debug_info "$check_sys_1"
  show_info "$check_sys_2"
  Linux_Distribution=$(lsb_release -a 2> /dev/null | grep "Distributor ID:" | awk '{print $3}')
  Linux_Version=$(lsb_release -a 2> /dev/null | grep "Release" | awk '{print $2}')
  show_info "$Linux_Distribution , $Linux_Version"
}

function install_packages(){
  # deb 系列系統
  debug_info "$install_pack_1"
  debug_info "$install_pack_2"
  if [ "$Linux_Distribution" == "Ubuntu" ] || [ "$Linux_Distribution" == "Debian" ] ;then
    echo -e "\n$install_pack_if_1\n"
    aptitude install -y expect ssh dialog
  # rpm 系列系統
  elif [ "$Linux_Distribution" == "Fedora" ] || [ "$Linux_Distribution" == "CentOS" ] ;then
    show_info "$install_pack_if_2"
  else
    show_info "$install_pack_if_2"
  fi
}

function check_nez_installed(){
  debug_info "$check_nez_1"
  if [ -d "opt/nutchez" ]; then
    show_info "$check_nez_2"
    exit
  else
    show_info "$check_nez_3"
  fi
}

function check_sunJava(){
  debug_info "$check_sunJava_1"
  debug_info "$check_sunJava_2"

  javaPath="/usr"
  yesno="no"
  choice="3"

  if [ -e $javaPath/bin/java ]; then
    JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
    JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
    awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)

  if [ "$JAVA_org" == "" ]; then
    show_info "$check_sunJava_if_1"
    show_info "$check_sunJava_if_2"
    show_info "$check_sunJava_if_3"
    read -p "$check_sunJava_if_4" choice
    case $choice  in
      "1")
        show_info "$check_sunJava_if_5"
        exit
        ;;
      "2")
        read -p "$check_sunJava_if_6" javaPath
        ;;
        "*")
        exit
        ;;
        esac

        if [ $choice == "2" ]; then
          JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
          JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
          awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)

          if [ "$JAVA_org" == "" ]; then
            show_info "$check_sunJava_if_7"
            exit
            fi
          fi
        fi

      large16=$(echo "$JAVA_version >= 1.6" | bc)
      if [ "${large16}" == 0 ]; then
        show_info "$check_sunJava_if_8"
        exit
      fi

      show_info "$check_sunJava_if_9"
  else
    show_info "$check_sunJava_if_10"
    exit
  fi

  unset JAVA_org
  unset JAVA_version
}

# 檢查是否有安裝openssh, openssh-server
function check_ssh(){
  debug_info "$check_ssh_1"
  if [ -e /usr/bin/ssh ]; then
    show_info "$check_ssh_2"
  else
    show_info "$check_ssh_3"
    exit
  fi

  if [ -e /usr/sbin/sshd ]; then
    show_info "$check_ssh_4"
  else
    show_info "$check_ssh_5"
    exit
  fi
}


# 檢查是否有安裝dialog
function check_dialog(){
  debug_info "$check_dialog_1"
  if [ -e /usr/bin/dialog ]; then
    show_info "$check_dialog_2"
  else
    show_info "$check_dialog_3"
    exit
  fi
}

check_info () {
  check_root
  check_systemInfo
  install_packages
  check_nez_installed
  check_sunJava
  check_ssh
  check_dialog
}

function set_install_information () { 
  set_nutchuser_passwd
  select_eth
  MasterIP_Address=$net_address
}

function set_nutchuser_passwd () {
  read -sp "$set_nutchuser_passwd_echo_1" Nutchuser_Passwd
# read -sp "Please enter nutchuser's password :  " Nutchuser_Passwd
  echo -e "\n"
  read -sp "$set_nutchuser_passwd_echo_2" Nutchuser_Passwd2
# read -sp "Please enter nutchuser's password again:  " Nutchuser_Passwd2
  echo -e "\n"
  if [ $Nutchuser_Passwd != $Nutchuser_Passwd2 ]; then
    set_nutchuser_passwd
  fi
}


function select_eth () {
  net_interfaces=$(ifconfig | grep ^eth | cut -d " " -f1)
  net_nu=$(echo $net_interfaces | wc -w)

  # 若只有一個 eth　時
  if [ "$net_nu" == "1" ]; then
    net_address=$(ifconfig $net_interfaces | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
    net_MacAddr=$(ifconfig $net_interfaces | grep 'HW' | sed 's/^.*HWaddr //g')

  # 若有多個 eth 時
  else
    declare -i i=1
    show_info $select_eth_echo_1
#   show_info  "\nSystem have multiple network device, which network use for this machine: "

    for net in $net_interfaces
      do
        show_info "($i)  $net  $(ifconfig $net | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)"
        i=i+1
      done
      read -p "$select_eth_echo_2 " net_choice
#     read -p "Please choice(1/2/3...): " net_choice
    if [ -z $net_choice ]; then
      net_choice=1
    fi

    show_info $select_eth_echo_3
#   show_info "Your choice is $net_choice"
    net_interface=$(echo $net_interfaces | cut -d " " -f $net_choice)
    #ifconfig $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1
    net_address=$(ifconfig $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
    net_MacAddr=$(ifconfig $net_interface | grep 'HW' | sed 's/^.*HWaddr //g')

    show_info $select_eth_echo_4
#   show_info "net_address is $net_address"
    show_info $select_eth_echo_5
#   show_info "net_MacAddr is $net_MacAddr"
  fi
}


#function show_master_info () {
#  show_info "The Master IP Address is $MasterIP_Address"
#  show_info "The Master MacAddr is $net_MacAddr"
#}

function make_ssh_key () {
  debug_info $make_ssh_key_echo_1
# debug_info "Make ssh key(begin...)"
  su nutchuser -c 'ssh-keygen -t rsa -f ~/.ssh/id_rsa -P ""'
  su nutchuser -c "cp ~/.ssh/id_rsa.pub ~/.ssh/authorized_keys"
  su nutchuser -c "ssh-add /home/nutchuser/.ssh/id_rsa"
  debug_info $make_ssh_key_echo_2
# debug_info "Make ssh key(done!)"
}


function set_haoop-site () {
  debug_info $set_haoop_site_echo_1
# debug_info "set hadoop-site.xml(begin...)"
  cd $Nutch_HOME/conf/
  cat > hadoop-site.xml << EOF
<configuration>
  <property>
    <name>fs.default.name</name>
    <value>hdfs://$MasterIP_Address:9000</value>
  </property>
  <property>
    <name>mapred.job.tracker</name>
    <value>$MasterIP_Address:9001</value>
  </property>
  <property>
    <name>hadoop.tmp.dir</name>
    <value>/var/nutchez/nutch-nutchuser</value>
  </property>
</configuration>
EOF
  debug_info $set_haoop_site_echo_2
# debug_info "set hadoop-site.xml(done!)"
}

# 修改nutch-site.xml中-http.agent.url, http.agent.email
function set_nutch-site () {
  debug_info $set_haoop_site_echo_1
# debug_info "set nutch-site.xml(begin...)"
  Line_NO=`cat $Nutch_HOME'/conf/nutch-site.xml' | grep -n 'http.agent.url' | sed 's/:.*//g'`
  debug_info $set_haoop_site_echo_2
# debug_info "debug...http.agent.url line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' $Nutch_HOME/conf/nutch-site.xml
  debug_info $set_haoop_site_echo_3
# debug_info "debug...edit http.agent.url delete line $((Line_NO+1))..."
  sed -i ''$Line_NO'a <value>'$MasterIP_Address'</value>' $Nutch_HOME/conf/nutch-site.xml
  debug_info $set_haoop_site_echo_4
# debug_info "debug...edit http.agent.url done..."

  Line_NO=`cat $Nutch_HOME'/conf/nutch-site.xml' | grep -n 'http.agent.email' | sed 's/:.*//g'`
  debug_info $set_haoop_site_echo_5
# debug_info "debug...http.agent.email line number = $Line_NO..."

  sed -i ''$((Line_NO+1))'d' $Nutch_HOME/conf/nutch-site.xml
  debug_info $set_haoop_site_echo_6
# debug_info "debug...edit http.agent.email delete line $((Line_NO+1))..."
  sed -i ''$Line_NO'a <value>'$Admin_email'</value>' $Nutch_HOME/conf/nutch-site.xml
  debug_info $set_haoop_site_echo_7
# debug_info "debug...edit http.agent.email done..."
  debug_info $set_haoop_site_echo_8
# debug_info "set nutch-site.xml(done!)"
}

function format_HDFS () {
  debug_info $format_HDFS_echo_1 
  su nutchuser -c "$Nutch_HOME/bin/hadoop namenode -format"
  debug_info $format_HDFS_echo_2
}

function start_up_NutchEZ (){
  debug_info $start_up_NutchEZ_echo_1
# debug_info "start up NutchEZ..."
  su nutchuser -c "$Nutch_HOME/bin/start-all.sh"
}


function set_hosts () {
  debug_info $set_hosts_echo_1
  Line_NO=`cat /etc/hosts | grep -n $(hostname) | sed 's/:.*//g'`
  content=$(cat /etc/hosts | awk 'NR=='$Line_NO'{printf "# " ; print}' )
  sed -i ""$Line_NO"c $content" /etc/hosts
  sed -i '1i '$MasterIP_Address' '$(hostname)'' /etc/hosts
}

function Install_Nutch () {
  debug_info $install_Nutch_echo_1
# debug_info "MasterIP_Address=$MasterIP_Address"
  debug_info $install_Nutch_echo_2
# debug_info "Master_Hostname=$(hostname)"
  su nutchuser -c "echo $net_address $(hostname) $net_MacAddr \>\> ~/nutchez/system/nutch_nodes"
  set_hosts
  set_haoop-site
  set_nutch-site
}


function client_PassMasterIPAddr () {
  cd $Start_PATH
  Line_NO=`cat client_install | grep -n '# Master IP here' | sed 's/:.*//g'`
  debug_info $client_PassMasterIPAddr_echo_1
# debug_info "debug...Master IP here line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' client_install
  debug_info $client_PassMasterIPAddr_echo_2
# debug_info "debug...edit Master IP at line $((Line_NO+1))..."
  sed -i ''$Line_NO'a Master_IP_Address='$MasterIP_Address'' client_install
  debug_info $client_PassMasterIPAddr_echo_3
# debug_info "edit client_install done..."
}


function client_PassMaster_Hostname () {
  cd $Start_PATH
  Line_NO=`cat client_install | grep -n '# Master Hostname here' | sed 's/:.*//g'`
  debug_info $client_PassMaster_Hostname_echo_1
# debug_info "debug...Master hostname here line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' client_install
  debug_info $client_PassMaster_Hostname_echo_2
# debug_info "debug...edit Master Hostname at line $((Line_NO+1))..."
  sed -i ''$Line_NO'a Master_Hostname='$(hostname)'' client_install
  debug_info $client_PassMaster_Hostname_echo_3
# debug_info "edit client_install done..."
}


function make_client_install () {
  # 建立資料夾(用來存放client的安奘檔)
  su nutchuser -c "mkdir $User_HOME/source"

  # 將Master_IP_Address給client
  # 打包安裝目錄(不含tomcat)
 
  debug_info $make_client_install_echo_1
# debug_info "function make_client_install..."

  client_PassMasterIPAddr
  client_PassMaster_Hostname
  cd /opt/nutchez/
  su nutchuser -c "tar -cvzf NutchezForClientOf_$MasterIP_Address.tar.gz  nutch"
  
  # 複製檔案至$User_HOME/source目錄下
  mv NutchezForClientOf_$MasterIP_Address.tar.gz /home/nutchuser/nutchez/source
  cp $Start_PATH/client_install $Start_PATH/client_install_func.sh /home/nutchuser/nutchez/source
}

function start_up_tomcat () {
  debug_info $start_up_tomcat_echo_1
# debug_info "start up tomcat..."

  i=10
  until [ $i -lt 1 ]
    do
      sleep 1s
      debug_info $start_up_tomcat_echo_2
#     debug_info "wait $i sec..."
      i=`expr $i - 1`
    done
  su nutchuser -c "$Tomcat_HOME/bin/startup.sh"
  debug_info $start_up_tomcat_echo_3
# debug_info "tomcat has been started..."
}

###最後再整理###
# client簡易步驟
function client_install_commands () {
  show_info $client_install_commands_echo_1
  show_info $client_install_commands_echo_2
  show_info $client_install_commands_echo_3
  show_info $client_install_commands_echo_4
  show_info $client_install_commands_echo_5
  show_info $client_install_commands_echo_6
  show_info $client_install_commands_echo_7


#  show_info "Client Install Command as Follows:"
#  show_info "cd ~"
#  show_info "mkdir nutchez_client_install"
#  show_info "cd nutchez_client_install"
#  show_info "scp nutchuser@$MasterIP_Address:/home/nutchuser/nutchez/source/* ."
#  show_info "sudo su"
#  show_info "./client_install"
}
