#!/bin/bash
# Program:
#   Functions for client_install.sh
# Author: 
#   Waue, Shunfa, Rock {waue, shunfa, rock}@nchc.org.tw
# History:
#   2010/05/20  Rock    First release(0.1)

# 正式版之後，記的將不必要的 echo 拿掉
function debug_info () {
#  if [ $? -eq 0 ]; then
    echo -e "\033[1;35;40m info - $1 \033[0m"
#  fi
}

function show_info () {
#  if [ $? -eq 0 ]; then
    echo -e "\033[1;32;40m $1 \033[0m"
#  fi
}


# choose Language
function choose_lang(){

lang=$(locale | grep 'LANG=' | cut -d "=" -f2)

# Default: source english
. lang_en_US_client_install
# if locale is zh then source chinese
echo $lang | grep 'zh' >> /dev/null && source lang_zh_TW_client_install

# Ask language
echo -e "\n$choose_lang_1"
read -p "$choose_lang_2 " langChoice

if [ $langChoice == "2" ]; then
    source lang_zh_TW_client_install
else
    source lang_en_US_client_install
fi
}

# 檢查執行這個程式的是否為root權限
function check_root(){
# 正式版後可拿掉此 echo
  debug_info "check_root"
  if [ $USER != "root" ]; then
    show_info "$check_root_1"
    exit
  fi
# 正式版後可拿掉此 echo
  show_info "$check_root_2"
}


# 查出此主機的作業系統,以及版本
function check_systemInfo(){
  debug_info "$check_sys_1"
  show_info "$check_sys_2"
  Linux_Distribution=$(lsb_release -a 2> /dev/null | grep "Distributor ID:" | awk '{print $3}')
  Linux_Version=$(lsb_release -a 2> /dev/null | grep "Release" | awk '{print $2}')
  show_info "$Linux_Distribution , $Linux_Version"
}


# 安裝需要的相依套件 (目前只支援 deb 套件的系統自動安裝，yum或其他套件系統的則需手動安裝)
function install_packages(){
  # deb 系列系統
  debug_info "$install_pack_1"
  debug_info "$install_pack_2"
  if [ "$Linux_Distribution" == "Ubuntu" ] || [ "$Linux_Distribution" == "Debian" ] ;then
    echo -e "\n$install_pack_if_1\n"
    aptitude install -y expect ssh dialog
  # rpm 系列系統
  elif [ "$Linux_Distribution" == "Fedora" ] || [ "$Linux_Distribution" == "CentOS" ] ;then
    show_info "$install_pack_if_2"
  else
    show_info "$install_pack_if_2"
  fi 
}


# 檢查之前是否有安裝NutchEz
# 目前先檢查是否有/opt/nutchez 這個資料夾即可
function check_nez_installed(){
  debug_info "$check_nez_1"
  if [ -d "opt/nutchez" ]; then
    show_info "$check_nez_2"
    exit
  else
    show_info "$check_nez_3"
  fi
}


# 檢查是否有安裝sun java ,並檢查是否為jdk 1.6 以上版本
# 4種判斷可能性 (1)系統沒安裝 JAVA (2)系統有安裝JAVA，但非sun版本 
# (3)系統有安裝但Sun Java 在非預設路徑下 (4)以正確安裝 Sun JAVA 預設路徑下
function check_sunJava(){
  debug_info "$check_sunJava_1"
  debug_info "$check_sunJava_2"

  javaPath="/usr"
  yesno="no"
  choice="3"

  if [ -e $javaPath/bin/java ]; then
    JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
    JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
    awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)
   
  if [ "$JAVA_org" == "" ]; then 
    show_info "$check_sunJava_if_1"
    show_info "$check_sunJava_if_2"
    show_info "$check_sunJava_if_3"
    read -p "$check_sunJava_if_4" choice
    case $choice  in
      "1")
        show_info "$check_sunJava_if_5"
        exit 
        ;;
      "2")
        read -p "$check_sunJava_if_6" javaPath
        ;;
        "*")
        exit
        ;;
        esac

        if [ $choice == "2" ]; then
          JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
          JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
          awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)
              
          if [ "$JAVA_org" == "" ]; then
            show_info "$check_sunJava_if_7"
            exit
            fi
          fi
        fi  

      large16=$(echo "$JAVA_version >= 1.6" | bc)
      if [ "${large16}" == 0 ]; then
        show_info "$check_sunJava_if_8"
        exit
      fi  
      
      show_info "$check_sunJava_if_9"
  else
    show_info "$check_sunJava_if_10"
    exit
  fi

  unset JAVA_org
  unset JAVA_version
}


# 檢查是否有安裝openssh, openssh-server
function check_ssh(){
  debug_info "$check_ssh_1"
  if [ -e /usr/bin/ssh ]; then
    show_info "$check_ssh_2"
  else
    show_info "$check_ssh_3"
    exit
  fi

  if [ -e /usr/sbin/sshd ]; then
    show_info "$check_ssh_4"
  else
    show_info "$check_ssh_5"
    exit
  fi
}


# 檢查是否有安裝dialog
function check_dialog(){
  debug_info "$check_dialog_1"
  if [ -e /usr/bin/dialog ]; then
    show_info "$check_dialog_2"
  else
    show_info "$check_dialog_3"
    exit
  fi
}


# scp nutchuser@master_ip:~ 把.ssh/目錄複製下來
# 當使用者輸入nutchuser 密碼時，將此密碼紀錄到Nutchuser_Passwd
# 此步驟若無法連到 master 則跳出
function scp_master_nutchuser_sshkey(){
  debug_info "$scp_sshkey_d1"
  debug_info "$scp_sshkey_d2"
  mkdir -p /home/nutchuser/.ssh/
  rm -fr /home/nutchuser/.ssh/*
  unset Nutchuser_Passwd2

  debug_info "$scp_sshkey_d3"
expect -c "spawn scp -r -o StrictHostKeyChecking=no nutchuser@$1:~/.ssh /home/nutchuser/
set timeout 1
sleep 2
expect \"*: \" { send \"$Nutchuser_Passwd\r\" }
expect \"*: \" { send_user \"$scp_sshkey_expect_1\" }
expect eof"

  if [ -e "/home/nutchuser/.ssh/authorized_keys" ]; then
    show_info "$scp_sshkey_s1"    
    else
      show_info "$scp_sshkey_s2"
    exit
  fi
  ssh-add /home/nutchuser/.ssh/id_rsa
  debug_info "$scp_sshkey_d4"
  chown -R nutchuser:nutchuser /home/nutchuser/.ssh
}

# 新增nutchuser 帳號時用 Nutchuser_Passwd 當密碼
function creat_nutchuser_account(){
  debug_info "$create_nutchuser_d1"
  while [ "$Nutchuser_Passwd" != "$Nutchuser_Passwd2" ]
  do
      echo -e "\n"
      read -sp "$create_nutchuser_1" Nutchuser_Passwd
      echo 
      read -sp "$create_nutchuser_2" Nutchuser_Passwd2
      echo 
        if [ "$Nutchuser_Passwd" == "$Nutchuser_Passwd2" ]; then
          show_info "$create_nutchuser_3"
        else
          show_info "$create_nutchuser_4"
        fi
  done                                                                                                                                    
  unset Nutchuser_Passwd2

  if [ $(cat /etc/passwd | grep nutchuser) ]; then
    show_info "$create_nutchuser_s1"
    expect -c "spawn passwd nutchuser
    set timeout 1
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect eof"
    else
      show_info "$create_nutchuser_s2"
      useradd -m nutchuser -s /bin/bash
      expect -c "spawn passwd nutchuser
      set timeout 1
      expect \"*: \"
      send \"$Nutchuser_Passwd\r\"
      expect \"*: \"
      send \"$Nutchuser_Passwd\r\"
      expect eof"
  fi
}

# 用scp 複製 master 的設定與安裝資料
# 目前僅需做到能無礙的複製遠端的/opt/nutchez/到local的/opt/
function scp_packages(){
  debug_info "$scp_packages_d1"
  mkdir /opt/nutchez
  mkdir /var/nutchez
  mkdir /home/nutchuser/nutchez
  mkdir /home/nutchuser/nutchez/source
  mkdir /home/nutchuser/nutchez/system
  chmod 777 /opt/nutchez
  debug_info "$scp_packages_d2"
  chown -R nutchuser:nutchuser /opt/nutchez
  chown -R nutchuser:nutchuser /var/nutchez
  chown -R nutchuser:nutchuser /home/nutchuser/nutchez
  chmod 755 /opt/nutchez
  debug_info "$scp_packages_d3"
  su nutchuser -c "scp -r -o StrictHostKeyChecking=no nutchuser@$1:/home/nutchuser/nutchez/source/NutchezForClientOf_$Master_IP_Address.tar.gz /home/nutchuser/nutchez/source"

}


function install_nutch_package(){
  debug_info "$install_nutch_package_d1"
  tar -zxvf /home/nutchuser/nutchez/source/NutchezForClientOf_$Master_IP_Address.tar.gz -C /opt/nutchez
  sed -i '1a '$Master_IP_Address' '$Master_Hostname'' /etc/hosts
  #/opt/nutchez/nutch/bin/hadoop-daemon.sh start datanode
  #/opt/nutchez/nutch/bin/hadoop-daemon.sh start tasktracker
}

function recall_hostname_ip(){
  debug_info "$recall_hostname_ip_d1"
  net_interfaces=$(ifconfig | grep ^eth | cut -d " " -f1)
  net_nu=$(echo $net_interfaces | wc -w)
  # 若只有一個 eth　時
  if [ "$net_nu" == "1" ]; then
  # ifconfig $net_interfaces | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1
  net_address=$(ifconfig $net_interfaces | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
  net_MacAddr=$(ifconfig $net_interfaces | grep 'HW' | sed 's/^.*HWaddr //g')
  show_info "$recall_hostname_ip_1 $net_address"
  show_info "$recall_hostname_ip_2 $net_MacAddr"

  # 若有多個 eth 時
    else
      declare -i i=1
      show_info "$recall_hostname_ip_3"
       
      for net in $net_interfaces
      do  
        echo "($i)  $net  $(ifconfig $net | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)"
        i=i+1
      done
       
      read -p "$recall_hostname_ip_4" net_choice
  if [ -z $net_choice ]; then
    net_choice=1
  fi   

  show_info "choice is $net_choice"
  net_interface=$(echo $net_interfaces | cut -d " " -f $net_choice)
  # config $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1
  net_address=$(ifconfig $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
  net_MacAddr=$(ifconfig $net_interface | grep 'HW' | sed 's/^.*HWaddr //g') 
  show_info "$recall_hostname_ip_1 $net_address"
  show_info "$recall_hostname_ip_2 $net_MacAddr"
  fi

  debug_info "$recall_hostname_ip_d2"
  su nutchuser -c "ssh nutchuser@$1 echo $net_address $(hostname) $net_MacAddr \>\> ~/nutchez/system/nutch_nodes"

#su nutchuser -c expect -c "spawn ssh nutchuser@$1
#set timeout 1
#expect \"*\"
#send \"echo $net_address $(hostname) >> /home/nutchuser/nutch_nodes\r\"
#expect \"*\"
#send \"exit\""
}
