#!/bin/bash
source install_lang
####### garbage here #############
function mainFunction ( )
{
echo "$Good"
}
function braBraBra ( )
{
echo "$Bra_Bra_Bra"
}
####### garbage end ###############

####### fafa code here ###########


# shell檔及壓縮檔在同一目錄中


####### 環境變數section###########
User_HOME=/home/nutchuser/nutchez
NutchEZ_HOME=/opt/nutchez
Nutch_HOME=$NutchEZ_HOME/nutch
Tomcat_HOME=$NutchEZ_HOME/tomcat
Index_DB=$User_HOME/search
Admin_email=nutchuser@nutch
Start_PATH=`pwd`
MasterIP_Address=`/sbin/ifconfig eth0 | grep 'inet addr' |  sed 's/^.*addr://g' | sed 's/Bcast.*$//g' | sed 's/ .*// '` 
net_MacAddr=`/sbin/ifconfig eth0 | grep 'HW' | sed 's/^.*HWaddr //g'`

######function section section#######


function debug_echo () {
  if [ $? -eq 0 ]; then
    echo -e "\033[1;32;40m $1 \033[0m"
  fi
}


check_info () {
  check_root
  check_systemInfo
  check_nez_installed
  check_sunJava
  check_ssh
  check_dialog
  install_packages
}

function set_install_information () { 
  set_nutchuser_passwd
  select_eth
  MasterIP_Address=$net_address
}

function set_nutchuser_passwd () {
  read -sp "Please enter nutchuser's password :  " Nutchuser_Passwd
  read -sp "Please enter nutchuser's password again:  " Nutchuser_Passwd2
  if [ $Nutchuser_Passwd != $Nutchuser_Passwd2 ]; then
    set_nutchuser_passwd
  fi
}


function select_eth () {
  net_interfaces=$(ifconfig | grep ^eth | cut -d " " -f1)
  net_nu=$(echo $net_interfaces | wc -w)

  # 若只有一個 eth　時
  if [ "$net_nu" == "1" ]; then
    #ifconfig $net_interfaces | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1
    net_address=$(ifconfig $net_interfaces | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
    net_MacAddr=$(ifconfig $net_interfaces | grep 'HW' | sed 's/^.*HWaddr //g')
    #echo "net_address is $net_address"
    #echo "net_MacAddr is $net_MacAddr"

  # 若有多個 eth 時
  else
    declare -i i=1
    echo -e "\nSystem have multiple network device, which network use for this machine: "

    for net in $net_interfaces
      do
        echo "($i)  $net  $(ifconfig $net | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)"
        i=i+1
      done

      read -p "Plz choice(1/2/3...): " net_choice
    if [ -z $net_choice ]; then
      net_choice=1
    fi

    echo "Your choice is $net_choice"
    net_interface=$(echo $net_interfaces | cut -d " " -f $net_choice)
    #ifconfig $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1
    net_address=$(ifconfig $net_interface | grep "inet addr:" | sed 's/^.*inet addr://g' | cut -d " " -f1)
    net_MacAddr=$(ifconfig $net_interfaces | grep 'HW' | sed 's/^.*HWaddr //g')
    echo "net_address is $net_address"
    echo "net_MacAddr is $net_MacAddr"
  fi
}


function show_info () {
  echo "The Master IP Address is $MasterIP_Address"
  echo "The Master MacAddr is $net_MacAddr"
}

function confirm_install_information () {
  read -p "Please confirm your install infomation: 1.Yes 2.No  " confirm
}

function make_ssh_key () {
  debug_echo "Make ssh key(begin...)"
  su nutchuser -c 'ssh-keygen -t rsa -f ~/.ssh/id_rsa -P ""'
  su nutchuser -c "cp ~/.ssh/id_rsa.pub ~/.ssh/authorized_keys"
  su nutchuser -c "ssh-add /home/nutchuser/.ssh/id_rsa"
  debug_echo "Make ssh key(done!)"
}


function set_haoop-site () {
  debug_echo "set hadoop-site.xml(begin...)"
  cd $Nutch_HOME/conf/
  cat > hadoop-site.xml << EOF
<configuration>
  <property>
    <name>fs.default.name</name>
    <value>hdfs://$MasterIP_Address:9000</value>
  </property>
  <property>
    <name>mapred.job.tracker</name>
    <value>$MasterIP_Address:9001</value>
  </property>
  <property>
    <name>hadoop.tmp.dir</name>
    <value>/var/nutchez/nutch-nutchuser</value>
  </property>
</configuration>
EOF
  debug_echo "set hadoop-site.xml(done!)"
}

# 修改nutch-site.xml中-http.agent.url, http.agent.email
function set_nutch-site () {
  debug_echo "set nutch-site.xml(begin...)"
  Line_NO=`cat $Nutch_HOME'/conf/nutch-site.xml' | grep -n 'http.agent.url' | sed 's/:.*//g'`
  debug_echo "debug...http.agent.url line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' $Nutch_HOME/conf/nutch-site.xml
  debug_echo "debug...edit http.agent.url delete line $((Line_NO+1))..."
  sed -i ''$Line_NO'a <value>'$MasterIP_Address'</value>' $Nutch_HOME/conf/nutch-site.xml
  debug_echo "debug...edit http.agent.url done..."

  Line_NO=`cat $Nutch_HOME'/conf/nutch-site.xml' | grep -n 'http.agent.email' | sed 's/:.*//g'`
  debug_echo "debug...http.agent.email line number = $Line_NO..."

  sed -i ''$((Line_NO+1))'d' $Nutch_HOME/conf/nutch-site.xml
  debug_echo "debug...edit http.agent.email delete line $((Line_NO+1))..."
  sed -i ''$Line_NO'a <value>'$Admin_email'</value>' $Nutch_HOME/conf/nutch-site.xml
  debug_echo "debug...edit http.agent.email done..."
  debug_echo "set nutch-site.xml(done!)"
}

function format_HDFS () {
  debug_echo "format HDFS..."
  su nutchuser -c "$Nutch_HOME/bin/hadoop namenode -format"
}

function start_up_NutchEZ (){
  debug_echo "start up NutchEZ..."
  su nutchuser -c "$Nutch_HOME/bin/start-all.sh"
}

function Install_Nutch () {
  set_haoop-site
  set_nutch-site
}


function client_PassMasterIPAddr () {
  cd $Start_PATH
  Line_NO=`cat client_install | grep -n '# Master IP here' | sed 's/:.*//g'`
  debug_echo "debug...Master IP here line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' client_install
  debug_echo "debug...edit Master IP at line $((Line_NO+1))..."
  sed -i ''$Line_NO'a Master_IP_Address='$MasterIP_Address'' client_install
  debug_echo "edit client_install done..."
}


function client_PassMaster_Hostname () {
  cd $Start_PATH
  Line_NO=`cat client_install | grep -n '# Master Hostname here' | sed 's/:.*//g'`
  debug_echo "debug...Master hostname here line number = $Line_NO..."
  sed -i ''$((Line_NO+1))'d' client_install
  debug_echo "debug...edit Master Hostname at line $((Line_NO+1))..."
  sed -i ''$Line_NO'a Master_Hostname='$(hostname)'' client_install
  debug_echo "edit client_install done..."
}


function make_client_install () {
  # 建立資料夾(用來存放client的安奘檔)
  su nutchuser -c "mkdir $User_HOME/source"

  # 將Master_IP_Address給client
  # 打包安裝目錄(不含tomcat)
  echo "function make_client_install..."
  client_PassMasterIPAddr
  client_PassMaster_Hostname
  cd /opt/nutchez/
  su nutchuser -c "tar -cvzf NutchezForClientOf_$Master_IP_Address.tar.gz  nutch"
  
  # 複製檔案至$User_HOME/source目錄下
  mv NutchezForClientOf_$Master_IP_Address.tar.gz /home/nutchuser/nutchez/source
  cp $Start_PATH/client_install $Start_PATH/client_install_func.sh /home/nutchuser/nutchez/source
}

function start_up_tomcat () {
  debug_echo "start up tomcat..."
  sleep 10s
  su nutchuser -c "$Tomcat_HOME/bin/startup.sh"
  debug_echo "tomcat has been started..."
}

###最後再整理###
# client簡易步驟
function client_install_command () {
  echo "Client Install Command as Follows:"
  echo "cd ~"
  echo "mkdir nutchez_client_install"
  echo "cd nutchez_client_install"
  echo "scp nutchuser@masterIP:/home/nutchuser/nutchez/source/* ."
  echo "./client_install"
}
