#!/bin/bash
# Program:
#   Check root identity and change root to exectue client_install.sh
# Author: 
#   Waue, Shunfa, Rock {waue, shunfa, rock}@nchc.org.tw
# History:
#   2010/05/20  Rock    First release

# 正式版之後，記的將不必要 read 拿掉 (trace 用的 read)

# 設定 functions 
. ./client_install_func.sh

# 需要master_install 設定的參數區
Master_IP_Address="a.a.a.a";

# 此檔自己用的參數區
Linux_Distribution="";
Linux_Version="";
Nutchuser_Passwd="xxxxxxxx";

# 功能邏輯區


# 程式邏輯區

# 檢查執行這個程式的是否為root權限
check_root
read

# 查出此主機的作業系統,以及版本
check_systemInfo
read

# 檢查之前是否有安裝NutchEz
# 目前先檢查是否有/opt/nutchez 這個資料夾即可
check_nez_installed
read

# 檢查是否有安裝sun java ,並檢查是否為jdk 1.6 以上版本
check_sunJava
read

# 檢查是否有安裝openssh, openssh-server
check_ssh
read

# 檢查是否有安裝dialog
check_dialog
read

# 檢查是否安裝 php 5.5
check_php
read

# scp nutchuser@master_ip:~ 把.ssh/目錄複製下來
# 當使用者輸入nutchuser 密碼時，將此密碼紀錄到Nutchuser_Passwd
# 此步驟若無法連到 master 則跳出
scp_master_nutchuser_sshkey $Master_IP_Address
read

# 新增nutchuser 帳號時用 Nutchuser_Passwd 當密碼
creat_nutchuser_account $Nutchuser_Passwd
read

# 用scp 複製 master 的設定與安裝資料
# 目前僅需做到能無礙的複製遠端的/opt/nutchez/到local的/opt/
scp_packages $Master_IP_Address
read

# 安裝
#install_packages

